/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.commonmark.node.Node;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentWriter;

public class TableTextContentNodeRenderer
extends TableNodeRenderer {
    private final TextContentWriter textContentWriter;
    private final TextContentNodeRendererContext context;

    public TableTextContentNodeRenderer(TextContentNodeRendererContext textContentNodeRendererContext) {
        this.textContentWriter = textContentNodeRendererContext.getWriter();
        this.context = textContentNodeRendererContext;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.textContentWriter.pushTight(true);
        this.renderChildren(tableBlock);
        this.textContentWriter.popTight();
        this.textContentWriter.block();
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.renderChildren(tableHead);
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.renderChildren(tableBody);
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.renderChildren(tableRow);
        this.textContentWriter.block();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        this.renderChildren(tableCell);
        if (tableCell.getNext() != null) {
            this.textContentWriter.write('|');
            this.textContentWriter.whitespace();
        }
    }

    private void renderChildren(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.context.render(node2);
            node2 = node3;
        }
    }
}

