/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.commonmark.node.Node;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownWriter;
import org.commonmark.text.AsciiMatcher;

public class TableMarkdownNodeRenderer
extends TableNodeRenderer {
    private final MarkdownWriter writer;
    private final MarkdownNodeRendererContext context;
    private final AsciiMatcher pipe = AsciiMatcher.builder().c('|').build();
    private final List<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();

    public TableMarkdownNodeRenderer(MarkdownNodeRendererContext markdownNodeRendererContext) {
        this.writer = markdownNodeRendererContext.getWriter();
        this.context = markdownNodeRendererContext;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.columns.clear();
        this.writer.pushTight(true);
        this.renderChildren(tableBlock);
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.renderChildren(tableHead);
        for (TableCell.Alignment alignment : this.columns) {
            this.writer.raw('|');
            if (alignment == TableCell.Alignment.LEFT) {
                this.writer.raw(":---");
                continue;
            }
            if (alignment == TableCell.Alignment.RIGHT) {
                this.writer.raw("---:");
                continue;
            }
            if (alignment == TableCell.Alignment.CENTER) {
                this.writer.raw(":---:");
                continue;
            }
            this.writer.raw("---");
        }
        this.writer.raw("|");
        this.writer.block();
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.renderChildren(tableBody);
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.renderChildren(tableRow);
        this.writer.raw("|");
        this.writer.block();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        if (tableCell.getParent() != null && tableCell.getParent().getParent() instanceof TableHead) {
            this.columns.add(tableCell.getAlignment());
        }
        this.writer.raw("|");
        this.writer.pushRawEscape(this.pipe);
        this.renderChildren(tableCell);
        this.writer.popRawEscape();
    }

    private void renderChildren(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.context.render(node2);
            node2 = node3;
        }
    }
}

