/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.Map;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.commonmark.node.Node;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class TableHtmlNodeRenderer
extends TableNodeRenderer {
    private final HtmlWriter htmlWriter;
    private final HtmlNodeRendererContext context;

    public TableHtmlNodeRenderer(HtmlNodeRendererContext htmlNodeRendererContext) {
        this.htmlWriter = htmlNodeRendererContext.getWriter();
        this.context = htmlNodeRendererContext;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.htmlWriter.line();
        this.htmlWriter.tag("table", this.getAttributes(tableBlock, "table"));
        this.renderChildren(tableBlock);
        this.htmlWriter.tag("/table");
        this.htmlWriter.line();
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.htmlWriter.line();
        this.htmlWriter.tag("thead", this.getAttributes(tableHead, "thead"));
        this.renderChildren(tableHead);
        this.htmlWriter.tag("/thead");
        this.htmlWriter.line();
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tbody", this.getAttributes(tableBody, "tbody"));
        this.renderChildren(tableBody);
        this.htmlWriter.tag("/tbody");
        this.htmlWriter.line();
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.htmlWriter.line();
        this.htmlWriter.tag("tr", this.getAttributes(tableRow, "tr"));
        this.renderChildren(tableRow);
        this.htmlWriter.tag("/tr");
        this.htmlWriter.line();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        String string = tableCell.isHeader() ? "th" : "td";
        this.htmlWriter.line();
        this.htmlWriter.tag(string, this.getCellAttributes(tableCell, string));
        this.renderChildren(tableCell);
        this.htmlWriter.tag("/" + string);
        this.htmlWriter.line();
    }

    private Map<String, String> getAttributes(Node node, String string) {
        return this.context.extendAttributes(node, string, Map.of());
    }

    private Map<String, String> getCellAttributes(TableCell tableCell, String string) {
        if (tableCell.getAlignment() != null) {
            return this.context.extendAttributes(tableCell, string, Map.of("align", TableHtmlNodeRenderer.getAlignValue(tableCell.getAlignment())));
        }
        return this.context.extendAttributes(tableCell, string, Map.of());
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + alignment);
    }

    private void renderChildren(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            this.context.render(node2);
            node2 = node3;
        }
    }
}

