/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.node.Block;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;

public class TableBlockParser
extends AbstractBlockParser {
    private final TableBlock block = new TableBlock();
    private final List<SourceLine> rowLines = new ArrayList<SourceLine>();
    private final List<TableCellInfo> columns;
    private boolean canHaveLazyContinuationLines = true;

    private TableBlockParser(List<TableCellInfo> list, SourceLine sourceLine) {
        this.columns = list;
        this.rowLines.add(sourceLine);
    }

    @Override
    public boolean canHaveLazyContinuationLines() {
        return this.canHaveLazyContinuationLines;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        CharSequence charSequence = parserState.getLine().getContent();
        int n = Characters.find('|', charSequence, parserState.getNextNonSpaceIndex());
        if (n != -1) {
            if (n == parserState.getNextNonSpaceIndex() && Characters.skipSpaceTab(charSequence, n + 1, charSequence.length()) == charSequence.length()) {
                this.canHaveLazyContinuationLines = false;
                return BlockContinue.none();
            }
            return BlockContinue.atIndex(parserState.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine sourceLine) {
        this.rowLines.add(sourceLine);
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        Object object;
        List<SourceSpan> list = this.block.getSourceSpans();
        SourceSpan sourceSpan = !list.isEmpty() ? list.get(0) : null;
        TableHead tableHead = new TableHead();
        if (sourceSpan != null) {
            tableHead.addSourceSpan(sourceSpan);
        }
        this.block.appendChild(tableHead);
        TableRow tableRow = new TableRow();
        tableRow.setSourceSpans(tableHead.getSourceSpans());
        tableHead.appendChild(tableRow);
        List<SourceLine> list2 = TableBlockParser.split(this.rowLines.get(0));
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            SourceLine sourceLine = list2.get(i);
            object = this.parseCell(sourceLine, i, inlineParser);
            ((TableCell)object).setHeader(true);
            tableRow.appendChild((Node)object);
        }
        Node node = null;
        for (int i = 2; i < this.rowLines.size(); ++i) {
            object = this.rowLines.get(i);
            SourceSpan sourceSpan2 = i < list.size() ? list.get(i) : null;
            List<SourceLine> list3 = TableBlockParser.split((SourceLine)object);
            TableRow tableRow2 = new TableRow();
            if (sourceSpan2 != null) {
                tableRow2.addSourceSpan(sourceSpan2);
            }
            for (int j = 0; j < n; ++j) {
                SourceLine sourceLine = j < list3.size() ? list3.get(j) : SourceLine.of("", null);
                TableCell tableCell = this.parseCell(sourceLine, j, inlineParser);
                tableRow2.appendChild(tableCell);
            }
            if (node == null) {
                node = new TableBody();
                this.block.appendChild(node);
            }
            node.appendChild(tableRow2);
            node.addSourceSpan(sourceSpan2);
        }
    }

    private TableCell parseCell(SourceLine sourceLine, int n, InlineParser inlineParser) {
        Object object;
        TableCell tableCell = new TableCell();
        SourceSpan sourceSpan = sourceLine.getSourceSpan();
        if (sourceSpan != null) {
            tableCell.addSourceSpan(sourceSpan);
        }
        if (n < this.columns.size()) {
            object = this.columns.get(n);
            tableCell.setAlignment(((TableCellInfo)object).getAlignment());
            tableCell.setWidth(((TableCellInfo)object).getWidth());
        }
        object = sourceLine.getContent();
        int n2 = Characters.skipSpaceTab((CharSequence)object, 0, object.length());
        int n3 = Characters.skipSpaceTabBackwards((CharSequence)object, object.length() - 1, n2);
        inlineParser.parse(SourceLines.of(sourceLine.substring(n2, n3 + 1)), tableCell);
        return tableCell;
    }

    private static List<SourceLine> split(SourceLine sourceLine) {
        int n;
        CharSequence charSequence = sourceLine.getContent();
        int n2 = n = Characters.skipSpaceTab(charSequence, 0, charSequence.length());
        int n3 = charSequence.length();
        if (charSequence.charAt(n) == '|') {
            n2 = n + 1;
            int n4 = Characters.skipSpaceTabBackwards(charSequence, charSequence.length() - 1, n2);
            n3 = n4 + 1;
        }
        ArrayList<SourceLine> arrayList = new ArrayList<SourceLine>();
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 < n3 && charSequence.charAt(i + 1) == '|') {
                        stringBuilder.append('|');
                        ++i;
                        continue block4;
                    }
                    stringBuilder.append('\\');
                    continue block4;
                }
                case '|': {
                    String string = stringBuilder.toString();
                    arrayList.add(SourceLine.of(string, sourceLine.substring(n2, i).getSourceSpan()));
                    stringBuilder.setLength(0);
                    n2 = i + 1;
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder.length() > 0) {
            String string = stringBuilder.toString();
            arrayList.add(SourceLine.of(string, sourceLine.substring(n2, sourceLine.getContent().length()).getSourceSpan()));
        }
        return arrayList;
    }

    private static List<TableCellInfo> parseSeparator(CharSequence charSequence) {
        ArrayList<TableCellInfo> arrayList = new ArrayList<TableCellInfo>();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        block5: while (n2 < charSequence.length()) {
            char c = charSequence.charAt(n2);
            switch (c) {
                case '|': {
                    ++n2;
                    if (++n > 1) {
                        return null;
                    }
                    bl = true;
                    continue block5;
                }
                case '-': 
                case ':': {
                    if (n == 0 && !arrayList.isEmpty()) {
                        return null;
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (c == ':') {
                        bl2 = true;
                        ++n2;
                        ++n3;
                    }
                    boolean bl4 = false;
                    while (n2 < charSequence.length() && charSequence.charAt(n2) == '-') {
                        ++n2;
                        ++n3;
                        bl4 = true;
                    }
                    if (!bl4) {
                        return null;
                    }
                    if (n2 < charSequence.length() && charSequence.charAt(n2) == ':') {
                        bl3 = true;
                        ++n2;
                        ++n3;
                    }
                    arrayList.add(new TableCellInfo(TableBlockParser.getAlignment(bl2, bl3), n3));
                    n3 = 0;
                    n = 0;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    ++n2;
                    continue block5;
                }
            }
            return null;
        }
        if (!bl) {
            return null;
        }
        return arrayList;
    }

    private static TableCell.Alignment getAlignment(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return TableCell.Alignment.CENTER;
        }
        if (bl) {
            return TableCell.Alignment.LEFT;
        }
        if (bl2) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    private static class TableCellInfo {
        private final TableCell.Alignment alignment;
        private final int width;

        public TableCell.Alignment getAlignment() {
            return this.alignment;
        }

        public int getWidth() {
            return this.width;
        }

        public TableCellInfo(TableCell.Alignment alignment, int n) {
            this.alignment = alignment;
            this.width = n;
        }
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState parserState, MatchedBlockParser matchedBlockParser) {
            SourceLine sourceLine;
            SourceLine sourceLine2;
            List<TableCellInfo> list;
            List<SourceLine> list2 = matchedBlockParser.getParagraphLines().getLines();
            if (list2.size() >= 1 && Characters.find('|', list2.get(list2.size() - 1).getContent(), 0) != -1 && (list = TableBlockParser.parseSeparator((sourceLine2 = (sourceLine = parserState.getLine()).substring(parserState.getIndex(), sourceLine.getContent().length())).getContent())) != null && !list.isEmpty()) {
                SourceLine sourceLine3 = list2.get(list2.size() - 1);
                List<SourceLine> list3 = TableBlockParser.split(sourceLine3);
                if (list.size() >= list3.size()) {
                    return BlockStart.of(new TableBlockParser(list, sourceLine3)).atIndex(parserState.getIndex()).replaceParagraphLines(1);
                }
            }
            return BlockStart.none();
        }
    }
}

