/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables;

import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.internal.TableBlockParser;
import org.commonmark.ext.gfm.tables.internal.TableHtmlNodeRenderer;
import org.commonmark.ext.gfm.tables.internal.TableMarkdownNodeRenderer;
import org.commonmark.ext.gfm.tables.internal.TableTextContentNodeRenderer;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownNodeRendererFactory;
import org.commonmark.renderer.markdown.MarkdownRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentNodeRendererFactory;
import org.commonmark.renderer.text.TextContentRenderer;

public class TablesExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
MarkdownRenderer.MarkdownRendererExtension,
TextContentRenderer.TextContentRendererExtension {
    private TablesExtension() {
    }

    public static Extension create() {
        return new TablesExtension();
    }

    @Override
    public void extend(Parser.Builder builder) {
        builder.customBlockParserFactory(new TableBlockParser.Factory());
    }

    @Override
    public void extend(HtmlRenderer.Builder builder) {
        builder.nodeRendererFactory(new HtmlNodeRendererFactory(){

            @Override
            public NodeRenderer create(HtmlNodeRendererContext htmlNodeRendererContext) {
                return new TableHtmlNodeRenderer(htmlNodeRendererContext);
            }
        });
    }

    @Override
    public void extend(TextContentRenderer.Builder builder) {
        builder.nodeRendererFactory(new TextContentNodeRendererFactory(){

            @Override
            public NodeRenderer create(TextContentNodeRendererContext textContentNodeRendererContext) {
                return new TableTextContentNodeRenderer(textContentNodeRendererContext);
            }
        });
    }

    @Override
    public void extend(MarkdownRenderer.Builder builder) {
        builder.nodeRendererFactory(new MarkdownNodeRendererFactory(){

            @Override
            public NodeRenderer create(MarkdownNodeRendererContext markdownNodeRendererContext) {
                return new TableMarkdownNodeRenderer(markdownNodeRendererContext);
            }

            @Override
            public Set<Character> getSpecialCharacters() {
                return Set.of(Character.valueOf('|'));
            }
        });
    }
}

