/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.A;
import com.company.AA;
import com.company.ANSIs;
import com.company.GeminiSidePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.java.sampler.JSR223Sampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptPanel
extends JPanel {
    private static final Logger log = LogManager.getLogger(ScriptPanel.class);
    private static final String LOAD_MAGIC_PREFIX = "[Load Magic";
    private static final String LOAD_MAGIC_SUZY_PREFIX = "[Load Magic - Suzy]";
    private static final String LEGACY_PREFIX = "[DCAI";
    private static final String OUTPUT_LANGUAGE = "Groovy";
    private static final String OUTPUT_LANGUAGE_LOWER = "groovy";
    private final JComboBox<String> modeCombo;
    private final JTextArea instructionArea;
    private final JTextArea inputScriptArea;
    private final JEditorPane outputPane;
    private final JButton runButton;
    private final JButton copyButton;
    private final JButton insertButton;
    private final JButton clearButton;
    private final JLabel statusLabel;
    private volatile String lastGeneratedCode;
    private volatile String lastRawReply;

    public void setModeAndContent(String string, String string2, String string3) {
        try {
            if (string != null) {
                this.modeCombo.setSelectedItem(string);
            }
            if (string2 != null) {
                this.instructionArea.setText(string2);
            }
            if (string3 != null) {
                this.inputScriptArea.setText(string3);
            }
            log.info("[ScriptPanel] setModeAndContent: mode={} instrLen={} scriptLen={}", (Object)string, (Object)(string2 != null ? string2.length() : -1), (Object)(string3 != null ? string3.length() : -1));
        }
        catch (Exception exception) {
            log.warn("[ScriptPanel] setModeAndContent failed: {}", (Object)exception.getMessage());
        }
    }

    public void setModeAndRun(String string, String string2, String string3) {
        this.setModeAndContent(string, string2, string3);
        SwingUtilities.invokeLater(() -> {
            try {
                Thread.sleep(100L);
                this.onRun();
            }
            catch (Exception exception) {
                log.warn("[ScriptPanel] setModeAndRun failed: {}", (Object)exception.getMessage());
            }
        });
    }

    public void setModeRunAndInsert(String string, String string2, String string3) {
        try {
            log.info("[ScriptPanel] setModeRunAndInsert: START - mode='{}', instructionLen={}, inputScriptLen={}", (Object)string, (Object)(string2 != null ? string2.length() : -1), (Object)(string3 != null ? string3.length() : -1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModeAndContent(string, string2, string3);
        SwingUtilities.invokeLater(() -> {
            try {
                log.info("[ScriptPanel] setModeRunAndInsert: About to call onRun() with callback");
                Thread.sleep(100L);
                this.onRun(new AiResponseCallback(){

                    @Override
                    public void onResponseReceived(String string, String string2) {
                        try {
                            log.info("[ScriptPanel] setModeRunAndInsert: Callback received - generatedCode={}, rawReply={}", string != null ? "present (len=" + string.length() + ")" : "null", string2 != null ? "present (len=" + string2.length() + ")" : "null");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(() -> {
                            try {
                                if (string != null && !string.trim().isEmpty()) {
                                    log.info("[ScriptPanel] setModeRunAndInsert: Auto-inserting generated code, len={}", (Object)string.length());
                                    ScriptPanel.this.onInsert();
                                } else {
                                    log.warn("[ScriptPanel] setModeRunAndInsert: No generated code available for auto-insert");
                                    if (string2 != null && !string2.trim().isEmpty()) {
                                        log.info("[ScriptPanel] setModeRunAndInsert: Attempting to extract code from raw reply");
                                        String string3 = ScriptPanel.heuristicExtractCode(string2);
                                        if (string3 != null && !string3.trim().isEmpty()) {
                                            log.info("[ScriptPanel] setModeRunAndInsert: Extracted code from raw reply, len={}", (Object)string3.length());
                                            ScriptPanel.this.lastGeneratedCode = string3;
                                            ScriptPanel.this.onInsert();
                                        } else {
                                            log.warn("[ScriptPanel] setModeRunAndInsert: Could not extract code from raw reply");
                                        }
                                    }
                                }
                            }
                            catch (Exception exception) {
                                log.warn("[ScriptPanel] setModeRunAndInsert: Error in auto-insert: {}", (Object)exception.getMessage());
                            }
                        });
                    }

                    @Override
                    public void onError(Exception exception) {
                        log.warn("[ScriptPanel] setModeRunAndInsert: AI analysis failed: {}", (Object)exception.getMessage());
                    }
                });
            }
            catch (Exception exception) {
                log.warn("[ScriptPanel] setModeRunAndInsert failed: {}", (Object)exception.getMessage());
            }
        });
    }

    public ScriptPanel() {
        super(new BorderLayout(6, 6));
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel("Mode:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.modeCombo = new JComboBox<String>(new String[]{"Generate", "Convert", "Fix"});
        jPanel.add(this.modeCombo, gridBagConstraints);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setResizeWeight(0.35);
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.add((Component)new JLabel("Instruction:"), "North");
        this.instructionArea = new JTextArea(8, 100);
        this.instructionArea.setLineWrap(true);
        this.instructionArea.setWrapStyleWord(true);
        this.instructionArea.setToolTipText("Enter: Submit instruction | Ctrl+Enter or Shift+Enter: New line");
        this.instructionArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
                    keyEvent.consume();
                    SwingUtilities.invokeLater(() -> {
                        try {
                            log.info("[ScriptPanel] Enter key pressed - submitting instruction for processing");
                            ScriptPanel.this.onRunWithAutoInsert();
                        }
                        catch (Exception exception) {
                            log.warn("[ScriptPanel] Enter key submission failed: {}", (Object)exception.getMessage());
                        }
                    });
                }
            }
        });
        jPanel2.add((Component)new JScrollPane(this.instructionArea), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(4, 4));
        jPanel3.add((Component)new JLabel("Input script to convert/fix:"), "North");
        this.inputScriptArea = new JTextArea(12, 100);
        this.inputScriptArea.setLineWrap(true);
        this.inputScriptArea.setWrapStyleWord(true);
        jPanel3.add((Component)new JScrollPane(this.inputScriptArea), "Center");
        jSplitPane.setTopComponent(jPanel2);
        jSplitPane.setBottomComponent(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout(6, 6));
        this.outputPane = new JEditorPane();
        this.outputPane.setEditable(false);
        this.outputPane.setContentType("text/html");
        try {
            this.outputPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.outputPane.setFont(UIManager.getFont("TextArea.font"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.outputPane.setText("<html><body></body></html>");
        JScrollPane jScrollPane = new JScrollPane(this.outputPane);
        jScrollPane.setPreferredSize(new Dimension(200, 260));
        this.statusLabel = new JLabel("Ready");
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        JPanel jPanel5 = new JPanel(new BorderLayout(4, 4));
        jPanel5.add((Component)this.statusLabel, "North");
        jPanel5.add((Component)jScrollPane, "Center");
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        this.runButton = new JButton("Run");
        this.runButton.setPreferredSize(new Dimension(90, 24));
        this.runButton.addActionListener(actionEvent -> this.onRun());
        jPanel6.add((Component)this.runButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jPanel6.add(Box.createHorizontalStrut(1), gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        this.copyButton = new JButton("Copy");
        this.copyButton.setPreferredSize(new Dimension(64, 24));
        this.copyButton.addActionListener(actionEvent -> this.onCopy());
        jPanel6.add((Component)this.copyButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        this.insertButton = new JButton("Insert");
        this.insertButton.setPreferredSize(new Dimension(90, 24));
        this.insertButton.setToolTipText("Insert as new JSR223 Sampler at end");
        this.insertButton.addActionListener(actionEvent -> this.onInsert());
        jPanel6.add((Component)this.insertButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        this.clearButton = new JButton("Clear");
        this.clearButton.setPreferredSize(new Dimension(80, 24));
        this.clearButton.setToolTipText("Clear the script area for a fresh start");
        this.clearButton.addActionListener(actionEvent -> this.onClear());
        jPanel6.add((Component)this.clearButton, gridBagConstraints2);
        jPanel4.add((Component)jPanel5, "Center");
        jPanel4.add((Component)jPanel6, "South");
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, jPanel4);
        jSplitPane2.setResizeWeight(0.5);
        this.add((Component)jPanel, "North");
        this.add((Component)jSplitPane2, "Center");
        this.applyLookAndFeelStyles();
        UIManager.addPropertyChangeListener(propertyChangeEvent -> {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                this.applyLookAndFeelStyles();
                SwingUtilities.invokeLater(() -> {
                    this.revalidate();
                    this.repaint();
                });
            }
        });
    }

    private void onRunWithAutoInsert() {
        String string = (String)this.modeCombo.getSelectedItem();
        String string2 = OUTPUT_LANGUAGE;
        String string3 = this.instructionArea.getText().trim();
        String string4 = this.inputScriptArea.getText().trim();
        if (string3.isEmpty()) {
            this.setStatus("Enter an instruction", Color.ORANGE);
            return;
        }
        if (!this.ensureConvertInputPresent(string, string4)) {
            return;
        }
        this.onRun(new AiResponseCallback(){

            @Override
            public void onResponseReceived(String string, String string2) {
                try {
                    log.info("[ScriptPanel] onRunWithAutoInsert: Callback received - generatedCode={}, rawReply={}", string != null ? "present (len=" + string.length() + ")" : "null", string2 != null ? "present (len=" + string2.length() + ")" : "null");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(() -> {
                    try {
                        if (string != null && !string.trim().isEmpty()) {
                            log.info("[ScriptPanel] onRunWithAutoInsert: Auto-inserting generated code, len={}", (Object)string.length());
                            ScriptPanel.this.onInsert();
                        } else {
                            log.warn("[ScriptPanel] onRunWithAutoInsert: No generated code available for auto-insert");
                            if (string2 != null && !string2.trim().isEmpty()) {
                                log.info("[ScriptPanel] onRunWithAutoInsert: Attempting to extract code from raw reply");
                                String string3 = ScriptPanel.heuristicExtractCode(string2);
                                if (string3 != null && !string3.trim().isEmpty()) {
                                    log.info("[ScriptPanel] onRunWithAutoInsert: Extracted code from raw reply, len={}", (Object)string3.length());
                                    ScriptPanel.this.lastGeneratedCode = string3;
                                    ScriptPanel.this.onInsert();
                                } else {
                                    log.warn("[ScriptPanel] onRunWithAutoInsert: Could not extract code from raw reply");
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        log.warn("[ScriptPanel] onRunWithAutoInsert: Error in auto-insert: {}", (Object)exception.getMessage());
                    }
                });
            }

            @Override
            public void onError(Exception exception) {
                log.warn("[ScriptPanel] onRunWithAutoInsert: AI analysis failed: {}", (Object)exception.getMessage());
            }
        });
    }

    private void onRun() {
        String string;
        String string2 = (String)this.modeCombo.getSelectedItem();
        String string3 = OUTPUT_LANGUAGE;
        String string4 = this.instructionArea.getText().trim();
        String string5 = this.inputScriptArea.getText().trim();
        if (string4.isEmpty()) {
            this.setStatus("Enter an instruction", Color.ORANGE);
            return;
        }
        if (!this.ensureConvertInputPresent(string2, string5)) {
            return;
        }
        try {
            log.info("[ScriptPanel] Building prompt: mode='{}' lang='{}'", (Object)string2, (Object)string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = "Generate".equalsIgnoreCase(string2) ? ANSIs.AA(string4, string3) : ("Convert".equalsIgnoreCase(string2) ? ANSIs.A(null, string3, string5) : ANSIs.A(string4, string5));
            if (!ANSIs.AA(string)) {
                this.setStatus("Invalid prompt structure", Color.RED);
                this.setOutputHtml("<p style='color:#f66;'>Error: Invalid prompt structure</p>");
                this.runButton.setEnabled(true);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setStatus("Invalid input: " + illegalArgumentException.getMessage(), Color.RED);
            this.setOutputHtml("<p style='color:#f66;'>Error: " + ScriptPanel.escape(illegalArgumentException.getMessage()) + "</p>");
            this.runButton.setEnabled(true);
            return;
        }
        String string6 = GeminiSidePanel.getSelectedProviderLabel();
        try {
            log.info("[ScriptPanel] onRun: mode={} lang={} instrLen={} inputLen={}", (Object)string2, (Object)string3, (Object)string4.length(), (Object)string5.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStatus("Asking " + string6 + "...", Color.ORANGE);
        this.runButton.setEnabled(false);
        new Thread(() -> {
            Object object;
            try {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("source", "script-panel");
                if (!ScriptPanel.isEmpty(string2)) {
                    linkedHashMap.put("mode", string2);
                }
                if (!ScriptPanel.isEmpty(string3)) {
                    linkedHashMap.put("language", string3);
                }
                if ((object = A.AA(string, linkedHashMap)) == null || !((A.AA)object).A) {
                    String string4 = "Load Magic dispatch error";
                    String string5 = null;
                    if (object != null && ((A.AA)object).AB != null) {
                        if (!ScriptPanel.isEmpty(((A.AA)object).AB.AA)) {
                            string4 = ((A.AA)object).AB.AA;
                        }
                        string5 = ((A.AA)object).AB.s;
                    }
                    this.setStatus(string4, Color.RED);
                    this.setOutputHtml("<p style='color:#f66;'>Error: " + ScriptPanel.escape(string4 + (String)(ScriptPanel.isEmpty(string5) ? "" : " (trace " + string5 + ")")) + "</p>");
                    return;
                }
                String string6 = !ScriptPanel.isEmpty(((A.AA)object).AAA) ? ((A.AA)object).AAA : (((A.AA)object).s != null ? ((A.AA)object).s : "");
                try {
                    log.info("[ScriptPanel] onRun: replyLen={}, replyPreview={}", (Object)(string6 != null ? string6.length() : -1), (Object)ScriptPanel.sampleForLog(string6, 500));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.lastRawReply = string6;
                String string7 = ScriptPanel.extractFirstCodeBlock(string6);
                if (string7 != null && !string7.isEmpty()) {
                    this.lastGeneratedCode = string7 = ScriptPanel.sanitizeCodeForLanguage(string7, string3);
                    try {
                        log.info("[ScriptPanel] onRun: fenced code extracted, codeLen={}, codePreview={}", (Object)string7.length(), (Object)ScriptPanel.sampleForLog(string7, 300));
                        log.info("[ScriptPanel] onRun: lastGeneratedCode is now available for auto-insert");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setOutputHtml("<pre><code>" + ScriptPanel.escape(string7) + "</code></pre>");
                } else {
                    String string8 = ScriptPanel.heuristicExtractCode(string6);
                    if (string8 != null && !string8.isEmpty()) {
                        this.lastGeneratedCode = string8 = ScriptPanel.sanitizeCodeForLanguage(string8, string3);
                        try {
                            log.info("[ScriptPanel] onRun: heuristic code extracted, codeLen={}, codePreview={}", (Object)string8.length(), (Object)ScriptPanel.sampleForLog(string8, 300));
                            log.info("[ScriptPanel] onRun: lastGeneratedCode is now available for auto-insert (heuristic)");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.setOutputHtml("<pre><code>" + ScriptPanel.escape(string8) + "</code></pre>");
                    } else {
                        String string9 = ScriptPanel.enhancedCodeExtraction(string6, OUTPUT_LANGUAGE_LOWER);
                        if (string9 != null && !string9.isEmpty()) {
                            this.lastGeneratedCode = string9 = ScriptPanel.sanitizeCodeForLanguage(string9, string3);
                            try {
                                log.info("[ScriptPanel] onRun: enhanced extraction, codeLen={}, codePreview={}", (Object)string9.length(), (Object)ScriptPanel.sampleForLog(string9, 300));
                                log.info("[ScriptPanel] onRun: lastGeneratedCode is now available for auto-insert (enhanced)");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.setOutputHtml("<pre><code>" + ScriptPanel.escape(string9) + "</code></pre>");
                        } else {
                            this.lastGeneratedCode = null;
                            try {
                                log.warn("[ScriptPanel] onRun: NO CODE FOUND - replyLen={}, replyPreview={}", (Object)(string6 != null ? string6.length() : -1), (Object)ScriptPanel.sampleForLog(string6, 1000));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.setOutputHtml(ScriptPanel.markdownToHtml(string6));
                        }
                    }
                }
                this.setStatus("Ready", Color.GREEN);
                try {
                    GeminiSidePanel.refreshCreditsAsync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {
                object = exception.getMessage();
                if (object == null || ((String)object).isEmpty()) {
                    object = exception.getClass().getSimpleName();
                }
                this.setOutputHtml("<p style='color:#f66;'>Error: " + ScriptPanel.escape((String)object) + "</p>");
                this.setStatus("Error", Color.RED);
            }
            finally {
                SwingUtilities.invokeLater(() -> this.runButton.setEnabled(true));
            }
        }, "script-run").start();
    }

    private void onRun(AiResponseCallback aiResponseCallback) {
        String string = (String)this.modeCombo.getSelectedItem();
        String string2 = OUTPUT_LANGUAGE;
        String string3 = this.instructionArea.getText().trim();
        String string4 = this.inputScriptArea.getText().trim();
        if (string3.isEmpty()) {
            this.setStatus("Enter an instruction", Color.ORANGE);
            if (aiResponseCallback != null) {
                aiResponseCallback.onError(new IllegalArgumentException("Instruction is empty"));
            }
            return;
        }
        if (!this.ensureConvertInputPresent(string, string4)) {
            if (aiResponseCallback != null) {
                aiResponseCallback.onError(new IllegalArgumentException("Input script is empty for Convert mode"));
            }
            return;
        }
        this.setStatus("Running...", Color.BLUE);
        this.runButton.setEnabled(false);
        new Thread(() -> {
            String string5;
            try {
                A.AA aA;
                String string6;
                try {
                    log.info("[ScriptPanel] Building prompt (callback): mode='{}' lang='{}'", (Object)string, (Object)string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string6 = "Generate".equalsIgnoreCase(string) ? ANSIs.AA(string3, string2) : ("Convert".equalsIgnoreCase(string) ? ANSIs.A(null, string2, string4) : ANSIs.A(string3, string4));
                    if (!ANSIs.AA(string6)) {
                        throw new IllegalArgumentException("Invalid prompt structure");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SwingUtilities.invokeLater(() -> {
                        this.setStatus("Invalid prompt: " + illegalArgumentException.getMessage(), Color.RED);
                        this.setOutputHtml("<p style='color:#f66;'>Error: " + ScriptPanel.escape(illegalArgumentException.getMessage()) + "</p>");
                    });
                    if (aiResponseCallback != null) {
                        aiResponseCallback.onError(illegalArgumentException);
                    }
                    SwingUtilities.invokeLater(() -> this.runButton.setEnabled(true));
                    return;
                }
                string5 = GeminiSidePanel.getSelectedProviderLabel();
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("source", "script-panel");
                if (!ScriptPanel.isEmpty(string)) {
                    linkedHashMap.put("mode", string);
                }
                if (!ScriptPanel.isEmpty(string2)) {
                    linkedHashMap.put("language", string2);
                }
                if ((aA = A.AA(string6, linkedHashMap)) == null || !aA.A) {
                    String string7 = "Load Magic dispatch error";
                    String string8 = null;
                    if (aA != null && aA.AB != null) {
                        if (!ScriptPanel.isEmpty(aA.AB.AA)) {
                            string7 = aA.AB.AA;
                        }
                        string8 = aA.AB.s;
                    }
                    this.setStatus(string7, Color.RED);
                    this.setOutputHtml("<p style='color:#f66;'>Error: " + ScriptPanel.escape(string7 + (String)(ScriptPanel.isEmpty(string8) ? "" : " (trace " + string8 + ")")) + "</p>");
                    if (aiResponseCallback != null) {
                        aiResponseCallback.onError(new IllegalStateException(string7));
                    }
                    return;
                }
                String string9 = !ScriptPanel.isEmpty(aA.AAA) ? aA.AAA : (aA.s != null ? aA.s : "");
                try {
                    log.info("[ScriptPanel] onRun(callback): replyLen={}, replyPreview={}", (Object)(string9 != null ? string9.length() : -1), (Object)ScriptPanel.sampleForLog(string9, 500));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.lastRawReply = string9;
                String string10 = ScriptPanel.extractBestCodeBlock(string9, OUTPUT_LANGUAGE_LOWER);
                if (string10 != null && !string10.isEmpty()) {
                    this.lastGeneratedCode = string10 = ScriptPanel.sanitizeCodeForLanguage(string10, string2);
                    try {
                        log.info("[ScriptPanel] onRun(callback): enhanced code extracted for language '{}', codeLen={}, codePreview={}", (Object)string2, (Object)string10.length(), (Object)ScriptPanel.sampleForLog(string10, 300));
                        log.info("[ScriptPanel] onRun(callback): lastGeneratedCode is now available for auto-insert");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setOutputHtml("<pre><code>" + ScriptPanel.escape(string10) + "</code></pre>");
                    if (aiResponseCallback != null) {
                        aiResponseCallback.onResponseReceived(string10, string9);
                    }
                } else {
                    String string11 = ScriptPanel.heuristicExtractCode(string9);
                    if (string11 != null && !string11.isEmpty()) {
                        this.lastGeneratedCode = string11 = ScriptPanel.sanitizeCodeForLanguage(string11, string2);
                        try {
                            log.info("[ScriptPanel] onRun(callback): heuristic code extracted, codeLen={}, codePreview={}", (Object)string11.length(), (Object)ScriptPanel.sampleForLog(string11, 300));
                            log.info("[ScriptPanel] onRun(callback): lastGeneratedCode is now available for auto-insert (heuristic)");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.setOutputHtml("<pre><code>" + ScriptPanel.escape(string11) + "</code></pre>");
                        if (aiResponseCallback != null) {
                            aiResponseCallback.onResponseReceived(string11, string9);
                        }
                    } else {
                        String string12 = ScriptPanel.enhancedCodeExtraction(string9, OUTPUT_LANGUAGE_LOWER);
                        if (string12 != null && !string12.isEmpty()) {
                            this.lastGeneratedCode = string12 = ScriptPanel.sanitizeCodeForLanguage(string12, string2);
                            try {
                                log.info("[ScriptPanel] onRun(callback): enhanced extraction for language '{}', codeLen={}, codePreview={}", (Object)string2, (Object)string12.length(), (Object)ScriptPanel.sampleForLog(string12, 300));
                                log.info("[ScriptPanel] onRun(callback): lastGeneratedCode is now available for auto-insert (enhanced)");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.setOutputHtml("<pre><code>" + ScriptPanel.escape(string12) + "</code></pre>");
                            if (aiResponseCallback != null) {
                                aiResponseCallback.onResponseReceived(string12, string9);
                            }
                        } else {
                            this.lastGeneratedCode = null;
                            try {
                                log.warn("[ScriptPanel] onRun(callback): NO CODE FOUND - replyLen={}, replyPreview={}", (Object)(string9 != null ? string9.length() : -1), (Object)ScriptPanel.sampleForLog(string9, 1000));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.setOutputHtml(ScriptPanel.markdownToHtml(string9));
                            if (aiResponseCallback != null) {
                                aiResponseCallback.onResponseReceived(null, string9);
                            }
                        }
                    }
                }
                this.setStatus("Ready", Color.GREEN);
                try {
                    GeminiSidePanel.refreshCreditsAsync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {
                string5 = exception.getMessage();
                if (string5 == null || string5.isEmpty()) {
                    string5 = exception.getClass().getSimpleName();
                }
                this.setOutputHtml("<p style='color:#f66;'>Error: " + ScriptPanel.escape(string5) + "</p>");
                this.setStatus("Error", Color.RED);
                if (aiResponseCallback != null) {
                    aiResponseCallback.onError(exception);
                }
            }
            finally {
                SwingUtilities.invokeLater(() -> this.runButton.setEnabled(true));
            }
        }, "script-run-callback").start();
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    private void onCopy() {
        Object object;
        String string = this.lastGeneratedCode;
        if (string == null || string.isEmpty()) {
            object = this.outputPane.getText();
            string = ScriptPanel.extractFirstCodeBlockFromHtml((String)object);
        }
        if (string != null) {
            string = ScriptPanel.htmlUnescape(string);
            object = OUTPUT_LANGUAGE;
            string = ScriptPanel.sanitizeCodeForLanguage(string, (String)object);
        }
        try {
            log.info("[ScriptPanel] onCopy: codeLen={} (null means -1)", (Object)(string != null ? string.length() : -1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string.isEmpty()) {
            return;
        }
        object = Toolkit.getDefaultToolkit().getSystemClipboard();
        ((Clipboard)object).setContents(new StringSelection(string), null);
        JOptionPane.showMessageDialog(this, "Script copied to clipboard", "Copied", 1);
    }

    private void onClear() {
        this.instructionArea.setText("");
        this.inputScriptArea.setText("");
        this.outputPane.setText("");
        this.statusLabel.setText("Ready");
        this.lastGeneratedCode = null;
        this.lastRawReply = null;
        this.instructionArea.requestFocus();
        try {
            log.info("[ScriptPanel] onClear: cleared all areas for fresh start");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onInsert() {
        String string;
        boolean bl;
        try {
            log.info("[ScriptPanel] onInsert: START - called from auto-insert or manual button");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = OUTPUT_LANGUAGE;
        String string3 = (String)this.modeCombo.getSelectedItem();
        boolean bl2 = bl = string3 != null && "Fix".equalsIgnoreCase(string3);
        if (string2 == null || !OUTPUT_LANGUAGE.equalsIgnoreCase(string2)) {
            JOptionPane.showMessageDialog(this, "Insert supports Groovy (JSR223) only.", "Not supported", 2);
            return;
        }
        String string4 = this.lastGeneratedCode;
        try {
            log.info("[ScriptPanel] onInsert: lastGeneratedCode len={}", (Object)(string4 != null ? string4.length() : -1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 == null || string4.trim().isEmpty()) {
            String string5 = this.outputPane.getText();
            string4 = ScriptPanel.extractFirstCodeBlockFromHtml(string5);
            try {
                log.info("[ScriptPanel] onInsert: extracted from HTML len={}", (Object)(string4 != null ? string4.length() : -1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string4 == null || string4.trim().isEmpty()) {
                string = ScriptPanel.extractPlainTextFromHtml(string5);
                String string6 = ScriptPanel.heuristicExtractCode(string);
                if (string6 == null || string6.isEmpty()) {
                    string6 = ScriptPanel.heuristicExtractCode(this.lastRawReply);
                }
                if (string6 != null && !string6.isEmpty()) {
                    string4 = ScriptPanel.sanitizeCodeForLanguage(string6, string2);
                    try {
                        log.info("[ScriptPanel] onInsert: heuristic from HTML/raw len={}", (Object)string4.length());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (string4 != null) {
            string4 = ScriptPanel.htmlUnescape(string4);
            string4 = ScriptPanel.sanitizeCodeForLanguage(string4, string2);
        }
        boolean bl3 = false;
        if (string4 == null || string4.trim().isEmpty()) {
            string4 = "log.info('DCAI Insert test - hello');\nvars.put('DC_AI_TEST','ok');\nreturn null;";
            bl3 = true;
            try {
                log.info("[ScriptPanel] onInsert: using fallback test script, len={}", (Object)string4.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = string4;
        boolean bl4 = bl3;
        SwingUtilities.invokeLater(() -> {
            try {
                Object object;
                Object object2;
                String string3;
                Object object3;
                boolean bl3;
                Object object4;
                Object object5;
                JMeterTreeModel jMeterTreeModel;
                GuiPackage guiPackage;
                block70: {
                    String string4;
                    Object object6;
                    JMeterTreeNode jMeterTreeNode;
                    block69: {
                        String string5;
                        block71: {
                            guiPackage = GuiPackage.getInstance();
                            if (guiPackage == null) {
                                JOptionPane.showMessageDialog(this, "JMeter GUI not available", "Error", 0);
                                return;
                            }
                            jMeterTreeModel = guiPackage.getTreeModel();
                            if (jMeterTreeModel == null) {
                                JOptionPane.showMessageDialog(this, "Tree model not available", "Error", 0);
                                return;
                            }
                            jMeterTreeNode = null;
                            try {
                                jMeterTreeNode = guiPackage.getTreeListener().getCurrentNode();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (jMeterTreeNode == null) {
                                try {
                                    object5 = guiPackage.getMainFrame().getTree();
                                    Object object7 = object4 = object5 != null ? ((JTree)object5).getLastSelectedPathComponent() : null;
                                    if (object4 instanceof JMeterTreeNode) {
                                        jMeterTreeNode = (JMeterTreeNode)object4;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            object5 = (JMeterTreeNode)jMeterTreeModel.getRoot();
                            object4 = null;
                            JMeterTreeNode jMeterTreeNode2 = GeminiSidePanel.getPendingInsertTargetNode();
                            string5 = GeminiSidePanel.getPendingInsertTargetLabel();
                            bl3 = false;
                            if (!bl || jMeterTreeNode2 == null) break block71;
                            try {
                                if (jMeterTreeNode2.getParent() != null && jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode2) != null) {
                                    object5 = (JMeterTreeNode)jMeterTreeNode2.getParent();
                                    object4 = jMeterTreeNode2;
                                    bl3 = true;
                                    try {
                                        log.info("[ScriptPanel] onInsert: using captured target node '{}', inserting as sibling (AUTO-INSERT)", (Object)jMeterTreeNode2.getName());
                                    }
                                    catch (Exception exception) {}
                                    break block69;
                                }
                                try {
                                    log.warn("[ScriptPanel] onInsert: captured node '{}' is no longer valid in tree, falling back to label search", (Object)string5);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (string5 == null || string5.isEmpty() || (object6 = this.findSamplerByLabel((JMeterTreeNode)jMeterTreeModel.getRoot(), string5)) == null) break block69;
                                object5 = (JMeterTreeNode)object6.getParent();
                                object4 = object6;
                                bl3 = true;
                                try {
                                    log.info("[ScriptPanel] onInsert: found target sampler '{}' by label search (AUTO-INSERT)", (Object)string5);
                                    break block69;
                                }
                                catch (Exception exception) {
                                }
                            }
                            catch (Exception exception) {
                                try {
                                    log.warn("[ScriptPanel] onInsert: error validating captured node, falling back to label search: {}", (Object)exception.getMessage());
                                }
                                catch (Exception exception2) {
                                    // empty catch block
                                }
                                if (string5 == null || string5.isEmpty() || (object3 = this.findSamplerByLabel((JMeterTreeNode)jMeterTreeModel.getRoot(), string5)) == null) break block69;
                                object5 = (JMeterTreeNode)object3.getParent();
                                object4 = object3;
                                bl3 = true;
                                try {
                                    log.info("[ScriptPanel] onInsert: found target sampler '{}' by label search after exception (AUTO-INSERT)", (Object)string5);
                                    break block69;
                                }
                                catch (Exception exception3) {}
                            }
                            break block69;
                        }
                        if (bl && string5 != null && !string5.isEmpty()) {
                            object6 = this.findSamplerByLabel((JMeterTreeNode)jMeterTreeModel.getRoot(), string5);
                            if (object6 != null) {
                                object5 = (JMeterTreeNode)object6.getParent();
                                object4 = object6;
                                bl3 = true;
                                try {
                                    log.info("[ScriptPanel] onInsert: found target sampler '{}' by label (no node ref available) (AUTO-INSERT)", (Object)string5);
                                }
                                catch (Exception exception) {}
                            }
                        } else if (!bl && string5 != null && !string5.isEmpty()) {
                            try {
                                log.info("[ScriptPanel] onInsert: ignoring pending target '{}' because mode='{}' (MANUAL-INSERT)", (Object)string5, (Object)string3);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (object4 == null && jMeterTreeNode != null) {
                        object6 = jMeterTreeNode.getUserObject();
                        if (object6 instanceof TestElement) {
                            object5 = (JMeterTreeNode)jMeterTreeNode.getParent();
                            object4 = jMeterTreeNode;
                            try {
                                log.info("[ScriptPanel] onInsert: manual insert - inserting as sibling after selected '{}' (MANUAL-INSERT)", (Object)ScriptPanel.nodeName(jMeterTreeNode));
                            }
                            catch (Exception exception) {}
                        } else {
                            object5 = (JMeterTreeNode)jMeterTreeNode.getParent();
                            if (object5 == null) {
                                object5 = (JMeterTreeNode)jMeterTreeModel.getRoot();
                            }
                            try {
                                log.info("[ScriptPanel] onInsert: manual insert - inserting under parent '{}' (MANUAL-INSERT)", (Object)ScriptPanel.nodeName((JMeterTreeNode)object5));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    object6 = new JSR223Sampler();
                    object6.setScriptLanguage(OUTPUT_LANGUAGE_LOWER);
                    object6.setFilename("");
                    object6.setScript(string);
                    if (bl3 && object4 != null) {
                        string3 = ScriptPanel.nodeName((JMeterTreeNode)object4);
                        string4 = this.extractBaseNameFromDcaiScript(string3);
                        object3 = "[Load Magic - Suzy] " + string4;
                    } else {
                        string3 = string3;
                        if (string3 == null) {
                            string3 = "generate";
                        }
                        string4 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyMMdd-HH:mm:ss"));
                        object3 = "[Load Magic - Suzy] - [" + string3.toLowerCase() + "] - " + string4;
                    }
                    if (bl3) {
                        object3 = this.handleVersioning((JMeterTreeNode)object5, (String)object3);
                    }
                    object6.setName((String)object3);
                    object6.setEnabled(true);
                    try {
                        log.info("[ScriptPanel] onInsert: created sampler '{}' with enabled={}", object3, (Object)object6.isEnabled());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        object6.setProperty("TestElement.gui_class", "org.apache.jmeter.testbeans.gui.TestBeanGUI");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        object6.setProperty("TestElement.test_class", JSR223Sampler.class.getName());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (object4 != null) {
                        try {
                            log.info("[ScriptPanel] onInsert: adding sampler as sibling after='{}' under parent='{}' codeLen={}", (Object)ScriptPanel.nodeName((JMeterTreeNode)object4), (Object)ScriptPanel.nodeName((JMeterTreeNode)object5), (Object)string.length());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        string3 = jMeterTreeModel.addComponent((TestElement)object6, (JMeterTreeNode)object5);
                        int n = object5.getIndex((TreeNode)object4) + 1;
                        if (n < object5.getChildCount()) {
                            jMeterTreeModel.removeNodeFromParent((JMeterTreeNode)string3);
                            jMeterTreeModel.insertNodeInto((MutableTreeNode)((Object)string3), (MutableTreeNode)object5, n);
                        }
                    } else {
                        try {
                            log.info("[ScriptPanel] onInsert: adding sampler under parent='{}' codeLen={}", (Object)ScriptPanel.nodeName((JMeterTreeNode)object5), (Object)string.length());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        string3 = jMeterTreeModel.addComponent((TestElement)object6, (JMeterTreeNode)object5);
                    }
                    try {
                        object2 = string3.getUserObject();
                        if (!(object2 instanceof JSR223Sampler)) break block70;
                        object = (JSR223Sampler)object2;
                        object.setScriptLanguage(OUTPUT_LANGUAGE_LOWER);
                        object.setFilename("");
                        object.setScript(string);
                        try {
                            object.setProperty("script", string);
                            object.setProperty("scriptLanguage", OUTPUT_LANGUAGE_LOWER);
                            object.setProperty("filename", "");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            log.info("[ScriptPanel] onInsert: post-add restore: scriptLenNow={} propLen={}", (Object)(object.getScript() != null ? object.getScript().length() : -1), (Object)(object.getProperty("script") != null ? object.getProperty("script").getStringValue().length() : -1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            jMeterTreeModel.nodeChanged((TreeNode)((Object)string3));
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    object2 = guiPackage.getMainFrame().getTree();
                    object = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)((Object)string3)));
                    ((JTree)object2).setSelectionPath((TreePath)object);
                    ((JTree)object2).scrollPathToVisible((TreePath)object);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    object2 = string3.getUserObject();
                    if (object2 instanceof TestElement) {
                        object = (TestElement)object2;
                        log.info("[ScriptPanel] onInsert: new sampler '{}' enabled={}", (Object)object.getName(), (Object)object.isEnabled());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object2 = object5;
                object = object4;
                Object object8 = object3;
                String string6 = string;
                boolean bl4 = bl4;
                boolean bl5 = bl3;
                SwingUtilities.invokeLater(() -> this.lambda$onInsert$13(bl5, (JMeterTreeNode)object, (JMeterTreeNode)object2, (String)object8, string6, bl4));
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, "Insert failed: " + String.valueOf(throwable.getMessage()), "Error", 0);
            }
        });
    }

    private static String buildSamplerNameFromCode(String string) {
        if (string == null) {
            return "Generated Script";
        }
        String[] stringArray = string.split("\n");
        Object object = "";
        for (String string2 : stringArray) {
            if (string2 == null || string2.trim().isEmpty()) continue;
            object = string2.trim();
            break;
        }
        if (((String)object).length() > 60) {
            object = ((String)object).substring(0, 60) + "\u2026";
        }
        if (((String)object).isEmpty()) {
            object = "Generated Script";
        }
        return "JSR223: " + (String)object;
    }

    private static String nodeName(JMeterTreeNode jMeterTreeNode) {
        try {
            if (jMeterTreeNode == null) {
                return "(root)";
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement) {
                String string = ((TestElement)object).getName();
                return string == null || string.isEmpty() ? jMeterTreeNode.toString() : string;
            }
            return jMeterTreeNode.toString();
        }
        catch (Exception exception) {
            return "(node)";
        }
    }

    private JMeterTreeNode findSamplerByLabel(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            TestElement testElement;
            if (jMeterTreeNode == null || string == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && (testElement = (TestElement)object) instanceof Sampler && string.equals(testElement.getName())) {
                return jMeterTreeNode;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                JMeterTreeNode jMeterTreeNode3 = this.findSamplerByLabel(jMeterTreeNode2, string);
                if (jMeterTreeNode3 == null) continue;
                return jMeterTreeNode3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String handleVersioning(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            if (jMeterTreeNode == null) {
                return string + " v1";
            }
            String string2 = this.extractBaseNameFromDcaiScript(string);
            int n = this.findMaxExistingDcaiVersion(jMeterTreeNode, string2);
            int n2 = n + 1;
            String string3 = string + " v" + n2;
            try {
                log.info("[ScriptPanel] handleVersioning: found max existing version={}, using next version '{}'", (Object)n, (Object)string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string3;
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] handleVersioning: error occurred, using fallback: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return string + " v1";
        }
    }

    private int findMaxExistingDcaiVersion(JMeterTreeNode jMeterTreeNode, String string) {
        int n = 0;
        try {
            if (jMeterTreeNode == null || string == null || string.isEmpty()) {
                return 0;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                int n2;
                String string2;
                TestElement testElement;
                String string3;
                Object object;
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                if (jMeterTreeNode2 == null || !((object = jMeterTreeNode2.getUserObject()) instanceof TestElement) || (string3 = (testElement = (TestElement)object).getName()) == null || string3.isEmpty() || !string.equals(string2 = this.extractBaseNameFromDcaiScript(string3)) || (n2 = this.extractVersionFromName(string3)) <= 0) continue;
                n = Math.max(n, n2);
                try {
                    log.info("[ScriptPanel] findMaxExistingDcaiVersion: found AI script '{}' with version {}", (Object)string3, (Object)n2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] findMaxExistingDcaiVersion: error occurred: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return n;
    }

    private int extractVersionFromName(String string) {
        try {
            Pattern pattern = Pattern.compile("\\bv(\\d+)\\b");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(1));
            }
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] extractVersionFromName: error extracting version from '{}': {}", (Object)string, (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return 0;
    }

    private String extractBaseNameFromDcaiScript(String string) {
        try {
            int n;
            if (string == null || string.trim().isEmpty()) {
                return "Generated Script";
            }
            String string2 = string.trim();
            if ((string2.startsWith(LEGACY_PREFIX) || string2.startsWith(LOAD_MAGIC_PREFIX)) && (n = string2.indexOf(93)) != -1 && n + 1 < string2.length()) {
                string2 = string2.substring(n + 1).trim();
            }
            if ((string2 = string2.replaceAll("\\s+v\\d+\\s*$", "").trim()).isEmpty()) {
                string2 = "Generated Script";
            }
            try {
                log.info("[ScriptPanel] extractBaseNameFromDcaiScript: '{}' -> '{}'", (Object)string, (Object)string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string2;
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] extractBaseNameFromDcaiScript: error extracting base name from '{}': {}", (Object)string, (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return "Generated Script";
        }
    }

    private void disableOriginalSampler(JMeterTreeNode jMeterTreeNode) {
        block10: {
            try {
                if (jMeterTreeNode == null) {
                    return;
                }
                Object object = jMeterTreeNode.getUserObject();
                if (!(object instanceof TestElement)) break block10;
                TestElement testElement = (TestElement)object;
                String string = testElement.getName();
                testElement.setEnabled(false);
                try {
                    GuiPackage guiPackage = GuiPackage.getInstance();
                    if (guiPackage != null) {
                        JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
                        jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    log.info("[ScriptPanel] disableOriginalSampler: disabled original sampler '{}'", (Object)string);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                try {
                    log.warn("[ScriptPanel] disableOriginalSampler: error occurred: {}", (Object)exception.getMessage());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    private void disableAllExistingVersions(JMeterTreeNode jMeterTreeNode, String string, String string2) {
        try {
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                try {
                    log.info("[ScriptPanel] disableAllExistingVersions: GuiPackage is null, skipping");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            String string3 = this.extractBaseNameFromDcaiScript(string);
            try {
                log.info("[ScriptPanel] disableAllExistingVersions: starting with targetBase='{}', excluding '{}'", (Object)string3, (Object)string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.disableMatchingAiScripts(jMeterTreeNode, string3, string2, jMeterTreeModel);
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] disableAllExistingVersions: error occurred: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void disableMatchingAiScripts(JMeterTreeNode jMeterTreeNode, String string, String string2, JMeterTreeModel jMeterTreeModel) {
        if (jMeterTreeNode == null || string == null || string.isEmpty()) {
            return;
        }
        try {
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                String string3;
                TestElement testElement;
                String string4;
                Object object;
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                if (jMeterTreeNode2 == null || !((object = jMeterTreeNode2.getUserObject()) instanceof TestElement) || !this.isAiGeneratedSampler(string4 = (testElement = (TestElement)object).getName()) || !string.equals(string3 = this.extractBaseNameFromDcaiScript(string4))) continue;
                if (string4.equals(string2)) {
                    try {
                        log.info("[ScriptPanel] disableMatchingAiScripts: skipping newly created sampler '{}'", (Object)string4);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    log.info("[ScriptPanel] disableMatchingAiScripts: disabling '{}', currently enabled={}", (Object)string4, (Object)testElement.isEnabled());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                testElement.setEnabled(false);
                try {
                    jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    log.info("[ScriptPanel] disableMatchingAiScripts: disabled '{}', now enabled={}", (Object)string4, (Object)testElement.isEnabled());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] disableMatchingAiScripts: error occurred: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private boolean isAiGeneratedSampler(String string) {
        return string != null && (string.startsWith(LOAD_MAGIC_PREFIX) || string.startsWith(LEGACY_PREFIX));
    }

    private JMeterTreeNode findSamplerByName(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            TestElement testElement;
            if (jMeterTreeNode == null || string == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && (testElement = (TestElement)object) instanceof Sampler && string.equals(testElement.getName())) {
                return jMeterTreeNode;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                JMeterTreeNode jMeterTreeNode3 = this.findSamplerByName(jMeterTreeNode2, string);
                if (jMeterTreeNode3 == null) continue;
                return jMeterTreeNode3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean ensureConvertInputPresent(String string, String string2) {
        if (!"Convert".equalsIgnoreCase(string) || !string2.isEmpty()) {
            return true;
        }
        this.setStatus("Enter input script for Convert", Color.ORANGE);
        JOptionPane.showMessageDialog(this, "Please add the script you want to convert before submitting.", "Input Script Required", 0);
        return false;
    }

    private void setOutputHtml(String string) {
        SwingUtilities.invokeLater(() -> this.outputPane.setText("<html><body>" + string + "</body></html>"));
    }

    private void setStatus(String string, Color color) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(string);
            this.statusLabel.setForeground(color);
        });
    }

    private static String extractFirstCodeBlock(String string) {
        return AA.AA(string);
    }

    private static String extractBestCodeBlock(String string, String string2) {
        return AA.A(string, string2);
    }

    private static String extractFirstCodeBlockFromHtml(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf("<pre><code>");
        if (n2 >= 0 && (n = string.indexOf("</code></pre>", n2)) > n2) {
            String string2 = string.substring(n2 + 11, n);
            return string2;
        }
        return null;
    }

    private static String extractPlainTextFromHtml(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("(?is)<br\\s*/?>", "\n");
        string2 = string2.replaceAll("(?is)<[^>]+>", "");
        string2 = ScriptPanel.htmlUnescape(string2);
        return string2;
    }

    private static String heuristicExtractCode(String string) {
        String string2 = ANSIs.A(string);
        if (string2 != null && !string2.trim().isEmpty()) {
            return string2;
        }
        return ScriptPanel.heuristicExtractCodeHelper(string);
    }

    private static String heuristicExtractCodeHelper(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return null;
        }
        String[] stringArray = string2.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = stringArray;
        int n3 = ((String[])object).length;
        for (int i = 0; i < n3; ++i) {
            boolean bl4;
            String string3;
            String string4 = string3 = object[i];
            String string5 = string4.trim();
            if (!bl && (string5.startsWith("import ") || string5.startsWith("def ") || string5.contains("vars.") || string5.contains("prev.") || string5.contains("log.") || string5.contains("try {") || string5.contains("LocalDateTime"))) {
                bl = true;
            }
            if (!bl) continue;
            if (string5.contains("try {")) {
                bl2 = true;
            }
            if (string5.contains("catch")) {
                bl3 = true;
            }
            if (string5.contains("} catch")) {
                bl3 = true;
            }
            boolean bl5 = bl4 = string5.startsWith("import ") || string5.startsWith("def ") || string5.contains("vars.") || string5.contains("prev.") || string5.contains("log.") || string5.contains("sampler.") || string5.contains("ctx.") || string5.contains("props.") || string5.matches(".*[{}();].*") || string5.matches(".*\\w+\\s*=\\s*.*") || string5.contains("LocalDateTime") || string5.contains("String.valueOf") || string5.contains("padLeft") || string5.contains("Math.random") || string5.contains("intValue") || string5.contains("toString") || string5.contains("} catch") || string5.contains("} finally") || string5.contains("prev.set") || string5.contains("log.error") || string5.contains("log.info") || string5.matches(".*\\[.*") || string5.matches(".*\\].*") || string5.matches(".*,.*") || string5.matches("\".*\"") || string5.matches("'.*'") || string5.contains("ThreadLocalRandom") || string5.contains("nextInt") || string5.contains("size()") || string5.contains("put(") || string5.contains("get(") || string5.matches(".*\\w+\\s*\\[.*\\].*") || string5.matches(".*\\w+\\s*\\(.*\\).*");
            if (bl4) {
                ++n;
                n2 = 0;
            } else if (!string5.isEmpty()) {
                ++n2;
            }
            stringBuilder.append(string4).append("\n");
            if (n > 10 ? string5.toLowerCase().startsWith("this script") || string5.toLowerCase().startsWith("the script") || string5.toLowerCase().startsWith("note:") || string5.toLowerCase().startsWith("explanation:") || string5.toLowerCase().startsWith("the code") || string5.toLowerCase().startsWith("here's") || string5.toLowerCase().startsWith("fixed script") || string5.toLowerCase().startsWith("##") || string5.toLowerCase().startsWith("---") : (n > 5 ? string5.toLowerCase().startsWith("this script") || string5.toLowerCase().startsWith("the script") || string5.toLowerCase().startsWith("note:") || string5.toLowerCase().startsWith("explanation:") || string5.toLowerCase().startsWith("the code") || string5.toLowerCase().startsWith("here's") || string5.toLowerCase().startsWith("fixed script") : n2 >= 5)) break;
        }
        if (!((String)(object = stringBuilder.toString().trim())).isEmpty() && ((String)object).length() > 50) {
            log.info("[ScriptPanel] Heuristic extraction: {} code lines, {} total chars", (Object)n, (Object)((String)object).length());
            return object;
        }
        return ScriptPanel.extractCompleteScriptFallback(string);
    }

    private static String extractCompleteScriptFallback(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        Object object = stringArray;
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string2 = object[i];
            String string3 = string2.trim();
            if (!bl && (string3.startsWith("import ") || string3.startsWith("def ") || string3.contains("vars.") || string3.contains("prev.") || string3.contains("log.") || string3.contains("ThreadLocalRandom") || string3.contains("LocalDateTime"))) {
                bl = true;
            }
            if (!bl) continue;
            if (string3.toLowerCase().startsWith("this script") || string3.toLowerCase().startsWith("the script") || string3.toLowerCase().startsWith("note:") || string3.toLowerCase().startsWith("explanation:") || string3.toLowerCase().startsWith("the code") || string3.toLowerCase().startsWith("here's") || string3.toLowerCase().startsWith("fixed script") || string3.toLowerCase().startsWith("##") || string3.toLowerCase().startsWith("---") || string3.startsWith("```")) break;
            stringBuilder.append(string2).append("\n");
        }
        if (!((String)(object = stringBuilder.toString().trim())).isEmpty() && ((String)object).length() > 50) {
            log.info("[ScriptPanel] Fallback extraction: {} chars", (Object)((String)object).length());
            return object;
        }
        return null;
    }

    private static String enhancedCodeExtraction(String string, String string2) {
        Object object;
        int n;
        int n2;
        String[] stringArray;
        if (string == null) {
            return null;
        }
        String string3 = ScriptPanel.extractBestCodeBlock(string, string2);
        if (string3 != null && !string3.trim().isEmpty()) {
            log.info("[ScriptPanel] Enhanced extraction found best code block for language '{}', len={}", (Object)string2, (Object)string3.length());
            return string3;
        }
        for (String string4 : stringArray = new String[]{"```groovy", "```java", "```javascript", "```", "```code"}) {
            String string5;
            int n3;
            n2 = string.indexOf(string4);
            if (n2 < 0 || (n3 = string.indexOf("```", n2 + string4.length())) <= n2 || (string5 = string.substring(n2 + string4.length(), n3).trim()).isEmpty()) continue;
            log.info("[ScriptPanel] Enhanced extraction found code with marker '{}', len={}", (Object)string4, (Object)string5.length());
            return string5;
        }
        String[] stringArray2 = new String[]{"Here's the fixed script:", "Fixed script:", "Here's the corrected code:", "Corrected code:", "import java.time.LocalDateTime"};
        String[] stringArray3 = new String[]{"```", "---", "##", "**Note:", "Note:", "Explanation:", "This script", "The script", "Here's"};
        for (String string6 : stringArray2) {
            int n4 = string.toLowerCase().indexOf(string6.toLowerCase());
            if (n4 < 0) continue;
            String string7 = string.substring(n4 + string6.length());
            n = Integer.MAX_VALUE;
            for (String string8 : stringArray3) {
                int n5 = string7.toLowerCase().indexOf(string8.toLowerCase());
                if (n5 < 0 || n5 >= n) continue;
                n = n5;
            }
            if (n < Integer.MAX_VALUE) {
                object = string7.substring(0, n).trim();
                if (((String)object).isEmpty() || ((String)object).length() <= 20) continue;
                log.info("[ScriptPanel] Enhanced extraction found code with start pattern '{}', len={}", (Object)string6, (Object)((String)object).length());
                return object;
            }
            object = string7.trim();
            if (((String)object).isEmpty() || ((String)object).length() <= 50) continue;
            log.info("[ScriptPanel] Enhanced extraction found code with start pattern '{}' (no end), len={}", (Object)string6, (Object)((String)object).length());
            return object;
        }
        String[] stringArray4 = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        n2 = 0;
        int n6 = 0;
        Object object2 = stringArray4;
        int n7 = ((String[])object2).length;
        for (n = 0; n < n7; ++n) {
            int n8;
            object = object2[n];
            String string9 = ((String)object).trim();
            if (string9.isEmpty()) continue;
            int n9 = n8 = string9.startsWith("import ") || string9.startsWith("def ") || string9.contains("vars.") || string9.contains("prev.") || string9.contains("log.") || string9.contains("sampler.") || string9.contains("ctx.") || string9.contains("props.") || string9.matches(".*[{}();].*") || string9.matches(".*\\w+\\s*=\\s*.*") ? 1 : 0;
            if (n8 != 0) {
                n2 = 1;
                ++n6;
            }
            if (n2 == 0) continue;
            stringBuilder.append((String)object).append("\n");
            if (n8 == 0 && n6 > 0 && (string9.toLowerCase().startsWith("this") || string9.toLowerCase().startsWith("the script") || string9.toLowerCase().startsWith("note:") || string9.toLowerCase().startsWith("explanation:"))) break;
        }
        if (!((String)(object2 = stringBuilder.toString().trim())).isEmpty() && ((String)object2).length() > 50) {
            log.info("[ScriptPanel] Enhanced extraction found {} lines of code-like content, len={}", (Object)n6, (Object)((String)object2).length());
            return object2;
        }
        return null;
    }

    private static String sampleForLog(String string, int n) {
        if (string == null) {
            return "<null>";
        }
        if (string.length() <= n) {
            return string.replace('\n', ' ').replace('\r', ' ');
        }
        return string.substring(0, n).replace('\n', ' ').replace('\r', ' ') + "...";
    }

    private static String markdownToHtml(String string) {
        if (string == null) {
            return "";
        }
        String string2 = ScriptPanel.escape(string).replaceAll("```([\\s\\S]*?)```", "<pre><code>$1</code></pre>").replaceAll("\n\n", "<br/><br/>").replaceAll("\n", "<br/>").replaceAll("\\*\\*(.+?)\\*\\*", "<b>$1</b>");
        return string2;
    }

    private static String escape(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String htmlUnescape(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&#39;", "'").replace("&amp;", "&");
    }

    private static String buildBackgroundForLanguage(String string) {
        String string2 = string == null ? "" : string.trim().toLowerCase();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("You are generating code to run inside Apache JMeter.\n\n");
        stringBuilder.append("General requirements:\n");
        stringBuilder.append("- Thread-safety: no static mutable state, no global singletons.\n");
        stringBuilder.append("- Deterministic output: no sleeps/random unless asked.\n");
        stringBuilder.append("- I/O: don\u2019t write files or network unless asked.\n");
        stringBuilder.append("- Output \u2018code only\u2019 (no commentary), formatted for direct paste.\n");
        stringBuilder.append("- Include appropriate import statements for the selected language (see below).\n\n");
        if (OUTPUT_LANGUAGE_LOWER.equals(string2) || "jsr223".equals(string2)) {
            stringBuilder.append("Environment facts (Groovy / JSR223):\n");
            stringBuilder.append("- Context bindings: log, ctx, vars, props, prev (SampleResult), sampler, OUT.\n");
            stringBuilder.append("- Access variables via vars.get(\"name\") / vars.put(\"name\", \"value\"); avoid ${var} expansions.\n");
            stringBuilder.append("- Prefer Groovy (JSR223) for performance (compiled and cached).\n");
            stringBuilder.append("- Read response: prev.getResponseDataAsString(); headers: prev.getResponseHeaders(); code: prev.getResponseCode();\n");
            stringBuilder.append("- Thread-safety: no static mutable fields; keep state local to the script.\n");
            stringBuilder.append("- Logging: use log.info/log.debug instead of println/System.out.\n");
            stringBuilder.append("- Return: scripts typically don\u2019t need an explicit return; to expose values, use vars.put(\"var\", \"value\").\n");
            stringBuilder.append("- JSON/XML helpers: prefer groovy.json.JsonSlurper and groovy.xml.XmlSlurper; avoid external libs unless asked.\n");
            stringBuilder.append("- Date/time: prefer java.time.* APIs; avoid new Date().toGMTString().\n");
            stringBuilder.append("- Encoding: for bytes use prev.getResponseData(); for text use prev.getResponseDataAsString().\n");
            stringBuilder.append("- Imports: include only what you use; prefer JDK + Groovy stdlib.\n");
        } else if ("beanshell".equals(string2)) {
            stringBuilder.append("Environment facts (BeanShell):\n");
            stringBuilder.append("- log, ctx, vars, props, prev, sampler, OUT are available.\n");
            stringBuilder.append("- BeanShell is legacy; consider Groovy for performance.\n");
            stringBuilder.append("- Imports: include necessary imports at the top if non-default classes are used.\n");
        } else if ("jexl".equals(string2) || "jexl2".equals(string2) || "jexl3".equals(string2)) {
            stringBuilder.append("Environment facts (JEXL):\n");
            stringBuilder.append("- Use ${__jexl3(...)} or ${__jexl2(...)}; can access log, ctx, vars, props, sampler, sampleResult.\n");
            stringBuilder.append("- Imports: not applicable; return a single expression.\n");
        } else if ("java".equals(string2)) {
            stringBuilder.append("Environment facts (Java Request):\n");
            stringBuilder.append("- Implement JavaSamplerClient; used by the \u2018Java Request\u2019 sampler.\n");
            stringBuilder.append("- Imports: include all required imports (e.g., java.util.*, org.apache.jmeter.*) so the class compiles standalone.\n");
        } else {
            stringBuilder.append("Environment facts:\n");
            stringBuilder.append("- log, ctx, vars, props may be available depending on language.\n");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static String sanitizeCode(String string) {
        String string2;
        if (string == null) {
            return "";
        }
        String string3 = string;
        int n = string3.indexOf(10);
        if (n > 0 && ((string2 = string3.substring(0, n).trim()).equalsIgnoreCase(OUTPUT_LANGUAGE_LOWER) || string2.equalsIgnoreCase("java"))) {
            string3 = string3.substring(n + 1);
        }
        try {
            string3 = Normalizer.normalize(string3, Normalizer.Form.NFKC);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string3 = string3.replace('\u00a0', ' ').replace('\u2007', ' ').replace('\u202f', ' ').replace("\u200b", "").replace("\u200c", "").replace("\u200d", "").replace("\ufeff", "");
        string3 = string3.replaceAll("(?i)<[^>]*uff[^>]*>", "");
        string3 = string3.replace("\r\n", "\n").replace('\r', '\n');
        return string3.trim();
    }

    private static String sanitizeCodeForLanguage(String string, String string2) {
        String string3;
        String string4 = ScriptPanel.sanitizeCode(string);
        String string5 = string3 = string2 == null ? "" : string2.trim().toLowerCase();
        if (OUTPUT_LANGUAGE_LOWER.equals(string3)) {
            // empty if block
        }
        return string4;
    }

    public void applyLookAndFeelStyles() {
        SwingUtilities.invokeLater(() -> {
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
            String string = UIManager.getFont("Label.font") != null ? UIManager.getFont("Label.font").getFamily() : "Sans-Serif";
            Color color = UIManager.getColor("EditorPane.background");
            Color color2 = UIManager.getColor("EditorPane.foreground");
            String string2 = ScriptPanel.colorToHex(color != null ? color : UIManager.getColor("Panel.background"));
            String string3 = ScriptPanel.colorToHex(color2 != null ? color2 : UIManager.getColor("Label.foreground"));
            styleSheet.addRule("body { background: " + string2 + "; color: " + string3 + "; font-family: '" + string + "', Sans-Serif; font-size: 12px; margin: 8px; }");
            styleSheet.addRule("code, pre { font-family: '" + (UIManager.getFont("TextArea.font") != null ? UIManager.getFont("TextArea.font").getFamily() : "Monospaced") + "', Monospaced; }");
            styleSheet.addRule("a { color: " + string3 + "; }");
            this.outputPane.setEditorKit(hTMLEditorKit);
            this.outputPane.setText(this.outputPane.getText());
        });
    }

    private static String colorToHex(Color color) {
        if (color == null) {
            return "#333333";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private /* synthetic */ void lambda$onInsert$13(boolean bl, JMeterTreeNode jMeterTreeNode, JMeterTreeNode jMeterTreeNode2, String string, String string2, boolean bl2) {
        try {
            String string3;
            Thread.sleep(100L);
            if (bl) {
                try {
                    log.info("[ScriptPanel] onInsert: AUTO-INSERT - disabling previous versions and original sampler");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string3 = "[Load Magic - Suzy] " + (jMeterTreeNode != null ? ScriptPanel.nodeName(jMeterTreeNode) : "Generated Script");
                this.disableAllExistingVersions(jMeterTreeNode2, string3, string);
                if (jMeterTreeNode != null) {
                    this.disableOriginalSampler(jMeterTreeNode);
                }
            } else {
                try {
                    log.info("[ScriptPanel] onInsert: MANUAL-INSERT - skipping automatic disabling, user can decide");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string3 = jMeterTreeNode != null ? "Inserted '" + string + "' after '" + ScriptPanel.nodeName(jMeterTreeNode) + "' (len=" + string2.length() + ")" + (bl2 ? " [fallback]" : "") : "Inserted '" + string + "' under '" + ScriptPanel.nodeName(jMeterTreeNode2) + "' (len=" + string2.length() + ")" + (bl2 ? " [fallback]" : "");
            JOptionPane.showMessageDialog(this, string3, "Inserted", 1);
        }
        catch (Exception exception) {
            try {
                log.warn("[ScriptPanel] onInsert: error in delayed disable: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string4 = "Inserted '" + string + "' (len=" + string2.length() + ")" + (bl2 ? " [fallback]" : "");
            JOptionPane.showMessageDialog(this, string4, "Inserted", 1);
        }
    }

    public static interface AiResponseCallback {
        public void onResponseReceived(String var1, String var2);

        public void onError(Exception var1);
    }
}

