/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.A;
import com.company.GeminiSidePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class RegexPanel
extends JPanel {
    private final JTextArea contextArea;
    private final JTextArea instructionArea;
    private final JButton generateButton;
    private final JButton clearButton;
    private final JTextField regexField;
    private final JButton copyButton;
    private final JButton insertButton;
    private final JEditorPane outputPane;
    private final JLabel statusLabel;
    private volatile boolean autoInsertNext = false;

    public RegexPanel() {
        super(new BorderLayout(6, 6));
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)new JLabel("HTTP / Text Context:"), "North");
        this.contextArea = new JTextArea(8, 100);
        this.contextArea.setLineWrap(true);
        this.contextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.contextArea);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 6));
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 6));
        JLabel jLabel = new JLabel("Instruction (e.g., value for client_data) - Enter: Generate | Ctrl+Enter/Shift+Enter: New line:");
        jPanel3.add((Component)jLabel, "North");
        this.instructionArea = new JTextArea(16, 100);
        this.instructionArea.setLineWrap(true);
        this.instructionArea.setWrapStyleWord(true);
        this.instructionArea.setFont(this.instructionArea.getFont().deriveFont(0, this.instructionArea.getFont().getSize2D()));
        this.instructionArea.setToolTipText("Enter: Generate regex | Ctrl+Enter or Shift+Enter: New line");
        this.instructionArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
                    keyEvent.consume();
                    SwingUtilities.invokeLater(() -> {
                        try {
                            RegexPanel.this.onGenerate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.instructionArea);
        jPanel3.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel("Regex:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.regexField = new JTextField();
        this.regexField.setEditable(false);
        this.regexField.setToolTipText("Extracted regex");
        Dimension dimension = this.regexField.getPreferredSize();
        this.regexField.setPreferredSize(new Dimension(dimension.width, 24));
        jPanel4.add((Component)this.regexField, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        this.generateButton = new JButton("Generate RegEx");
        Dimension dimension2 = this.generateButton.getPreferredSize();
        this.generateButton.setPreferredSize(new Dimension(Math.max(130, dimension2.width), 24));
        this.generateButton.addActionListener(actionEvent -> this.onGenerate());
        jPanel5.add((Component)this.generateButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        this.copyButton = new JButton("Copy");
        this.copyButton.setPreferredSize(new Dimension(64, 24));
        this.copyButton.addActionListener(actionEvent -> this.onCopyRegex());
        jPanel5.add((Component)this.copyButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        this.insertButton = new JButton("Insert");
        this.insertButton.setPreferredSize(new Dimension(72, 24));
        this.insertButton.addActionListener(actionEvent -> this.onInsertRegex());
        jPanel5.add((Component)this.insertButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        jPanel5.add(Box.createHorizontalStrut(1), gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        this.clearButton = new JButton("Clear");
        this.clearButton.setPreferredSize(new Dimension(64, 24));
        this.clearButton.addActionListener(actionEvent -> this.onClear());
        jPanel5.add((Component)this.clearButton, gridBagConstraints2);
        this.outputPane = new JEditorPane();
        this.outputPane.setEditable(false);
        this.outputPane.setContentType("text/html");
        try {
            this.outputPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.outputPane.setFont(UIManager.getFont("TextArea.font"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.outputPane.setText("<html><body></body></html>");
        JScrollPane jScrollPane3 = new JScrollPane(this.outputPane);
        jScrollPane3.setPreferredSize(new Dimension(200, 260));
        this.statusLabel = new JLabel("Ready");
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        JPanel jPanel6 = new JPanel(new BorderLayout(4, 4));
        jPanel6.add((Component)this.statusLabel, "North");
        jPanel6.add((Component)jScrollPane3, "Center");
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel(new BorderLayout(4, 4));
        jPanel7.add((Component)jPanel4, "North");
        jPanel7.add((Component)jPanel5, "South");
        jPanel2.add((Component)jPanel7, "South");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
        jSplitPane.setResizeWeight(0.3);
        this.add((Component)jSplitPane, "Center");
        this.applyLookAndFeelStyles();
        UIManager.addPropertyChangeListener(propertyChangeEvent -> {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                this.applyLookAndFeelStyles();
                SwingUtilities.invokeLater(() -> {
                    this.revalidate();
                    this.repaint();
                });
            }
        });
    }

    public void setContextText(String string) {
        SwingUtilities.invokeLater(() -> this.contextArea.setText(string == null ? "" : string));
    }

    public void setInstructionText(String string) {
        SwingUtilities.invokeLater(() -> this.instructionArea.setText(string == null ? "" : string));
    }

    private void onGenerate() {
        String string = this.contextArea.getText().trim();
        String string2 = this.instructionArea.getText().trim();
        if (string.isEmpty() || string2.isEmpty()) {
            this.render("<p style='color:#ff6;'>Please provide both context and an instruction.</p>");
            this.setStatus("Enter context and instruction", Color.ORANGE);
            return;
        }
        String string3 = GeminiSidePanel.getSelectedProviderLabel();
        this.setStatus("Asking " + string3 + "...", Color.ORANGE);
        this.generateButton.setEnabled(false);
        new Thread(() -> {
            Object object;
            try {
                String string3;
                boolean bl = string.indexOf(10) >= 0 || string.indexOf(13) >= 0;
                object = new LinkedHashMap();
                object.put("source", "regex-panel");
                A.AA aA = A.A(string2, string, bl, (Map<String, String>)object);
                if (aA == null || !aA.A) {
                    String string4 = "Dispatch error";
                    String string5 = null;
                    if (aA != null && aA.AB != null) {
                        if (!RegexPanel.isEmpty(aA.AB.AA)) {
                            string4 = aA.AB.AA;
                        }
                        string5 = aA.AB.s;
                    }
                    this.render("<p style='color:#f66;'>" + RegexPanel.escape(string4) + (String)(RegexPanel.isEmpty(string5) ? "" : " (trace " + RegexPanel.escape(string5) + ")") + "</p>");
                    this.setStatus("Load Magic dispatch error", Color.RED);
                    return;
                }
                String string6 = !RegexPanel.isEmpty(aA.s) ? aA.s : (string3 = aA.AAA != null ? aA.AAA : "");
                if (RegexPanel.isEmpty(string3)) {
                    this.render("<p style='color:#f66;'>No response from Rupert dispatch.</p>");
                    this.setStatus("Empty reply", Color.RED);
                    return;
                }
                this.postProcessReply(string3, false);
                try {
                    GeminiSidePanel.refreshCreditsAsync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {
                object = exception.getMessage();
                if (object == null || ((String)object).isEmpty()) {
                    object = exception.getClass().getSimpleName();
                }
                this.render("<p style='color:#f66;'>Error: " + RegexPanel.escape((String)object) + "</p>");
                this.setStatus("Error", Color.RED);
            }
            finally {
                SwingUtilities.invokeLater(() -> this.generateButton.setEnabled(true));
            }
        }, "regex-gen").start();
    }

    private void postProcessReply(String string, String string2) {
        this.postProcessReply(string, string2, true);
    }

    private void postProcessReply(String string, boolean bl) {
        this.postProcessReply(null, string, bl);
    }

    private void postProcessReply(String string, String string2, boolean bl) {
        if (string2 == null) {
            string2 = "";
        }
        this.setStatus("Received reply (len=" + string2.length() + ")", Color.GRAY);
        String string3 = RegexPanel.normalizeRegex(RegexPanel.extractRegexSmart(string2));
        if (string3 != null && !string3.isEmpty()) {
            this.setRegex(string3);
        }
        this.renderMarkdown(string2);
        this.setStatus("Ready", Color.GREEN);
    }

    private static String jsonEscape(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(Math.min(8192, string.length() + 64));
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                default: {
                    if (c < ' ') {
                        stringBuilder.append(String.format("\\u%04x", c));
                        continue block7;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void renderMarkdown(String string) {
        try {
            if (string == null || string.trim().isEmpty()) {
                this.render("<i>(no content returned)</i>");
                return;
            }
            String string2 = RegexPanel.normalizeDisplay(string);
            if (string2.contains("```")) {
                String string3 = RegexPanel.escape(string2).replaceAll("```([\\s\\S]*?)```", "<pre><code>$1</code></pre>").replaceAll("\n\n", "<br/><br/>").replaceAll("\n", "<br/>").replaceAll("\\*\\*(.+?)\\*\\*", "<b>$1</b>");
                this.render(string3);
                return;
            }
            if (this.looksScriptLike(string2) || string2.indexOf(10) >= 0) {
                String string4 = "<pre><code>" + RegexPanel.escape(string2) + "</code></pre>";
                this.render(string4);
                return;
            }
            String string5 = RegexPanel.escape(string2).replaceAll("\\*\\*(.+?)\\*\\*", "<b>$1</b>").replaceAll("\n\n", "<br/><br/>").replaceAll("\n", "<br/>");
            this.render(string5);
        }
        catch (Exception exception) {
            this.render("<span style='color:#c00'>Rendering error: " + RegexPanel.escape(exception.getMessage() == null ? exception.getClass().getSimpleName() : exception.getMessage()) + "</span>");
        }
    }

    private boolean looksScriptLike(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return false;
        }
        if (string2.contains("\n") && (string2.contains("import ") || string2.contains(" vars.put(") || string2.contains("new ") || string2.contains("def "))) {
            return true;
        }
        return string2.contains("=") && string2.contains("\n");
    }

    private void render(String string) {
        SwingUtilities.invokeLater(() -> this.outputPane.setText("<html><body>" + string + "</body></html>"));
    }

    private void setStatus(String string, Color color) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(string);
            this.statusLabel.setForeground(color);
        });
    }

    private void setRegex(String string) {
        SwingUtilities.invokeLater(() -> {
            this.regexField.setText(string);
            if (this.autoInsertNext) {
                try {
                    BiConsumer<String, String> biConsumer = GeminiSidePanel.getRegexInsertHandler();
                    Supplier<String> supplier = GeminiSidePanel.getRegexVarSupplier();
                    if (biConsumer != null && string != null && !string.trim().isEmpty()) {
                        String string2;
                        String string3 = string2 = supplier != null ? supplier.get() : null;
                        if (string2 == null || string2.trim().isEmpty()) {
                            string2 = "DCAI_REGEX_VAR";
                        }
                        biConsumer.accept(string2.trim(), string.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.autoInsertNext = false;
            }
        });
    }

    private void onCopyRegex() {
        String string = this.regexField.getText();
        if (string == null || string.isEmpty()) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
        JOptionPane.showMessageDialog(this, "Regex copied to clipboard", "Copied", 1);
    }

    private void onClear() {
        try {
            this.contextArea.setText("");
            this.instructionArea.setText("");
            this.regexField.setText("");
            this.render("");
            this.setStatus("Cleared", Color.GRAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onInsertRegex() {
        try {
            String string;
            String string2 = this.regexField.getText();
            if (string2 == null || string2.trim().isEmpty()) {
                JOptionPane.showMessageDialog(this, "No regex to insert. Generate or paste one first.", "Empty", 1);
                return;
            }
            BiConsumer<String, String> biConsumer = GeminiSidePanel.getRegexInsertHandler();
            Supplier<String> supplier = GeminiSidePanel.getRegexVarSupplier();
            if (biConsumer == null) {
                JOptionPane.showMessageDialog(this, "Insert is not available outside the visualiser context.", "No Context", 1);
                return;
            }
            String string3 = string = supplier != null ? supplier.get() : null;
            if ((string == null || string.trim().isEmpty()) && ((string = JOptionPane.showInputDialog(this, "Variable name for extractor:", "Variable Name", 3)) == null || string.trim().isEmpty())) {
                return;
            }
            biConsumer.accept(string.trim(), string2.trim());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error inserting regex: " + exception.getMessage(), "Error", 0);
        }
    }

    public void autoGenerateAndInsert() {
        this.autoInsertNext = true;
        this.onGenerate();
    }

    private static String extractRegex(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf("```");
        if (n3 >= 0 && (n2 = string.indexOf("```", n3 + 3)) > n3) {
            int n4;
            int n5;
            String string2 = string.substring(n3 + 3, n2).trim();
            int n6 = string2.indexOf("Pattern.compile(");
            if (n6 >= 0 && (n5 = string2.indexOf(34, n6)) > 0 && (n4 = string2.indexOf(34, n5 + 1)) > n5) {
                return string2.substring(n5 + 1, n4);
            }
            if (string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        n2 = string.indexOf(96);
        if (n2 >= 0 && (n = string.indexOf(96, n2 + 1)) > n2) {
            return string.substring(n2 + 1, n).trim();
        }
        return null;
    }

    private static String extractRegexSmart(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        String string2 = RegexPanel.extractRegex(string);
        if (string2 != null && !string2.trim().isEmpty()) {
            return string2.trim();
        }
        for (String string3 : stringArray = string.split("\n")) {
            String string4;
            String string5 = string3.trim();
            if (string5.isEmpty() || (string4 = string5.toLowerCase()).startsWith("here is") || string4.contains("jmeter")) continue;
            if (string5.startsWith("`") && string5.endsWith("`") && string5.length() > 2) {
                string5 = string5.substring(1, string5.length() - 1).trim();
            }
            if (!RegexPanel.looksLikeRegex(string5)) continue;
            return string5;
        }
        return RegexPanel.extractRegex(string);
    }

    private static boolean looksLikeRegex(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return false;
        }
        String string3 = "\\()[]^$?+*{}|";
        boolean bl = false;
        for (int i = 0; i < string3.length(); ++i) {
            if (string2.indexOf(string3.charAt(i)) < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        return string2.contains("\\s") || string2.contains("\\d") || string2.contains("[") || string2.contains("(") || string2.contains("\"") || string2.contains(":");
    }

    private static String normalizeRegex(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = RegexPanel.decodeRawUnicodeTokens(string2);
        string2 = string2.replaceFirst("(?i)^regex\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^regexp\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^pattern\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^perl\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^pcre\\s*[:\\-]?\\s*", "");
        string2 = string2.replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r").replace("\\\"", "\"").replace("\\'", "'").replace("\\\\", "\\");
        string2 = string2.replace("\\u003c", "<").replace("\\u003e", ">").replace("\\u002f", "/");
        string2 = string2.replace("u003c", "<").replace("U003C", "<").replace("u003e", ">").replace("U003E", ">").replace("u002f", "/").replace("U002F", "/");
        if ((string2 = string2.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&")).startsWith("`") && string2.endsWith("`") && string2.length() > 2) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.length() >= 2 && string2.charAt(0) == '/' && string2.charAt(string2.length() - 1) == '/') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2.trim();
    }

    private static String escape(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String normalizeDisplay(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = RegexPanel.decodeRawUnicodeTokens(string2);
        string2 = string2.replace("\\u003c", "<").replace("\\u003e", ">").replace("\\u002f", "/");
        string2 = string2.replace("u003c", "<").replace("U003C", "<").replace("u003e", ">").replace("U003E", ">").replace("u002f", "/").replace("U002F", "/");
        string2 = string2.replace("\\/", "/");
        string2 = string2.replaceAll("\\(\\?[a-zA-Z-]+\\)", "");
        string2 = string2.replaceAll("(?m)^\\s*regex\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceAll("(?i)group\\s*1\\s*[\u2192>:\\-]+\\s*", "Group 1 = ");
        return string2;
    }

    private static String decodeRawUnicodeTokens(String string) {
        if (string == null || string.indexOf(117) < 0 && string.indexOf(85) < 0) {
            return string;
        }
        Pattern pattern = Pattern.compile("(?i)(?<!\\\\)u([0-9a-f]{4})");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                int n = Integer.parseInt(string2, 16);
                String string3 = new String(Character.toChars(n));
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public void applyLookAndFeelStyles() {
        SwingUtilities.invokeLater(() -> {
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
            String string = UIManager.getFont("Label.font") != null ? UIManager.getFont("Label.font").getFamily() : "Sans-Serif";
            Color color = UIManager.getColor("EditorPane.background");
            Color color2 = UIManager.getColor("EditorPane.foreground");
            String string2 = RegexPanel.colorToHex(color != null ? color : UIManager.getColor("Panel.background"));
            String string3 = RegexPanel.colorToHex(color2 != null ? color2 : UIManager.getColor("Label.foreground"));
            styleSheet.addRule("body { background: " + string2 + "; color: " + string3 + "; font-family: '" + string + "', Sans-Serif; font-size: 12px; margin: 8px; }");
            styleSheet.addRule("code, pre { font-family: '" + (UIManager.getFont("TextArea.font") != null ? UIManager.getFont("TextArea.font").getFamily() : "Monospaced") + "', Monospaced; }");
            styleSheet.addRule("pre, code { white-space: pre-wrap; }");
            styleSheet.addRule("a { color: " + string3 + "; }");
            this.outputPane.setEditorKit(hTMLEditorKit);
            this.outputPane.setText(this.outputPane.getText());
        });
    }

    private static String colorToHex(Color color) {
        if (color == null) {
            return "#333333";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

