/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.ABM;
import com.company.UploadProgress;
import java.io.File;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarUploadWorker
extends SwingWorker<ABM.AAA, UploadProgress> {
    private static final Logger log = LoggerFactory.getLogger(HarUploadWorker.class);
    private final File harFile;
    private final String userId;
    private final String projectId;
    private final String subscriptionTier;
    private final String excludePatterns;
    private final JProgressBar progressBar;
    private final JTextField statusLabel;
    private final JButton cancelButton;

    public HarUploadWorker(File file, String string, String string2, String string3, String string4, JProgressBar jProgressBar, JTextField jTextField) {
        this(file, string, string2, string3, string4, jProgressBar, jTextField, null);
    }

    public HarUploadWorker(File file, String string, String string2, String string3, String string4, JProgressBar jProgressBar, JTextField jTextField, JButton jButton) {
        this.harFile = file;
        this.userId = string;
        this.projectId = string2;
        this.subscriptionTier = string3;
        this.excludePatterns = string4;
        this.progressBar = jProgressBar;
        this.statusLabel = jTextField;
        this.cancelButton = jButton;
        if (jButton != null) {
            jButton.setEnabled(true);
        }
    }

    @Override
    protected ABM.AAA doInBackground() {
        log.info("=== Starting HAR upload in background thread ===");
        log.info("File: {}", (Object)(this.harFile != null ? this.harFile.getAbsolutePath() : "null"));
        log.info("User ID: {}", (Object)this.userId);
        log.info("Project ID: {}", (Object)this.projectId);
        log.info("File exists: {}", (Object)(this.harFile != null && this.harFile.exists() ? 1 : 0));
        log.info("File size: {} bytes", (Object)(this.harFile != null ? this.harFile.length() : 0L));
        this.publish(new UploadProgress("Background thread started", 0L, 0L, 0));
        try {
            ABM.AA aA = new ABM.AA(){

                @Override
                public void onProgress(String string, long l, long l2, int n) {
                    log.debug("Progress update: stage={}, bytes={}/{}, percent={}%", new Object[]{string, l, l2, n});
                    if (HarUploadWorker.this.isCancelled()) {
                        log.info("Upload cancelled by user");
                        return;
                    }
                    HarUploadWorker.this.publish(new UploadProgress[]{new UploadProgress(string, l, l2, n)});
                }

                @Override
                public void onStageChange(String string) {
                    log.info("Stage change: {}", (Object)string);
                    if (HarUploadWorker.this.isCancelled()) {
                        return;
                    }
                    HarUploadWorker.this.publish(new UploadProgress[]{new UploadProgress(string, 0L, 0L, 0)});
                }
            };
            log.info("Calling uploadHarFile with progress listener...");
            ABM.AAA aAA = ABM.A(this.harFile, this.userId, this.projectId, this.subscriptionTier, this.excludePatterns, aA);
            log.info("HAR upload completed: success={}, message={}", (Object)(aAA != null ? aAA.A() : false), (Object)(aAA != null ? aAA.AA() : "null result"));
            return aAA;
        }
        catch (Exception exception) {
            log.error("Exception in doInBackground during HAR upload", (Throwable)exception);
            throw exception;
        }
    }

    @Override
    protected void process(List<UploadProgress> list) {
        if (!list.isEmpty()) {
            UploadProgress uploadProgress = list.get(list.size() - 1);
            log.debug("Processing {} progress updates on EDT, latest: stage={}, percent={}%", new Object[]{list.size(), uploadProgress.stage, uploadProgress.percentComplete});
            if (this.progressBar != null) {
                this.progressBar.setValue(uploadProgress.percentComplete);
                this.progressBar.setString(uploadProgress.percentComplete + "%");
            }
            if (this.statusLabel != null) {
                String string = uploadProgress.totalBytes > 0L ? String.format("%s: %d%% (%s / %s)", uploadProgress.stage, uploadProgress.percentComplete, this.formatBytes(uploadProgress.bytesUploaded), this.formatBytes(uploadProgress.totalBytes)) : uploadProgress.stage;
                this.statusLabel.setText(string);
                log.debug("Updated status label to: {}", (Object)string);
            }
        }
    }

    @Override
    protected void done() {
        log.info("=== Worker done() method called ===");
        try {
            if (this.isCancelled()) {
                log.info("Upload was cancelled");
                if (this.statusLabel != null) {
                    this.statusLabel.setText("Upload cancelled");
                }
                if (this.progressBar != null) {
                    this.progressBar.setValue(0);
                    this.progressBar.setString("Cancelled");
                }
            } else {
                log.info("Getting upload result from worker...");
                ABM.AAA aAA = (ABM.AAA)this.get();
                log.info("Result retrieved: success={}", aAA != null ? Boolean.valueOf(aAA.A()) : "null");
                if (aAA != null && aAA.A()) {
                    log.info("Upload completed successfully: harId={}", (Object)aAA.s());
                    if (this.statusLabel != null) {
                        this.statusLabel.setText("Upload complete!");
                    }
                    if (this.progressBar != null) {
                        this.progressBar.setValue(100);
                        this.progressBar.setString("Complete");
                    }
                } else {
                    String string = aAA != null ? aAA.AA() : "Unknown error (null result)";
                    log.error("Upload failed: {}", (Object)string);
                    if (this.statusLabel != null) {
                        this.statusLabel.setText("Upload failed: " + string);
                    }
                    if (this.progressBar != null) {
                        this.progressBar.setValue(0);
                        this.progressBar.setString("Failed");
                    }
                }
            }
        }
        catch (CancellationException cancellationException) {
            log.info("Upload was cancelled (CancellationException)");
            if (this.statusLabel != null) {
                this.statusLabel.setText("Upload cancelled");
            }
        }
        catch (Exception exception) {
            log.error("Exception in done() method: {}", (Object)exception.getMessage(), (Object)exception);
            if (this.statusLabel != null) {
                this.statusLabel.setText("Error: " + exception.getMessage());
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(0);
                this.progressBar.setString("Error");
            }
        }
        finally {
            log.info("Disabling cancel button and cleaning up");
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(false);
            }
        }
    }

    private String formatBytes(long l) {
        if (l < 1024L) {
            return l + " B";
        }
        if (l < 0x100000L) {
            return String.format("%.1f KB", (double)l / 1024.0);
        }
        if (l < 0x40000000L) {
            return String.format("%.1f MB", (double)l / 1048576.0);
        }
        return String.format("%.1f GB", (double)l / 1.073741824E9);
    }
}

