/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.A;
import com.company.AAA;
import com.company.ABMs;
import com.company.DCAIResultsVisualizer;
import com.company.RegexPanel;
import com.company.ScriptPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.gui.RegexExtractorGui;
import org.apache.jmeter.extractor.json.jsonpath.JSONPostProcessor;
import org.apache.jmeter.extractor.json.jsonpath.gui.JSONPostProcessorGui;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Replaceable;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.java.sampler.JSR223Sampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeminiSidePanel
extends JPanel {
    private static final String GEMINI_COMMAND = "gemini";
    private static final Color USER_MSG_COLOR = new Color(0, 153, 255);
    private static final Color AI_MSG_COLOR = new Color(102, 255, 178);
    private static final double LOW_UNIQUENESS_THRESHOLD = 0.7;
    private JEditorPane chatPane;
    private JTabbedPane tabs;
    private static BiConsumer<String, String> regexInsertHandler;
    private static Supplier<String> regexVarSupplier;
    private StringBuilder chatHtml = new StringBuilder();
    private JTextArea inputArea;
    private JButton sendButton;
    private JButton clearButton;
    private JButton copyTextButton;
    private JButton insertFixButton;
    private static volatile String lastErrorDcaiHeader;
    private JLabel statusLabel;
    private JLabel creditsLabel;
    private JLabel agentsLabel;
    private JPanel agentsStatusPanel;
    private JLabel georgeStatus;
    private JLabel carrieStatus;
    private JLabel rupertStatus;
    private JLabel suzyStatus;
    private Icon statusIconRed;
    private Icon statusIconGreen;
    private volatile Integer lastAvailableCredits = null;
    private static final String PROVIDER_DCAI = "Load Magic";
    private ExecutorService executorService;
    private ExecutorService watchdogExecutor;
    private volatile boolean isGeminiReady = false;
    private boolean isCollapsed = false;
    private String lastAiMarkdown = null;
    private String lastAiHtml = null;
    private static GeminiSidePanel instance;
    private JButton toggleButton;
    private int expandedWidth = 400;
    private int collapsedWidth = 30;
    private final Preferences prefs = Preferences.userRoot().node("com.company.GeminiSidePanel");
    private static int remainingUnlockAttempts;
    private transient Image loadMagicLogoImage;
    private JLabel headerLogoLabel;
    private int lastAppliedLogoWidth = -1;
    private static final Logger log;
    private static volatile boolean commonmarkChecked;
    private static volatile boolean commonmarkCorePresent;
    private static volatile boolean commonmarkTablesPresent;
    private static volatile boolean commonmarkAutolinkPresent;
    private static volatile String aiIconHtml;
    private static volatile boolean aiIconAttempted;
    private static volatile URL aiIconUrl;
    private volatile boolean welcomeShown = false;
    private static volatile String pendingInsertTargetLabel;
    private static volatile JMeterTreeNode pendingInsertTargetNode;
    private static final Color WARNING_COLOR;
    private volatile File lastUploadedHarFile = null;
    private static final String DCAI_ARGS_NODE_NAME = "Load Magic Vars";
    private static final String DCAI_HAR_PATH_VAR = "DCAI_HAR_PATH";
    private static volatile String lastCarrieCorrelationJson;
    private static volatile boolean lastCarrieCorrelationEscalated;
    private static volatile boolean lastCarrieCorrelationIssue;
    private static volatile String lastCarrieCorrelationValue;
    private static volatile String lastCarrieCorrelationCause;
    private static volatile String lastCarrieCorrelationSample;
    private static volatile String lastCarrieCorrelationCandidateName;
    private static volatile List<CarrieCandidate> lastCarrieCandidatesToProcess;
    private static volatile CarrieCandidate currentCandidateBeingProcessed;
    private static volatile boolean lastCarrieValueHadNotFoundPrefix;
    private static volatile String pendingBoundariesDcaiId;
    private static volatile boolean validationEndpointDisabledDueTo404;
    private static volatile boolean validationEndpointDisabledLogOnce;
    private static volatile String pendingBoundariesUrl;

    private static int getIntProperty(String string, int n) {
        try {
            String string2 = JMeterUtils.getProperty((String)string);
            if (string2 == null) {
                return n;
            }
            if ((string2 = string2.trim()).isEmpty()) {
                return n;
            }
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public GeminiSidePanel() {
        log.info("[GeminiSidePanel] Constructor started [AUTO-TEST-LOG-1]");
        this.executorService = Executors.newSingleThreadExecutor();
        this.watchdogExecutor = Executors.newCachedThreadPool();
        log.info("[GeminiSidePanel] ExecutorService and WatchdogExecutor created");
        try {
            int n = this.prefs.getInt("panelWidth", this.expandedWidth);
            if (n >= 240 && n <= 1200) {
                this.expandedWidth = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("[GeminiSidePanel] About to initialize components");
        this.initializeComponents();
        log.info("[GeminiSidePanel] Components initialized");
        log.info("[GeminiSidePanel] About to initialize Gemini");
        this.initializeGemini();
        log.info("[GeminiSidePanel] Gemini initialization submitted");
        log.info("[GeminiSidePanel] About to verify CommonMark");
        this.verifyCommonMarkAvailability();
        log.info("[GeminiSidePanel] CommonMark verification complete");
        try {
            this.fetchCreditsAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.warmAgentsAndUpdateStatusAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("[GeminiSidePanel] Initialised; diagnostics active. corePresent={} tablesPresent={} autolinkPresent={}", (Object)commonmarkCorePresent, (Object)commonmarkTablesPresent, (Object)commonmarkAutolinkPresent);
        log.info("[GeminiSidePanel] Constructor completed, setting instance");
        instance = this;
        this.showWelcomeIfAppropriate();
    }

    public static GeminiSidePanel getInstance() {
        log.info("[GeminiSidePanel] getInstance() CALLED [AUTO-TEST-LOG-1], instance={}", (Object)(instance != null ? "exists" : "null"));
        if (instance == null) {
            log.info("[GeminiSidePanel] Creating new instance");
            instance = new GeminiSidePanel();
            log.info("[GeminiSidePanel] New instance created");
        } else {
            log.info("[GeminiSidePanel] Returning existing instance");
        }
        return instance;
    }

    public static void setPendingInsertTargetLabel(String string) {
        try {
            pendingInsertTargetLabel = string == null ? null : string.trim();
            LogManager.getLogger(GeminiSidePanel.class).info("[GeminiSidePanel] Pending insert target set: {}", (Object)pendingInsertTargetLabel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPendingInsertTargetLabel() {
        return pendingInsertTargetLabel;
    }

    public static void setPendingInsertTargetNode(JMeterTreeNode jMeterTreeNode) {
        try {
            pendingInsertTargetNode = jMeterTreeNode;
            LogManager.getLogger(GeminiSidePanel.class).info("[GeminiSidePanel] Pending insert target node set: {}", (Object)(jMeterTreeNode != null ? jMeterTreeNode.getName() : "null"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JMeterTreeNode getPendingInsertTargetNode() {
        return pendingInsertTargetNode;
    }

    public static void clearPendingInsertTargetLabel() {
        try {
            pendingInsertTargetLabel = null;
            pendingInsertTargetNode = null;
            LogManager.getLogger(GeminiSidePanel.class).info("[GeminiSidePanel] Pending insert target cleared");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyCommonMarkAvailability() {
        Object object;
        Object object2;
        log.info("[GeminiSidePanel] verifyCommonMarkAvailability called, checked={}", (Object)commonmarkChecked);
        if (commonmarkChecked) {
            log.info("[GeminiSidePanel] CommonMark already checked, skipping");
            return;
        }
        commonmarkChecked = true;
        try {
            object2 = Class.forName("org.commonmark.parser.Parser");
            object = Class.forName("org.commonmark.node.Node");
            commonmarkCorePresent = object2 != null && object != null;
        }
        catch (Throwable throwable) {
            commonmarkCorePresent = false;
        }
        try {
            object2 = Class.forName("org.commonmark.ext.gfm.tables.TablesExtension");
            object = ((Class)object2).getMethod("create", new Class[0]).invoke(null, new Object[0]);
            commonmarkTablesPresent = object != null;
        }
        catch (Throwable throwable) {
            commonmarkTablesPresent = false;
        }
        try {
            object2 = Class.forName("org.commonmark.ext.autolink.AutolinkExtension");
            object = ((Class)object2).getMethod("create", new Class[0]).invoke(null, new Object[0]);
            commonmarkAutolinkPresent = object != null;
        }
        catch (Throwable throwable) {
            commonmarkAutolinkPresent = false;
        }
        object2 = null;
        try {
            object = Class.forName("org.commonmark.node.Node").getPackage();
            object2 = object != null ? ((Package)object).getImplementationVersion() : null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log.info("[GeminiSidePanel] CommonMark core: {}{}", (Object)(commonmarkCorePresent ? "OK" : "MISSING"), object2 != null ? " (version=" + (String)object2 + ")" : "");
        log.info("[GeminiSidePanel] CommonMark ext: GFM Tables={} Autolink={}", (Object)(commonmarkTablesPresent ? "OK" : "MISSING"), (Object)(commonmarkAutolinkPresent ? "OK" : "MISSING"));
        if (commonmarkCorePresent) {
            try {
                Object object3;
                Object object4;
                object = "| H | V |\n|---|---|\n| 1 | 2 |\n\nVisit https://example.com";
                Object object5 = Class.forName("org.commonmark.parser.Parser").getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (commonmarkTablesPresent) {
                    object4 = Class.forName("org.commonmark.ext.gfm.tables.TablesExtension").getMethod("create", new Class[0]).invoke(null, new Object[0]);
                    arrayList.add(object4);
                }
                if (commonmarkAutolinkPresent) {
                    object4 = Class.forName("org.commonmark.ext.autolink.AutolinkExtension").getMethod("create", new Class[0]).invoke(null, new Object[0]);
                    arrayList.add(object4);
                }
                if (!arrayList.isEmpty()) {
                    try {
                        object5.getClass().getMethod("extensions", List.class).invoke(object5, arrayList);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            object5.getClass().getMethod("extensions", Iterable.class).invoke(object5, arrayList);
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            for (Method[] methodArray : object3 = object5.getClass().getMethods()) {
                                if (!"extensions".equals(methodArray.getName()) || methodArray.getParameterCount() != 1) continue;
                                try {
                                    methodArray.invoke(object5, arrayList);
                                    break;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                object4 = object5.getClass().getMethod("build", new Class[0]).invoke(object5, new Object[0]);
                Object object6 = object4.getClass().getMethod("parse", String.class).invoke(object4, object);
                object3 = Class.forName("org.commonmark.renderer.html.HtmlRenderer").getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                if (!arrayList.isEmpty()) {
                    try {
                        object3.getClass().getMethod("extensions", List.class).invoke(object3, arrayList);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            object3.getClass().getMethod("extensions", Iterable.class).invoke(object3, arrayList);
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            Method[] methodArray;
                            for (Method method : methodArray = object3.getClass().getMethods()) {
                                if (!"extensions".equals(method.getName()) || method.getParameterCount() != 1) continue;
                                try {
                                    method.invoke(object3, arrayList);
                                    break;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                Object object7 = object3.getClass().getMethod("build", new Class[0]).invoke(object3, new Object[0]);
                String string = (String)object7.getClass().getMethod("render", Class.forName("org.commonmark.node.Node")).invoke(object7, object6);
                int n = string != null && string.contains("<table") ? 1 : 0;
                boolean bl = string != null && string.contains("<a ");
                log.info("[GeminiSidePanel] CommonMark render test: htmlLen={} tableDetected={} autolinkDetected={}", (Object)(string != null ? string.length() : 0), (Object)(n != 0), (Object)bl);
            }
            catch (Throwable throwable) {
                log.warn("[GeminiSidePanel] CommonMark render test failed: {}", (Object)throwable.toString());
            }
        }
    }

    public void showRegexTabWith(String string, String string2) {
        try {
            if (this.tabs == null) {
                return;
            }
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                Component component = this.tabs.getComponentAt(i);
                String string3 = this.tabs.getTitleAt(i);
                if (!"Regex".equalsIgnoreCase(string3) || !(component instanceof RegexPanel)) continue;
                RegexPanel regexPanel = (RegexPanel)component;
                regexPanel.setContextText(string);
                regexPanel.setInstructionText(string2);
                this.tabs.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showRegexTabAndAutoInsert(String string, String string2) {
        try {
            if (this.tabs == null) {
                return;
            }
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                Component component = this.tabs.getComponentAt(i);
                String string3 = this.tabs.getTitleAt(i);
                if (!"Regex".equalsIgnoreCase(string3) || !(component instanceof RegexPanel)) continue;
                RegexPanel regexPanel = (RegexPanel)component;
                regexPanel.setContextText(string);
                regexPanel.setInstructionText(string2);
                this.tabs.setSelectedIndex(i);
                regexPanel.autoGenerateAndInsert();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showScriptTabWithFixMode(String string, String string2) {
        try {
            if (this.tabs == null) {
                return;
            }
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                Component component = this.tabs.getComponentAt(i);
                String string3 = this.tabs.getTitleAt(i);
                if (!"Script".equalsIgnoreCase(string3) || !(component instanceof ScriptPanel)) continue;
                ScriptPanel scriptPanel = (ScriptPanel)component;
                scriptPanel.setModeAndRun("Fix", string, string2);
                this.tabs.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showScriptTabWithFixModeAndAutoInsert(String string, String string2) {
        try {
            if (this.tabs == null) {
                return;
            }
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                Component component = this.tabs.getComponentAt(i);
                String string3 = this.tabs.getTitleAt(i);
                if (!"Script".equalsIgnoreCase(string3) || !(component instanceof ScriptPanel)) continue;
                ScriptPanel scriptPanel = (ScriptPanel)component;
                scriptPanel.setModeRunAndInsert("Fix", string, string2);
                this.tabs.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setRegexInsertHandler(BiConsumer<String, String> biConsumer, Supplier<String> supplier) {
        regexInsertHandler = biConsumer;
        regexVarSupplier = supplier;
    }

    public static void clearRegexInsertHandler() {
        regexInsertHandler = null;
        regexVarSupplier = null;
    }

    public static BiConsumer<String, String> getRegexInsertHandler() {
        return regexInsertHandler;
    }

    public static Supplier<String> getRegexVarSupplier() {
        return regexVarSupplier;
    }

    private void initializeComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setBorder(new EmptyBorder(5, 8, 5, 5));
        this.setPreferredSize(new Dimension(this.expandedWidth, 600));
        this.add((Component)this.createHeaderPanel(), "North");
        this.add((Component)this.createResizer(), "West");
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createMainPanel(), "Center");
        jPanel.add((Component)this.createInputPanel(), "South");
        jTabbedPane.addTab("Chat", jPanel);
        jTabbedPane.addTab("Regex", new RegexPanel());
        jTabbedPane.addTab("Script", new ScriptPanel());
        this.add((Component)jTabbedPane, "Center");
        this.tabs = jTabbedPane;
        UIManager.addPropertyChangeListener(propertyChangeEvent -> {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    this.reapplyLookAndFeelToChat();
                    try {
                        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                            Component component = jTabbedPane.getComponentAt(i);
                            if (!(component instanceof JPanel)) continue;
                            for (Component component2 : ((JPanel)component).getComponents()) {
                                if (component2 instanceof RegexPanel) {
                                    ((RegexPanel)component2).applyLookAndFeelStyles();
                                    continue;
                                }
                                if (!(component2 instanceof ScriptPanel)) continue;
                                ((ScriptPanel)component2).applyLookAndFeelStyles();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.revalidate();
                    this.repaint();
                    this.updateToggleButtonIcon();
                });
            }
        });
    }

    private void showWelcomeIfAppropriate() {
        try {
            if (this.welcomeShown) {
                return;
            }
            this.welcomeShown = true;
            SwingUtilities.invokeLater(() -> {
                String string = "Hi! I'm George, your JMeter Genius. I can help you with JMeter test plans, debugging, and optimisation. What would you like to work on today?";
                this.appendAiReplyWithAvatar("George - JMeter Genius", string, "/com/company/dcai/images/George.png");
                this.updateStatus("Ready!", Color.GREEN);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JComponent createResizer() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(6, 1));
        jPanel.setCursor(Cursor.getPredefinedCursor(10));
        jPanel.setOpaque(false);
        final Point[] pointArray = new Point[1];
        final int[] nArray = new int[1];
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                pointArray[0] = mouseEvent.getPoint();
                nArray[0] = GeminiSidePanel.this.getWidth();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                GeminiSidePanel.this.saveWidth();
            }
        });
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (GeminiSidePanel.this.isCollapsed) {
                    return;
                }
                int n = mouseEvent.getX() - (pointArray[0] != null ? pointArray[0].x : 0);
                int n2 = nArray[0] > 0 ? nArray[0] : GeminiSidePanel.this.getWidth();
                int n3 = Math.max(GeminiSidePanel.this.collapsedWidth, 60);
                int n4 = Math.max(n3, Math.min(1200, n2 - n));
                GeminiSidePanel.this.setPreferredSize(new Dimension(n4, GeminiSidePanel.this.getHeight()));
                GeminiSidePanel.this.setSize(new Dimension(n4, GeminiSidePanel.this.getHeight()));
                GeminiSidePanel.this.expandedWidth = n4;
                Container container = GeminiSidePanel.this.getParent();
                if (container != null) {
                    container.revalidate();
                    container.repaint();
                }
            }
        });
        return jPanel;
    }

    private void saveWidth() {
        try {
            this.prefs.putInt("panelWidth", this.expandedWidth);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel createHeaderPanel() {
        Serializable serializable;
        JLabel jLabel;
        Object object;
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(UIManager.getColor("Panel.background"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 16, 0));
        URL uRL = GeminiSidePanel.class.getResource("/com/company/dcai/images/loadmagic-dark.png");
        if (uRL != null) {
            try {
                object = ImageIO.read(uRL);
                this.loadMagicLogoImage = this.trimTransparentBorders((BufferedImage)object);
            }
            catch (Exception exception) {
                try {
                    log.warn("[GeminiSidePanel] Failed loading Load Magic logo: {}", (Object)exception.getMessage());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.loadMagicLogoImage = null;
            }
            if (this.loadMagicLogoImage != null) {
                this.headerLogoLabel = new JLabel();
                this.headerLogoLabel.setToolTipText("Load Magic Utilities");
                jLabel = this.headerLogoLabel;
                this.applyLogoScale(Math.max(this.expandedWidth - 60, 200));
            } else {
                this.headerLogoLabel = null;
                jLabel = new JLabel("Load Magic Utilities");
                jLabel.setFont(jLabel.getFont().deriveFont(1, 14.0f));
            }
        } else {
            this.headerLogoLabel = null;
            jLabel = new JLabel("Load Magic Utilities");
            jLabel.setFont(jLabel.getFont().deriveFont(1, 14.0f));
        }
        jPanel.add((Component)jLabel, "Center");
        this.toggleButton = new JButton();
        this.toggleButton.setPreferredSize(new Dimension(22, 24));
        this.toggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.toggleButton.setFocusable(false);
        this.toggleButton.setContentAreaFilled(false);
        this.toggleButton.setOpaque(false);
        this.toggleButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.toggleButton.putClientProperty("JButton.buttonType", "borderless");
        this.toggleButton.setToolTipText("Collapse Panel");
        this.toggleButton.addActionListener(actionEvent -> this.togglePanel());
        this.updateToggleButtonIcon();
        jPanel.add((Component)this.toggleButton, "East");
        jPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (GeminiSidePanel.this.headerLogoLabel != null) {
                    SwingUtilities.invokeLater(() -> GeminiSidePanel.this.applyLogoScale(jPanel.getWidth() - GeminiSidePanel.this.toggleButton.getWidth() - 40));
                }
            }
        });
        object = new JPanel(new FlowLayout(0, 8, 0));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        ((JComponent)object).setOpaque(false);
        this.creditsLabel = new JLabel("Credits: -");
        try {
            this.creditsLabel.setFont(this.creditsLabel.getFont().deriveFont(10.0f));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.creditsLabel.setToolTipText("Available credits (placeholder)");
        ((Container)object).add(this.creditsLabel);
        try {
            serializable = GeminiSidePanel.class.getResource("/com/company/dcai/images/green.png");
            URL uRL2 = GeminiSidePanel.class.getResource("/com/company/dcai/images/red.png");
            if (serializable != null) {
                this.statusIconGreen = new ImageIcon((URL)serializable);
                log.info("[GeminiSidePanel] Green status icon loaded successfully: {}", (Object)serializable);
            } else {
                log.info("[GeminiSidePanel] Green status icon not found at: /dcai/images/green.png");
            }
            if (uRL2 != null) {
                this.statusIconRed = new ImageIcon(uRL2);
                log.info("[GeminiSidePanel] Red status icon loaded successfully: {}", (Object)uRL2);
            } else {
                log.info("[GeminiSidePanel] Red status icon not found at: /dcai/images/red.png");
            }
        }
        catch (Exception exception) {
            log.info("[GeminiSidePanel] Exception loading status icons: {}", (Object)exception.getMessage());
        }
        this.agentsStatusPanel = new JPanel(new FlowLayout(0, 6, 0));
        this.agentsStatusPanel.setOpaque(false);
        this.georgeStatus = new JLabel("George");
        this.carrieStatus = new JLabel("Carrie");
        this.rupertStatus = new JLabel("Rupert");
        this.suzyStatus = new JLabel("Suzy");
        try {
            serializable = this.creditsLabel.getFont().deriveFont(10.0f);
            this.georgeStatus.setFont((Font)serializable);
            this.carrieStatus.setFont((Font)serializable);
            this.rupertStatus.setFont((Font)serializable);
            this.suzyStatus.setFont((Font)serializable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAgentIndicator(this.georgeStatus, false);
        this.setAgentIndicator(this.carrieStatus, false);
        this.setAgentIndicator(this.rupertStatus, false);
        this.setAgentIndicator(this.suzyStatus, false);
        this.agentsStatusPanel.add(this.georgeStatus);
        this.agentsStatusPanel.add(this.carrieStatus);
        this.agentsStatusPanel.add(this.rupertStatus);
        this.agentsStatusPanel.add(this.suzyStatus);
        ((Container)object).add(this.agentsStatusPanel);
        jPanel.add((Component)object, "South");
        SwingUtilities.invokeLater(() -> {
            if (this.headerLogoLabel != null) {
                this.applyLogoScale(jPanel.getWidth() - this.toggleButton.getWidth() - 40);
            }
        });
        return jPanel;
    }

    private void applyLogoScale(int n) {
        if (this.headerLogoLabel == null) {
            return;
        }
        if (this.loadMagicLogoImage == null) {
            this.headerLogoLabel.setIcon(null);
            this.headerLogoLabel.setText("Load Magic Utilities");
            try {
                this.headerLogoLabel.setFont(this.headerLogoLabel.getFont().deriveFont(1, 14.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (n <= 0) {
            return;
        }
        if (n < 140) {
            if (this.headerLogoLabel.getIcon() != null) {
                this.headerLogoLabel.setIcon(null);
            }
            this.headerLogoLabel.setText(PROVIDER_DCAI);
            try {
                this.headerLogoLabel.setFont(this.headerLogoLabel.getFont().deriveFont(1, 12.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastAppliedLogoWidth = -1;
            return;
        }
        int n2 = this.loadMagicLogoImage.getWidth(null);
        int n3 = this.loadMagicLogoImage.getHeight(null);
        if (n2 <= 0 || n3 <= 0) {
            this.headerLogoLabel.setIcon(null);
            this.headerLogoLabel.setText("Load Magic Utilities");
            try {
                this.headerLogoLabel.setFont(this.headerLogoLabel.getFont().deriveFont(1, 14.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        int n4 = Math.min(n2, Math.max(140, n));
        if (n4 == this.lastAppliedLogoWidth && this.headerLogoLabel.getIcon() != null) {
            return;
        }
        Image image = this.loadMagicLogoImage;
        if (n4 < n2) {
            double d = (double)n4 / (double)n2;
            int n5 = Math.max(1, (int)Math.round((double)n3 * d));
            image = this.loadMagicLogoImage.getScaledInstance(n4, n5, 4);
        } else {
            n4 = n2;
        }
        this.headerLogoLabel.setText(null);
        this.headerLogoLabel.setIcon(new ImageIcon(image));
        this.lastAppliedLogoWidth = n4;
        this.updateToggleButtonIcon();
    }

    private void updateToggleButtonIcon() {
        if (this.toggleButton == null) {
            return;
        }
        Color color = UIManager.getColor("Label.foreground");
        if (color == null) {
            color = new Color(120, 120, 120);
        }
        this.toggleButton.setIcon(this.createArrowIcon(this.isCollapsed, color));
        this.toggleButton.setText(null);
    }

    private Icon createArrowIcon(boolean bl, Color color) {
        int[] nArray;
        int[] nArray2;
        int n = 14;
        int n2 = 18;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(color.getRGB(), true));
        if (bl) {
            nArray2 = new int[]{4, 4, 10};
            nArray = new int[]{3, 15, 9};
        } else {
            nArray2 = new int[]{10, 10, 4};
            nArray = new int[]{3, 15, 9};
        }
        graphics2D.fillPolygon(nArray2, nArray, 3);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private HttpResponse<String> sendWithRetry(HttpClient httpClient, Supplier<HttpRequest> supplier, int n, int n2, int n3, String string) {
        if (httpClient == null || supplier == null) {
            return null;
        }
        n = Math.max(1, n);
        int n4 = Math.max(100, n2);
        n3 = Math.max(n4, n3);
        IOException iOException = null;
        for (int i = 1; i <= n; ++i) {
            HttpRequest httpRequest = supplier.get();
            if (httpRequest == null) {
                return null;
            }
            try {
                if (i > 1) {
                    try {
                        log.info("[Retry] {} attempt {}/{}", (Object)string, (Object)i, (Object)n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw interruptedException;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    log.warn("[Retry] {} attempt {}/{} failed: {}", (Object)string, (Object)i, (Object)n, (Object)iOException2.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i >= n) break;
                this.sleepQuietly(n4);
                n4 = Math.min(n3, (int)Math.round((double)n4 * 1.5));
                continue;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return null;
    }

    private void sleepQuietly(int n) {
        try {
            Thread.sleep(Math.max(0, n));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private BufferedImage trimTransparentBorders(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        if (bufferedImage == null) {
            return null;
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = 0;
        int n7 = 0;
        int n8 = n4 - 1;
        int n9 = n5 - 1;
        boolean bl = false;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage.getRGB(n2, n3) >>> 24;
                if (n == 0) continue;
                n6 = n3;
                bl = true;
                break;
            }
            if (bl) break;
        }
        bl = false;
        for (n3 = n5 - 1; n3 >= n6; --n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage.getRGB(n2, n3) >>> 24;
                if (n == 0) continue;
                n9 = n3;
                bl = true;
                break;
            }
            if (bl) break;
        }
        bl = false;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = n6; n2 <= n9; ++n2) {
                n = bufferedImage.getRGB(n3, n2) >>> 24;
                if (n == 0) continue;
                n7 = n3;
                bl = true;
                break;
            }
            if (bl) break;
        }
        bl = false;
        for (n3 = n4 - 1; n3 >= n7; --n3) {
            for (n2 = n6; n2 <= n9; ++n2) {
                n = bufferedImage.getRGB(n3, n2) >>> 24;
                if (n == 0) continue;
                n8 = n3;
                bl = true;
                break;
            }
            if (bl) break;
        }
        n3 = Math.max(1, n8 - n7 + 1);
        n2 = Math.max(1, n9 - n6 + 1);
        if (n3 == n4 && n2 == n5) {
            return bufferedImage;
        }
        return bufferedImage.getSubimage(n7, n6, n3, n2);
    }

    private JPanel createMainPanel() {
        JComponent jComponent;
        JComponent jComponent2;
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.chatPane = new JEditorPane();
        this.chatPane.setEditable(false);
        this.chatPane.setContentType("text/html");
        try {
            this.chatPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.chatPane.setFont(UIManager.getFont("TextArea.font"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        Font font = UIManager.getFont("TextArea.font");
        String string = font != null ? font.getFamily() : (UIManager.getFont("Label.font") != null ? UIManager.getFont("Label.font").getFamily() : "Sans-Serif");
        int n = font != null ? font.getSize() : 12;
        Color color = UIManager.getColor("EditorPane.background");
        Color color2 = UIManager.getColor("EditorPane.foreground");
        String string2 = GeminiSidePanel.colorToHex(color != null ? color : UIManager.getColor("Panel.background"));
        String string3 = GeminiSidePanel.colorToHex(color2 != null ? color2 : UIManager.getColor("Label.foreground"));
        styleSheet.addRule("body { background: " + string2 + "; color: " + string3 + "; font-family: '" + string + "', Sans-Serif; font-size: " + n + "pt; margin: 8px; }");
        styleSheet.addRule("code, pre { font-family: '" + (UIManager.getFont("TextArea.font") != null ? UIManager.getFont("TextArea.font").getFamily() : "Monospaced") + "', Monospaced; }");
        styleSheet.addRule("pre, code { white-space: pre-wrap; }");
        styleSheet.addRule("ul { margin-top: 4px; margin-bottom: 4px; }");
        styleSheet.addRule("ol { margin-top: 4px; margin-bottom: 4px; }");
        styleSheet.addRule(".user { color: " + GeminiSidePanel.colorToHex(USER_MSG_COLOR) + "; }");
        styleSheet.addRule(".ai { color: " + GeminiSidePanel.colorToHex(AI_MSG_COLOR) + "; }");
        Color color3 = UIManager.getColor("Panel.background");
        Color color4 = GeminiSidePanel.blend(UIManager.getColor("Label.foreground"), color3, 0.75);
        Color color5 = GeminiSidePanel.blend(color3, UIManager.getColor("Label.foreground"), 0.06);
        Color color6 = GeminiSidePanel.blend(color3, UIManager.getColor("Label.foreground"), 0.03);
        styleSheet.addRule(".bubble { border: 1px solid " + GeminiSidePanel.colorToHex(color4) + "; padding: 8px; margin: 8px 0; border-radius: 6px; }");
        styleSheet.addRule(".bubble-user { background: " + GeminiSidePanel.colorToHex(color6) + "; }");
        styleSheet.addRule(".bubble-ai { background: " + GeminiSidePanel.colorToHex(color5) + "; }");
        styleSheet.addRule(".bubble-title { font-weight: bold; margin-bottom: 4px; }");
        styleSheet.addRule("table { border-collapse: collapse; margin: 6px 0; width: 100%; max-width: 100%; }");
        styleSheet.addRule("th, td { border: 1px solid " + GeminiSidePanel.colorToHex(color4) + "; padding: 6px 8px; text-align: left; vertical-align: top; }");
        styleSheet.addRule("th { background: " + GeminiSidePanel.colorToHex(GeminiSidePanel.blend(color3, UIManager.getColor("Label.foreground"), 0.12)) + "; }");
        styleSheet.addRule("tr:nth-child(even) td { background: " + GeminiSidePanel.colorToHex(GeminiSidePanel.blend(color3, UIManager.getColor("Label.foreground"), 0.04)) + "; }");
        this.chatPane.setEditorKit(hTMLEditorKit);
        this.applyDocumentBaseFromIconIfAvailable();
        try {
            serializable = new JPopupMenu();
            jComponent2 = new JMenuItem("Copy last AI reply (plain text)");
            ((AbstractButton)jComponent2).addActionListener(actionEvent -> this.copyLastAiResponseAsText());
            jComponent = new JMenuItem("Copy selection (plain text)");
            ((AbstractButton)jComponent).addActionListener(actionEvent -> {
                try {
                    String string = this.chatPane.getSelectedText();
                    if (string == null) {
                        string = "";
                    }
                    StringSelection stringSelection = new StringSelection(string);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
                    this.updateStatus("Copied selection as text", Color.GREEN);
                }
                catch (Exception exception) {
                    this.updateStatus("Copy failed: " + exception.getMessage(), Color.RED);
                }
            });
            ((JPopupMenu)serializable).add((JMenuItem)jComponent2);
            ((JPopupMenu)serializable).add((JMenuItem)jComponent);
            this.chatPane.setComponentPopupMenu((JPopupMenu)serializable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chatHtml.setLength(0);
        this.chatHtml.append("<html><body></body></html>");
        this.chatPane.setText(this.chatHtml.toString());
        serializable = (DefaultCaret)this.chatPane.getCaret();
        ((DefaultCaret)serializable).setUpdatePolicy(2);
        jComponent2 = new JScrollPane(this.chatPane);
        ((JScrollPane)jComponent2).setVerticalScrollBarPolicy(20);
        jComponent2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)jComponent2, "Center");
        jComponent = new JPanel(new FlowLayout(0, 5, 2));
        jComponent.setOpaque(false);
        this.statusLabel = new JLabel("Initializing...");
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        jComponent.add(this.statusLabel);
        jPanel.add((Component)jComponent, "South");
        return jPanel;
    }

    private void applyDocumentBaseFromIconIfAvailable() {
        try {
            if (aiIconUrl == null) {
                return;
            }
            String string = aiIconUrl.toString();
            int n = string.lastIndexOf(47);
            if (n > 0) {
                String string2 = string.substring(0, n + 1);
                URL uRL = new URL(string2);
                Document document = this.chatPane.getDocument();
                if (document instanceof HTMLDocument) {
                    ((HTMLDocument)document).setBase(uRL);
                    log.info("[GeminiSidePanel] Set HTML document base to {}", (Object)uRL);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.inputArea = new JTextArea(8, 20);
        this.inputArea.setLineWrap(true);
        this.inputArea.setWrapStyleWord(true);
        this.inputArea.setToolTipText("Enter: Send message | Ctrl+Enter or Shift+Enter: New line");
        Font font = UIManager.getFont("TextArea.font");
        if (font != null) {
            this.inputArea.setFont(font);
        }
        this.inputArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
                    keyEvent.consume();
                    SwingUtilities.invokeLater(() -> {
                        try {
                            log.info("[GeminiSidePanel] Enter key pressed - submitting message");
                            GeminiSidePanel.this.sendMessage();
                        }
                        catch (Exception exception) {
                            log.warn("[GeminiSidePanel] Enter key submission failed: {}", (Object)exception.getMessage());
                        }
                    });
                }
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 2, 2));
        jPanel2.setOpaque(false);
        this.clearButton = new JButton("Clear");
        this.clearButton.setFont(this.clearButton.getFont().deriveFont(10.0f));
        this.clearButton.addActionListener(actionEvent -> this.clearChat());
        this.sendButton = new JButton("Send");
        this.sendButton.setFont(this.sendButton.getFont().deriveFont(10.0f));
        this.sendButton.addActionListener(actionEvent -> {
            log.info("[GeminiSidePanel] Send button clicked");
            this.sendMessage();
        });
        this.sendButton.setEnabled(false);
        jPanel2.add(this.clearButton);
        jPanel2.add(this.sendButton);
        jPanel.add((Component)new JLabel("Message (Enter: Send | Ctrl+Enter/Shift+Enter: New line):"), "North");
        jPanel.add((Component)new JScrollPane(this.inputArea), "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void togglePanel() {
        Object object;
        boolean bl = this.isCollapsed = !this.isCollapsed;
        if (this.isCollapsed) {
            this.setPreferredSize(new Dimension(this.collapsedWidth, this.getHeight()));
            this.toggleButton.setToolTipText("Expand Panel");
            object = this.getComponents();
            for (Component component : object) {
                if (component == this.getComponent(0)) continue;
                component.setVisible(false);
            }
        } else {
            this.setPreferredSize(new Dimension(this.expandedWidth, this.getHeight()));
            this.toggleButton.setToolTipText("Collapse Panel");
            object = this.getComponents();
            for (Component component : object) {
                component.setVisible(true);
            }
        }
        this.updateToggleButtonIcon();
        this.revalidate();
        this.repaint();
        object = this.getParent();
        if (object != null) {
            ((Component)object).revalidate();
            ((Component)object).repaint();
        }
    }

    public void ensureExpanded() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.isCollapsed) {
                this.togglePanel();
            }
        } else {
            SwingUtilities.invokeLater(this::ensureExpanded);
        }
    }

    private void initializeGemini() {
        log.info("[GeminiSidePanel] initializeGemini() called");
        this.executorService.submit(() -> {
            log.info("[GeminiSidePanel] ExecutorService task started - initialiseProviderStatus");
            try {
                this.initialiseProviderStatus();
            }
            catch (Exception exception) {
                log.error("[GeminiSidePanel] Error in initialiseProviderStatus", (Throwable)exception);
            }
            log.info("[GeminiSidePanel] ExecutorService task completed");
        });
    }

    private void fetchCreditsAsync() {
        this.executorService.submit(() -> {
            try {
                Integer n;
                String string = AAA.AA();
                if (string == null || string.trim().isEmpty()) {
                    try {
                        log.info("[DCAI Billing] Skipping credits fetch: missing dcai.account.api");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(() -> this.setCreditsText("Credits: -"));
                    return;
                }
                String string2 = AAA.s();
                String string3 = string2.endsWith("/") ? string2 + "usage/status" : string2 + "/usage/status";
                try {
                    log.info("[DCAI Billing] GET credits: url={}", (Object)string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n2 = Math.max(1000, GeminiSidePanel.getIntProperty("dcai.billing.connectTimeoutMs", 15000));
                int n3 = Math.max(2000, GeminiSidePanel.getIntProperty("dcai.billing.readTimeoutMs", 20000));
                int n4 = Math.max(1, GeminiSidePanel.getIntProperty("dcai.billing.retryAttempts", 3));
                int n5 = Math.max(250, GeminiSidePanel.getIntProperty("dcai.billing.retryBackoffMs", 1500));
                int n6 = Math.max(n5, GeminiSidePanel.getIntProperty("dcai.billing.retryMaxBackoffMs", 10000));
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(n2)).build();
                String string4 = string;
                Supplier<HttpRequest> supplier = () -> {
                    HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(string3)).timeout(Duration.ofMillis(n3)).GET();
                    AAA.A(builder, string4);
                    return builder.build();
                };
                HttpResponse<String> httpResponse = this.sendWithRetry(httpClient, supplier, n4, n5, n6, "DCAI Billing credits");
                if (httpResponse == null) {
                    SwingUtilities.invokeLater(() -> this.setCreditsText("Credits: -"));
                    return;
                }
                try {
                    log.info("[DCAI Billing] GET credits response: status={} bodyLen={} preview={}", (Object)(httpResponse != null ? httpResponse.statusCode() : -1), (Object)(httpResponse != null && httpResponse.body() != null ? httpResponse.body().length() : -1), (Object)this.sample(httpResponse != null ? httpResponse.body() : null, 400));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (httpResponse.statusCode() != 200) {
                    SwingUtilities.invokeLater(() -> this.setCreditsText("Credits: -"));
                    return;
                }
                this.lastAvailableCredits = n = this.parseAvailableCredits(httpResponse.body());
                SwingUtilities.invokeLater(() -> this.setCreditsText("Credits: " + (Serializable)(n != null ? n : "-")));
            }
            catch (Exception exception) {
                try {
                    log.info("[DCAI Billing] GET credits error: {}", (Object)String.valueOf(exception.getMessage()));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(() -> this.setCreditsText("Credits: -"));
            }
        });
    }

    public static void refreshCreditsAsync() {
        GeminiSidePanel geminiSidePanel = instance;
        if (geminiSidePanel == null) {
            return;
        }
        try {
            geminiSidePanel.fetchCreditsAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCreditsText(String string) {
        try {
            if (this.creditsLabel != null) {
                this.creditsLabel.setText(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Integer parseAvailableCredits(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            int n;
            String string2 = "\"available_credits\"";
            int n2 = string.indexOf(string2);
            if (n2 < 0) {
                return null;
            }
            int n3 = string.indexOf(":", n2 + string2.length());
            if (n3 < 0) {
                return null;
            }
            for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            int n4 = n;
            while (n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '+')) {
                ++n;
            }
            if (n > n4) {
                String string3 = string.substring(n4, n).trim();
                try {
                    return Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void onProviderChanged() {
        this.executorService.submit(this::initialiseProviderStatus);
    }

    private void initialiseProviderStatus() {
        try {
            SwingUtilities.invokeLater(() -> {
                this.sendButton.setEnabled(true);
                this.inputArea.setEnabled(true);
            });
            this.updateStatus("Load Magic ready (DigitalOcean Agent)", Color.GREEN);
            this.isGeminiReady = true;
        }
        catch (Exception exception) {
            this.updateStatus("Error: " + exception.getMessage(), Color.RED);
        }
    }

    public static String getSelectedProviderLabel() {
        return PROVIDER_DCAI;
    }

    public static boolean isLocalProviderSelected() {
        return false;
    }

    public static boolean isExternalProviderSelected() {
        return false;
    }

    public static boolean isDcaiProviderSelected() {
        return true;
    }

    public static boolean isGeminiExternalSelected() {
        return false;
    }

    private void sendMessage() {
        String string;
        String string2 = this.inputArea.getText().trim();
        log.info("[GeminiSidePanel] sendMessage called; ready={}, msgLen={}", (Object)this.isGeminiReady, (Object)string2.length());
        if (string2.isEmpty()) {
            this.updateStatus("Enter a message", Color.ORANGE);
            try {
                JOptionPane.showMessageDialog(this, "Please include an instruction for the assistant.", "Instruction needed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (!this.isGeminiReady) {
            this.updateStatus("Not ready - configure dcai.account.api", Color.RED);
            return;
        }
        this.appendMarkdownToChat(string2, USER_MSG_COLOR);
        this.inputArea.setText("");
        this.sendButton.setEnabled(false);
        String string3 = string = string2;
        this.executorService.submit(() -> {
            try {
                boolean bl;
                this.updateStatus("Asking Load Magic...", Color.ORANGE);
                A.AA aA = A.A(string3);
                try {
                    log.info("[Search Auto] Dispatch reply status={} ok={} trace={} metaKeys={}", (Object)aA.ABC, (Object)aA.A, (Object)(aA.ABM != null ? aA.ABM.get("trace_id") : null), aA.ABM != null ? aA.ABM.keySet() : null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aA == null || !aA.A) {
                    StringBuilder stringBuilder = new StringBuilder("\u274c Dispatch error");
                    if (aA != null && aA.AB != null) {
                        if (!this.isEmpty(aA.AB.A)) {
                            stringBuilder.append(" [").append(aA.AB.A).append(']');
                        }
                        if (!this.isEmpty(aA.AB.AA)) {
                            stringBuilder.append(": ").append(aA.AB.AA);
                        }
                        if (!this.isEmpty(aA.AB.s)) {
                            stringBuilder.append(" (trace ").append(aA.AB.s).append(')');
                        }
                    } else if (aA != null) {
                        stringBuilder.append(": HTTP ").append(aA.ABC);
                    }
                    String string2 = stringBuilder.toString();
                    SwingUtilities.invokeLater(() -> {
                        this.appendToChatArea(GeminiSidePanel.escapeHtml(string2 + "\n"), Color.RED, true);
                        this.updateStatus("Load Magic dispatch failure", Color.RED);
                    });
                    try {
                        log.warn("[Search Auto] Dispatch failure body={}", (Object)this.sample(aA != null ? aA.ABCs : null, 512));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                String string3 = aA.AAA != null ? aA.AAA : "";
                try {
                    log.info("[Search Auto] Dispatch reply received; len={} meta={} ", (Object)(string3 != null ? string3.length() : -1), aA.ABM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.logLargeInfo("LLM Reply [Dispatch]", string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.writeDebugText(string3, "dcai");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LinkedHashMap linkedHashMap = aA.ABM != null ? aA.ABM : new LinkedHashMap();
                String string4 = this.firstNonEmpty((String)linkedHashMap.get("free_remaining"), (String)linkedHashMap.get("freeRemaining"));
                String string5 = this.firstNonEmpty((String)linkedHashMap.get("paid_available"), (String)linkedHashMap.get("paidAvailable"));
                String string6 = this.firstNonEmpty((String)linkedHashMap.get("query_type"), (String)linkedHashMap.get("queryType"));
                SwingUtilities.invokeLater(() -> {
                    try {
                        log.info("[Search Auto] Updating UI with dispatch reply (appendAiReply)");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.appendAiReply("\ud83e\udd16 George - JMeter Genius", string3);
                    if (!(this.isEmpty(string4) && this.isEmpty(string5) && this.isEmpty(string6))) {
                        String string5 = !this.isEmpty(string4) ? string4 : "-";
                        String string6 = !this.isEmpty(string5) ? string5 : "-";
                        String string7 = !this.isEmpty(string6) ? string6 : "-";
                        this.updateStatus("Credits: free=" + string5 + ", paid=" + string6 + ", type=" + string7, Color.GREEN);
                        try {
                            this.fetchCreditsAsync();
                        }
                        catch (Exception exception) {}
                    } else {
                        this.updateStatus("Ready!", Color.GREEN);
                    }
                });
                try {
                    String string7 = this.extractFirstFencedCode(string3);
                    String string8 = string7 != null && string7.trim().startsWith("{") ? string7.trim() : string3;
                    boolean bl2 = this.isSortCorrelationIssue(string8);
                    try {
                        log.info("[Search Auto] Probe dispatch reply: fencedPresent={} sortIssue={} (replyLen={})", (Object)(string7 != null ? 1 : 0), (Object)bl2, (Object)(string3 != null ? string3.length() : -1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl2) {
                        this.processAllUninsertedCandidates();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl3 = bl = !this.isEmpty(string6);
                if (!bl) {
                    this.consumeCreditAsync("george", string3, 1);
                }
            }
            catch (Exception exception) {
                String string9 = exception.getMessage();
                if (string9 == null || string9.isEmpty()) {
                    string9 = exception.getClass().getSimpleName();
                }
                String string10 = string9;
                SwingUtilities.invokeLater(() -> {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("\u274c Error: " + string10 + "\n"), Color.RED, true);
                    this.updateStatus("Error", Color.RED);
                });
            }
            finally {
                SwingUtilities.invokeLater(() -> this.sendButton.setEnabled(true));
            }
        });
    }

    private void consumeCreditAsync(String string, String string2, int n) {
        this.executorService.submit(() -> {
            try {
                String string3 = AAA.AA();
                if (string3 == null || string3.trim().isEmpty()) {
                    try {
                        log.info("[DCAI Billing] Skipping consume: missing dcai.account.api");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                String string4 = AAA.s();
                String string5 = string4.endsWith("/") ? string4 + "usage/test-query" : string4 + "/usage/test-query";
                Object object = string2;
                if (object == null) {
                    object = "";
                }
                if (((String)object).length() > 800) {
                    object = ((String)object).substring(0, 800) + "\u2026";
                }
                String string6 = "{\n  \"agent_type\": \"" + this.escapeForJsonSimple(string != null ? string : "george") + "\",\n  \"query\": \"" + this.escapeForJsonSimple((String)object) + "\"\n}";
                try {
                    log.info("[DCAI Billing] POST consume: url={} payloadLen={} payloadPreview={}", (Object)string5, (Object)(string6 != null ? string6.length() : -1), (Object)this.sample(string6, 400));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n = Math.max(1000, GeminiSidePanel.getIntProperty("dcai.billing.connectTimeoutMs", 15000));
                int n2 = Math.max(2000, GeminiSidePanel.getIntProperty("dcai.billing.readTimeoutMs", 20000));
                int n3 = Math.max(1, GeminiSidePanel.getIntProperty("dcai.billing.retryAttempts", 3));
                int n4 = Math.max(250, GeminiSidePanel.getIntProperty("dcai.billing.retryBackoffMs", 1500));
                int n5 = Math.max(n4, GeminiSidePanel.getIntProperty("dcai.billing.retryMaxBackoffMs", 10000));
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(n)).build();
                String string7 = string3;
                Supplier<HttpRequest> supplier = () -> {
                    HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(string5)).timeout(Duration.ofMillis(n2)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(string6, StandardCharsets.UTF_8));
                    AAA.A(builder, string7);
                    return builder.build();
                };
                HttpResponse<String> httpResponse = this.sendWithRetry(httpClient, supplier, n3, n4, n5, "DCAI Billing consume");
                if (httpResponse == null) {
                    return;
                }
                try {
                    log.info("[DCAI Billing] POST consume response: status={} bodyLen={} bodyPreview={}", (Object)(httpResponse != null ? httpResponse.statusCode() : -1), (Object)(httpResponse != null && httpResponse.body() != null ? httpResponse.body().length() : -1), (Object)this.sample(httpResponse != null ? httpResponse.body() : null, 400));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (httpResponse.statusCode() == 401) {
                    try {
                        log.warn("[DCAI Billing] 401 Unauthorized - check API key validity");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (httpResponse.statusCode() == 200) {
                    try {
                        this.fetchCreditsAsync();
                    }
                    catch (Exception exception) {}
                } else if (httpResponse.statusCode() == 429) {
                    SwingUtilities.invokeLater(() -> this.updateStatus("Credits exceeded (429)", WARNING_COLOR));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private String escapeForJsonSimple(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                default: {
                    if (c < ' ') {
                        stringBuilder.append(String.format("\\u%04x", c));
                        continue block7;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void writeDebugText(String string, String string2) {
        try {
            String string3 = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS").format(new Date());
            String string4 = string2 == null || string2.isEmpty() ? "reply" : string2;
            String string5 = "dcai_reply_" + string4 + "_" + string3 + ".txt";
            byte[] byArray = string == null ? new byte[]{} : string.getBytes(StandardCharsets.UTF_8);
            try {
                String string6 = System.getProperty("java.io.tmpdir");
                Path path = Paths.get(string6, string5);
                Files.write(path, byArray, new OpenOption[0]);
                log.info("[DCAI Debug] Wrote reply text to {} (len={})", (Object)path.toAbsolutePath(), (Object)byArray.length);
                return;
            }
            catch (Exception exception) {
                log.info("[DCAI Debug] Failed writing reply to tmpdir: {}", (Object)exception.toString());
                try {
                    String string7 = JMeterUtils.getJMeterHome();
                    Path path = Paths.get(string7, "logs");
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    Path path2 = path.resolve(string5);
                    Files.write(path2, byArray, new OpenOption[0]);
                    log.info("[DCAI Debug] Wrote reply text to {} (len={})", (Object)path2.toAbsolutePath(), (Object)byArray.length);
                    return;
                }
                catch (Exception exception3) {
                    log.info("[DCAI Debug] Failed writing reply to JMeter logs/: {}", (Object)exception3.toString());
                    try {
                        String string8 = JMeterUtils.getJMeterHome();
                        Path path = Paths.get(string8, string5);
                        Files.write(path, byArray, new OpenOption[0]);
                        log.info("[DCAI Debug] Wrote reply text to {} (len={})", (Object)path.toAbsolutePath(), (Object)byArray.length);
                    }
                    catch (Exception exception4) {
                        log.info("[DCAI Debug] Failed writing reply to JMeter home: {}", (Object)exception4.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void acceptExternalContextAndAsk(String string) {
        try {
            if (string == null || string.trim().isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    if (this.tabs != null) {
                        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                            String string2 = this.tabs.getTitleAt(i);
                            if (!"Chat".equalsIgnoreCase(string2)) continue;
                            this.tabs.setSelectedIndex(i);
                            break;
                        }
                    }
                    if (this.inputArea != null) {
                        this.inputArea.setText(string);
                    }
                    this.sendMessage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String sha256Hex(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void clearChat() {
        this.chatHtml.setLength(0);
        this.chatHtml.append("<html><body></body></html>");
        this.chatPane.setText(this.chatHtml.toString());
        try {
            String string = "Hi! I'm George, your JMeter Genius. I can help you with JMeter test plans, debugging, and optimisation. What would you like to work on today?";
            this.appendAiReplyWithAvatar("George - JMeter Genius", string, "/com/company/dcai/images/George.png");
            this.updateStatus("Ready!", Color.GREEN);
        }
        catch (Exception exception) {
            this.appendToChatArea("Chat cleared. How can I help you?", Color.GRAY, true);
        }
    }

    private String getJmxContext() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage != null) {
                String string;
                String string2 = guiPackage.getTestPlanFile();
                if (string2 != null) {
                    stringBuilder.append("Current Test Plan: ").append(string2).append("\n");
                }
                if ((string = FileServer.getFileServer().getBaseDir()) != null && !string.isEmpty()) {
                    stringBuilder.append("Base Directory: ").append(string).append("\n");
                }
                stringBuilder.append("JMeter GUI Mode: Active\n");
                stringBuilder.append("Available for: Performance testing assistance\n");
            }
        }
        catch (Exception exception) {
            stringBuilder.append("JMeter context not available: ").append(exception.getMessage()).append("\n");
        }
        return stringBuilder.toString();
    }

    private void appendToChatArea(String string, Color color, boolean bl) {
        SwingUtilities.invokeLater(() -> {
            String string2 = this.chatPane.getText();
            int n = string2.lastIndexOf("</body>");
            if (n < 0) {
                this.chatHtml.setLength(0);
                this.chatHtml.append("<html><body></body></html>");
                n = this.chatHtml.indexOf("</body>");
            } else {
                this.chatHtml.setLength(0);
                this.chatHtml.append(string2);
            }
            String string3 = (bl ? "<p>" : "") + string + (bl ? "</p>" : "");
            this.chatHtml.insert(n, string3);
            this.chatPane.setText(this.chatHtml.toString());
            this.chatPane.setCaretPosition(this.chatPane.getDocument().getLength());
        });
    }

    private void appendMarkdownToChat(String string, Color color) {
        try {
            log.info("[GeminiSidePanel] appendMarkdownToChat: len={} core={} tables={} autolink={}", (Object)(string != null ? string.length() : 0), (Object)commonmarkCorePresent, (Object)commonmarkTablesPresent, (Object)commonmarkAutolinkPresent);
            if (string != null) {
                log.info("[GeminiSidePanel] MD incoming preview: {}", (Object)this.sample(string, 400));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = this.toMarkdownHtmlPreferCommonMark(string);
        try {
            boolean bl = string2 != null && string2.contains("<table");
            boolean bl2 = string2 != null && string2.contains("<a ");
            log.info("[GeminiSidePanel] MD -> HTML: outLen={} table={} link={} preview={}", (Object)(string2 != null ? string2.length() : 0), (Object)bl, (Object)bl2, (Object)this.sample(string2, 400));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.appendToChatArea("<div class='bubble bubble-user'><div class='bubble-title'>\ud83d\udc64 You</div>" + string2 + "</div>", color, true);
    }

    private void appendSearchRunnerEscalationPrompt(String string) {
        try {
            String string2 = string == null ? "" : string;
            String string3 = this.toMarkdownHtmlPreferCommonMark(string2);
            if (string3 == null) {
                string3 = "";
            }
            String string4 = "\ud83d\udd01 Search Runner \u279c George";
            String string5 = "<div class='bubble bubble-user'><div class='bubble-title'>" + GeminiSidePanel.escapeHtml(string4) + "</div>" + string3 + "</div>";
            this.appendToChatArea(string5, USER_MSG_COLOR, true);
        }
        catch (Exception exception) {
            log.warn("[GeminiSidePanel] appendSearchRunnerEscalationPrompt error: {}", (Object)exception.toString());
        }
    }

    private String toBasicMarkdownHtml(String string) {
        String string2;
        if (string == null) {
            return "";
        }
        try {
            boolean bl = string.indexOf(124) >= 0;
            boolean bl2 = bl && this.looksLikeTableHeaderCandidate(string);
            log.info("[GeminiSidePanel] Basic MD path: len={} hasPipes={} headerCandidate={} tablesExtPresent={} autolinkExtPresent={}", (Object)string.length(), (Object)bl, (Object)bl2, (Object)commonmarkTablesPresent, (Object)commonmarkAutolinkPresent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = GeminiSidePanel.escapeHtml(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = string3;
        Pattern pattern = Pattern.compile("```([\\s\\S]*?)```", 8);
        Matcher matcher = pattern.matcher(string4);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (matcher.find()) {
            string2 = matcher.group(1);
            arrayList.add(string2);
            String string5 = "\u00a7\u00a7CODEBLOCK_" + n++ + "\u00a7\u00a7";
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string5));
        }
        matcher.appendTail(stringBuffer);
        string4 = stringBuffer.toString();
        try {
            log.info("[GeminiSidePanel] Basic MD: fenced code blocks tokenised count={}", (Object)arrayList.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = string4;
        string4 = this.convertPipeTables(string4);
        try {
            if (!string2.equals(string4)) {
                log.info("[GeminiSidePanel] Basic MD: pipe table converted (deltaLen={})", (Object)(string4.length() - string2.length()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string4 = this.promoteConfigBlocks(string4);
        string4 = string4.replaceAll("(?i)\\bt\\*\\s+", "\n- ");
        string4 = string4.replaceAll("(\\\")\\s*\\*\\s+", "$1\n- ");
        string4 = string4.replaceAll("(.)\\s+\\d+\\.\\s+", "$1\n$0");
        string4 = string4.replaceAll("`([^`]+)`", "<code>$1</code>");
        string4 = string4.replaceAll("\\*\\*(.+?)\\*\\*", "<b>$1</b>");
        string4 = string4.replaceAll("(?m)^- ", "\u2022 ");
        string4 = string4.replaceAll("(?m)^\\* ", "\u2022 ");
        string4 = string4.replaceAll("(?m)^(\\d+)\\.\\s+([^:]+):", "$1. <b>$2:</b>");
        string4 = string4.replaceAll("(?m)^\u2022\\s+([^:]+):", "\u2022 <b>$1:</b>");
        string4 = string4.replaceAll("\n\n", "<br/><br/>").replaceAll("\n", "<br/>");
        string4 = string4.replace("\u00a7\u00a7NL\u00a7\u00a7", "\n");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string6 = "\u00a7\u00a7CODEBLOCK_" + i + "\u00a7\u00a7";
            String string7 = "<pre><code>" + (String)arrayList.get(i) + "</code></pre>";
            string4 = string4.replace(string6, string7);
        }
        return string4;
    }

    private String toMarkdownHtmlPreferCommonMark(String string) {
        try {
            log.info("[GeminiSidePanel] CommonMark path: len={} core={} tables={} autolink={}", (Object)(string != null ? string.length() : 0), (Object)commonmarkCorePresent, (Object)commonmarkTablesPresent, (Object)commonmarkAutolinkPresent);
            if (string != null && string.indexOf(124) >= 0) {
                boolean bl = this.looksLikeTableHeaderCandidate(string);
                log.info("[GeminiSidePanel] CommonMark path: pipe detected headerCandidate={}", (Object)bl);
            }
            String string2 = this.sample(string, 400);
            log.info("[GeminiSidePanel] CommonMark input preview: {}", (Object)string2);
            String string3 = this.renderMarkdownWithCommonMark(string);
            if (string3 == null) {
                string3 = "";
            }
            if (string3.isEmpty()) {
                log.info("[GeminiSidePanel] CommonMark produced empty HTML; will fall back to basic converter");
            }
            if (string3 != null && !string3.isEmpty()) {
                return string3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.toBasicMarkdownHtml(this.applySimpleAutoLink(string));
    }

    private String renderMarkdownWithCommonMark(String string) {
        Object object;
        Object object2;
        Object object3;
        if (string == null) {
            return "";
        }
        long l = System.nanoTime();
        log.info("[GeminiSidePanel] CM: building parser");
        Class<?> clazz = Class.forName("org.commonmark.parser.Parser");
        Object object4 = clazz.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            object3 = Class.forName("org.commonmark.ext.gfm.tables.TablesExtension");
            object2 = ((Class)object3).getMethod("create", new Class[0]).invoke(null, new Object[0]);
            arrayList.add(object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object3 = Class.forName("org.commonmark.ext.autolink.AutolinkExtension");
            object2 = ((Class)object3).getMethod("create", new Class[0]).invoke(null, new Object[0]);
            arrayList.add(object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!arrayList.isEmpty()) {
            log.info("[GeminiSidePanel] CM: applying extensions count={}", (Object)arrayList.size());
            try {
                object4.getClass().getMethod("extensions", List.class).invoke(object4, arrayList);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object4.getClass().getMethod("extensions", Iterable.class).invoke(object4, arrayList);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    for (Method[] methodArray : object = object4.getClass().getMethods()) {
                        if (!"extensions".equals(methodArray.getName()) || methodArray.getParameterCount() != 1) continue;
                        try {
                            methodArray.invoke(object4, arrayList);
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        object3 = object4.getClass().getMethod("build", new Class[0]).invoke(object4, new Object[0]);
        object2 = object3.getClass().getMethod("parse", String.class).invoke(object3, string);
        object = Class.forName("org.commonmark.renderer.html.HtmlRenderer");
        Object object5 = ((Class)object).getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        if (!arrayList.isEmpty()) {
            log.info("[GeminiSidePanel] CM: applying renderer extensions count={}", (Object)arrayList.size());
            try {
                object5.getClass().getMethod("extensions", List.class).invoke(object5, arrayList);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object5.getClass().getMethod("extensions", Iterable.class).invoke(object5, arrayList);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    Method[] methodArray;
                    for (Method method : methodArray = object5.getClass().getMethods()) {
                        if (!"extensions".equals(method.getName()) || method.getParameterCount() != 1) continue;
                        try {
                            method.invoke(object5, arrayList);
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        try {
            object5.getClass().getMethod("softBreak", String.class).invoke(object5, "<br/>");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Object object6 = object5.getClass().getMethod("build", new Class[0]).invoke(object5, new Object[0]);
        String string2 = (String)object6.getClass().getMethod("render", Class.forName("org.commonmark.node.Node")).invoke(object6, object2);
        long l2 = System.nanoTime();
        int n = string2 != null && string2.contains("<table") ? 1 : 0;
        int n2 = string2 != null && string2.contains("<a ") ? 1 : 0;
        log.info("[GeminiSidePanel] CommonMark render: inLen={} outLen={} ms={} table={} link={} tablesExt={} autolinkExt={}", (Object)string.length(), (Object)(string2 != null ? string2.length() : 0), (Object)Math.round((double)(l2 - l) / 1000000.0), (Object)(n != 0), (Object)(n2 != 0), (Object)commonmarkTablesPresent, (Object)commonmarkAutolinkPresent);
        return string2;
    }

    private boolean looksLikeTableHeaderCandidate(String string) {
        try {
            if (string == null) {
                return false;
            }
            String[] stringArray = string.split("\n", -1);
            for (int i = 0; i < Math.min(50, stringArray.length - 1); ++i) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                if (!this.looksLikeTableHeader(string2) || !this.looksLikeTableSeparator(string3)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String convertPipeTables(String string) {
        if (string == null || string.indexOf(124) < 0) {
            return string;
        }
        String[] stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (this.looksLikeTableHeaderLoose(string2) && n + 1 < stringArray.length && this.looksLikeTableSeparator(stringArray[n + 1])) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                ++n;
                ++n;
                while (n < stringArray.length && this.containsPipe(stringArray[n]) && !stringArray[n].trim().isEmpty()) {
                    arrayList.add(stringArray[n]);
                    ++n;
                }
                stringBuilder.append(this.renderTable(arrayList));
                ++n2;
                if (n >= stringArray.length) continue;
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append(string2);
            if (n < stringArray.length - 1) {
                stringBuilder.append("\n");
            }
            ++n;
        }
        try {
            log.info("[GeminiSidePanel] Basic MD: tablesDetected={}", (Object)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private boolean containsPipe(String string) {
        return string != null && string.indexOf(124) >= 0;
    }

    private boolean looksLikeTableHeader(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        return string2.startsWith("|") && string2.endsWith("|") && string2.indexOf(124) >= 0;
    }

    private boolean looksLikeTableHeaderLoose(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (!string2.startsWith("|")) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != '|') continue;
            ++n;
        }
        return n >= 2;
    }

    private boolean looksLikeTableSeparator(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (!string2.startsWith("|") || !string2.endsWith("|")) {
            return false;
        }
        String[] stringArray = string2.substring(1, string2.length() - 1).split("\\|");
        if (stringArray.length == 0) {
            return false;
        }
        for (String string3 : stringArray) {
            String string4 = string3.trim().replace(":", "");
            if (string4.isEmpty()) {
                return false;
            }
            for (int i = 0; i < string4.length(); ++i) {
                char c = string4.charAt(i);
                if (c == '-' || c == ' ') continue;
                return false;
            }
        }
        return true;
    }

    private String renderTable(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String[] stringArray = this.splitRow(list.get(0));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table>");
        stringBuilder.append("<thead><tr>");
        for (String string : stringArray) {
            stringBuilder.append("<th>").append(this.trimPipes(string)).append("</th>");
        }
        stringBuilder.append("</tr></thead>");
        if (list.size() > 1) {
            stringBuilder.append("<tbody>");
            for (int i = 2; i < list.size(); ++i) {
                String[] stringArray2 = this.splitRow(list.get(i));
                stringBuilder.append("<tr>");
                for (String string : stringArray2) {
                    stringBuilder.append("<td>").append(this.trimPipes(string)).append("</td>");
                }
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</tbody>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private String promoteConfigBlocks(String string) {
        try {
            if (string == null || string.isEmpty()) {
                return string;
            }
            String[] stringArray = string.split("\n", -1);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < stringArray.length) {
                if (this.isConfigLikeLine(stringArray[n])) {
                    int n2;
                    int n3 = n;
                    while (n < stringArray.length && (this.isConfigLikeLine(stringArray[n]) || stringArray[n].trim().isEmpty())) {
                        ++n;
                    }
                    int n4 = n - n3;
                    if (n4 >= 3) {
                        stringBuilder.append("<pre><code>");
                        for (n2 = n3; n2 < n; ++n2) {
                            stringBuilder.append(stringArray[n2]).append("\u00a7\u00a7NL\u00a7\u00a7");
                        }
                        stringBuilder.append("</code></pre>");
                        if (n >= stringArray.length) continue;
                        stringBuilder.append("\n");
                        continue;
                    }
                    for (n2 = n3; n2 < n; ++n2) {
                        stringBuilder.append(stringArray[n2]);
                        if (n2 >= n - 1) continue;
                        stringBuilder.append("\n");
                    }
                    if (n >= stringArray.length) continue;
                    stringBuilder.append("\n");
                    continue;
                }
                stringBuilder.append(stringArray[n]);
                if (n < stringArray.length - 1) {
                    stringBuilder.append("\n");
                }
                ++n;
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private boolean isConfigLikeLine(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return false;
        }
        if (string2.startsWith("#")) {
            return true;
        }
        return string2.matches("[A-Za-z0-9_\\-\\.]+\\s*=.*");
    }

    private String sample(String string, int n) {
        try {
            if (string == null) {
                return "";
            }
            if (string.length() <= n) {
                return string;
            }
            return string.substring(0, Math.max(0, n)) + "\u2026 (" + string.length() + ")";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String firstNonEmpty(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (this.isEmpty(string)) continue;
            return string;
        }
        return null;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    private String sanitizeForInline(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replace('`', '\'').replace("\n", " ").replace("\r", " ");
        return string2.trim();
    }

    private void logLargeInfo(String string, String string2) {
        try {
            String string3;
            String string4 = string3 = string == null ? "LLM Reply" : string;
            if (string2 == null) {
                string2 = "";
            }
            log.info("[{}] totalLen={}", (Object)string3, (Object)string2.length());
            for (int i = 0; i < string2.length(); i += 2000) {
                int n = Math.min(string2.length(), i + 2000);
                String string5 = string2.substring(i, n);
                log.info("[{}] chunk {}-{}:\n{}", (Object)string3, (Object)i, (Object)n, (Object)string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] splitRow(String string) {
        if (string == null) {
            return new String[0];
        }
        String string2 = string.trim();
        if (string2.startsWith("|")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("|")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    private String trimPipes(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string2.startsWith("|")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("|")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2.trim();
    }

    private String applySimpleAutoLink(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        try {
            String string2 = string;
            string2 = string2.replaceAll("(?i)(?<![\\w@])((?:https?|ftp)://[\\w.-]+(?:/[^\\s]*)?)", "<$1>");
            string2 = string2.replaceAll("(?i)(?<![\\w.])([A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,})", "<$1>");
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void appendAiReply(String string, String string2) {
        try {
            if (string2 == null || string2.trim().isEmpty()) {
                String string3 = "<div class='bubble bubble-ai'><div class='bubble-title'>" + this.buildTitleHtml(string) + "</div><i>(no content returned)</i></div>";
                this.appendToChatArea(string3, AI_MSG_COLOR, true);
                return;
            }
            this.lastAiMarkdown = string2;
            String string4 = this.toMarkdownHtmlPreferCommonMark(string2);
            if (string4 == null) {
                string4 = "";
            }
            String string5 = "<div class='bubble bubble-ai'><div class='bubble-title'>" + this.buildTitleHtml(string) + "</div>" + string4 + "</div>";
            this.lastAiHtml = string5;
            this.appendToChatArea(string5, AI_MSG_COLOR, true);
        }
        catch (Exception exception) {
            log.warn("[GeminiSidePanel] Error rendering AI reply: {}", (Object)exception.toString());
            String string6 = GeminiSidePanel.escapeHtml(exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName());
            String string7 = "<div class='bubble bubble-ai'><div class='bubble-title'>" + this.buildTitleHtml(string) + "</div><span style='color:#c00'>Rendering error: " + string6 + "</span></div>";
            this.appendToChatArea(string7, AI_MSG_COLOR, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendAiReplyWithAvatar(String string, String string2, String string3) {
        try {
            void var10_26;
            String[] stringArray;
            Object object2;
            Object object3 = null;
            try {
                String object;
                object2 = null;
                stringArray = string3 != null && !string3.isEmpty() ? ((object = string3.toLowerCase()).contains("search-runner") ? new String[]{string3, "/com/company/dcai/images/search-runner.png", "/dcai/images/search-runner.png", "/JMCommonScripts/manual-build/dcai/images/search-runner.png", "/images/search-runner.png"} : (object.contains("george") ? new String[]{string3, "/com/company/dcai/images/George.png", "/dcai/images/George.png", "/JMCommonScripts/manual-build/dcai/images/George.png", "/images/George.png"} : (object.contains("carrie") ? new String[]{string3, "/com/company/dcai/images/Carrie.png", "/dcai/images/Carrie.png", "/JMCommonScripts/manual-build/dcai/images/Carrie.png", "/images/Carrie.png"} : new String[]{string3}))) : new String[]{"/com/company/dcai/images/George.png", "/dcai/images/George.png", "/JMCommonScripts/manual-build/dcai/images/George.png", "/images/George.png"};
                for (String string4 : stringArray) {
                    try {
                        object2 = GeminiSidePanel.class.getResource(string4);
                        if (object2 == null) continue;
                        log.info("[GeminiSidePanel] Avatar icon found on classpath: {}", object2);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object2 == null) {
                    try {
                        String[] stringArray2;
                        String string5 = JMeterUtils.getJMeterHome();
                        String string6 = string3 != null && !string3.isEmpty() ? new File(string3).getName() : "George.png";
                        for (String string7 : stringArray2 = new String[]{string5 + "/JMCommonScripts/manual-build/com/company/dcai/images/" + string6, string5 + "/com/company/dcai/images/" + string6, string5 + "/dcai/images/" + string6, string5 + "/images/" + string6}) {
                            File file = new File(string7);
                            if (!file.exists() || !file.isFile()) continue;
                            object2 = file.toURI().toURL();
                            log.info("[GeminiSidePanel] Avatar icon found on filesystem: {}", (Object)string7);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    object3 = "<img src='" + ((URL)object2).toString() + "' width='24' height='24' style='vertical-align:middle;margin-right:8px;' alt='AI'/>";
                } else {
                    log.info("[GeminiSidePanel] Avatar icon not found; using default AI icon");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = string == null ? "" : string;
            stringArray = ((String)object2).replace("\ud83e\udd16", "").trim();
            String string8 = object3 != null && !((String)object3).isEmpty() ? object3 : GeminiSidePanel.getAiIconHtmlOrEmoji();
            String string9 = string8.startsWith("<img") ? "&nbsp;" : "";
            String string10 = string8 + string9 + GeminiSidePanel.escapeHtml((String)stringArray);
            String string11 = this.toMarkdownHtmlPreferCommonMark(string2);
            if (string11 == null) {
                String string12 = "";
            }
            String string13 = "<div class='bubble bubble-ai'><div class='bubble-title'>" + string10 + "</div>" + (String)var10_26 + "</div>";
            this.lastAiMarkdown = string2;
            this.lastAiHtml = string13;
            this.appendToChatArea(string13, AI_MSG_COLOR, true);
        }
        catch (Exception exception) {
            this.appendAiReply(string, string2);
        }
    }

    private String buildTitleHtml(String string) {
        try {
            String string2 = string == null ? "" : string;
            String string3 = string2.replace("\ud83e\udd16", "").trim();
            String string4 = GeminiSidePanel.getAiIconHtmlOrEmoji();
            String string5 = string4 != null && string4.startsWith("<img") ? "&nbsp;" : "";
            return string4 + string5 + GeminiSidePanel.escapeHtml(string3);
        }
        catch (Exception exception) {
            return GeminiSidePanel.escapeHtml(string != null ? string : "");
        }
    }

    private static String getAiIconHtmlOrEmoji() {
        GeminiSidePanel.ensureAiIconLoaded();
        if (aiIconHtml != null && !aiIconHtml.isEmpty()) {
            return aiIconHtml;
        }
        log.info("[GeminiSidePanel] Using emoji fallback for AI icon");
        return "\ud83e\udd16 ";
    }

    private static void ensureAiIconLoaded() {
        if (aiIconAttempted) {
            return;
        }
        aiIconAttempted = true;
        try {
            log.info("[GeminiSidePanel] AI icon load start. ClassLoader={} class={} attempted={}", (Object)String.valueOf(GeminiSidePanel.class.getClassLoader()), (Object)GeminiSidePanel.class.getName(), (Object)aiIconAttempted);
            String[] stringArray = new String[]{"/com/company/dcai/images/George.png", "/dcai/images/George.png", "/JMCommonScripts/manual-build/dcai/images/George.png", "/images/George.png"};
            for (String string : stringArray) {
                try {
                    URL uRL = GeminiSidePanel.class.getResource(string);
                    log.info("[GeminiSidePanel] Probing classpath resource path='{}' url={}", (Object)string, (Object)(uRL != null ? uRL.toString() : "null"));
                    if (uRL != null) {
                        aiIconUrl = uRL;
                        aiIconHtml = "<img src='" + uRL.toString() + "' width='24' height='24' style='vertical-align:middle;margin-right:8px;' alt='AI'/>";
                        log.info("[GeminiSidePanel] Using classpath URL for AI icon: {}", (Object)uRL);
                        return;
                    }
                    log.info("[GeminiSidePanel] Resource not found on classpath: {}", (Object)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                String string = JMeterUtils.getJMeterHome();
                log.info("[GeminiSidePanel] Probing filesystem under JMeterHome='{}'", (Object)string);
                if (string != null && !string.isEmpty()) {
                    String[] stringArray2;
                    for (String string2 : stringArray2 = new String[]{"JMCommonScripts/manual-build/dcai/images/George.png", "dcai/images/George.png"}) {
                        Path path = Paths.get(string, string2);
                        log.info("[GeminiSidePanel] Checking file {} exists={} size={} bytes", (Object)path.toAbsolutePath(), (Object)Files.exists(path, new LinkOption[0]), (Object)(Files.exists(path, new LinkOption[0]) ? Files.size(path) : -1L));
                        if (!Files.exists(path, new LinkOption[0])) continue;
                        String string3 = path.toUri().toString();
                        aiIconHtml = "<img src='" + string3 + "' width='24' height='24' style='vertical-align:middle;margin-right:8px;' alt='AI'/>";
                        log.info("[GeminiSidePanel] Using file URL for AI icon: {}", (Object)string3);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("[GeminiSidePanel] AI icon not found on classpath or filesystem; will fall back to emoji.");
        }
        catch (Exception exception) {
            log.info("[GeminiSidePanel] AI icon load failed: {}", (Object)exception.toString());
        }
    }

    private static byte[] readAllBytes(InputStream inputStream) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void copyLastAiResponseAsText() {
        try {
            Object object;
            Object object2;
            Object object3 = object2 = this.lastAiMarkdown != null ? this.lastAiMarkdown : "";
            if (((String)object2).trim().isEmpty()) {
                try {
                    object = this.chatPane.getSelectedText();
                    if (object != null) {
                        object2 = object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = new StringSelection((String)object2);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
            this.updateStatus("Copied AI reply as text", Color.GREEN);
        }
        catch (Exception exception) {
            this.updateStatus("Copy failed: " + exception.getMessage(), Color.RED);
        }
    }

    private String promoteCodeFencesForScripts(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (string.contains("```")) {
                return string;
            }
            String[] stringArray = string.split("\n", -1);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < stringArray.length) {
                if (this.isScriptyLine(stringArray[n]) || this.isConfigLikeLine(stringArray[n])) {
                    int n2;
                    int n3 = n;
                    int n4 = 0;
                    while (n < stringArray.length) {
                        String string2 = stringArray[n];
                        if (string2.trim().isEmpty()) {
                            ++n;
                            continue;
                        }
                        if (!this.isScriptyLine(string2) && !this.isConfigLikeLine(string2)) break;
                        ++n4;
                        ++n;
                    }
                    if (n4 >= 3) {
                        stringBuilder.append("```\n");
                        for (n2 = n3; n2 < n; ++n2) {
                            stringBuilder.append(stringArray[n2]).append("\n");
                        }
                        stringBuilder.append("```\n");
                        continue;
                    }
                    for (n2 = n3; n2 < n; ++n2) {
                        stringBuilder.append(stringArray[n2]).append("\n");
                    }
                    continue;
                }
                stringBuilder.append(stringArray[n]).append("\n");
                ++n;
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private boolean isScriptyLine(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return false;
        }
        if (string2.startsWith("import ") || string2.startsWith("package ")) {
            return true;
        }
        if (string2.startsWith("class ") || string2.startsWith("public ") || string2.startsWith("private ") || string2.startsWith("def ")) {
            return true;
        }
        if (string2.contains(" vars.put(") || string2.contains("new ") || string2.contains("Random ") || string2.contains("Pattern.compile")) {
            return true;
        }
        char c = string2.charAt(string2.length() - 1);
        if (c == ';' || c == '{' || c == '}' || c == ')') {
            return true;
        }
        return string2.matches(".*=\\s*\\[.*\\].*");
    }

    private void reapplyLookAndFeelToChat() {
        try {
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
            String string = UIManager.getFont("Label.font") != null ? UIManager.getFont("Label.font").getFamily() : "Sans-Serif";
            Color color = UIManager.getColor("EditorPane.background");
            Color color2 = UIManager.getColor("EditorPane.foreground");
            String string2 = GeminiSidePanel.colorToHex(color != null ? color : UIManager.getColor("Panel.background"));
            String string3 = GeminiSidePanel.colorToHex(color2 != null ? color2 : UIManager.getColor("Label.foreground"));
            styleSheet.addRule("body { background: " + string2 + "; color: " + string3 + "; font-family: '" + string + "', Sans-Serif; font-size: 12px; margin: 8px; }");
            styleSheet.addRule("code, pre { font-family: '" + (UIManager.getFont("TextArea.font") != null ? UIManager.getFont("TextArea.font").getFamily() : "Monospaced") + "', Monospaced; }");
            styleSheet.addRule("pre, code { white-space: pre-wrap; }");
            styleSheet.addRule("ul { margin-top: 4px; margin-bottom: 4px; }");
            styleSheet.addRule("ol { margin-top: 4px; margin-bottom: 4px; }");
            styleSheet.addRule(".user { color: " + GeminiSidePanel.colorToHex(USER_MSG_COLOR) + "; }");
            styleSheet.addRule(".ai { color: " + GeminiSidePanel.colorToHex(AI_MSG_COLOR) + "; }");
            Color color3 = UIManager.getColor("Panel.background");
            Color color4 = GeminiSidePanel.blend(UIManager.getColor("Label.foreground"), color3, 0.75);
            styleSheet.addRule("table { border-collapse: collapse; margin: 6px 0; width: 100%; max-width: 100%; }");
            styleSheet.addRule("th, td { border: 1px solid " + GeminiSidePanel.colorToHex(color4) + "; padding: 6px 8px; text-align: left; vertical-align: top; }");
            styleSheet.addRule("th { background: " + GeminiSidePanel.colorToHex(GeminiSidePanel.blend(color3, UIManager.getColor("Label.foreground"), 0.12)) + "; }");
            styleSheet.addRule("tr:nth-child(even) td { background: " + GeminiSidePanel.colorToHex(GeminiSidePanel.blend(color3, UIManager.getColor("Label.foreground"), 0.04)) + "; }");
            this.chatPane.setEditorKit(hTMLEditorKit);
            this.chatPane.setText(this.chatPane.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String escapeHtml(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;").replace("\n", "<br/>");
    }

    private static String colorToHex(Color color) {
        if (color == null) {
            return "#333333";
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String htmlUnescape(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&#39;", "'").replace("&amp;", "&");
    }

    private static Color blend(Color color, Color color2, double d) {
        if (color == null) {
            color = Color.WHITE;
        }
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        double d2 = Math.max(0.0, Math.min(1.0, d));
        int n = (int)Math.round((double)color.getRed() * (1.0 - d2) + (double)color2.getRed() * d2);
        int n2 = (int)Math.round((double)color.getGreen() * (1.0 - d2) + (double)color2.getGreen() * d2);
        int n3 = (int)Math.round((double)color.getBlue() * (1.0 - d2) + (double)color2.getBlue() * d2);
        return new Color(Math.max(0, Math.min(255, n)), Math.max(0, Math.min(255, n2)), Math.max(0, Math.min(255, n3)));
    }

    private void updateStatus(String string, Color color) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(string);
            Color color2 = color == Color.ORANGE ? WARNING_COLOR : color;
            this.statusLabel.setForeground(color2);
        });
    }

    private void traceEnter(String string) {
        try {
            log.info("[TRACE] ENTER {}", (Object)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void traceExit(String string) {
        try {
            log.info("[TRACE] EXIT {}", (Object)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onCarrieReplyJson(String string) {
        try {
            LogManager.getLogger(GeminiSidePanel.class).info("[Search Auto] onCarrieReplyJson ENTER len={}", (Object)(string != null ? string.length() : -1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
            if (geminiSidePanel != null) {
                geminiSidePanel.handleCarrieReplyJsonInternal(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LogManager.getLogger(GeminiSidePanel.class).info("[Search Auto] onCarrieReplyJson EXIT");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleCarrieReplyJsonInternal(String string) {
        this.traceEnter("handleCarrieReplyJsonInternal");
        try {
            boolean bl;
            String string2 = string == null ? "" : string.trim();
            lastCarrieCorrelationIssue = bl = this.isSortCorrelationIssue(string2);
            if (bl) {
                lastCarrieCorrelationJson = string2;
                lastCarrieCorrelationEscalated = false;
                try {
                    lastCarrieCorrelationValue = this.selectNextCandidateForInsertion(string2);
                }
                catch (Exception exception) {
                    lastCarrieCorrelationValue = null;
                }
                try {
                    lastCarrieCorrelationCause = this.extractJsonStringViaRegex(string2, "cause");
                }
                catch (Exception exception) {
                    lastCarrieCorrelationCause = null;
                }
            } else {
                lastCarrieCorrelationJson = null;
                lastCarrieCorrelationValue = null;
                lastCarrieCorrelationCause = null;
                lastCarrieCorrelationEscalated = false;
                lastCarrieCorrelationSample = null;
            }
            try {
                log.info("[Search Auto] handleCarrieReplyJsonInternal sortIssue={} hdr='{}' valuePreview='{}'", (Object)bl, (Object)String.valueOf(lastErrorDcaiHeader), (Object)this.sample(this.extractFirstCarrieValue(string2), 80));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                this.processAllUninsertedCandidates();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.traceExit("handleCarrieReplyJsonInternal");
    }

    private void handleSearchHar() {
        try {
            SwingUtilities.invokeLater(() -> {
                block12: {
                    try {
                        Object object;
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setDialogTitle("Select HAR file");
                        try {
                            if (this.lastUploadedHarFile != null && this.lastUploadedHarFile.getParentFile() != null) {
                                jFileChooser.setCurrentDirectory(this.lastUploadedHarFile.getParentFile());
                            } else {
                                object = FileServer.getFileServer().getBaseDir();
                                if (object != null && !((String)object).isEmpty()) {
                                    jFileChooser.setCurrentDirectory(new File((String)object));
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            object = new FileNameExtensionFilter("HTTP Archive (*.har)", "har");
                            jFileChooser.setFileFilter((FileFilter)object);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n = jFileChooser.showOpenDialog(this);
                        if (n == 0) {
                            File file = jFileChooser.getSelectedFile();
                            try {
                                log.info("[Search Manual] HAR chosen via file chooser: {}", (Object)(file != null ? file.getAbsolutePath() : "(null)"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.performHarSelection(file);
                            break block12;
                        }
                        this.updateStatus("HAR selection cancelled", Color.ORANGE);
                    }
                    catch (Exception exception) {
                        this.updateStatus("HAR selection error: " + exception.getMessage(), Color.RED);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void performHarSelection(File file) {
        try {
            try {
                log.info("[Search Start] performHarSelection called with file='{}' exists={} size={} bytes", (Object)(file != null ? file.getAbsolutePath() : "(null)"), (Object)(file != null && file.exists() ? 1 : 0), (Object)(file != null && file.exists() ? file.length() : -1L));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastUploadedHarFile = file;
            this.updateStatus("HAR selected: " + (file != null ? file.getName() : "(none)"), Color.GREEN);
            this.appendToChatArea(GeminiSidePanel.escapeHtml("Search HAR selected: " + (file != null ? file.getAbsolutePath() : "(none)")), AI_MSG_COLOR, true);
            if (file != null) {
                this.runHarSearchAsync(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void persistHarPath(String string) {
        try {
            Object object;
            try {
                log.info("[HAR Persist] persistHarPath: requested path='{}'", (Object)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                return;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            if (jMeterTreeModel == null) {
                return;
            }
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)jMeterTreeModel.getRoot();
            if (jMeterTreeNode == null) {
                return;
            }
            JMeterTreeNode jMeterTreeNode2 = this.findTestPlanNode(jMeterTreeNode);
            if (jMeterTreeNode2 == null) {
                return;
            }
            TestPlan testPlan = null;
            try {
                object = jMeterTreeNode2.getUserObject();
                if (object instanceof TestPlan) {
                    testPlan = (TestPlan)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (testPlan == null) {
                return;
            }
            if (string == null) {
                string = "";
            }
            object = testPlan.getArguments();
            try {
                log.info("[HAR Persist] persistHarPath: before update, argCount={} mapKeys={}", (Object)object.getArgumentCount(), testPlan.getUserDefinedVariables().keySet());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            try {
                int n = object.getArgumentCount();
                for (int i = 0; i < n; ++i) {
                    Argument argument = object.getArgument(i);
                    if (argument == null || !DCAI_HAR_PATH_VAR.equals(argument.getName())) continue;
                    try {
                        log.info("[HAR Persist] persistHarPath: updating existing '{}' at index {} from '{}' to '{}'", (Object)DCAI_HAR_PATH_VAR, (Object)i, (Object)argument.getValue(), (Object)string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    argument.setValue(string);
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                try {
                    log.info("[HAR Persist] persistHarPath: adding new '{}'='{}'", (Object)DCAI_HAR_PATH_VAR, (Object)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object.addArgument(DCAI_HAR_PATH_VAR, string);
            }
            testPlan.setUserDefinedVariables((Arguments)object);
            try {
                testPlan.setProperty(DCAI_HAR_PATH_VAR, string);
                log.info("[HAR Persist] persistHarPath: set TestPlan property {}='{}' (verify='{}')", (Object)DCAI_HAR_PATH_VAR, (Object)string, (Object)testPlan.getPropertyAsString(DCAI_HAR_PATH_VAR));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ensureDcaiArgsNodeWithVar(jMeterTreeNode2, jMeterTreeModel, DCAI_HAR_PATH_VAR, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                log.info("[HAR Persist] persistHarPath: after update, argCount={} mapValue='{}'", (Object)object.getArgumentCount(), (Object)String.valueOf(testPlan.getUserDefinedVariables().get(DCAI_HAR_PATH_VAR)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                guiPackage.getMainFrame().repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                log.info("[HAR Persist] verify-in-memory: mapNow='{}'", (Object)this.safeCurrentHarMap());
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void applyPersistedHarPathToUi() {
        block9: {
            try {
                String string = this.loadHarPathFromTestPlan();
                try {
                    log.info("[HAR Persist] applyPersistedHarPathToUi: loaded path='{}'", (Object)String.valueOf(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string != null && !string.isEmpty()) break block9;
                try {
                    GuiPackage guiPackage = GuiPackage.getInstance();
                    if (guiPackage != null && guiPackage.getTreeModel() != null) {
                        TestPlan testPlan;
                        JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)guiPackage.getTreeModel().getRoot();
                        TestPlan testPlan2 = testPlan = jMeterTreeNode != null ? this.findTestPlan(jMeterTreeNode) : null;
                        if (testPlan != null) {
                            Arguments arguments = testPlan.getArguments();
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("[HAR Persist] Arguments dump (count=").append(arguments.getArgumentCount()).append("):\n");
                            for (int i = 0; i < arguments.getArgumentCount(); ++i) {
                                Argument argument = arguments.getArgument(i);
                                if (argument == null) continue;
                                stringBuilder.append("  [").append(i).append("] ").append(argument.getName()).append("=").append(argument.getValue()).append("\n");
                            }
                            log.info(stringBuilder.toString());
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String safeCurrentHarMap() {
        try {
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null || guiPackage.getTreeModel() == null) {
                return "{}";
            }
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)guiPackage.getTreeModel().getRoot();
            if (jMeterTreeNode == null) {
                return "{}";
            }
            TestPlan testPlan = this.findTestPlan(jMeterTreeNode);
            if (testPlan == null) {
                return "{}";
            }
            Map map = testPlan.getUserDefinedVariables();
            return map != null ? String.valueOf(map) : "{}";
        }
        catch (Exception exception) {
            return "{}";
        }
    }

    private String loadJMeterVariable(String string) {
        try {
            String string2;
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                return null;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            if (jMeterTreeModel == null) {
                return null;
            }
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)jMeterTreeModel.getRoot();
            if (jMeterTreeNode == null) {
                return null;
            }
            TestPlan testPlan = this.findTestPlan(jMeterTreeNode);
            if (testPlan == null) {
                return null;
            }
            Map map = testPlan.getUserDefinedVariables();
            if (map != null && (string2 = (String)map.get(string)) != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                string2 = this.findVarInDcaiArgsNode(jMeterTreeNode, string);
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string2 = this.findVarInAnyArgumentsNodes(jMeterTreeNode, string);
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = testPlan.getPropertyAsString(string);
            return string2 != null && !string2.isEmpty() ? string2 : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String loadHarPathFromTestPlan() {
        try {
            String string;
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                return null;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            if (jMeterTreeModel == null) {
                return null;
            }
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)jMeterTreeModel.getRoot();
            if (jMeterTreeNode == null) {
                return null;
            }
            TestPlan testPlan = this.findTestPlan(jMeterTreeNode);
            if (testPlan == null) {
                return null;
            }
            Map map = testPlan.getUserDefinedVariables();
            try {
                log.info("[HAR Persist] loadHarPathFromTestPlan: keys={} value(by DCAI_HAR_PATH)='{}'", map != null ? map.keySet() : null, map != null ? map.get(DCAI_HAR_PATH_VAR) : null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (map == null) {
                return null;
            }
            String string2 = (String)map.get(DCAI_HAR_PATH_VAR);
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                string = this.findVarInDcaiArgsNode((JMeterTreeNode)jMeterTreeModel.getRoot(), DCAI_HAR_PATH_VAR);
                if (string != null && !string.isEmpty()) {
                    log.info("[HAR Persist] loadHarPathFromTestPlan: found in '{}' node: '{}'", (Object)DCAI_ARGS_NODE_NAME, (Object)string);
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.findVarInAnyArgumentsNodes((JMeterTreeNode)jMeterTreeModel.getRoot(), DCAI_HAR_PATH_VAR);
                if (string != null && !string.isEmpty()) {
                    log.info("[HAR Persist] loadHarPathFromTestPlan: found in ANY Arguments node: '{}'", (Object)string);
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = testPlan.getPropertyAsString(DCAI_HAR_PATH_VAR);
            try {
                log.info("[HAR Persist] loadHarPathFromTestPlan: fallback property '{}'='{}'", (Object)DCAI_HAR_PATH_VAR, (Object)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string != null && !string.isEmpty() ? string : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void ensureDcaiArgsNodeWithVar(JMeterTreeNode jMeterTreeNode, JMeterTreeModel jMeterTreeModel, String string, String string2) {
        try {
            JMeterTreeNode jMeterTreeNode2 = this.findChildArgsNodeByName(jMeterTreeNode, DCAI_ARGS_NODE_NAME);
            if (jMeterTreeNode2 == null) {
                Arguments arguments = new Arguments();
                arguments.setName(DCAI_ARGS_NODE_NAME);
                arguments.addArgument(string, string2 != null ? string2 : "");
                jMeterTreeModel.addComponent((TestElement)arguments, jMeterTreeNode);
                log.info("[HAR Persist] ensureDcaiArgsNodeWithVar: created '{}' with {}='{}'", (Object)DCAI_ARGS_NODE_NAME, (Object)string, (Object)string2);
            } else {
                Object object = jMeterTreeNode2.getUserObject();
                if (object instanceof Arguments) {
                    Arguments arguments = (Arguments)object;
                    boolean bl = false;
                    for (int i = 0; i < arguments.getArgumentCount(); ++i) {
                        Argument argument = arguments.getArgument(i);
                        if (argument == null || !string.equals(argument.getName())) continue;
                        argument.setValue(string2 != null ? string2 : "");
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        arguments.addArgument(string, string2 != null ? string2 : "");
                    }
                    jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode2);
                    log.info("[HAR Persist] ensureDcaiArgsNodeWithVar: updated '{}' {}='{}' (updated={})", (Object)DCAI_ARGS_NODE_NAME, (Object)string, (Object)string2, (Object)bl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JMeterTreeNode findChildArgsNodeByName(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                TestElement testElement;
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                Object object = jMeterTreeNode2.getUserObject();
                if (!(object instanceof Arguments) || !string.equals((testElement = (TestElement)object).getName())) continue;
                return jMeterTreeNode2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String findVarInDcaiArgsNode(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            JMeterTreeNode jMeterTreeNode2 = this.findTestPlanNode(jMeterTreeNode);
            if (jMeterTreeNode2 == null) {
                return null;
            }
            JMeterTreeNode jMeterTreeNode3 = this.findChildArgsNodeByName(jMeterTreeNode2, DCAI_ARGS_NODE_NAME);
            if (jMeterTreeNode3 == null) {
                return null;
            }
            Object object = jMeterTreeNode3.getUserObject();
            if (object instanceof Arguments) {
                Arguments arguments = (Arguments)object;
                for (int i = 0; i < arguments.getArgumentCount(); ++i) {
                    Argument argument = arguments.getArgument(i);
                    if (argument == null || !string.equals(argument.getName())) continue;
                    return argument.getValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String findVarInAnyArgumentsNodes(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            if (jMeterTreeNode == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof Arguments) {
                Arguments arguments = (Arguments)object;
                for (int i = 0; i < arguments.getArgumentCount(); ++i) {
                    Argument argument = arguments.getArgument(i);
                    if (argument == null || !string.equals(argument.getName())) continue;
                    return argument.getValue();
                }
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                String string2 = this.findVarInAnyArgumentsNodes((JMeterTreeNode)jMeterTreeNode.getChildAt(i), string);
                if (string2 == null || string2.isEmpty()) continue;
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TestPlan findTestPlan(JMeterTreeNode jMeterTreeNode) {
        try {
            if (jMeterTreeNode == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && object instanceof TestPlan) {
                return (TestPlan)object;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                TestPlan testPlan = this.findTestPlan((JMeterTreeNode)jMeterTreeNode.getChildAt(i));
                if (testPlan == null) continue;
                return testPlan;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private JMeterTreeNode findTestPlanNode(JMeterTreeNode jMeterTreeNode) {
        try {
            if (jMeterTreeNode == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && object instanceof TestPlan) {
                return jMeterTreeNode;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                JMeterTreeNode jMeterTreeNode2 = this.findTestPlanNode((JMeterTreeNode)jMeterTreeNode.getChildAt(i));
                if (jMeterTreeNode2 == null) continue;
                return jMeterTreeNode2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void runHarSearchAsync(File file) {
        try {
            log.info("[Search Runner] Starting HAR search async for file='{}'", (Object)(file != null ? file.getAbsolutePath() : "(null)"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executorService.submit(() -> {
            try {
                String string;
                String string2;
                String string3;
                String string4 = lastCarrieCorrelationValue;
                if (string4 == null || string4.isEmpty()) {
                    string3 = this.getLastAiCarrieJson();
                    string4 = this.extractFirstCarrieValue(string3);
                }
                try {
                    log.info("[Search Runner] Inputs: valuePresent={} header='{}' startIdx={} fileExists={} size={} bytes", (Object)(string4 != null && !string4.isEmpty() ? 1 : 0), (Object)String.valueOf(lastErrorDcaiHeader), (Object)this.parseDcaiIndex(lastErrorDcaiHeader), (Object)(file != null && file.exists() ? 1 : 0), (Object)(file != null && file.exists() ? file.length() : -1L));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string4 == null || string4.isEmpty()) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner: No value found in last Carrie reply."), Color.ORANGE, true);
                    return;
                }
                string3 = lastErrorDcaiHeader;
                if (string3 == null || string3.isEmpty()) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner: Missing starting DCAI header from error request."), Color.ORANGE, true);
                    return;
                }
                int n = this.parseDcaiIndex(string3);
                if (n <= 0) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner: Invalid DCAI header '" + string3 + "'."), Color.ORANGE, true);
                    return;
                }
                this.appendAiReplyWithAvatar("\ud83e\udd16 Search Runner", "Starting search for correlation value (from Carrie):\n\n```\n" + (string4 == null ? "" : string4) + "\n```\n\nFrom DCAI starting at: " + GeminiSidePanel.escapeHtml(string3) + " (descending). Only responses will be scanned.", "/com/company/dcai/images/search-runner.png");
                String string5 = this.safeReadFileToString(file, 0x4000000);
                try {
                    log.info("[Search Runner] HAR read: ok={} length={} chars", (Object)(string5 != null ? 1 : 0), (Object)(string5 != null ? string5.length() : -1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string5 == null) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner: HAR too large or unreadable."), Color.RED, true);
                    return;
                }
                for (int i = n - 1; i >= 1; --i) {
                    block37: {
                        boolean bl;
                        try {
                            log.info("[Search Runner] Step check: DCAI={}", (Object)String.format("DCAI-%05d", i));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        string2 = String.format("DCAI-%05d", i);
                        this.appendToChatArea(GeminiSidePanel.escapeHtml("Search step: request header DCAI=" + string2), Color.GRAY, true);
                        int n2 = this.indexOfHeaderValue(string5, string2);
                        try {
                            log.info("[Search Runner] Header index result for {}: {}", (Object)string2, (Object)n2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n2 < 0) {
                            this.appendToChatArea(GeminiSidePanel.escapeHtml("- Not found: request DCAI=" + string2), Color.GRAY, true);
                            continue;
                        }
                        ResponseWindow responseWindow = this.extractResponseWindowForRequest(string5, n2);
                        if (responseWindow == null || responseWindow.segment == null) continue;
                        string = this.extractResponseBodyTextFromHarSegment(responseWindow.segment);
                        try {
                            log.info("[Search Runner] Response window: url='{}' respBodyLen={} segLen={} containsValue={} ", (Object)String.valueOf(responseWindow.url), (Object)(string != null ? string.length() : -1), (Object)(responseWindow.segment != null ? responseWindow.segment.length() : -1), (Object)(string != null && string4 != null && string.indexOf(string4) >= 0 ? 1 : 0));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean bl2 = bl = string != null && string4 != null && string.indexOf(string4) >= 0 || string4 != null && responseWindow.segment.indexOf(string4) >= 0;
                        if (!bl) {
                            this.appendToChatArea(GeminiSidePanel.escapeHtml("- Value not present in response for DCAI=" + string2), Color.GRAY, true);
                            continue;
                        }
                        String string6 = responseWindow.url != null ? responseWindow.url : this.extractNearestUrlBackward(string5, n2);
                        String string7 = this.buildMatchSnippet(string != null && !string.isEmpty() ? string : responseWindow.segment, string4, 140);
                        boolean bl3 = GeminiSidePanel.isLikelyJson(GeminiSidePanel.extractJsonSubstring(string == null ? "" : string.trim()));
                        this.appendAiReplyWithAvatar("\ud83e\udd16 Search Runner", "Found correlation value at request DCAI=" + string2 + (String)(string6 != null ? "\n\nURL: " + GeminiSidePanel.escapeHtml(string6) : "") + "\n\nIs JSON: " + (bl3 ? "Yes" : "No"), "/com/company/dcai/images/search-runner.png");
                        if (!bl3) {
                            try {
                                String string8 = this.buildMatchSnippet(string != null && !string.isEmpty() ? string : responseWindow.segment, string4, 100);
                                GeminiSidePanel.setPendingBoundariesDcaiId(string2);
                                GeminiSidePanel.setPendingBoundariesUrl(string6);
                                this.sendBoundariesToCarrie(string4, string8);
                            }
                            catch (Exception exception) {}
                        } else {
                            try {
                                String string9 = string != null && !string.isEmpty() ? string : responseWindow.segment;
                                String string10 = this.deriveJsonPathFromResponse(string9, string4);
                                try {
                                    log.info("[Search Runner] Derived JSONPath='{}' for value='{}'", (Object)String.valueOf(string10), (Object)this.sample(string4, 60));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (string10 != null && !string10.trim().isEmpty()) {
                                    try {
                                        String string11 = string2;
                                        String string12 = string4;
                                        String string13 = string10;
                                        SwingUtilities.invokeAndWait(() -> this.insertJsonUnderSamplerWithDcai(string11, string12, string13));
                                        break block37;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        log.error("[Search Runner] EDT insertion interrupted: {}", (Object)interruptedException.getMessage());
                                        Thread.currentThread().interrupt();
                                        throw new RuntimeException("Insertion interrupted", interruptedException);
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        log.error("[Search Runner] EDT insertion failed: {}", (Object)invocationTargetException.getCause().getMessage(), (Object)invocationTargetException.getCause());
                                        throw new RuntimeException("Insertion failed", invocationTargetException.getCause());
                                    }
                                }
                                this.appendToChatArea(GeminiSidePanel.escapeHtml("JSON path could not be derived; please select manually in JSON viewer."), Color.ORANGE, true);
                            }
                            catch (Exception exception) {
                                this.appendToChatArea(GeminiSidePanel.escapeHtml("JSON Extractor auto-insert failed: " + exception.getMessage()), Color.ORANGE, true);
                            }
                        }
                    }
                    return;
                }
                this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner: DCAI header scan failed; attempting fallback by position..."), Color.ORANGE, true);
                ResponseWindow responseWindow = this.findPreviousResponseContaining(string5, this.indexOfHeaderValue(string5, String.format("DCAI-%05d", n)), string4, 30);
                if (responseWindow != null) {
                    string2 = this.extractResponseBodyTextFromHarSegment(responseWindow.segment);
                    String string14 = responseWindow.url;
                    boolean bl = GeminiSidePanel.isLikelyJson(GeminiSidePanel.extractJsonSubstring(string2 == null ? "" : string2.trim()));
                    string = this.buildMatchSnippet(string2 != null && !string2.isEmpty() ? string2 : responseWindow.segment, string4, 140);
                    this.appendAiReplyWithAvatar("\ud83e\udd16 Search Runner", "Found correlation value in previous response (no DCAI match)" + (String)(string14 != null ? "\n\nURL: " + GeminiSidePanel.escapeHtml(string14) : "") + "\n\nIs JSON: " + (bl ? "Yes" : "No"), "/com/company/dcai/images/search-runner.png");
                    if (!bl) {
                        try {
                            String string15 = this.buildMatchSnippet(string2 != null && !string2.isEmpty() ? string2 : responseWindow.segment, string4, 100);
                            GeminiSidePanel.setPendingBoundariesUrl(string14);
                            this.sendBoundariesToCarrie(string4, string15);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner: Reached start without finding the value."), Color.RED, true);
                    this.maybeEscalateCorrelationFailureToGeorge(string4, string3, file, "Search Runner: Reached start without finding the value.");
                }
            }
            catch (Exception exception) {
                this.appendToChatArea(GeminiSidePanel.escapeHtml("Search Runner error: " + exception.getMessage()), Color.RED, true);
            }
        });
    }

    private ResponseWindow findPreviousResponseContaining(String string, int n, String string2, int n2) {
        try {
            if (string == null || string2 == null || string2.isEmpty()) {
                return null;
            }
            int n3 = n > 0 ? n : string.length();
            for (int i = 0; n3 > 0 && i < Math.max(1, n2) && (n3 = string.lastIndexOf("\"response\"", Math.max(0, n3 - 1))) >= 0; ++i) {
                int n4 = string.indexOf("\"request\"", n3 + 9);
                int n5 = n4 > n3 ? n4 : Math.min(string.length(), n3 + 400000);
                String string3 = this.substringSafe(string, n3, n5);
                String string4 = this.extractResponseBodyTextFromHarSegment(string3);
                boolean bl = string4 != null && string4.indexOf(string2) >= 0 || string3.indexOf(string2) >= 0;
                if (!bl) continue;
                String string5 = this.extractNearestUrlBackward(string, n3);
                return new ResponseWindow(string3, string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void maybeEscalateCorrelationFailureToGeorge(String string, String string2, File file, String string3) {
        try {
            if (!lastCarrieCorrelationIssue) {
                try {
                    log.info("[Search Auto] Escalation skipped: lastCarrieCorrelationIssue=false");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            String string4 = lastCarrieCorrelationJson;
            if (string4 == null || string4.trim().isEmpty()) {
                try {
                    log.info("[Search Auto] Escalation skipped: no stored Carrie JSON");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (lastCarrieCorrelationEscalated) {
                try {
                    log.info("[Search Auto] Escalation skipped: already escalated for current Carrie reply");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            lastCarrieCorrelationEscalated = true;
            String string5 = this.safeString(lastCarrieCorrelationCause);
            String string6 = this.extractFirstCarrieCandidateString(string4, "name");
            String string7 = this.extractFirstCarrieCandidateString(string4, "location");
            String string8 = this.extractFirstCarrieCandidateString(string4, "json_path");
            String string9 = this.safeString(string);
            if (string9.isEmpty()) {
                string9 = this.safeString(lastCarrieCorrelationValue);
            }
            String string10 = file != null ? this.safeString(file.getAbsolutePath()) : "";
            String string11 = this.safeString(lastCarrieCorrelationSample);
            String string12 = this.buildGeorgeEscalationSummary(string3, string5, string6, string7, string8, string9, this.safeString(string2), string10, string11);
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("source", "search-runner");
            linkedHashMap.put("trigger", "correlation_value_not_found");
            linkedHashMap.put("analysis_required", "true");
            linkedHashMap.put("avoid_regex", "true");
            if (!this.safeString(string2).isEmpty()) {
                linkedHashMap.put("dcai_header", string2);
            }
            if (!this.safeString(string6).isEmpty()) {
                linkedHashMap.put("candidate_name", string6);
            }
            if (!this.safeString(string7).isEmpty()) {
                linkedHashMap.put("candidate_location", string7);
            }
            if (!string9.isEmpty()) {
                linkedHashMap.put("candidate_value", string9);
            }
            linkedHashMap.put("mode", "correlation_escalation");
            if (!string11.isEmpty()) {
                linkedHashMap.put("has_sample", "true");
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    this.appendSearchRunnerEscalationPrompt(string12);
                    this.appendAiReplyWithAvatar("\ud83e\udd16 Search Runner", "Correlation value not found \u2013 escalating to George for manual triage.", "/com/company/dcai/images/search-runner.png");
                    this.updateStatus("Escalating to George...", Color.ORANGE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            try {
                A.AA aA = A.A(string3, string5, string6, string7, string8, string9, string10, string11, this.safeString(string2), string4, linkedHashMap);
                if (aA == null || !aA.A) {
                    lastCarrieCorrelationEscalated = false;
                    StringBuilder stringBuilder = new StringBuilder("\u274c George escalation failed");
                    if (aA != null && aA.AB != null) {
                        if (!this.isEmpty(aA.AB.A)) {
                            stringBuilder.append(" [").append(aA.AB.A).append(']');
                        }
                        if (!this.isEmpty(aA.AB.AA)) {
                            stringBuilder.append(": ").append(aA.AB.AA);
                        }
                        if (!this.isEmpty(aA.AB.s)) {
                            stringBuilder.append(" (trace ").append(aA.AB.s).append(')');
                        }
                    } else if (aA != null) {
                        stringBuilder.append(": HTTP ").append(aA.ABC);
                    }
                    String string13 = stringBuilder.toString();
                    SwingUtilities.invokeLater(() -> {
                        this.appendToChatArea(GeminiSidePanel.escapeHtml(string13), Color.RED, true);
                        this.updateStatus("George escalation failed", Color.RED);
                    });
                    try {
                        log.warn("[Search Auto] George escalation failure body={}", (Object)this.sample(aA != null ? aA.ABCs : null, 512));
                    }
                    catch (Exception exception) {}
                } else {
                    boolean bl;
                    String string14 = aA.AAA != null ? aA.AAA : "";
                    LinkedHashMap linkedHashMap2 = aA.ABM != null ? aA.ABM : new LinkedHashMap();
                    SwingUtilities.invokeLater(() -> {
                        this.appendAiReply("\ud83e\udd16 George - JMeter Genius", string14);
                        String string2 = this.firstNonEmpty((String)linkedHashMap2.get("free_remaining"), (String)linkedHashMap2.get("freeRemaining"));
                        String string3 = this.firstNonEmpty((String)linkedHashMap2.get("paid_available"), (String)linkedHashMap2.get("paidAvailable"));
                        String string4 = this.firstNonEmpty((String)linkedHashMap2.get("query_type"), (String)linkedHashMap2.get("queryType"));
                        if (!(this.isEmpty(string2) && this.isEmpty(string3) && this.isEmpty(string4))) {
                            this.updateStatus("Credits: free=" + (!this.isEmpty(string2) ? string2 : "-") + ", paid=" + (!this.isEmpty(string3) ? string3 : "-") + ", type=" + (!this.isEmpty(string4) ? string4 : "-"), Color.GREEN);
                        } else {
                            this.updateStatus("Ready!", Color.GREEN);
                        }
                    });
                    boolean bl2 = bl = !this.isEmpty(this.firstNonEmpty((String)linkedHashMap2.get("query_type"), (String)linkedHashMap2.get("queryType")));
                    if (!bl) {
                        this.consumeCreditAsync("george", "[correlation_escalation] " + this.sample(string9, 80), 1);
                    }
                }
            }
            catch (Exception exception) {
                lastCarrieCorrelationEscalated = false;
                SwingUtilities.invokeLater(() -> {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("\u274c George escalation exception: " + exception.getMessage()), Color.RED, true);
                    this.updateStatus("George escalation error", Color.RED);
                });
                try {
                    log.warn("[Search Auto] George escalation exception", (Throwable)exception);
                }
                catch (Exception exception2) {}
            }
        }
        catch (Exception exception) {
            lastCarrieCorrelationEscalated = false;
            try {
                log.warn("[Search Auto] Escalation unexpected error: {}", (Object)exception.toString());
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    private void processAllUninsertedCandidates() {
        try {
            List<CarrieCandidate> list = lastCarrieCandidatesToProcess;
            if (list == null || list.isEmpty()) {
                log.info("[Candidate Processing] No uninserted candidates to process - skipping");
                return;
            }
            int n = list.size();
            log.info("[Candidate Processing] Scheduling {} uninserted candidates for processing", (Object)n);
            SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udfaf Candidate Processing", "Starting to process " + n + " correlation candidate" + (n == 1 ? "" : "s") + "...\n\nProcessing one at a time with delays to prevent UI freezing.", "/com/company/dcai/images/search-runner.png"));
            ConcurrentHashMap<Integer, String> concurrentHashMap = new ConcurrentHashMap<Integer, String>();
            if (!list.isEmpty()) {
                this.scheduleNextCandidateProcessing(list, 0, concurrentHashMap);
            }
        }
        catch (Exception exception) {
            log.error("[Candidate Processing] Error in processAllUninsertedCandidates: {}", (Object)exception.getMessage(), (Object)exception);
        }
    }

    private void scheduleNextCandidateProcessing(List<CarrieCandidate> list, int n, ConcurrentHashMap<Integer, String> concurrentHashMap) {
        if (n >= list.size()) {
            int n2;
            int n3 = list.size();
            log.info("[Candidate Processing] Completed processing all {} candidates", (Object)n3);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                String string = concurrentHashMap.getOrDefault(n2, "unknown");
                if ("success".equals(string)) {
                    ++n4;
                    continue;
                }
                if ("timeout".equals(string)) {
                    ++n6;
                    continue;
                }
                ++n5;
            }
            n2 = n4;
            int n7 = n5;
            int n8 = n6;
            SwingUtilities.invokeLater(() -> {
                StringBuilder stringBuilder = new StringBuilder();
                if (n2 == n3) {
                    stringBuilder.append("\u2713 Successfully processed all ").append(n3).append(" correlation candidate");
                    if (n3 != 1) {
                        stringBuilder.append("s");
                    }
                } else {
                    stringBuilder.append("Completed processing ").append(n3).append(" correlation candidate");
                    if (n3 != 1) {
                        stringBuilder.append("s");
                    }
                    stringBuilder.append(":\n\n");
                    stringBuilder.append("\u2713 **Succeeded:** ").append(n2).append("\n");
                    if (n7 > 0) {
                        stringBuilder.append("\u2717 **Failed:** ").append(n7).append(" (not found or error)\n");
                    }
                    if (n8 > 0) {
                        stringBuilder.append("\u23f1 **Timed out:** ").append(n8).append("\n");
                    }
                }
                this.appendAiReplyWithAvatar("\ud83c\udfaf Candidate Processing", stringBuilder.toString(), "/com/company/dcai/images/search-runner.png");
            });
            return;
        }
        CarrieCandidate carrieCandidate = list.get(n);
        int n9 = n + 1;
        int n10 = list.size();
        log.info("[Candidate Processing] Scheduling candidate {}/{}: name={} location={}", (Object)n9, (Object)n10, (Object)carrieCandidate.name, (Object)carrieCandidate.location);
        SwingUtilities.invokeLater(() -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("**Processing candidate ").append(n9).append(" of ").append(n10).append("**\n\n");
            stringBuilder.append("**Candidate:** ").append(carrieCandidate.name).append("\n");
            stringBuilder.append("**Location:** ").append(carrieCandidate.location).append("\n\n");
            stringBuilder.append("Searching HAR files for correlation value...");
            this.appendAiReplyWithAvatar("\ud83d\udd0d Candidate " + n9 + "/" + n10, stringBuilder.toString(), "/com/company/dcai/images/search-runner.png");
        });
        Future<Boolean> future = this.executorService.submit(() -> {
            try {
                log.info("[Candidate Processing] ===== STARTING CANDIDATE {}/{} =====", (Object)n9, (Object)n10);
                log.info("[Candidate Processing] Thread: {}, Name: {}, Location: {}", (Object)Thread.currentThread().getName(), (Object)carrieCandidate.name, (Object)carrieCandidate.location);
                boolean bl = this.triggerServerSideHarSearchForCandidate(carrieCandidate, n9, n10);
                log.info("[Candidate Processing] ===== COMPLETED CANDIDATE {}/{} (success={}) =====", (Object)n9, (Object)n10, (Object)bl);
                return bl;
            }
            catch (Exception exception) {
                log.error("[Candidate Processing] ===== EXCEPTION IN CANDIDATE {}/{} =====", (Object)n9, (Object)n10, (Object)exception);
                SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udfaf Candidate Processing", "\u26a0 Error processing candidate " + n9 + "/" + n10 + ": " + exception.getMessage() + "\n\nContinuing with next candidate...", "/com/company/dcai/images/search-runner.png"));
                return false;
            }
        });
        this.watchdogExecutor.submit(() -> {
            String string = "failed";
            try {
                log.info("[Candidate Processing] Watchdog waiting for candidate {}/{} (30s timeout)", (Object)n9, (Object)n10);
                Boolean bl = (Boolean)future.get(30L, TimeUnit.SECONDS);
                log.info("[Candidate Processing] Watchdog: candidate {}/{} completed with success={}", (Object)n9, (Object)n10, (Object)bl);
                string = bl != null && bl != false ? "success" : "failed";
            }
            catch (TimeoutException timeoutException) {
                log.error("[Candidate Processing] ===== TIMEOUT ON CANDIDATE {}/{} =====", (Object)n9, (Object)n10);
                future.cancel(true);
                string = "timeout";
                SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udfaf Candidate Processing", "\u26a0 Candidate " + n9 + "/" + n10 + " timed out after 30 seconds.\n\nSkipping to next candidate...", "/com/company/dcai/images/search-runner.png"));
            }
            catch (Exception exception) {
                log.error("[Candidate Processing] Watchdog error for candidate {}/{}: {}", (Object)n9, (Object)n10, (Object)exception.getMessage());
                string = "failed";
            }
            finally {
                concurrentHashMap.put(n, string);
                log.info("[Candidate Processing] Recorded result for candidate {}/{}: {}", (Object)n9, (Object)n10, (Object)string);
                String string2 = string;
                SwingUtilities.invokeLater(() -> {
                    String string2;
                    String string3 = "success".equals(string2) ? "\u2705" : (string2 = "timeout".equals(string2) ? "\u23f1" : "\u274c");
                    String string4 = "success".equals(string2) ? "completed successfully" : ("timeout".equals(string2) ? "timed out" : "failed");
                    this.appendAiReplyWithAvatar(string2 + " Candidate " + n9 + "/" + n10, "Candidate **" + carrieCandidate.name + "** " + string4 + ".", "/com/company/dcai/images/search-runner.png");
                });
                try {
                    log.info("[Candidate Processing] Watchdog: waiting 5 seconds before scheduling next...");
                    Thread.sleep(5000L);
                    log.info("[Candidate Processing] Watchdog: scheduling candidate {}/{}", (Object)(n9 + 1), (Object)n10);
                    this.scheduleNextCandidateProcessing(list, n + 1, concurrentHashMap);
                }
                catch (InterruptedException interruptedException) {
                    log.warn("[Candidate Processing] Watchdog interrupted while scheduling next");
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean triggerServerSideHarSearchForCandidate(CarrieCandidate carrieCandidate, int n, int n2) {
        try {
            boolean bl;
            String string;
            double d;
            String string2;
            String string3;
            currentCandidateBeingProcessed = carrieCandidate;
            String string4 = this.normalizeCarrieCandidateValue(carrieCandidate.value);
            log.info("[Server Search] Starting server-side HAR search for candidate {}/{}: name={} location={} uniqueness={}", (Object)n, (Object)n2, (Object)carrieCandidate.name, (Object)carrieCandidate.location, (Object)carrieCandidate.valueUniquenessProb);
            if (string4 == null || string4.isEmpty()) {
                log.info("[Server Search] No correlation value to search for candidate {}/{}", (Object)n, (Object)n2);
                SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "Skipped candidate " + n + "/" + n2 + ": No correlation value available", "/com/company/dcai/images/search-runner.png"));
                boolean bl2 = false;
                return bl2;
            }
            String string5 = this.loadJMeterVariable("LOADMAGIC_USER_ID");
            String string6 = this.loadJMeterVariable("LOADMAGIC_PROJECT_ID");
            String string7 = this.loadJMeterVariable("LOADMAGIC_HAR");
            String string8 = lastErrorDcaiHeader;
            if (string5 == null || string5.isEmpty()) {
                string3 = "test-user";
                log.warn("[Server Search] LOADMAGIC_USER_ID not found, using fallback: {}", (Object)string3);
            } else {
                string3 = string5;
            }
            if (string6 == null || string6.isEmpty()) {
                string2 = "default";
                log.warn("[Server Search] LOADMAGIC_PROJECT_ID not found, using fallback: {}", (Object)string2);
            } else {
                string2 = string6;
            }
            log.info("[Server Search] Searching for value: {} (userId: {}, projectId: {}, harFilename: {}, dcaiHeader: {}, candidate: {}/{})", (Object)this.sample(string4, 80), (Object)string3, (Object)string2, (Object)string7, (Object)string8, (Object)n, (Object)n2);
            if (carrieCandidate != null) {
                d = carrieCandidate.valueUniquenessProb;
                if (carrieCandidate.leftBoundary != null && !carrieCandidate.leftBoundary.trim().isEmpty()) {
                    string = carrieCandidate.leftBoundary;
                    bl = d < 0.7;
                } else {
                    string = null;
                    bl = false;
                }
            } else {
                d = 1.0;
                string = null;
                bl = false;
            }
            SwingUtilities.invokeLater(() -> {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("**Candidate ").append(n).append("/").append(n2).append("**\n\n");
                stringBuilder.append("Starting server-side search for: **").append(this.sanitizeForInline(carrieCandidate.name)).append("**\n\n");
                stringBuilder.append("Location: `").append(this.sanitizeForInline(carrieCandidate.location)).append("`\n\n");
                stringBuilder.append("Value:\n```\n");
                stringBuilder.append(string4).append("\n```\n\n");
                stringBuilder.append("User: ").append(string3).append(", Project: ").append(string2);
                if (string7 != null && !string7.isEmpty()) {
                    stringBuilder.append(", HAR File: ").append(string7);
                }
                if (string8 != null && !string8.isEmpty()) {
                    stringBuilder.append(", DCAI Header: ").append(this.sanitizeForInline(string8));
                }
                if (bl && string != null) {
                    stringBuilder.append("\n\nMode: **BOUNDARY-AWARE** (uniqueness ").append(String.format(Locale.ROOT, "%.2f", d)).append(" < ").append(0.7).append(")\n");
                    stringBuilder.append("Left boundary: `").append(this.sanitizeForInline(string)).append("`");
                }
                this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", stringBuilder.toString(), "/com/company/dcai/images/search-runner.png");
            });
            ABMs.AA aA = null;
            try {
                log.info("[Server Search] Calling HAR search API for candidate {}/{}...", (Object)n, (Object)n2);
                if (bl && string != null) {
                    log.info("[Server Search] Using boundary-aware HAR search (threshold {}, boundary '{}')", (Object)0.7, (Object)this.sample(string, 120));
                    aA = ABMs.A(string3, string2, string7, string8, string4, string, 100, 0.8, false);
                } else {
                    aA = ABMs.A(string3, string2, string7, string8, string4, false);
                }
                log.info("[Server Search] HAR search API returned for candidate {}/{}", (Object)n, (Object)n2);
            }
            catch (Exception exception) {
                log.error("[Server Search] Exception during HAR search for candidate {}/{}: {}", (Object)n, (Object)n2, (Object)exception.getMessage(), (Object)exception);
                SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "**Candidate " + n + "/" + n2 + "** - Search failed with exception:\n\n" + this.formatServerSearchErrorBlock(exception.getMessage()), "/com/company/dcai/images/search-runner.png"));
                boolean bl3 = false;
                currentCandidateBeingProcessed = null;
                return bl3;
            }
            if (aA == null) {
                log.error("[Server Search] Search result is null for candidate {}/{}", (Object)n, (Object)n2);
                boolean bl4 = false;
                return bl4;
            }
            log.info("[Server Search] Result for candidate {}/{}: success={}, matchCount={}, httpStatus={}", (Object)n, (Object)n2, (Object)aA.A(), (Object)aA.AB(), (Object)aA.AAA());
            if (aA.A()) {
                int n3 = aA.AB();
                String string9 = aA.s();
                SwingUtilities.invokeLater(() -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("**Candidate ").append(n).append("/").append(n2).append("** - Search completed!\n\n");
                    stringBuilder.append("**Matches found:** ").append(n3).append("\n\n");
                    if (n3 > 0) {
                        stringBuilder.append("**Response details:**\n");
                        stringBuilder.append(this.formatServerSearchJsonBlock(string9));
                    } else {
                        stringBuilder.append("No matches found in server-side HAR files.");
                    }
                    this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", stringBuilder.toString(), "/com/company/dcai/images/search-runner.png");
                });
                log.info("[Server Search] Successfully completed candidate {}/{} with {} matches", (Object)n, (Object)n2, (Object)n3);
                if (n3 > 0 && string9 != null) {
                    try {
                        log.info("[Server Search] Starting insertion for candidate {}/{}...", (Object)n, (Object)n2);
                        this.processServerSearchMatch(string9, string4);
                        log.info("[Server Search] Completed insertion for candidate {}/{}", (Object)n, (Object)n2);
                        boolean bl5 = true;
                        return bl5;
                    }
                    catch (Exception exception) {
                        log.error("[Server Search] Failed to process match for candidate {}/{}: {}", (Object)n, (Object)n2, (Object)exception.getMessage(), (Object)exception);
                        SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "**Candidate " + n + "/" + n2 + "** - Insertion failed:\n\n" + this.formatServerSearchErrorBlock(exception.getMessage()), "/com/company/dcai/images/search-runner.png"));
                        boolean bl6 = false;
                        currentCandidateBeingProcessed = null;
                        return bl6;
                    }
                }
                log.info("[Server Search] No match to insert for candidate {}/{}", (Object)n, (Object)n2);
                boolean bl7 = false;
                return bl7;
            }
            String string10 = aA.AA();
            int n4 = aA.AAA();
            SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "**Candidate " + n + "/" + n2 + "** - Search failed (HTTP " + n4 + "):\n\n" + this.formatServerSearchErrorBlock(string10 != null ? string10 : "Unknown error"), "/com/company/dcai/images/search-runner.png"));
            log.error("[Server Search] Candidate {}/{} failed with HTTP {}: {}", (Object)n, (Object)n2, (Object)n4, (Object)string10);
            boolean bl8 = false;
            return bl8;
            {
                catch (Exception exception) {
                    log.error("[Server Search] Exception during server-side HAR search for candidate {}/{}: {}", (Object)n, (Object)n2, (Object)exception.getMessage(), (Object)exception);
                    SwingUtilities.invokeLater(() -> this.appendToChatArea(GeminiSidePanel.escapeHtml("\ud83c\udf10 Server Search error for candidate " + n + "/" + n2 + ": " + exception.getMessage()), Color.RED, true));
                    boolean bl9 = false;
                    return bl9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            currentCandidateBeingProcessed = null;
        }
    }

    private String formatServerSearchJsonBlock(String string) {
        if (string == null) {
            return "```json\nnull\n```";
        }
        String string2 = GeminiSidePanel.htmlUnescape(string).trim();
        if (string2.isEmpty()) {
            return "```json\n\n```";
        }
        String string3 = GeminiSidePanel.isLikelyJson(string2) ? GeminiSidePanel.extractJsonSubstring(string2) : string2;
        Object object = GeminiSidePanel.prettyPrintJson(string3);
        if (((String)object).length() > 12000) {
            object = ((String)object).substring(0, 12000) + "\n...(truncated)...";
        }
        return "```json\n" + (String)object + "\n```";
    }

    private String formatServerSearchErrorBlock(String string) {
        Object object = string == null ? "" : string;
        if (((String)(object = GeminiSidePanel.htmlUnescape((String)object).trim())).isEmpty()) {
            return "```\n(no error details)\n```";
        }
        if (GeminiSidePanel.isLikelyJson((String)object)) {
            String string2 = GeminiSidePanel.extractJsonSubstring((String)object);
            Object object2 = GeminiSidePanel.prettyPrintJson(string2);
            if (((String)object2).length() > 12000) {
                object2 = ((String)object2).substring(0, 12000) + "\n...(truncated)...";
            }
            return "```json\n" + (String)object2 + "\n```";
        }
        if (((String)object).length() > 4000) {
            object = ((String)object).substring(0, 4000) + "\n...(truncated)...";
        }
        return "```\n" + (String)object + "\n```";
    }

    private void processServerSearchMatch(String string, String string2) {
        block15: {
            try {
                log.info("[Server Search] Processing match for insertion");
                int n = string.indexOf("\"matches\":");
                if (n == -1) {
                    log.warn("[Server Search] No matches array found in response");
                    return;
                }
                int n2 = string.indexOf(91, n);
                if (n2 == -1) {
                    log.warn("[Server Search] Matches array opening bracket not found");
                    return;
                }
                int n3 = string.indexOf(123, n2);
                if (n3 == -1) {
                    log.warn("[Server Search] No match object found in matches array");
                    return;
                }
                int n4 = this.findMatchingBracket(string, n3);
                if (n4 == -1) {
                    log.warn("[Server Search] Could not find end of match object");
                    return;
                }
                String string3 = string.substring(n3, n4 + 1);
                log.info("[Server Search] First match JSON: {}", (Object)this.sample(string3, 200));
                String string4 = this.extractJsonStringViaRegex(string3, "dcai");
                String string5 = this.extractJsonStringViaRegex(string3, "snippet");
                String string6 = this.extractJsonStringViaRegex(string3, "url");
                Boolean bl = this.extractJsonBooleanField(string3, "is_json");
                boolean bl2 = Boolean.TRUE.equals(bl);
                log.info("[Server Search] Match details: dcai={}, isJson={}, url={}, snippetLen={}", (Object)string4, (Object)bl2, (Object)string6, (Object)(string5 != null ? string5.length() : -1));
                if (string4 == null || string4.isEmpty()) {
                    log.warn("[Server Search] No DCAI header found in match");
                    return;
                }
                if (string6 != null && !string6.isEmpty()) {
                    GeminiSidePanel.setPendingBoundariesUrl(string6);
                }
                if (bl2 && string5 != null) {
                    log.info("[Server Search] Processing JSON response, deriving JSONPath");
                    SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "Found correlation value in JSON response at DCAI=" + string4 + "\n\nDeriving JSONPath for automatic extraction...", "/com/company/dcai/images/search-runner.png"));
                    String string7 = this.deriveJsonPathFromResponse(string5, string2);
                    log.info("[Server Search] Derived JSONPath='{}' for value='{}'", (Object)String.valueOf(string7), (Object)this.sample(string2, 60));
                    if (string7 != null && !string7.trim().isEmpty()) {
                        try {
                            String string8 = string4;
                            String string9 = string2;
                            String string10 = string7;
                            SwingUtilities.invokeAndWait(() -> this.insertJsonUnderSamplerWithDcai(string8, string9, string10));
                            SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "JSON Extractor inserted at DCAI=" + string4 + "\n\nJSONPath: `" + string7 + "`", "/com/company/dcai/images/search-runner.png"));
                            break block15;
                        }
                        catch (InterruptedException interruptedException) {
                            log.error("[Server Search] EDT insertion interrupted: {}", (Object)interruptedException.getMessage());
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Insertion interrupted", interruptedException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            log.error("[Server Search] EDT insertion failed: {}", (Object)invocationTargetException.getCause().getMessage(), (Object)invocationTargetException.getCause());
                            throw new RuntimeException("Insertion failed", invocationTargetException.getCause());
                        }
                    }
                    SwingUtilities.invokeLater(() -> this.appendToChatArea(GeminiSidePanel.escapeHtml("\ud83c\udf10 Server Search: JSONPath could not be derived automatically"), Color.ORANGE, true));
                    break block15;
                }
                if (string5 != null) {
                    log.info("[Server Search] Processing non-JSON response, sending to Rupert for boundaries");
                    SwingUtilities.invokeLater(() -> this.appendAiReplyWithAvatar("\ud83c\udf10 Server Search", "Found correlation value in non-JSON response at DCAI=" + string4 + "\n\nSending to Rupert for regex boundary detection...", "/com/company/dcai/images/search-runner.png"));
                    GeminiSidePanel.setPendingBoundariesDcaiId(string4);
                    String string11 = this.buildMatchSnippet(string5, string2, 100);
                    this.sendBoundariesToCarrie(string2, string11);
                } else {
                    log.warn("[Server Search] No snippet found in match");
                }
            }
            catch (Exception exception) {
                log.error("[Server Search] Exception in processServerSearchMatch: {}", (Object)exception.getMessage(), (Object)exception);
                SwingUtilities.invokeLater(() -> this.appendToChatArea(GeminiSidePanel.escapeHtml("\ud83c\udf10 Server Search error processing match: " + exception.getMessage()), Color.RED, true));
            }
        }
    }

    private int findMatchingBracket(String string, int n) {
        if (n >= string.length()) {
            return -1;
        }
        char c = string.charAt(n);
        char c2 = c == '{' ? (char)'}' : ']';
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n + 1; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (bl) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (c3 == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c3 != '\"') continue;
                bl = false;
                continue;
            }
            if (c3 == '\"') {
                bl = true;
                continue;
            }
            if (c3 == c) {
                ++n2;
                continue;
            }
            if (c3 != c2 || --n2 != 0) continue;
            return i;
        }
        return -1;
    }

    private int indexOfHeaderValue(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        int n = string.indexOf("\"value\":\"" + string2 + "\"");
        if (n >= 0) {
            return n;
        }
        try {
            Matcher matcher = Pattern.compile("\\\"value\\\"\\s*:\\s*\\\"" + Pattern.quote(string2) + "\\\"").matcher(string);
            if (matcher.find()) {
                return matcher.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string.indexOf(string2);
    }

    private ResponseWindow extractResponseWindowForRequest(String string, int n) {
        try {
            int n2;
            int n3 = this.lastIndexOfSafe(string, "\"request\"", n, 200000);
            if (n3 < 0) {
                n3 = Math.max(0, n - 50000);
            }
            if ((n2 = string.indexOf("\"response\"", n3)) < 0) {
                return new ResponseWindow(this.substringSafe(string, n, Math.min(string.length(), n + 400000)), this.extractNearestUrlBackward(string, n));
            }
            int n4 = string.indexOf("\"request\"", n2 + 9);
            int n5 = n4 > n2 ? n4 : Math.min(string.length(), n2 + 400000);
            String string2 = this.substringSafe(string, n2, n5);
            String string3 = this.extractNearestUrlBackward(string, n2);
            return new ResponseWindow(string2, string3);
        }
        catch (Exception exception) {
            return new ResponseWindow(this.substringSafe(string, n, Math.min(string.length(), n + 300000)), this.extractNearestUrlBackward(string, n));
        }
    }

    private String extractResponseBodyTextFromHarSegment(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        try {
            char c;
            int n = string.indexOf("\"content\"");
            int n2 = n >= 0 ? n : 0;
            int n3 = string.indexOf("\"text\"", n2);
            if (n3 < 0) {
                return "";
            }
            int n4 = string.indexOf(58, n3);
            if (n4 < 0) {
                return "";
            }
            int n5 = string.indexOf(34, n4 + 1);
            if (n5 < 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = n5 + 1; i < string.length(); ++i) {
                c = string.charAt(i);
                if (bl) {
                    switch (c) {
                        case 'n': {
                            stringBuilder.append('\n');
                            break;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        case '\"': {
                            stringBuilder.append('\"');
                            break;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            break;
                        }
                        case 'u': {
                            if (i + 4 < string.length()) {
                                String string2 = string.substring(i + 1, i + 5);
                                try {
                                    stringBuilder.append((char)Integer.parseInt(string2, 16));
                                    i += 4;
                                }
                                catch (Exception exception) {
                                    stringBuilder.append('u').append(string2);
                                    i += 4;
                                }
                                break;
                            }
                            stringBuilder.append('u');
                            break;
                        }
                        default: {
                            stringBuilder.append(c);
                        }
                    }
                    bl = false;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (c == '\"') break;
                stringBuilder.append(c);
            }
            String string3 = stringBuilder.toString();
            c = '\u0000';
            try {
                int n6 = string.indexOf(123, n >= 0 ? n : n2);
                int n7 = -1;
                if (n6 >= 0) {
                    int n8 = 0;
                    for (int i = n6; i < string.length(); ++i) {
                        char c2 = string.charAt(i);
                        if (c2 == '{') {
                            ++n8;
                            continue;
                        }
                        if (c2 != '}' || --n8 != 0) continue;
                        n7 = i + 1;
                        break;
                    }
                }
                String string4 = n6 >= 0 && n7 > n6 ? string.substring(n6, n7) : string;
                c = string4.contains("\"encoding\":\"base64\"") || Pattern.compile("\\\"encoding\\\"\\s*:\\s*\\\"base64\\\"").matcher(string4).find() ? (char)'\u0001' : '\u0000';
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c != '\u0000') {
                try {
                    byte[] byArray = Base64.getDecoder().decode(string3);
                    string3 = new String(byArray, StandardCharsets.UTF_8);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string3;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static boolean isLikelyJson(String string) {
        int n;
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n >= n2) {
            return false;
        }
        char c = string.charAt(n);
        return c == '{' || c == '[';
    }

    private static String extractJsonSubstring(String string) {
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < n2 && (string.charAt(n) == '{' || string.charAt(n) == '[')) {
            return string;
        }
        return "";
    }

    private String deriveJsonPathFromResponse(String string, String string2) {
        try {
            Object object;
            if (string == null || string2 == null) {
                log.warn("[JSONPath Derivation] Null input: json={}, value={}", (Object)(string == null ? "null" : "present"), (Object)(string2 == null ? "null" : "present"));
                return null;
            }
            String string3 = string.trim();
            if (string3.isEmpty()) {
                log.warn("[JSONPath Derivation] Empty JSON string after trim");
                return null;
            }
            log.info("[JSONPath Derivation] Input: value='{}', snippet length={}, snippet preview='{}'", (Object)this.sample(string2, 60), (Object)string3.length(), (Object)this.sample(string3, 150));
            int n = -1;
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (c != '{' && c != '[') continue;
                n = i;
                break;
            }
            if (n > 0) {
                string3 = string3.substring(n);
            }
            try {
                Pattern pattern = Pattern.compile("\\\"([^\\\"]+)\\\"\\s*:\\s*\\\"" + Pattern.quote(string2) + "\\\"");
                Matcher matcher = pattern.matcher(string3);
                if (matcher.find() && (object = matcher.group(1)) != null && !((String)object).isEmpty()) {
                    log.info("[JSONPath Derivation] Found exact match: key='{}' for value='{}'", object, (Object)this.sample(string2, 60));
                    return "$." + (String)object;
                }
                log.info("[JSONPath Derivation] No exact match found for value='{}', trying fallback", (Object)this.sample(string2, 60));
            }
            catch (Exception exception) {
                log.warn("[JSONPath Derivation] Exact match regex failed: {}", (Object)exception.getMessage());
            }
            int n2 = string3.indexOf(string2);
            if (n2 >= 0) {
                Pattern pattern = Pattern.compile("\\\"([^\\\"]+)\\\"\\s*:");
                object = pattern.matcher(string3);
                String string4 = null;
                int n3 = -1;
                while (((Matcher)object).find() && ((Matcher)object).end() <= n2) {
                    string4 = ((Matcher)object).group(1);
                    n3 = ((Matcher)object).end();
                }
                if (string4 != null && !string4.isEmpty()) {
                    return "$." + string4;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void insertJsonUnderSamplerWithDcai(String string, String string2, String string3) {
        block52: {
            try {
                Object object;
                String string4;
                Object object2;
                JMeterTreeNode jMeterTreeNode;
                if (string == null || string.isEmpty() || string3 == null || string3.trim().isEmpty()) {
                    return;
                }
                GuiPackage guiPackage = GuiPackage.getInstance();
                if (guiPackage == null) {
                    return;
                }
                JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
                if (jMeterTreeModel == null) {
                    return;
                }
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeModel.getRoot();
                JMeterTreeNode jMeterTreeNode3 = this.findSamplerByDcaiHeader(jMeterTreeNode2, string);
                if (jMeterTreeNode3 == null) {
                    jMeterTreeNode3 = this.findSamplerByHttpHeaderManager(jMeterTreeNode2, string);
                }
                if (jMeterTreeNode3 == null) {
                    jMeterTreeNode3 = this.findSamplerByUrlHeuristic(jMeterTreeNode2, pendingBoundariesUrl);
                }
                if (jMeterTreeNode3 == null) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("JSON: Could not locate sampler with DCAI=" + string), Color.ORANGE, true);
                    return;
                }
                boolean bl = lastCarrieValueHadNotFoundPrefix || string2 != null && string2.startsWith("NOT_FOUND_");
                String string5 = bl ? this.normalizeCarrieCandidateValue(string2) : string2;
                String string6 = this.suggestJsonVarName(string3, string5);
                String string7 = bl ? this.findExistingVarForNotFoundDefault(jMeterTreeNode3, string5) : null;
                try {
                    log.info("[Replace] JSON hasNotFoundPrefix={} normalized='{}' existingVar='{}'", (Object)bl, (Object)this.sample(string5, 120), (Object)string7);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JSONPostProcessor jSONPostProcessor = new JSONPostProcessor();
                jSONPostProcessor.setName(string6);
                jSONPostProcessor.setProperty("TestElement.test_class", JSONPostProcessor.class.getName());
                jSONPostProcessor.setProperty("TestElement.gui_class", JSONPostProcessorGui.class.getName());
                jSONPostProcessor.setRefNames(string6);
                jSONPostProcessor.setJsonPathExpressions(string3);
                jSONPostProcessor.setMatchNumbers("1");
                jSONPostProcessor.setDefaultValues("NOT_FOUND_" + (string5 != null ? string5 : ""));
                jSONPostProcessor.setComputeConcatenation(false);
                try {
                    jSONPostProcessor.setProperty("TestPlan.comments", "Original value = " + String.valueOf(string5));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jMeterTreeModel.addComponent((TestElement)jSONPostProcessor, jMeterTreeNode3);
                JMeterTreeNode jMeterTreeNode4 = null;
                try {
                    for (int i = jMeterTreeNode3.getChildCount() - 1; i >= 0; --i) {
                        jMeterTreeNode = (JMeterTreeNode)jMeterTreeNode3.getChildAt(i);
                        object2 = jMeterTreeNode.getUserObject();
                        if (!(object2 instanceof TestElement) || (string4 = ((TestElement)object2).getClass().getName()) == null || !string4.endsWith("JSONPostProcessor")) continue;
                        jMeterTreeNode4 = jMeterTreeNode;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TreePath treePath = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode3));
                jMeterTreeNode = jMeterTreeNode4;
                object2 = jMeterTreeNode != null ? new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode)) : null;
                SwingUtilities.invokeLater(() -> GeminiSidePanel.lambda$insertJsonUnderSamplerWithDcai$57(guiPackage, treePath, (TreePath)object2));
                this.appendToChatArea(GeminiSidePanel.escapeHtml("Inserted JSON Extractor under sampler with DCAI=" + string + " variable=" + string6 + " path=" + string3), Color.GREEN, true);
                try {
                    boolean bl2;
                    String string8;
                    Object object3;
                    Object object4;
                    string4 = null;
                    String string9 = null;
                    String string10 = null;
                    String string11 = lastCarrieCorrelationJson;
                    if (string11 != null && string5 != null) {
                        try {
                            object = this.extractAllCarrieCandidates(string11);
                            object4 = object.iterator();
                            while (object4.hasNext()) {
                                object3 = (CarrieCandidate)object4.next();
                                string8 = this.normalizeCarrieCandidateValue(((CarrieCandidate)object3).value);
                                if (string8 == null || !string8.equals(string5) && !string5.contains(string8)) continue;
                                string4 = ((CarrieCandidate)object3).name;
                                string9 = ((CarrieCandidate)object3).location;
                                string10 = ((CarrieCandidate)object3).jsonPath;
                                log.info("[Insertion Tracking] Matched insertion value to candidate: name='{}' location='{}'", (Object)string4, (Object)string9);
                                break;
                            }
                        }
                        catch (Exception exception) {
                            log.warn("[Insertion Tracking] Failed to match insertion to candidate", (Throwable)exception);
                        }
                    }
                    object = null;
                    if (string4 != null) {
                        object = DCAIResultsVisualizer.getAttemptIdForCandidate(string4);
                        log.info("[Insertion Tracking] Map lookup for candidate '{}': attemptId={}", (Object)string4, object);
                        if (object == null && (object4 = DCAIResultsVisualizer.getLastCorrelationSessionId()) != null && string9 != null) {
                            log.info("[Insertion Tracking] Map lookup failed, trying server API for candidate '{}'", (Object)string4);
                            object = this.lookupAttemptIdFromServer((Long)object4, string4, string9, string10);
                            if (object != null) {
                                log.info("[Insertion Tracking] Server lookup succeeded: attemptId={}", object);
                            }
                        }
                    }
                    boolean bl3 = bl2 = string4 != null && object != null;
                    if (object == null) {
                        object = DCAIResultsVisualizer.getLastCorrelationAttemptId();
                        log.info("[Insertion Tracking] Using fallback last attemptId: {}", object);
                    }
                    object3 = DCAIResultsVisualizer.getLastCorrelationDcaiHeader();
                    string8 = DCAIResultsVisualizer.getLastCorrelationCandidateValue();
                    Long l = DCAIResultsVisualizer.getLastCorrelationTimestamp();
                    boolean bl4 = bl2;
                    if (!bl4 && object != null) {
                        boolean bl5 = object3 != null && ((String)object3).equals(string);
                        boolean bl6 = false;
                        if (string8 != null && string5 != null && l != null) {
                            long l2 = System.currentTimeMillis() - l;
                            bl6 = l2 < 30000L && string5.contains(string8);
                        }
                        bl4 = bl5 || bl6;
                        log.info("[Insertion Tracking DEBUG] Fallback matching - dcaiId={}, correlationDcai={}, dcaiMatch={}, valueMatch={}", (Object)string, object3, (Object)bl5, (Object)bl6);
                    }
                    log.info("[Insertion Tracking DEBUG] JSON extractor inserted - dcaiId={}, attemptId={}, candidateName={}, foundViaCandidate={}, shouldTrack={}, normalizedValue={}", (Object)string, object, (Object)string4, (Object)bl2, (Object)bl4, (Object)(string5 != null ? string5.substring(0, Math.min(30, string5.length())) : "null"));
                    if (bl4) {
                        String string12 = bl2 ? "candidate match" : "fallback match";
                        log.info("[Insertion Tracking] Correlation insertion detected ({}) - tracking for attempt {}", (Object)string12, object);
                        String string13 = "{\"path\":\"" + string3.replace("\"", "\\\"") + "\",\"matchNumber\":\"1\"}";
                        String string14 = "NOT_FOUND_" + (string5 != null ? string5 : "");
                        String string15 = this.loadJMeterVariable("LOADMAGIC_HAR");
                        log.info("[Insertion Tracking DEBUG] Calling trackCorrelationInsertion with payload: {}, harFilename: {}", (Object)string13, (Object)string15);
                        DCAIResultsVisualizer.trackCorrelationInsertion((Long)object, string, "json", string13, string6, string14, string15);
                    } else {
                        log.info("[Insertion Tracking DEBUG] NOT tracking - conditions not met");
                    }
                }
                catch (Exception exception) {
                    log.warn("[Insertion Tracking] Failed to track correlation insertion", (Throwable)exception);
                }
                try {
                    if (jMeterTreeNode4 != null) {
                        int n;
                        string4 = string7 != null && !string7.isEmpty() ? "${" + string7 + "}" : string5;
                        try {
                            log.info("[Replace] JSON findToken='{}' replacement='${}'", (Object)this.sample(string4, 160), (Object)this.sample(string6, 160));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean bl7 = false;
                        double d = 1.0;
                        object = null;
                        if (currentCandidateBeingProcessed != null) {
                            d = GeminiSidePanel.currentCandidateBeingProcessed.valueUniquenessProb;
                            object = GeminiSidePanel.currentCandidateBeingProcessed.leftBoundary;
                            if ((object == null || ((String)object).trim().isEmpty()) && GeminiSidePanel.currentCandidateBeingProcessed.name != null && !GeminiSidePanel.currentCandidateBeingProcessed.name.trim().isEmpty()) {
                                object = GeminiSidePanel.currentCandidateBeingProcessed.name;
                                try {
                                    log.info("[Replace] JSON field name '{}' used as boundary (Carrie provided none)", object);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            bl7 = d < 0.7 && object != null && !((String)object).trim().isEmpty();
                        }
                        try {
                            log.info("[Replace] value_uniqueness_probability={}, useBoundaryAware={}, leftBoundary='{}'", (Object)d, (Object)bl7, object != null ? object : "null");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (bl7) {
                            try {
                                log.info("[Replace] Using BOUNDARY-AWARE replacement (low uniqueness)");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            n = this.replaceLiteralValueAfterNodeWithBoundary(jMeterTreeNode2, jMeterTreeNode4, string4, "${" + string6 + "}", (String)object, 0.7);
                        } else {
                            try {
                                log.info("[Replace] Using STANDARD replacement (high uniqueness)");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            n = this.replaceLiteralValueAfterNode(jMeterTreeNode2, jMeterTreeNode4, string4, "${" + string6 + "}");
                        }
                        if (n == 0) {
                            log.warn("[Replace] WARNING: JSON extractor inserted but no literal values were replaced. Value '{}' may not exist in test plan after insertion point.", (Object)this.sample(string4, 60));
                            SwingUtilities.invokeLater(() -> this.appendToChatArea("\u26a0 Warning: Inserted extractor for variable '" + string6 + "' but found no occurrences of the literal value in the test plan after this point. The correlation may not work correctly.", Color.ORANGE, true));
                        } else {
                            int n2 = n;
                            boolean bl8 = bl7;
                            log.info("[Replace] JSON replacement successful: {} occurrence(s) replaced", (Object)n);
                            SwingUtilities.invokeLater(() -> {
                                String string3 = bl8 ? "(boundary-aware)" : "";
                                this.appendToChatArea(String.format("\u2713 Replaced %d occurrence(s) of '%s' with ${%s} %s", n2, this.sample(string4, 40), string6, string3), Color.decode("#2E7D32"), false);
                            });
                        }
                        try {
                            guiPackage.getMainFrame().repaint();
                        }
                        catch (Exception exception) {}
                        break block52;
                    }
                    log.error("[Replace] ERROR: insertedNode is null - cannot perform replacement!");
                    SwingUtilities.invokeLater(() -> this.appendToChatArea("\u274c Error: Failed to identify inserted extractor node. Replacement step skipped.", Color.RED, true));
                }
                catch (Exception exception) {
                    log.error("[Replace] Exception during replacement: {}", (Object)exception.getMessage(), (Object)exception);
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Replace-after-insert failed: " + exception.getMessage()), Color.ORANGE, true);
                }
            }
            catch (Exception exception) {
                this.appendToChatArea(GeminiSidePanel.escapeHtml("JSON auto-insert failed: " + exception.getMessage()), Color.RED, true);
            }
        }
    }

    private int lastIndexOfSafe(String string, String string2, int n, int n2) {
        try {
            int n3 = Math.max(0, n - Math.max(0, n2));
            return string.lastIndexOf(string2, n);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String substringSafe(String string, int n, int n2) {
        int n3 = string == null ? 0 : string.length();
        int n4 = Math.max(0, Math.min(n, n3));
        int n5 = Math.max(0, Math.min(n2, n3));
        if (n5 < n4) {
            int n6 = n4;
            n4 = n5;
            n5 = n6;
        }
        try {
            return string.substring(n4, n5);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String buildMatchSnippet(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return "";
        }
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string.substring(0, Math.min(string.length(), Math.max(120, string2.length() + 40)));
        }
        int n3 = Math.max(0, n2 - Math.max(0, n));
        int n4 = Math.min(string.length(), n2 + string2.length() + Math.max(0, n));
        return string.substring(n3, n4);
    }

    private String getLastAiCarrieJson() {
        try {
            String string = this.lastAiMarkdown;
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            String string2 = this.extractFirstFencedCode(string);
            String string3 = string2 != null && string2.trim().startsWith("{") ? string2.trim() : string.trim();
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<CarrieCandidate> extractAllCarrieCandidates(String string) {
        ArrayList<CarrieCandidate> arrayList = new ArrayList<CarrieCandidate>();
        if (string == null || string.trim().isEmpty()) {
            return arrayList;
        }
        try {
            int n;
            int n2;
            int n3 = string.indexOf("\"correlation_candidates\"");
            if (n3 == -1) {
                return arrayList;
            }
            int n4 = string.indexOf(91, n3);
            if (n4 == -1) {
                return arrayList;
            }
            int n5 = 0;
            int n6 = -1;
            for (int i = n4; i < string.length(); ++i) {
                n2 = string.charAt(i);
                if (n2 == 91) {
                    ++n5;
                    continue;
                }
                if (n2 != 93 || --n5 != 0) continue;
                n6 = i;
                break;
            }
            if (n6 == -1) {
                return arrayList;
            }
            String string2 = string.substring(n4 + 1, n6);
            n2 = 0;
            while (n2 < string2.length() && (n = string2.indexOf(123, n2)) != -1) {
                int n7 = 0;
                int n8 = -1;
                for (int i = n; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == '{') {
                        ++n7;
                        continue;
                    }
                    if (c != '}' || --n7 != 0) continue;
                    n8 = i;
                    break;
                }
                if (n8 == -1) break;
                String string3 = string2.substring(n, n8 + 1);
                CarrieCandidate carrieCandidate = new CarrieCandidate();
                carrieCandidate.name = this.extractJsonStringViaRegex(string3, "name");
                carrieCandidate.value = this.extractJsonStringViaRegex(string3, "value");
                carrieCandidate.location = this.extractJsonStringViaRegex(string3, "location");
                carrieCandidate.jsonPath = this.extractJsonStringViaRegex(string3, "json_path");
                carrieCandidate.leftBoundary = this.extractJsonStringViaRegex(string3, "left_boundary");
                try {
                    String string4 = this.extractJsonNumberViaRegex(string3, "value_uniqueness_probability");
                    if (string4 != null && !string4.isEmpty()) {
                        carrieCandidate.valueUniquenessProb = Double.parseDouble(string4);
                        try {
                            log.info("[Candidate Selection] Parsed uniqueness for '{}': {} (raw: '{}')", (Object)carrieCandidate.name, (Object)carrieCandidate.valueUniquenessProb, (Object)string4);
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            log.warn("[Candidate Selection] Failed to parse uniqueness for '{}', using default 1.0", (Object)carrieCandidate.name);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    try {
                        log.warn("[Candidate Selection] Exception parsing uniqueness for '{}': {}", (Object)carrieCandidate.name, (Object)exception.getMessage());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (carrieCandidate.value != null && !carrieCandidate.value.trim().isEmpty()) {
                    arrayList.add(carrieCandidate);
                }
                n2 = n8 + 1;
            }
            try {
                log.info("[Candidate Selection] Extracted {} candidates from Carrie response", (Object)arrayList.size());
                for (n = 0; n < arrayList.size(); ++n) {
                    CarrieCandidate carrieCandidate = (CarrieCandidate)arrayList.get(n);
                    log.info("[Candidate Selection]   Candidate {}: name={}, value={}, location={}", (Object)(n + 1), (Object)carrieCandidate.name, carrieCandidate.value != null && carrieCandidate.value.length() > 30 ? carrieCandidate.value.substring(0, 30) + "..." : carrieCandidate.value, (Object)carrieCandidate.location);
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            try {
                log.warn("[Candidate Selection] Error parsing candidates: {}", (Object)exception.getMessage());
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private String selectNextCandidateForInsertion(String string) {
        try {
            Object object;
            List<CarrieCandidate> list = this.extractAllCarrieCandidates(string);
            if (list.isEmpty()) {
                log.info("[Candidate Selection] No candidates found, falling back to extractFirstCarrieValue");
                lastCarrieCandidatesToProcess = new ArrayList<CarrieCandidate>();
                return this.extractFirstCarrieValue(string);
            }
            Long l = DCAIResultsVisualizer.getLastCorrelationSessionId();
            if (l == null) {
                log.info("[Candidate Selection] No session ID available (likely first correlation in session) - will process all candidates without duplicate checking");
                lastCarrieCandidatesToProcess = new ArrayList<CarrieCandidate>(list);
                for (CarrieCandidate carrieCandidate : list) {
                    DCAIResultsVisualizer.createAttemptForCandidate(carrieCandidate.name, carrieCandidate.value, carrieCandidate.location, carrieCandidate.jsonPath);
                }
                log.info("[Candidate Selection] Processing all {} candidates (no session ID for duplicate check)", (Object)list.size());
                return this.normalizeCarrieCandidateValue(list.get((int)0).value);
            }
            ArrayList<CarrieCandidate> arrayList = new ArrayList<CarrieCandidate>();
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                String string2 = this.normalizeCarrieCandidateValue(((CarrieCandidate)object).value);
                try {
                    log.info("[Candidate Selection DEBUG] Checking candidate idx={} name={} location={} jsonPath={} sessionId={} harFilename={} rawValue={}", (Object)(i + 1), (Object)((CarrieCandidate)object).name, (Object)((CarrieCandidate)object).location, (Object)((CarrieCandidate)object).jsonPath, (Object)l, (Object)DCAIResultsVisualizer.getLastCorrelationHarFilename(), (Object)this.sample(((CarrieCandidate)object).value, 120));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = this.checkCandidateAlreadyInserted(l, ((CarrieCandidate)object).name, ((CarrieCandidate)object).location, ((CarrieCandidate)object).jsonPath);
                log.info("[Candidate Selection] Candidate {}/{}: name={} location={} alreadyInserted={}", (Object)(i + 1), (Object)list.size(), (Object)((CarrieCandidate)object).name, (Object)((CarrieCandidate)object).location, (Object)bl);
                if (bl) continue;
                log.info("[Candidate Selection] Adding uninserted candidate {}/{} to process list: name={} location={}", (Object)(i + 1), (Object)list.size(), (Object)((CarrieCandidate)object).name, (Object)((CarrieCandidate)object).location);
                arrayList.add((CarrieCandidate)object);
                Long l2 = DCAIResultsVisualizer.createAttemptForCandidate(((CarrieCandidate)object).name, ((CarrieCandidate)object).value, ((CarrieCandidate)object).location, ((CarrieCandidate)object).jsonPath);
                if (l2 != null) {
                    log.info("[Candidate Selection] Created attempt for candidate '{}': attemptId={}", (Object)((CarrieCandidate)object).name, (Object)l2);
                    continue;
                }
                log.warn("[Candidate Selection] Failed to create attempt for candidate '{}'", (Object)((CarrieCandidate)object).name);
            }
            lastCarrieCandidatesToProcess = arrayList;
            log.info("[Candidate Selection] Found {} uninserted candidates to process", (Object)arrayList.size());
            if (!arrayList.isEmpty()) {
                CarrieCandidate carrieCandidate = (CarrieCandidate)arrayList.get(0);
                object = this.normalizeCarrieCandidateValue(carrieCandidate.value);
                try {
                    if (object != null && ((String)object).startsWith("NOT_FOUND_")) {
                        lastCarrieValueHadNotFoundPrefix = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return object;
            }
            log.info("[Candidate Selection] All {} candidates have been inserted already for this session", (Object)list.size());
            SwingUtilities.invokeLater(() -> {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("All ").append(list.size()).append(" correlation candidate");
                if (list.size() != 1) {
                    stringBuilder.append("s");
                }
                stringBuilder.append(" from Carrie ");
                if (list.size() == 1) {
                    stringBuilder.append("has");
                } else {
                    stringBuilder.append("have");
                }
                stringBuilder.append(" already been inserted for this session.\n\n");
                stringBuilder.append("**Candidates already processed:**\n");
                for (int i = 0; i < list.size() && i < 5; ++i) {
                    stringBuilder.append("- ").append(((CarrieCandidate)list.get((int)i)).name).append(" (").append(((CarrieCandidate)list.get((int)i)).location).append(")\n");
                }
                if (list.size() > 5) {
                    stringBuilder.append("... and ").append(list.size() - 5).append(" more\n");
                }
                stringBuilder.append("\nNo further action needed.");
                this.appendAiReplyWithAvatar("\u2713 Candidates Already Processed", stringBuilder.toString(), "/com/company/dcai/images/search-runner.png");
            });
            CarrieCandidate carrieCandidate = list.get(0);
            object = this.normalizeCarrieCandidateValue(carrieCandidate.value);
            try {
                if (object != null && ((String)object).startsWith("NOT_FOUND_")) {
                    lastCarrieValueHadNotFoundPrefix = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }
        catch (Exception exception) {
            log.error("[Candidate Selection] Error selecting candidate: {}", (Object)exception.getMessage(), (Object)exception);
            lastCarrieCandidatesToProcess = new ArrayList<CarrieCandidate>();
            return this.extractFirstCarrieValue(string);
        }
    }

    private boolean checkCandidateAlreadyInserted(Long l, String string, String string2, String string3) {
        try {
            String string4 = JMeterUtils.getProperty((String)"dcai.account.api");
            if (string4 == null || string4.trim().isEmpty()) {
                log.warn("[Candidate Selection] No API key available");
                return false;
            }
            String string5 = AAA.AB();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string5).append("/api/carrie/correlation/check-insertion");
            stringBuilder.append("?sessionId=").append(l);
            if (string != null && !string.isEmpty()) {
                stringBuilder.append("&candidateName=").append(URLEncoder.encode(string, "UTF-8"));
            }
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append("&candidateLocation=").append(URLEncoder.encode(string2, "UTF-8"));
            }
            if (string3 != null && !string3.isEmpty()) {
                stringBuilder.append("&candidateJsonPath=").append(URLEncoder.encode(string3, "UTF-8"));
            }
            String string6 = stringBuilder.toString();
            log.info("[Candidate Selection] Checking insertion: sessionId={} name={} location={} jsonPath={} url={} harFilename={}", (Object)l, (Object)string, (Object)string2, (Object)string3, (Object)string6, (Object)DCAIResultsVisualizer.getLastCorrelationHarFilename());
            URL uRL = new URL(string6);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("X-API-Key", string4);
            httpURLConnection.setRequestProperty("Accept", "application/json");
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string7;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder stringBuilder2 = new StringBuilder();
                while ((string7 = bufferedReader.readLine()) != null) {
                    stringBuilder2.append(string7);
                }
                bufferedReader.close();
                String string8 = stringBuilder2.toString();
                boolean bl = string8.contains("\"inserted\":true") || string8.contains("\"inserted\": true");
                log.info("[Candidate Selection] Check result: inserted={} rawResponse={} ", (Object)bl, (Object)string8);
                return bl;
            }
            log.warn("[Candidate Selection] Check insertion API returned status {}", (Object)n);
            return false;
        }
        catch (Exception exception) {
            log.error("[Candidate Selection] Error checking insertion: {}", (Object)exception.getMessage());
            return false;
        }
    }

    private Long lookupAttemptIdFromServer(Long l, String string, String string2, String string3) {
        try {
            String string4 = JMeterUtils.getProperty((String)"dcai.account.api");
            if (string4 == null || string4.trim().isEmpty()) {
                log.warn("[Insertion Tracking] No API key available for server lookup");
                return null;
            }
            String string5 = AAA.AB();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string5).append("/api/carrie/correlation/attempts/lookup");
            stringBuilder.append("?sessionId=").append(l);
            stringBuilder.append("&candidateName=").append(URLEncoder.encode(string, "UTF-8"));
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append("&candidateLocation=").append(URLEncoder.encode(string2, "UTF-8"));
            }
            if (string3 != null && !string3.isEmpty()) {
                stringBuilder.append("&candidateJsonPath=").append(URLEncoder.encode(string3, "UTF-8"));
            }
            String string6 = stringBuilder.toString();
            log.info("[Insertion Tracking] Looking up attemptId from server: sessionId={}, candidateName={}", (Object)l, (Object)string);
            URL uRL = new URL(string6);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("X-API-Key", string4);
            httpURLConnection.setRequestProperty("Accept", "application/json");
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string7;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder stringBuilder2 = new StringBuilder();
                while ((string7 = bufferedReader.readLine()) != null) {
                    stringBuilder2.append(string7);
                }
                bufferedReader.close();
                String string8 = stringBuilder2.toString();
                if (string8.contains("\"found\":true") || string8.contains("\"found\": true")) {
                    int n2 = string8.indexOf("\"attemptId\":");
                    if (n2 != -1) {
                        int n3 = n2 + 12;
                        int n4 = string8.indexOf(",", n3);
                        if (n4 == -1) {
                            n4 = string8.indexOf("}", n3);
                        }
                        String string9 = string8.substring(n3, n4).trim();
                        Long l2 = Long.parseLong(string9);
                        log.info("[Insertion Tracking] Server returned attemptId: {}", (Object)l2);
                        return l2;
                    }
                } else {
                    log.info("[Insertion Tracking] Server: attempt not found for candidate '{}'", (Object)string);
                }
            } else {
                log.warn("[Insertion Tracking] Server lookup failed with status: {}", (Object)n);
            }
        }
        catch (Exception exception) {
            log.warn("[Insertion Tracking] Failed to lookup attemptId from server: {}", (Object)exception.getMessage());
        }
        return null;
    }

    private String extractFirstCarrieValue(String string) {
        block12: {
            Matcher matcher;
            Pattern pattern;
            block11: {
                if (string == null) {
                    return null;
                }
                try {
                    pattern = Pattern.compile("\\\"correlation_candidates\\\"\\s*:\\s*\\[\\s*\\{[\\s\\S]*?\\\"value\\\"\\s*:\\s*\\\"(.*?)\\\"", 8);
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) break block11;
                    String string2 = matcher.group(1);
                    try {
                        if (string2 != null && string2.startsWith("NOT_FOUND_")) {
                            lastCarrieValueHadNotFoundPrefix = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return this.normalizeCarrieCandidateValue(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                pattern = Pattern.compile("\\\"value\\\"\\s*:\\s*\\\"(.*?)\\\"", 8);
                matcher = pattern.matcher(string);
                if (!matcher.find()) break block12;
                String string3 = matcher.group(1);
                try {
                    if (string3 != null && string3.startsWith("NOT_FOUND_")) {
                        lastCarrieValueHadNotFoundPrefix = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.normalizeCarrieCandidateValue(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractFirstCarrieCandidateString(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        try {
            String string3 = "\\\"correlation_candidates\\\"\\s*:\\s*\\[\\s*\\{[\\s\\S]*?\\\"" + Pattern.quote(string2) + "\\\"\\s*:\\s*\\\"(.*?)\\\"";
            Pattern pattern = Pattern.compile(string3, 8);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                String string4 = matcher.group(1);
                return this.normaliseBoundary(string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String normalizeCarrieCandidateValue(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (string.startsWith("NOT_FOUND_")) {
                String string2 = string.substring("NOT_FOUND_".length());
                if (!string2.isEmpty() && Character.isWhitespace(string2.charAt(0))) {
                    string2 = string2.substring(1);
                }
                return string2;
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void sendBoundariesToCarrie(String string, String string2) {
        try {
            if (!this.hasDispatchCredentials()) {
                String string3 = "```json\n{\n  \"mode\": \"BOUNDARIES\",\n  \"value\": \"" + this.escapeForJsonSimple(string) + "\",\n  \"snippet\": \"" + this.escapeForJsonSimple(string2) + "\"\n}\n```";
                this.appendAiReply("\ud83e\udd16 Carrie - The Correlator (BOUNDARIES intent)", string3);
                return;
            }
            String string4 = this.buildCarrieBoundariesPrompt(string, string2);
            this.appendCarrieUserMessageToChat(string4);
            new Thread(() -> {
                try {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    linkedHashMap.put("source", "boundaries");
                    A.AA aA = A.A(string, string2, linkedHashMap);
                    if (aA == null || !aA.A) {
                        String string3 = "Carrie dispatch failed";
                        if (aA != null && aA.AB != null && !this.isEmpty(aA.AB.AA)) {
                            string3 = aA.AB.AA;
                        }
                        this.appendCarrieReplyToChat("{\n  \"mode\": \"BOUNDARIES\",\n  \"value\": \"" + this.escapeForJsonSimple(string) + "\",\n  \"left_boundary\": \"\",\n  \"right_boundary\": \"\",\n  \"confidence\": 0.0,\n  \"error\": \"" + this.escapeForJsonSimple(string3) + "\"\n}");
                        return;
                    }
                    String string4 = !this.isEmpty(aA.s) ? aA.s : (aA.AAA != null ? aA.AAA : "");
                    this.appendCarrieReplyToChat(string4);
                    try {
                        GeminiSidePanel.refreshCreditsAsync();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    try {
                        this.appendCarrieReplyToChat("{\n  \"mode\": \"BOUNDARIES\",\n  \"value\": \"" + this.escapeForJsonSimple(string) + "\",\n  \"left_boundary\": \"\",\n  \"right_boundary\": \"\",\n  \"confidence\": 0.0,\n  \"error\": \"" + this.escapeForJsonSimple(String.valueOf(exception.getMessage())) + "\"\n}");
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }, "carrie-boundaries").start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildCarrieBoundariesPrompt(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("SNIPPET:\n");
        stringBuilder.append(string2 == null ? "" : string2).append("\n\n");
        stringBuilder.append("VALUE:\n");
        stringBuilder.append(string == null ? "" : string).append("\n");
        return stringBuilder.toString();
    }

    private String buildGeorgeEscalationSummary(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("**Correlation Escalation**\n");
        if (!this.isEmpty(string)) {
            stringBuilder.append("- Search runner: ").append(this.sanitizeForInline(string)).append('\n');
        }
        if (!this.isEmpty(string2)) {
            stringBuilder.append("- Carrie cause: ").append(this.sanitizeForInline(string2)).append('\n');
        }
        if (!(this.isEmpty(string3) && this.isEmpty(string4) && this.isEmpty(string5) && this.isEmpty(string6))) {
            stringBuilder.append("- Candidate:");
            if (!this.isEmpty(string3)) {
                stringBuilder.append(" name=").append(this.sanitizeForInline(string3));
            }
            if (!this.isEmpty(string4)) {
                stringBuilder.append(" location=").append(this.sanitizeForInline(string4));
            }
            if (!this.isEmpty(string5)) {
                stringBuilder.append(" json_path=").append(this.sanitizeForInline(string5));
            }
            if (!this.isEmpty(string6)) {
                stringBuilder.append(" value=").append(this.sanitizeForInline(this.sample(string6, 80)));
            }
            stringBuilder.append('\n');
        }
        if (!this.isEmpty(string7)) {
            stringBuilder.append("- DCAI header: ").append(this.sanitizeForInline(string7)).append('\n');
        }
        if (!this.isEmpty(string8)) {
            stringBuilder.append("- HAR path: ").append(this.sanitizeForInline(string8)).append('\n');
        }
        if (!this.isEmpty(string9)) {
            stringBuilder.append("- Sample context preview: ").append(this.sanitizeForInline(this.sample(string9, 120))).append('\n');
        }
        stringBuilder.append("- Full context attached server-side");
        return stringBuilder.toString();
    }

    private int parseDcaiIndex(String string) {
        if (string == null) {
            return -1;
        }
        try {
            Matcher matcher = Pattern.compile("DCAI-0*([0-9]+)").matcher(string);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private String safeReadFileToString(File file, int n) {
        try {
            long l = file.length();
            if (l > (long)n) {
                return null;
            }
            byte[] byArray = Files.readAllBytes(file.toPath());
            return new String(byArray, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String extractNearestUrlBackward(String string, int n) {
        try {
            int n2;
            int n3 = Math.max(0, n - 20000);
            String string2 = string.substring(n3, n);
            int n4 = string2.lastIndexOf("\"url\":\"");
            if (n4 >= 0 && (n2 = string2.indexOf(34, n4 + 7)) > n4) {
                String string3 = string2.substring(n4, Math.min(string2.length(), n2 + 1));
                Matcher matcher = Pattern.compile("\\\"url\\\"\\s*:\\s*\\\"(.*?)\\\"").matcher(string3);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setLastErrorDcaiHeader(String string) {
        lastErrorDcaiHeader = string == null ? null : string.trim();
    }

    public static void setLastCarrieCorrelationSample(String string) {
        lastCarrieCorrelationSample = string == null ? null : string.trim();
    }

    public void cleanup() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void appendCarrieUserMessageToChat(String string) {
        try {
            String string2 = "**To Carrie - The Correlator**\n\n" + (string == null ? "" : string);
            this.appendMarkdownToChat(string2, new Color(0, 153, 255));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendCarrieReplyToChat(String string) {
        block32: {
            try {
                String string2;
                String string3;
                block31: {
                    String string4;
                    string3 = string == null ? "" : string.trim();
                    try {
                        string4 = GeminiSidePanel.prettyPrintJson(string3);
                    }
                    catch (Exception exception) {
                        string4 = string3;
                    }
                    String string5 = "```json\n" + string4 + "\n```";
                    this.appendAiReplyWithAvatar("\ud83e\udd16 Carrie - The Correlator", string5, "/com/company/dcai/images/Carrie.png");
                    try {
                        Object object;
                        String string6;
                        CarrieBoundariesResult carrieBoundariesResult = this.parseCarrieBoundaries(string3);
                        if (!(carrieBoundariesResult != null && carrieBoundariesResult.leftBoundary != null && carrieBoundariesResult.rightBoundary != null && carrieBoundariesResult.leftBoundary.length() >= 4 || string3 == null || (string2 = this.deepJsonUnescape(string3)) == null || string2.equals(string3))) {
                            carrieBoundariesResult = this.parseCarrieBoundaries(string2);
                        }
                        if (carrieBoundariesResult == null || pendingBoundariesDcaiId == null || pendingBoundariesDcaiId.isEmpty()) break block31;
                        string2 = this.normaliseBoundary(carrieBoundariesResult.leftBoundary);
                        String string7 = this.normaliseBoundary(carrieBoundariesResult.rightBoundary);
                        if ((string7 == null || string7.isEmpty()) && carrieBoundariesResult.rightBoundary != null) {
                            string6 = carrieBoundariesResult.rightBoundary;
                            if (string6.contains("\\r\\n") || string6.contains("\r\n")) {
                                string7 = "\r\n";
                            } else if (string6.contains("\\n") || string6.contains("\n")) {
                                string7 = "\n";
                            }
                        }
                        string6 = GeminiSidePanel.escapeOroRegexLiteral(string2);
                        String string8 = GeminiSidePanel.escapeOroRegexLiteral(string7);
                        boolean bl = string2.indexOf(34) >= 0 || string7.indexOf(34) >= 0;
                        boolean bl2 = string2.indexOf(10) >= 0 || string7.indexOf(10) >= 0;
                        String string9 = bl ? "[^\\\"]+" : ".*?";
                        String string10 = (bl2 ? "(?s)" : "") + string6 + "(" + string9 + ")" + string8;
                        try {
                            object = "Boundaries debug:\nleft_raw: " + String.valueOf(carrieBoundariesResult.leftBoundary) + "\nright_raw: " + String.valueOf(carrieBoundariesResult.rightBoundary) + "\nleft_norm: " + string2 + "\nright_norm: " + string7 + "\nprefix: " + string6 + "\nsuffix: " + string8 + "\ngroup: " + string9 + "\npattern: " + string10 + "\n";
                            this.appendAiReplyWithAvatar("\ud83e\udd16 Search Runner", "Regex build details from BOUNDARIES:\n\n```\n" + (String)object + "```\n", "/com/company/dcai/images/search-runner.png");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (string10 != null && !string10.isEmpty()) {
                            try {
                                object = pendingBoundariesDcaiId;
                                String string11 = carrieBoundariesResult.value;
                                String string12 = string10;
                                String string13 = string2;
                                String string14 = string7;
                                SwingUtilities.invokeAndWait(() -> this.lambda$appendCarrieReplyToChat$63((String)object, string11, string12, string13, string14));
                            }
                            catch (InterruptedException interruptedException) {
                                log.error("[Boundaries] EDT insertion interrupted: {}", (Object)interruptedException.getMessage());
                                Thread.currentThread().interrupt();
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                log.error("[Boundaries] EDT insertion failed: {}", (Object)invocationTargetException.getCause().getMessage(), (Object)invocationTargetException.getCause());
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    boolean bl;
                    try {
                        log.info("[Search Auto] Carrie reply received; evaluating SORT correlation issue...");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    lastCarrieCorrelationIssue = bl = this.isSortCorrelationIssue(string3);
                    if (bl) {
                        lastCarrieCorrelationJson = string3;
                        lastCarrieCorrelationEscalated = false;
                        try {
                            lastCarrieCorrelationValue = this.selectNextCandidateForInsertion(string3);
                        }
                        catch (Exception exception) {
                            lastCarrieCorrelationValue = null;
                        }
                        try {
                            lastCarrieCorrelationCause = this.extractJsonStringViaRegex(string3, "cause");
                        }
                        catch (Exception exception) {
                            lastCarrieCorrelationCause = null;
                        }
                    } else {
                        lastCarrieCorrelationJson = null;
                        lastCarrieCorrelationValue = null;
                        lastCarrieCorrelationCause = null;
                        lastCarrieCorrelationEscalated = false;
                    }
                    try {
                        log.info("[Search Auto] isSortCorrelationIssue={} (replyLen={})", (Object)bl, (Object)(string3 != null ? string3.length() : -1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) break block32;
                    try {
                        string2 = this.sample(this.extractFirstCarrieValue(this.getLastAiCarrieJson()), 80);
                        log.info("[Search Auto] SORT=true; scheduling auto-run. lastHeader='{}' valuePreview='{}'", (Object)String.valueOf(lastErrorDcaiHeader), (Object)string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.processAllUninsertedCandidates();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void autoRunHarFromSavedPathWithRetry(int n, long l) {
        try {
            this.executorService.submit(() -> {
                for (int i = 1; i <= Math.max(1, n); ++i) {
                    try {
                        String string;
                        String string2;
                        boolean bl;
                        String string3 = this.loadHarPathFromTestPlan();
                        try {
                            log.info("[Search Auto] Attempt {}/{}: DCAI_HAR_PATH='{}'", (Object)i, (Object)n, (Object)String.valueOf(string3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        File file = string3 != null ? new File(string3.trim()) : null;
                        boolean bl2 = bl = file != null && file.exists() && file.isFile();
                        if (!bl && this.lastUploadedHarFile != null && this.lastUploadedHarFile.exists() && this.lastUploadedHarFile.isFile()) {
                            try {
                                log.info("[Search Auto] Using lastUploadedHarFile fallback: {}", (Object)this.lastUploadedHarFile.getAbsolutePath());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            file = this.lastUploadedHarFile;
                            bl = true;
                        }
                        boolean bl3 = (string2 = this.extractFirstCarrieValue(string = this.getLastAiCarrieJson())) != null && !string2.isEmpty();
                        String string4 = lastErrorDcaiHeader;
                        boolean bl4 = string4 != null && this.parseDcaiIndex(string4) > 0;
                        try {
                            log.info("[Search Auto] Attempt {}/{}: pathOk={} haveValue={} haveHdr={} hdr='{}' valuePreview='{}'", (Object)i, (Object)n, (Object)bl, (Object)bl3, (Object)bl4, (Object)String.valueOf(string4), (Object)this.sample(string2, 60));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (bl && bl3 && bl4) {
                            File file2 = file;
                            try {
                                log.info("[Search Auto] Starting performHarSelection with file='{}'", (Object)file2.getAbsolutePath());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(() -> this.performHarSelection(file2));
                            return;
                        }
                        if (i >= n) continue;
                        try {
                            Thread.sleep(Math.max(50L, l));
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Auto HAR search: prerequisites not ready (path/header/value)."), Color.ORANGE, true);
                    log.info("[Search Auto] Gave up waiting for prerequisites");
                    SwingUtilities.invokeLater(() -> {
                        try {
                            log.info("[Search Auto] Opening HAR chooser as fallback");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.handleSearchHar();
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setPendingBoundariesDcaiId(String string) {
        pendingBoundariesDcaiId = string;
    }

    private CarrieBoundariesResult parseCarrieBoundaries(String string) {
        try {
            if (string == null) {
                return null;
            }
            String string2 = string.trim();
            try {
                log.info("[BOUNDARIES Debug] Parsing JSON input (len={}): {}", (Object)string2.length(), (Object)this.sample(string2, 400));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = this.extractJsonStringViaRegex(string2, "mode");
            if (string3 == null || !"BOUNDARIES".equalsIgnoreCase(string3)) {
                return null;
            }
            String string4 = this.extractJsonStringViaRegex(string2, "value");
            String string5 = this.extractJsonStringViaRegex(string2, "left_boundary");
            String string6 = this.extractJsonStringViaRegex(string2, "right_boundary");
            if (string5 == null || string6 == null) {
                return null;
            }
            return new CarrieBoundariesResult(string3, string4, string5, string6);
        }
        catch (Exception exception) {
            try {
                log.info("[BOUNDARIES Debug] Exception in parseCarrieBoundaries: {}", (Object)exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    private boolean isSortCorrelationIssue(String string) {
        try {
            if (string == null) {
                return false;
            }
            String string2 = this.extractJsonStringViaRegex(string, "mode");
            if (string2 == null || !"SORT".equalsIgnoreCase(string2)) {
                return false;
            }
            Boolean bl = this.extractJsonBooleanField(string, "is_correlation_issue");
            boolean bl2 = Boolean.TRUE.equals(bl);
            try {
                log.info("[Search Auto] mode='{}' is_correlation_issue={} (detected={})", (Object)String.valueOf(string2), (Object)String.valueOf(bl), (Object)bl2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Boolean extractJsonBooleanField(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        try {
            int n;
            String string3 = "\"" + string2 + "\"";
            int n2 = string.indexOf(string3);
            if (n2 < 0) {
                return null;
            }
            int n3 = string.indexOf(58, n2 + string3.length());
            if (n3 < 0) {
                return null;
            }
            for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            if (n >= string.length()) {
                return null;
            }
            if (this.regionMatchesIgnoreCase(string, n, "true")) {
                return Boolean.TRUE;
            }
            if (this.regionMatchesIgnoreCase(string, n, "false")) {
                return Boolean.FALSE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean regionMatchesIgnoreCase(String string, int n, String string2) {
        try {
            if (string == null || string2 == null) {
                return false;
            }
            if (n < 0 || n + string2.length() > string.length()) {
                return false;
            }
            for (int i = 0; i < string2.length(); ++i) {
                char c;
                char c2 = Character.toLowerCase(string.charAt(n + i));
                if (c2 == (c = Character.toLowerCase(string2.charAt(i)))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String extractJsonStringFieldLocal(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        try {
            String string3 = "\"" + string2 + "\"";
            int n = string.indexOf(string3);
            if (n < 0) {
                return null;
            }
            int n2 = string.indexOf(":", n + string3.length());
            if (n2 < 0) {
                return null;
            }
            int n3 = string.indexOf(34, n2 + 1);
            if (n3 < 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = n3 + 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl) {
                    stringBuilder.append(c);
                    bl = false;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (c == '\"') break;
                stringBuilder.append(c);
            }
            String string4 = stringBuilder.toString();
            return string4.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\"", "\"").replace("\\/", "/").replace("\\\\", "\\");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String extractJsonStringViaRegex(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        try {
            int n;
            String string3 = "\"" + string2 + "\"";
            int n2 = string.indexOf(string3);
            if (n2 < 0) {
                return null;
            }
            int n3 = string.indexOf(58, n2 + string3.length());
            if (n3 < 0) {
                return null;
            }
            for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            if (n >= string.length() || string.charAt(n) != '\"') {
                return null;
            }
            ++n;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (bl) {
                    stringBuilder.append(c);
                    bl = false;
                } else if (c == '\\') {
                    stringBuilder.append(c);
                    bl = true;
                } else {
                    if (c == '\"') break;
                    stringBuilder.append(c);
                }
                ++n;
            }
            String string4 = stringBuilder.toString();
            String string5 = string4.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\u0022", "\"").replace("\\u005C", "\\").replace("\\\"", "\"").replace("\\/", "/").replace("\\\\", "\\");
            return string5;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String extractJsonNumberViaRegex(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        try {
            char c;
            int n;
            String string3 = "\"" + string2 + "\"";
            int n2 = string.indexOf(string3);
            if (n2 < 0) {
                return null;
            }
            int n3 = string.indexOf(58, n2 + string3.length());
            if (n3 < 0) {
                return null;
            }
            for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            if (n >= string.length()) {
                return null;
            }
            char c2 = string.charAt(n);
            if (c2 == '\"') {
                return this.extractJsonStringViaRegex(string, string2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (n < string.length() && ((c = string.charAt(n)) == '-' || c == '+' || c == '.' || c == 'e' || c == 'E' || Character.isDigit(c))) {
                stringBuilder.append(c);
                ++n;
            }
            String string4 = stringBuilder.toString().trim();
            return string4.isEmpty() ? null : string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String deepJsonUnescape(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.contains("\\\"{") || string.contains("\\\"mode\\\"")) {
                String string2 = string.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\"", "\"").replace("\\/", "/").replace("\\\\", "\\");
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String buildSafeOroRegexFromBoundaries(String string, String string2) {
        try {
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            string = this.normaliseBoundary(string);
            string2 = this.normaliseBoundary(string2);
            boolean bl = string.indexOf(10) >= 0 || string2.indexOf(10) >= 0;
            String string3 = GeminiSidePanel.escapeOroRegexLiteral(string);
            String string4 = GeminiSidePanel.escapeOroRegexLiteral(string2);
            boolean bl2 = string.indexOf(34) >= 0 || string2.indexOf(34) >= 0;
            String string5 = bl2 ? "[^\\\"]+" : ".*?";
            return (bl ? "(?s)" : "") + string3 + "(" + string5 + ")" + string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String normaliseBoundary(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        string2 = string2.replace("\\u0022", "\"").replace("\\u005C", "\\").replace("\\\"", "\"").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\/", "/").replace("\\\\", "\\");
        return string2;
    }

    private static String escapeOroRegexLiteral(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuilder.append('\\').append(c);
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block6;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRegexUnderSamplerWithDcai(String string, String string2, String string3, String string4, String string5) {
        block58: {
            try {
                Object object;
                String string6;
                Object object2;
                JMeterTreeNode jMeterTreeNode;
                if (string == null || string.isEmpty() || string3 == null || string3.isEmpty()) {
                    return;
                }
                GuiPackage guiPackage = GuiPackage.getInstance();
                if (guiPackage == null) {
                    return;
                }
                JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
                if (jMeterTreeModel == null) {
                    return;
                }
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeModel.getRoot();
                JMeterTreeNode jMeterTreeNode3 = this.findSamplerByDcaiHeader(jMeterTreeNode2, string);
                if (jMeterTreeNode3 == null) {
                    jMeterTreeNode3 = this.findSamplerByHttpHeaderManager(jMeterTreeNode2, string);
                }
                if (jMeterTreeNode3 == null) {
                    jMeterTreeNode3 = this.findSamplerByUrlHeuristic(jMeterTreeNode2, pendingBoundariesUrl);
                }
                if (jMeterTreeNode3 == null) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("BOUNDARIES: Could not locate sampler with DCAI=" + string), Color.ORANGE, true);
                    return;
                }
                boolean bl = lastCarrieValueHadNotFoundPrefix || string2 != null && string2.startsWith("NOT_FOUND_");
                String string7 = bl ? this.normalizeCarrieCandidateValue(string2) : string2;
                String string8 = this.suggestRegexVarName(string4, string5, string7);
                String string9 = bl ? this.findExistingVarForNotFoundDefault(jMeterTreeNode3, string7) : null;
                try {
                    log.info("[Replace] REGEX hasNotFoundPrefix={} normalized='{}' existingVar='{}'", (Object)bl, (Object)this.sample(string7, 120), (Object)string9);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RegexExtractor regexExtractor = new RegexExtractor();
                regexExtractor.setName("Load Magic Regex Extractor - " + string8);
                regexExtractor.setProperty("TestElement.test_class", RegexExtractor.class.getName());
                regexExtractor.setProperty("TestElement.gui_class", RegexExtractorGui.class.getName());
                regexExtractor.setRefName(string8);
                regexExtractor.setRegex(string3);
                regexExtractor.setTemplate("$1$");
                regexExtractor.setMatchNumber("1");
                regexExtractor.setDefaultValue("NOT_FOUND_" + (string7 != null ? string7 : ""));
                jMeterTreeModel.addComponent((TestElement)regexExtractor, jMeterTreeNode3);
                JMeterTreeNode jMeterTreeNode4 = null;
                try {
                    for (int i = jMeterTreeNode3.getChildCount() - 1; i >= 0; --i) {
                        jMeterTreeNode = (JMeterTreeNode)jMeterTreeNode3.getChildAt(i);
                        object2 = jMeterTreeNode.getUserObject();
                        if (!(object2 instanceof TestElement) || (string6 = ((TestElement)object2).getClass().getName()) == null || !string6.endsWith("RegexExtractor")) continue;
                        jMeterTreeNode4 = jMeterTreeNode;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TreePath treePath = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode3));
                jMeterTreeNode = jMeterTreeNode4;
                object2 = jMeterTreeNode != null ? new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode)) : null;
                SwingUtilities.invokeLater(() -> GeminiSidePanel.lambda$insertRegexUnderSamplerWithDcai$67(guiPackage, treePath, (TreePath)object2));
                this.appendToChatArea(GeminiSidePanel.escapeHtml("Inserted Regex Extractor under sampler with DCAI=" + string + " variable=" + string8), Color.GREEN, true);
                try {
                    boolean bl2;
                    String string10;
                    Object object3;
                    Object object4;
                    string6 = null;
                    String string11 = null;
                    String string12 = null;
                    String string13 = lastCarrieCorrelationJson;
                    if (string13 != null && string7 != null) {
                        try {
                            object = this.extractAllCarrieCandidates(string13);
                            object4 = object.iterator();
                            while (object4.hasNext()) {
                                object3 = (CarrieCandidate)object4.next();
                                string10 = this.normalizeCarrieCandidateValue(((CarrieCandidate)object3).value);
                                if (string10 == null || !string10.equals(string7) && !string7.contains(string10)) continue;
                                string6 = ((CarrieCandidate)object3).name;
                                string11 = ((CarrieCandidate)object3).location;
                                string12 = ((CarrieCandidate)object3).jsonPath;
                                log.info("[Insertion Tracking] Matched insertion value to candidate: name='{}' location='{}'", (Object)string6, (Object)string11);
                                break;
                            }
                        }
                        catch (Exception exception) {
                            log.warn("[Insertion Tracking] Failed to match insertion to candidate", (Throwable)exception);
                        }
                    }
                    object = null;
                    if (string6 != null) {
                        object = DCAIResultsVisualizer.getAttemptIdForCandidate(string6);
                        log.info("[Insertion Tracking] Map lookup for candidate '{}': attemptId={}", (Object)string6, object);
                        if (object == null && (object4 = DCAIResultsVisualizer.getLastCorrelationSessionId()) != null && string11 != null) {
                            log.info("[Insertion Tracking] Map lookup failed, trying server API for candidate '{}'", (Object)string6);
                            object = this.lookupAttemptIdFromServer((Long)object4, string6, string11, string12);
                            if (object != null) {
                                log.info("[Insertion Tracking] Server lookup succeeded: attemptId={}", object);
                            }
                        }
                    }
                    boolean bl3 = bl2 = string6 != null && object != null;
                    if (object == null) {
                        object = DCAIResultsVisualizer.getLastCorrelationAttemptId();
                        log.info("[Insertion Tracking] Using fallback last attemptId: {}", object);
                    }
                    object3 = DCAIResultsVisualizer.getLastCorrelationDcaiHeader();
                    string10 = DCAIResultsVisualizer.getLastCorrelationCandidateValue();
                    Long l = DCAIResultsVisualizer.getLastCorrelationTimestamp();
                    boolean bl4 = bl2;
                    if (!bl4 && object != null) {
                        boolean bl5 = object3 != null && ((String)object3).equals(string);
                        boolean bl6 = false;
                        if (string10 != null && string7 != null && l != null) {
                            long l2 = System.currentTimeMillis() - l;
                            bl6 = l2 < 30000L && string7.contains(string10);
                        }
                        bl4 = bl5 || bl6;
                        log.info("[Insertion Tracking DEBUG] Fallback matching - dcaiId={}, correlationDcai={}, dcaiMatch={}, valueMatch={}", (Object)string, object3, (Object)bl5, (Object)bl6);
                    }
                    log.info("[Insertion Tracking DEBUG] REGEX extractor inserted - dcaiId={}, attemptId={}, candidateName={}, foundViaCandidate={}, shouldTrack={}, normalizedValue={}", (Object)string, object, (Object)string6, (Object)bl2, (Object)bl4, (Object)(string7 != null ? string7.substring(0, Math.min(30, string7.length())) : "null"));
                    if (bl4) {
                        String string14 = bl2 ? "candidate match" : "fallback match";
                        log.info("[Insertion Tracking] Correlation insertion detected (REGEX, {}) - tracking for attempt {}", (Object)string14, object);
                        String string15 = "{\"pattern\":\"" + string3.replace("\"", "\\\"").replace("\\", "\\\\") + "\",\"template\":\"$1$\",\"matchNumber\":\"1\"}";
                        String string16 = "NOT_FOUND_" + (string7 != null ? string7 : "");
                        String string17 = this.loadJMeterVariable("LOADMAGIC_HAR");
                        log.info("[Insertion Tracking DEBUG] Calling trackCorrelationInsertion with payload: {}, harFilename: {}", (Object)string15, (Object)string17);
                        DCAIResultsVisualizer.trackCorrelationInsertion((Long)object, string, "regex", string15, string8, string16, string17);
                    } else {
                        log.info("[Insertion Tracking DEBUG] NOT tracking - conditions not met");
                    }
                }
                catch (Exception exception) {
                    log.warn("[Insertion Tracking] Failed to track correlation insertion (REGEX)", (Throwable)exception);
                }
                try {
                    if (jMeterTreeNode4 != null) {
                        int n;
                        string6 = string9 != null && !string9.isEmpty() ? "${" + string9 + "}" : string7;
                        try {
                            log.info("[Replace] REGEX findToken='{}' replacement='${}'", (Object)this.sample(string6, 160), (Object)this.sample(string8, 160));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean bl7 = false;
                        double d = 1.0;
                        object = string4;
                        if (currentCandidateBeingProcessed != null) {
                            d = GeminiSidePanel.currentCandidateBeingProcessed.valueUniquenessProb;
                            if (GeminiSidePanel.currentCandidateBeingProcessed.leftBoundary != null && !GeminiSidePanel.currentCandidateBeingProcessed.leftBoundary.trim().isEmpty()) {
                                object = GeminiSidePanel.currentCandidateBeingProcessed.leftBoundary;
                            }
                            if ((object == null || ((String)object).trim().isEmpty()) && GeminiSidePanel.currentCandidateBeingProcessed.name != null && !GeminiSidePanel.currentCandidateBeingProcessed.name.trim().isEmpty()) {
                                object = GeminiSidePanel.currentCandidateBeingProcessed.name;
                                try {
                                    log.info("[Replace] REGEX field name '{}' used as boundary (Carrie provided none)", object);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            bl7 = d < 0.7 && object != null && !((String)object).trim().isEmpty();
                        }
                        try {
                            log.info("[Replace] value_uniqueness_probability={}, useBoundaryAware={}, boundary='{}'", (Object)d, (Object)bl7, object != null ? object : "null");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (bl7) {
                            try {
                                log.info("[Replace] Using BOUNDARY-AWARE replacement (low uniqueness)");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            n = this.replaceLiteralValueAfterNodeWithBoundary(jMeterTreeNode2, jMeterTreeNode4, string6, "${" + string8 + "}", (String)object, 0.7);
                        } else {
                            try {
                                log.info("[Replace] Using STANDARD replacement (high uniqueness)");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            n = this.replaceLiteralValueAfterNode(jMeterTreeNode2, jMeterTreeNode4, string6, "${" + string8 + "}");
                        }
                        if (n == 0) {
                            log.warn("[Replace] WARNING: REGEX extractor inserted but no literal values were replaced. Value '{}' may not exist in test plan after insertion point.", (Object)this.sample(string6, 60));
                            SwingUtilities.invokeLater(() -> this.appendToChatArea("\u26a0 Warning: Inserted regex extractor for variable '" + string8 + "' but found no occurrences of the literal value in the test plan after this point. The correlation may not work correctly.", Color.ORANGE, true));
                        } else {
                            int n2 = n;
                            boolean bl8 = bl7;
                            log.info("[Replace] REGEX replacement successful: {} occurrence(s) replaced", (Object)n);
                            SwingUtilities.invokeLater(() -> {
                                String string3 = bl8 ? "(boundary-aware)" : "";
                                this.appendToChatArea(String.format("\u2713 Replaced %d occurrence(s) of '%s' with ${%s} %s", n2, this.sample(string6, 40), string8, string3), Color.decode("#2E7D32"), false);
                            });
                        }
                        try {
                            guiPackage.getMainFrame().repaint();
                        }
                        catch (Exception exception) {}
                        break block58;
                    }
                    log.error("[Replace] ERROR: insertedNode is null - cannot perform replacement!");
                    SwingUtilities.invokeLater(() -> this.appendToChatArea("\u274c Error: Failed to identify inserted regex extractor node. Replacement step skipped.", Color.RED, true));
                }
                catch (Exception exception) {
                    this.appendToChatArea(GeminiSidePanel.escapeHtml("Replace-after-insert failed: " + exception.getMessage()), Color.ORANGE, true);
                }
            }
            catch (Exception exception) {
                this.appendToChatArea(GeminiSidePanel.escapeHtml("BOUNDARIES auto-insert failed: " + exception.getMessage()), Color.RED, true);
            }
            finally {
                pendingBoundariesDcaiId = null;
                pendingBoundariesUrl = null;
            }
        }
    }

    private String findExistingVarForNotFoundDefault(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            if (jMeterTreeNode == null || string == null || string.isEmpty()) {
                return null;
            }
            String string2 = "NOT_FOUND_" + string;
            for (int i = jMeterTreeNode.getChildCount() - 1; i >= 0; --i) {
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                Object object = jMeterTreeNode2.getUserObject();
                if (!(object instanceof TestElement)) continue;
                TestElement testElement = (TestElement)object;
                try {
                    String string3;
                    String string4;
                    JSONPostProcessor jSONPostProcessor;
                    if (testElement instanceof JSONPostProcessor) {
                        String string5;
                        jSONPostProcessor = (JSONPostProcessor)testElement;
                        string4 = this.safeString(jSONPostProcessor.getDefaultValues());
                        if (!string2.equals(string4) || (string5 = this.firstRefName(string3 = this.safeString(jSONPostProcessor.getRefNames()))) == null || string5.isEmpty()) continue;
                        return string5;
                    }
                    if (!(testElement instanceof RegexExtractor) || !string2.equals(string4 = this.safeString((jSONPostProcessor = (RegexExtractor)testElement).getDefaultValue())) || (string3 = this.safeString(jSONPostProcessor.getRefName())).isEmpty()) continue;
                    return string3;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String safeString(String string) {
        return string == null ? "" : string;
    }

    private String firstRefName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return null;
        }
        int n = string2.indexOf(59);
        String string3 = n >= 0 ? string2.substring(0, n) : string2;
        return string3.trim();
    }

    private int replaceLiteralValueAfterNode(JMeterTreeNode jMeterTreeNode, JMeterTreeNode jMeterTreeNode2, String string, String string2) {
        try {
            log.info("[Replace] ENTER literal='{}' replacement='{}' hadNotFoundPreviously={}", (Object)this.sample(string, 160), (Object)this.sample(string2, 160), (Object)lastCarrieValueHadNotFoundPrefix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jMeterTreeNode == null || jMeterTreeNode2 == null || string == null || string.isEmpty() || string2 == null) {
            try {
                log.info("[Replace] EXIT early due to invalid args root/nulls");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        ArrayList<JMeterTreeNode> arrayList = new ArrayList<JMeterTreeNode>();
        boolean[] blArray = new boolean[1];
        this.collectReplaceableNodesAfter(jMeterTreeNode, jMeterTreeNode2, arrayList, blArray);
        String string3 = Pattern.quote(string);
        String string4 = this.sample(string3, 160);
        try {
            log.info("[Replace] literalPreview='{}' regexPreview='{}'", (Object)this.sample(string, 200), (Object)string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        try {
            log.info("[Replace] Prepared regex='{}' replaceableNodes={}", (Object)this.sample(string3, 160), (Object)arrayList.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            JMeterTreeNode jMeterTreeNode3 = (JMeterTreeNode)arrayList.get(i);
            if (jMeterTreeNode3 == jMeterTreeNode2) continue;
            Object object = jMeterTreeNode3.getUserObject();
            String string5 = object != null ? object.getClass().getName() : "null";
            try {
                Replaceable replaceable = (Replaceable)object;
                int n2 = 0;
                try {
                    try {
                        log.info("[Replace] Node#{} class={} raw attempt", (Object)i, (Object)string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n2 = replaceable.replace(string3, string2, true);
                }
                catch (Exception exception) {
                    try {
                        String string6 = this.quoteReplacement(string2);
                        try {
                            log.info("[Replace] Node#{} class={} fallback attempt", (Object)i, (Object)string5);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        n2 = replaceable.replace(string3, string6, true);
                    }
                    catch (Exception exception3) {
                        n2 = 0;
                    }
                }
                if (n2 <= 0) continue;
                n += n2;
                try {
                    log.info("[Replace] Node#{} class={} changes={} (cumulative={})", (Object)i, (Object)string5, (Object)n2, (Object)n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    jMeterTreeNode3.nameChanged();
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            log.info("[Replace] EXIT replaceableNodes={} totalChanges={}", (Object)arrayList.size(), (Object)n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private void collectReplaceableNodesAfter(JMeterTreeNode jMeterTreeNode, JMeterTreeNode jMeterTreeNode2, List<JMeterTreeNode> list, boolean[] blArray) {
        Object object;
        if (jMeterTreeNode == null) {
            return;
        }
        if (jMeterTreeNode == jMeterTreeNode2) {
            blArray[0] = true;
            return;
        }
        if (blArray[0] && (object = jMeterTreeNode.getUserObject()) instanceof Replaceable) {
            list.add(jMeterTreeNode);
        }
        for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
            this.collectReplaceableNodesAfter((JMeterTreeNode)jMeterTreeNode.getChildAt(i), jMeterTreeNode2, list, blArray);
        }
    }

    private String quoteReplacement(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replace("\\", "\\\\");
        string2 = string2.replace("$", "\\$");
        return string2;
    }

    private int replaceLiteralValueAfterNodeWithBoundary(JMeterTreeNode jMeterTreeNode, JMeterTreeNode jMeterTreeNode2, String string, String string2, String string3, double d) {
        boolean bl;
        String string4;
        int n;
        int n2;
        Object object;
        HashSet<String> hashSet;
        try {
            log.info("[BoundaryReplace] ENTER literal='{}' leftBoundary='{}' confidenceThreshold={}", (Object)this.sample(string, 60), (Object)this.sample(string3, 40), (Object)d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jMeterTreeNode == null || jMeterTreeNode2 == null || string == null || string.isEmpty() || string2 == null || string3 == null || string3.isEmpty()) {
            try {
                log.info("[BoundaryReplace] EXIT early due to invalid args");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        List<String[]> list = this.buildPreciseReplacementRules(string, string3, string2);
        if (list == null || list.isEmpty()) {
            try {
                log.info("[BoundaryReplace] EXIT early: no rules produced");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        String string5 = this.joinRegexAlternation(list);
        ArrayList<JMeterTreeNode> arrayList = new ArrayList<JMeterTreeNode>();
        boolean[] blArray = new boolean[1];
        this.collectReplaceableNodesAfter(jMeterTreeNode, jMeterTreeNode2, arrayList, blArray);
        try {
            log.info("[BoundaryReplace] Found {} replaceable nodes after insertion point", (Object)arrayList.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<ReplacementCandidateInfo> arrayList2 = new ArrayList<ReplacementCandidateInfo>();
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string5);
        }
        catch (Exception exception) {
            try {
                log.warn("[BoundaryReplace] Failed to compile precise regex, falling back to simple literal scan: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        for (JMeterTreeNode jMeterTreeNode3 : arrayList) {
            int n3;
            Object object2;
            int n4;
            if (jMeterTreeNode3 == jMeterTreeNode2 || !((hashSet = jMeterTreeNode3.getUserObject()) instanceof Replaceable) || (object = this.extractNodeTextForBoundaryCheck(jMeterTreeNode3)) == null || ((String)object).isEmpty()) continue;
            if (pattern != null) {
                Matcher matcher = pattern.matcher((CharSequence)object);
                int n5 = 0;
                while (matcher.find()) {
                    int n6;
                    int n7;
                    ++n5;
                    int n8 = matcher.start();
                    n4 = matcher.end();
                    n2 = ((String)object).indexOf(string, n8);
                    if (n2 < 0 || n2 > n4) {
                        n2 = n8;
                    }
                    if (this.isInsideJMeterVariable((String)(object2 = ((String)object).substring(n7 = Math.max(0, n2 - (n = 120)), n3 = Math.min(((String)object).length(), n2 + string.length() + n))), n6 = Math.max(0, n2 - n7))) {
                        try {
                            log.info("[BoundaryReplace] \u274c SKIPPED (inside variable) at pos {} in node '{}'. Context: ...{}...", (Object)n2, (Object)jMeterTreeNode3.getName(), (Object)((String)object2).substring(Math.max(0, n6 - 30), Math.min(((String)object2).length(), n6 + 30)));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    String[] stringArray = new ReplacementCandidateInfo();
                    stringArray.node = jMeterTreeNode3;
                    stringArray.context = object2;
                    stringArray.valuePosition = n6;
                    stringArray.occurrenceId = jMeterTreeNode3.getName() + "-m-" + n5 + "-pos-" + n2;
                    arrayList2.add((ReplacementCandidateInfo)stringArray);
                    try {
                        string4 = ((String)object2).substring(Math.max(0, n6 - 50), Math.min(((String)object2).length(), n6 + 50));
                        log.info("[BoundaryReplace] \ud83d\udccd Candidate #{}: node='{}', match={}, pos={}, context: ...{}...", (Object)arrayList2.size(), (Object)jMeterTreeNode3.getName(), (Object)n5, (Object)n2, (Object)string4);
                    }
                    catch (Exception exception) {}
                }
                continue;
            }
            List<Integer> list2 = this.findAllOccurrencesInText((String)object, string);
            for (Integer n9 : list2) {
                n4 = 100;
                n2 = Math.max(0, n9 - n4);
                String string6 = ((String)object).substring(n2, n = Math.min(((String)object).length(), n9 + string.length() + n4));
                if (this.isInsideJMeterVariable(string6, n3 = n9 - n2)) continue;
                object2 = new ReplacementCandidateInfo();
                ((ReplacementCandidateInfo)object2).node = jMeterTreeNode3;
                ((ReplacementCandidateInfo)object2).context = string6;
                ((ReplacementCandidateInfo)object2).valuePosition = n3;
                ((ReplacementCandidateInfo)object2).occurrenceId = jMeterTreeNode3.getName() + "-pos-" + n9;
                arrayList2.add((ReplacementCandidateInfo)object2);
            }
        }
        if (arrayList2.isEmpty()) {
            try {
                log.info("[BoundaryReplace] No occurrences found in test plan");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        try {
            log.info("[BoundaryReplace] Found {} total occurrences to validate", (Object)arrayList2.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<ValidationResultInfo> list2 = this.validateReplacementCandidatesViaServer(string, string3, arrayList2, d);
        boolean bl2 = bl = !list2.isEmpty() || arrayList2.isEmpty();
        if (!bl) {
            try {
                log.warn("[BoundaryReplace] Validation unavailable - using local precise boundary replacement fallback");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hashSet = new HashSet<String>();
        if (bl) {
            object = list2.iterator();
            while (object.hasNext()) {
                ValidationResultInfo validationResultInfo = (ValidationResultInfo)object.next();
                if (validationResultInfo.safeToReplace) {
                    hashSet.add(validationResultInfo.occurrenceId);
                    try {
                        log.info("[BoundaryReplace] \u2705 SAFE: occurrenceId='{}', boundary_confidence={:.3f}, boundary_found={}", (Object)validationResultInfo.occurrenceId, (Object)validationResultInfo.boundaryConfidence, (Object)validationResultInfo.boundaryFound);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    log.info("[BoundaryReplace] \u274c UNSAFE: occurrenceId='{}', boundary_confidence={:.3f} (threshold={:.2f}), reason='{}'", (Object)validationResultInfo.occurrenceId, (Object)validationResultInfo.boundaryConfidence, (Object)d, (Object)(validationResultInfo.reason != null ? validationResultInfo.reason : "N/A"));
                }
                catch (Exception exception) {}
            }
        } else {
            for (ReplacementCandidateInfo replacementCandidateInfo : arrayList2) {
                hashSet.add(replacementCandidateInfo.occurrenceId);
            }
        }
        try {
            log.info("[BoundaryReplace] \ud83d\udcca Validation complete: {} safe, {} unsafe (out of {} total)", (Object)hashSet.size(), (Object)(arrayList2.size() - hashSet.size()), (Object)arrayList2.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new HashMap();
        HashMap<JMeterTreeNode, Integer> hashMap = new HashMap<JMeterTreeNode, Integer>();
        for (ReplacementCandidateInfo replacementCandidateInfo : arrayList2) {
            hashMap.merge(replacementCandidateInfo.node, 1, Integer::sum);
            if (!hashSet.contains(replacementCandidateInfo.occurrenceId)) continue;
            object.merge(replacementCandidateInfo.node, 1, Integer::sum);
        }
        int n10 = 0;
        for (JMeterTreeNode jMeterTreeNode3 : object.keySet()) {
            n2 = (Integer)object.get(jMeterTreeNode3);
            if (n2 == (n = ((Integer)hashMap.get(jMeterTreeNode3)).intValue())) {
                Object object3 = jMeterTreeNode3.getUserObject();
                if (!(object3 instanceof Replaceable)) continue;
                Replaceable replaceable = (Replaceable)object3;
                try {
                    int n11 = 0;
                    for (String[] stringArray : list) {
                        String string7;
                        int n12;
                        if (stringArray == null || stringArray.length < 2 || (n12 = replaceable.replace(string4 = stringArray[0], string7 = stringArray[1], true)) <= 0) continue;
                        n11 += n12;
                        n10 += n12;
                    }
                    if (n11 <= 0) continue;
                    try {
                        log.info("[BoundaryReplace] Replaced {} occurrences in node: {}", (Object)n11, (Object)jMeterTreeNode3.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        jMeterTreeNode3.nameChanged();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {
                    try {
                        log.warn("[BoundaryReplace] Failed to replace in node {}: {}", (Object)jMeterTreeNode3.getName(), (Object)exception.getMessage());
                    }
                    catch (Exception exception2) {}
                }
                continue;
            }
            try {
                log.info("[BoundaryReplace] SKIPPING node {} ({}/{} safe) - partial replacement too risky", (Object)jMeterTreeNode3.getName(), (Object)n2, (Object)n);
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            int n13 = n10;
            SwingUtilities.invokeLater(() -> this.appendToChatArea("\u26a0 Boundary validation unavailable (server). Applied local boundary-aware replacement only. Replaced " + n13 + " occurrence(s).", Color.ORANGE, true));
        }
        try {
            log.info("[BoundaryReplace] EXIT totalReplacements={}", (Object)n10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n10;
    }

    private List<String[]> buildPreciseReplacementRules(String string, String string2, String string3) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            String string4;
            if (string == null) {
                return arrayList;
            }
            String string5 = Pattern.quote(string);
            String string6 = string4 = string2 == null ? "" : string2.replaceAll("[=:\"'\\s]+$", "").trim();
            if (string4.isEmpty()) {
                String string7 = "(?<!\\$\\{[^}]{0,200})\\b" + string5 + "\\b(?![^\\$]*\\})";
                arrayList.add(new String[]{string7, string3});
                return arrayList;
            }
            String string8 = Pattern.quote(string4);
            String string9 = "(?<!\\$\\{[^}]{0,200})";
            String string10 = string9 + "\"" + string8 + "\"\\s*:\\s*\"" + string5 + "\"";
            String string11 = "\"" + string4 + "\":\"" + string3 + "\"";
            arrayList.add(new String[]{string10, string11});
            String string12 = string9 + "\"" + string8 + "\"\\s*:\\s*" + string5 + "(?=[,\\}\\s])";
            String string13 = "\"" + string4 + "\":" + string3;
            arrayList.add(new String[]{string12, string13});
            String string14 = string9 + string8 + "\\s*=\\s*" + string5 + "(?=&|$|\\s)";
            String string15 = string4 + "=" + string3;
            arrayList.add(new String[]{string14, string15});
            try {
                log.debug("[BoundaryReplace] Built {} replacement rule(s) for key='{}', value='{}'", (Object)arrayList.size(), (Object)string4, (Object)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return arrayList;
        }
        catch (Exception exception) {
            try {
                log.warn("[BoundaryReplace] Failed to build precise pattern, using simple fallback: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string16 = "(?<!\\$\\{[^}]{0,200})\\b" + Pattern.quote(string) + "\\b(?![^\\$]*\\})";
            arrayList.add(new String[]{string16, string3});
            return arrayList;
        }
    }

    private String joinRegexAlternation(List<String[]> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String[] stringArray : list) {
            String string;
            if (stringArray == null || stringArray.length < 1 || (string = stringArray[0]) == null || string.trim().isEmpty()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("(?:").append(string).append(")");
        }
        return stringBuilder.toString();
    }

    private String extractNodeTextForBoundaryCheck(JMeterTreeNode jMeterTreeNode) {
        try {
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement) {
                TestElement testElement = (TestElement)object;
                StringBuilder stringBuilder = new StringBuilder();
                PropertyIterator propertyIterator = testElement.propertyIterator();
                while (propertyIterator.hasNext()) {
                    JMeterProperty jMeterProperty = propertyIterator.next();
                    String string = jMeterProperty.getName();
                    String string2 = jMeterProperty.getStringValue();
                    if (string == null || string2 == null) continue;
                    stringBuilder.append(string).append("=").append(string2).append("&");
                }
                return stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            try {
                log.debug("[BoundaryReplace] Failed to extract text from node: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return "";
    }

    private boolean isInsideJMeterVariable(String string, int n) {
        if (n < 0 || n >= string.length()) {
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        for (int i = n - 1; i >= 0; --i) {
            if (i < string.length() - 1 && string.charAt(i) == '$' && string.charAt(i + 1) == '{') {
                n2 = i;
                break;
            }
            if (string.charAt(i) != '}') continue;
            n3 = i;
            break;
        }
        return n2 > n3;
    }

    private List<Integer> findAllOccurrencesInText(String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string == null || string2 == null) {
            return arrayList;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        int n = 0;
        while ((n = string3.indexOf(string4, n)) != -1) {
            arrayList.add(n);
            n += string2.length();
        }
        return arrayList;
    }

    private List<ValidationResultInfo> validateReplacementCandidatesViaServer(String string, String string2, List<ReplacementCandidateInfo> list, double d) {
        ArrayList<ValidationResultInfo> arrayList = new ArrayList<ValidationResultInfo>();
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            if (validationEndpointDisabledDueTo404) {
                return arrayList;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append("\"value\":\"").append(this.escapeJsonString(string)).append("\",");
            stringBuilder.append("\"left_boundary\":\"").append(this.escapeJsonString(string2)).append("\",");
            stringBuilder.append("\"confidence_threshold\":").append(d).append(",");
            stringBuilder.append("\"candidates\":[");
            for (int i = 0; i < list.size(); ++i) {
                object3 = list.get(i);
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("{");
                stringBuilder.append("\"context\":\"").append(this.escapeJsonString(((ReplacementCandidateInfo)object3).context)).append("\",");
                stringBuilder.append("\"value_position\":").append(((ReplacementCandidateInfo)object3).valuePosition).append(",");
                stringBuilder.append("\"occurrence_id\":\"").append(this.escapeJsonString(((ReplacementCandidateInfo)object3).occurrenceId)).append("\"");
                stringBuilder.append("}");
            }
            stringBuilder.append("]}");
            String string3 = null;
            try {
                string3 = AAA.AB();
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = null;
            try {
                object3 = AAA.ABCs();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
            if (string3 != null && !string3.trim().isEmpty()) {
                arrayList2.add((CallSite)((Object)(GeminiSidePanel.stripTrailingSlashLocal(string3) + "/api/carrie/correlation/validate-replacement-candidates")));
            }
            if (object3 != null && !((String)object3).trim().isEmpty()) {
                arrayList2.add((CallSite)((Object)(GeminiSidePanel.stripTrailingSlashLocal((String)object3) + "/api/correlation/validate-replacement-candidates")));
            }
            if (arrayList2.isEmpty()) {
                try {
                    log.warn("[BoundaryReplace] No base URL available for validation endpoint");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return arrayList;
            }
            try {
                log.info("[BoundaryReplace] \ud83d\udce4 Request params: value='{}', boundary='{}', threshold={}, candidates={}", (Object)string, (Object)string2, (Object)d, (Object)list.size());
                if (!list.isEmpty()) {
                    object2 = list.get(0);
                    object = ((ReplacementCandidateInfo)object2).context.substring(Math.max(0, ((ReplacementCandidateInfo)object2).valuePosition - 50), Math.min(((ReplacementCandidateInfo)object2).context.length(), ((ReplacementCandidateInfo)object2).valuePosition + 50));
                    log.info("[BoundaryReplace] \ud83d\udce4 Example context (first candidate): ...{}...", object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = null;
            object = null;
            for (String string4 : arrayList2) {
                try {
                    log.info("[BoundaryReplace] \ud83c\udf10 Calling validation endpoint: {}", (Object)string4);
                    object2 = this.httpPost(string4, stringBuilder.toString());
                    object = null;
                    break;
                }
                catch (Exception exception) {
                    object = exception;
                    try {
                        log.warn("[BoundaryReplace] Validation endpoint failed at {}: {}", (Object)string4, (Object)exception.getMessage());
                    }
                    catch (Exception exception2) {}
                }
            }
            if (object2 == null && object != null) {
                throw object;
            }
            if (object2 == null || ((String)object2).trim().isEmpty()) {
                try {
                    log.error("[BoundaryReplace] Empty response from validation endpoint");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return arrayList;
            }
            try {
                log.debug("[BoundaryReplace] Response: {}", (Object)this.sample((String)object2, 500));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n3 = ((String)object2).indexOf("\"results\"");
            if (n3 == -1) {
                try {
                    log.error("[BoundaryReplace] No results array in response");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return arrayList;
            }
            int n4 = ((String)object2).indexOf(91, n3);
            if (n4 == -1) {
                return arrayList;
            }
            int n5 = this.findMatchingBracket((String)object2, n4);
            if (n5 == -1) {
                return arrayList;
            }
            String string5 = ((String)object2).substring(n4 + 1, n5);
            int n6 = 0;
            while (n6 < string5.length() && (n2 = string5.indexOf(123, n6)) != -1 && (n = this.findMatchingBracket(string5, n2)) != -1) {
                String string6 = string5.substring(n2, n + 1);
                ValidationResultInfo validationResultInfo = new ValidationResultInfo();
                validationResultInfo.occurrenceId = this.extractJsonStringViaRegex(string6, "occurrence_id");
                validationResultInfo.safeToReplace = "true".equals(this.extractJsonStringViaRegex(string6, "safe_to_replace"));
                String string7 = this.extractJsonStringViaRegex(string6, "boundary_found");
                validationResultInfo.boundaryFound = "true".equals(string7);
                String string8 = this.extractJsonStringViaRegex(string6, "boundary_confidence");
                if (string8 != null && !string8.isEmpty()) {
                    try {
                        validationResultInfo.boundaryConfidence = Double.parseDouble(string8);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                validationResultInfo.reason = this.extractJsonStringViaRegex(string6, "reason");
                arrayList.add(validationResultInfo);
                n6 = n + 1;
            }
            try {
                log.info("[BoundaryReplace] Parsed {} validation results", (Object)arrayList.size());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                SmartMatchingConfig smartMatchingConfig = this.parseSmartMatchingConfig((String)object2);
                if (smartMatchingConfig != null && smartMatchingConfig.enabled) {
                    log.info("[BoundaryReplace] Smart matching enabled:");
                    log.info("  - Boundary pattern: {}", (Object)smartMatchingConfig.boundaryPattern);
                    log.info("  - Tokens: {}", smartMatchingConfig.boundaryTokens);
                    log.info("  - Strategies: {} available", (Object)(smartMatchingConfig.matchStrategies != null ? smartMatchingConfig.matchStrategies.size() : 0));
                    log.info("  - Confidence threshold: {}", (Object)smartMatchingConfig.confidenceThreshold);
                }
            }
            catch (Exception exception) {
                log.debug("[BoundaryReplace] Could not parse smart_matching config (non-fatal): {}", (Object)exception.getMessage());
            }
        }
        catch (Exception exception) {
            try {
                log.error("[BoundaryReplace] Failed to validate candidates: {}", (Object)exception.getMessage(), (Object)exception);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                String string9 = String.valueOf(exception.getMessage());
                if (string9.contains("HTTP 404")) {
                    validationEndpointDisabledDueTo404 = true;
                    if (!validationEndpointDisabledLogOnce) {
                        validationEndpointDisabledLogOnce = true;
                        log.warn("[BoundaryReplace] Disabling validation endpoint calls for this run (received HTTP 404). Using local boundary-aware replacement only.");
                    }
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static String stripTrailingSlashLocal(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private SmartMatchingConfig parseSmartMatchingConfig(String string) {
        try {
            String string2;
            int n = string.indexOf("\"smart_matching\"");
            if (n == -1) {
                return null;
            }
            int n2 = string.indexOf(123, n);
            if (n2 == -1) {
                return null;
            }
            int n3 = this.findMatchingBracket(string, n2);
            if (n3 == -1) {
                return null;
            }
            String string3 = string.substring(n2, n3 + 1);
            SmartMatchingConfig smartMatchingConfig = new SmartMatchingConfig();
            smartMatchingConfig.enabled = "true".equals(this.extractJsonStringViaRegex(string3, "enabled"));
            smartMatchingConfig.boundaryPattern = this.extractJsonStringViaRegex(string3, "boundary_pattern");
            smartMatchingConfig.normalizedPattern = this.extractJsonStringViaRegex(string3, "normalized_pattern");
            smartMatchingConfig.usageNote = this.extractJsonStringViaRegex(string3, "usage_note");
            String string4 = this.extractJsonStringViaRegex(string3, "confidence_threshold");
            if (string4 != null && !string4.isEmpty()) {
                try {
                    smartMatchingConfig.confidenceThreshold = Double.parseDouble(string4);
                }
                catch (Exception exception) {
                    smartMatchingConfig.confidenceThreshold = 0.55;
                }
            }
            if ((string2 = this.extractJsonStringViaRegex(string3, "proximity_chars")) != null && !string2.isEmpty()) {
                try {
                    smartMatchingConfig.proximityChars = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    smartMatchingConfig.proximityChars = 100;
                }
            }
            smartMatchingConfig.boundaryTokens = this.extractJsonStringArray(string3, "boundary_tokens");
            smartMatchingConfig.matchStrategies = this.parseMatchStrategies(string3);
            return smartMatchingConfig;
        }
        catch (Exception exception) {
            try {
                log.warn("[SmartMatching] Failed to parse smart_matching config: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    private List<MatchStrategy> parseMatchStrategies(String string) {
        ArrayList<MatchStrategy> arrayList = new ArrayList<MatchStrategy>();
        try {
            int n;
            int n2;
            int n3 = string.indexOf("\"match_strategies\"");
            if (n3 == -1) {
                return arrayList;
            }
            int n4 = string.indexOf(91, n3);
            if (n4 == -1) {
                return arrayList;
            }
            int n5 = this.findMatchingBracket(string, n4);
            if (n5 == -1) {
                return arrayList;
            }
            String string2 = string.substring(n4 + 1, n5);
            int n6 = 0;
            while (n6 < string2.length() && (n2 = string2.indexOf(123, n6)) != -1 && (n = this.findMatchingBracket(string2, n2)) != -1) {
                String string3 = string2.substring(n2, n + 1);
                MatchStrategy matchStrategy = new MatchStrategy();
                matchStrategy.type = this.extractJsonStringViaRegex(string3, "type");
                matchStrategy.pattern = this.extractJsonStringViaRegex(string3, "pattern");
                matchStrategy.token = this.extractJsonStringViaRegex(string3, "token");
                matchStrategy.description = this.extractJsonStringViaRegex(string3, "description");
                String string4 = this.extractJsonStringViaRegex(string3, "confidence");
                if (string4 != null && !string4.isEmpty()) {
                    try {
                        matchStrategy.confidence = Double.parseDouble(string4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                matchStrategy.tokens = this.extractJsonStringArray(string3, "tokens");
                arrayList.add(matchStrategy);
                n6 = n + 1;
            }
        }
        catch (Exception exception) {
            try {
                log.warn("[SmartMatching] Failed to parse match_strategies: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private List<String> extractJsonStringArray(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n;
            int n2;
            int n3 = string.indexOf("\"" + string2 + "\"");
            if (n3 == -1) {
                return arrayList;
            }
            int n4 = string.indexOf(91, n3);
            if (n4 == -1) {
                return arrayList;
            }
            int n5 = this.findMatchingBracket(string, n4);
            if (n5 == -1) {
                return arrayList;
            }
            String string3 = string.substring(n4 + 1, n5);
            int n6 = 0;
            while (n6 < string3.length() && (n2 = string3.indexOf(34, n6)) != -1 && (n = string3.indexOf(34, n2 + 1)) != -1) {
                String string4 = string3.substring(n2 + 1, n);
                arrayList.add(string4);
                n6 = n + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private String escapeJsonString(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String httpPost(String string, String string2) {
        Object object;
        Object object2;
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        try {
            object2 = AAA.AA();
            if (object2 != null && !((String)object2).trim().isEmpty()) {
                object = AAA.AAA();
                if ("Authorization".equalsIgnoreCase((String)object)) {
                    httpURLConnection.setRequestProperty("Authorization", "Bearer " + ((String)object2).trim());
                } else {
                    httpURLConnection.setRequestProperty((String)object, ((String)object2).trim());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(30000);
        object2 = httpURLConnection.getOutputStream();
        try {
            object = string2.getBytes(StandardCharsets.UTF_8);
            ((OutputStream)object2).write((byte[])object, 0, ((Object)object).length);
        }
        finally {
            if (object2 != null) {
                ((OutputStream)object2).close();
            }
        }
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            throw new Exception("HTTP " + n);
        }
        object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
        try {
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string3 = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string3.trim());
            }
            String string4 = stringBuilder.toString();
            return string4;
        }
        finally {
            ((BufferedReader)object).close();
        }
    }

    private void collectNodesPreOrder(JMeterTreeNode jMeterTreeNode, List<JMeterTreeNode> list) {
        if (jMeterTreeNode == null) {
            return;
        }
        list.add(jMeterTreeNode);
        for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
            this.collectNodesPreOrder((JMeterTreeNode)jMeterTreeNode.getChildAt(i), list);
        }
    }

    private JMeterTreeNode findSamplerByDcaiHeader(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            TestElement testElement;
            if (jMeterTreeNode == null || string == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && (testElement = (TestElement)object) instanceof Sampler && this.hasChildHeaderWithDcai(jMeterTreeNode, string)) {
                return jMeterTreeNode;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                JMeterTreeNode jMeterTreeNode2 = this.findSamplerByDcaiHeader((JMeterTreeNode)jMeterTreeNode.getChildAt(i), string);
                if (jMeterTreeNode2 == null) continue;
                return jMeterTreeNode2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean hasChildHeaderWithDcai(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                TestElement testElement;
                String string2;
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                Object object = jMeterTreeNode2.getUserObject();
                if (!(object instanceof TestElement) || (string2 = (testElement = (TestElement)object).getClass().getName()) == null || !string2.endsWith("HeaderManager")) continue;
                String string3 = testElement.toString();
                if (string3 != null && string3.contains("DCAI") && string3.contains(string)) {
                    return true;
                }
                String string4 = String.valueOf(testElement.getPropertyAsString("HeaderManager.headers"));
                if (string4 == null || !string4.contains(string)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private JMeterTreeNode findSamplerByHttpHeaderManager(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            TestElement testElement;
            if (jMeterTreeNode == null || string == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && (testElement = (TestElement)object) instanceof Sampler && this.hasChildHeaderWithDcai(jMeterTreeNode, string)) {
                return jMeterTreeNode;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                JMeterTreeNode jMeterTreeNode2 = this.findSamplerByHttpHeaderManager((JMeterTreeNode)jMeterTreeNode.getChildAt(i), string);
                if (jMeterTreeNode2 == null) continue;
                return jMeterTreeNode2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void setPendingBoundariesUrl(String string) {
        pendingBoundariesUrl = string;
    }

    private JMeterTreeNode findSamplerByUrlHeuristic(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            String string2;
            TestElement testElement;
            if (jMeterTreeNode == null || string == null || string.isEmpty()) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && (testElement = (TestElement)object) instanceof Sampler) {
                string2 = testElement.getPropertyAsString("HTTPSampler.path");
                if (string2 != null && !string2.isEmpty() && string.contains(string2)) {
                    return jMeterTreeNode;
                }
                String string3 = testElement.getPropertyAsString("HTTPSampler.domain");
                if (string3 != null && !string3.isEmpty() && string.contains(string3)) {
                    return jMeterTreeNode;
                }
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                string2 = this.findSamplerByUrlHeuristic((JMeterTreeNode)jMeterTreeNode.getChildAt(i), string);
                if (string2 == null) continue;
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String suggestJsonVarName(String string, String string2) {
        String string3 = this.extractJsonPathToken(string);
        String string4 = this.shortHash(string2);
        return ("LM_JSON_" + string3 + "_" + string4).toUpperCase(Locale.ROOT);
    }

    private String suggestRegexVarName(String string, String string2, String string3) {
        String string4 = this.extractBoundaryToken(string);
        if (string4 == null) {
            string4 = this.extractBoundaryToken(string2);
        }
        if (string4 == null) {
            string4 = "BOUNDARY";
        }
        String string5 = this.shortHash(string3);
        return ("LM_REGEX_" + string4 + "_" + string5).toUpperCase(Locale.ROOT);
    }

    private String extractJsonPathToken(String string) {
        if (string == null || string.trim().isEmpty()) {
            return "FIELD";
        }
        String string2 = string.trim();
        string2 = string2.replaceAll("\\['([^']+)'\\]", ".$1");
        string2 = string2.replaceAll("\\[\\\"([^\\\"]+)\\\"\\]", ".$1");
        if ((string2 = string2.replaceAll("\\[(\\d+)\\]", ".$1")).startsWith("$")) {
            string2 = string2.substring(1);
        }
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        if (string2.isEmpty()) {
            return "FIELD";
        }
        int n = string2.lastIndexOf(46);
        if (n >= 0 && n < string2.length() - 1) {
            string2 = string2.substring(n + 1);
        }
        return this.normaliseIdentifier(string2, "FIELD");
    }

    private String extractBoundaryToken(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string2 = string.replaceAll("[^A-Za-z0-9]+", " ").trim();
        if (string2.isEmpty()) {
            return null;
        }
        String[] stringArray = string2.split("\\s+");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string3 = stringArray[i];
            if (string3.length() < 3) continue;
            return this.normaliseIdentifier(string3, "BOUNDARY");
        }
        return null;
    }

    private String normaliseIdentifier(String string, String string2) {
        if (string == null) {
            string = "";
        }
        String string3 = string.replaceAll("[^A-Za-z0-9]", "_");
        string3 = string3.replaceAll("_+", "_");
        if ((string3 = string3.replaceAll("^_+|_+$", "")).isEmpty()) {
            string3 = string2;
        }
        if (string3.length() > 32) {
            string3 = string3.substring(string3.length() - 32);
        }
        return string3.toUpperCase(Locale.ROOT);
    }

    private String shortHash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = messageDigest.digest((string != null ? string : "DCAI").getBytes(StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder(10);
            for (int i = 0; i < 5 && i < byArray.length; ++i) {
                stringBuilder.append(String.format(Locale.ROOT, "%02X", byArray[i]));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return Long.toHexString(System.nanoTime()).toUpperCase(Locale.ROOT);
        }
    }

    private static String prettyPrintJson(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 64);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuilder.append(c);
                bl2 = false;
                continue;
            }
            if (c == '\\') {
                stringBuilder.append(c);
                bl2 = true;
                continue;
            }
            if (c == '\"') {
                stringBuilder.append(c);
                bl = !bl;
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case '[': 
                case '{': {
                    stringBuilder.append(c).append('\n');
                    GeminiSidePanel.appendSpaces(stringBuilder, n += 2);
                    continue block6;
                }
                case ']': 
                case '}': {
                    stringBuilder.append('\n');
                    n = Math.max(0, n - 2);
                    GeminiSidePanel.appendSpaces(stringBuilder, n);
                    stringBuilder.append(c);
                    continue block6;
                }
                case ',': {
                    stringBuilder.append(c).append('\n');
                    GeminiSidePanel.appendSpaces(stringBuilder, n);
                    continue block6;
                }
                case ':': {
                    stringBuilder.append(": ");
                    continue block6;
                }
                default: {
                    if (Character.isWhitespace(c)) continue block6;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void appendSpaces(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
    }

    private String extractFirstFencedCode(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2;
            Pattern pattern = Pattern.compile("```([a-zA-Z0-9_-]+)?\\s*\\n([\\s\\S]*?)```", 8);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find() && (string2 = matcher.group(2)) != null) {
                return string2.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void tryInsertFixSamplerFromReply(String string) {
        try {
            String string2 = this.extractFirstFencedCode(string);
            if (string2 == null || string2.isEmpty()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> {
            try {
                Object object;
                Object object2;
                GuiPackage guiPackage = GuiPackage.getInstance();
                if (guiPackage == null) {
                    return;
                }
                JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
                if (jMeterTreeModel == null) {
                    return;
                }
                JMeterTreeNode jMeterTreeNode = null;
                try {
                    jMeterTreeNode = guiPackage.getTreeListener().getCurrentNode();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (jMeterTreeNode == null) {
                    try {
                        object2 = guiPackage.getMainFrame().getTree();
                        Object object3 = object = object2 != null ? ((JTree)object2).getLastSelectedPathComponent() : null;
                        if (object instanceof JMeterTreeNode) {
                            jMeterTreeNode = (JMeterTreeNode)object;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (jMeterTreeNode == null) {
                    return;
                }
                object2 = jMeterTreeNode.getUserObject();
                if (!(object2 instanceof TestElement)) {
                    return;
                }
                object = (TestElement)object2;
                if (!(object instanceof Sampler)) {
                    return;
                }
                String string2 = object.getName();
                if (string2 == null) {
                    string2 = "(unnamed sampler)";
                }
                if (!string2.startsWith("[ORIGINAL] ")) {
                    object.setName("[ORIGINAL] " + string2);
                    try {
                        jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                JSR223Sampler jSR223Sampler = new JSR223Sampler();
                jSR223Sampler.setName("Fix: " + string2);
                jSR223Sampler.setScriptLanguage("groovy");
                String string3 = this.extractFirstFencedCode(string);
                if (string3 == null || string3.isEmpty()) {
                    return;
                }
                jSR223Sampler.setScript(string3);
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getParent();
                if (jMeterTreeNode2 == null) {
                    return;
                }
                jMeterTreeModel.addComponent((TestElement)jSR223Sampler, jMeterTreeNode2);
                this.updateStatus("Inserted fix as JSR223 Sampler", Color.GREEN);
            }
            catch (Throwable throwable) {
                this.updateStatus("Auto-insert failed: " + throwable.getMessage(), Color.RED);
            }
        });
    }

    private void insertPlaceholderUnderPendingSampler() {
        SwingUtilities.invokeLater(() -> {
            try {
                String string;
                Object object;
                Object object2;
                GuiPackage guiPackage = GuiPackage.getInstance();
                if (guiPackage == null) {
                    this.updateStatus("JMeter GUI not available", Color.RED);
                    return;
                }
                JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
                if (jMeterTreeModel == null) {
                    this.updateStatus("Tree model not available", Color.RED);
                    return;
                }
                JMeterTreeNode jMeterTreeNode = null;
                String string2 = pendingInsertTargetLabel;
                if (string2 != null && !string2.isEmpty()) {
                    jMeterTreeNode = this.findSamplerByLabel((JMeterTreeNode)jMeterTreeModel.getRoot(), string2);
                }
                if (jMeterTreeNode == null) {
                    try {
                        jMeterTreeNode = guiPackage.getTreeListener().getCurrentNode();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (jMeterTreeNode == null) {
                        try {
                            object2 = guiPackage.getMainFrame().getTree();
                            Object object3 = object = object2 != null ? ((JTree)object2).getLastSelectedPathComponent() : null;
                            if (object instanceof JMeterTreeNode) {
                                jMeterTreeNode = (JMeterTreeNode)object;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (jMeterTreeNode == null) {
                    this.updateStatus("No sampler selected/targeted", Color.ORANGE);
                    return;
                }
                object2 = jMeterTreeNode.getUserObject();
                if (!(object2 instanceof TestElement) || !((TestElement)object2 instanceof Sampler)) {
                    this.updateStatus("Target is not a sampler", Color.ORANGE);
                    return;
                }
                object = (TestElement)object2;
                String string3 = object.getName();
                if (string3 == null) {
                    string3 = "(unnamed sampler)";
                }
                String string4 = string = string3.startsWith("[ORIGINAL] ") ? string3.substring(11) : string3;
                if (!string3.startsWith("[ORIGINAL] ")) {
                    object.setName("[ORIGINAL] " + string);
                    try {
                        jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                JSR223Sampler jSR223Sampler = new JSR223Sampler();
                jSR223Sampler.setName("Fix: " + string);
                jSR223Sampler.setScriptLanguage("groovy");
                jSR223Sampler.setFilename("");
                jSR223Sampler.setScript("// Placeholder - your fix script goes here\n\nreturn null;");
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getParent();
                if (jMeterTreeNode2 == null) {
                    this.updateStatus("No parent to insert under", Color.ORANGE);
                    return;
                }
                jMeterTreeModel.addComponent((TestElement)jSR223Sampler, jMeterTreeNode2);
                try {
                    JTree jTree = guiPackage.getMainFrame().getTree();
                    TreePath treePath = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode2));
                    jTree.setSelectionPath(treePath);
                    jTree.scrollPathToVisible(treePath);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.updateStatus("Inserted placeholder under '" + string + "'", Color.GREEN);
            }
            catch (Throwable throwable) {
                this.updateStatus("Insert failed: " + throwable.getMessage(), Color.RED);
            }
        });
    }

    private JMeterTreeNode findSamplerByLabel(JMeterTreeNode jMeterTreeNode, String string) {
        try {
            TestElement testElement;
            if (jMeterTreeNode == null || string == null) {
                return null;
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement && (testElement = (TestElement)object) instanceof Sampler && string.equals(testElement.getName())) {
                return jMeterTreeNode;
            }
            for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
                JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
                JMeterTreeNode jMeterTreeNode3 = this.findSamplerByLabel(jMeterTreeNode2, string);
                if (jMeterTreeNode3 == null) continue;
                return jMeterTreeNode3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void setAgentsStatusText(String string) {
        try {
            if (this.agentsLabel != null) {
                this.agentsLabel.setText(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAgentIndicator(JLabel jLabel, boolean bl) {
        try {
            Icon icon = bl && this.statusIconGreen != null ? this.statusIconGreen : (!bl && this.statusIconRed != null ? this.statusIconRed : null);
            jLabel.setIcon(icon);
            jLabel.setForeground(Color.BLACK);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void warmAgentsAndUpdateStatusAsync() {
        this.executorService.submit(() -> {
            boolean bl = this.hasDispatchCredentials();
            SwingUtilities.invokeLater(() -> {
                this.setAgentIndicator(this.georgeStatus, bl);
                this.setAgentIndicator(this.rupertStatus, bl);
                this.setAgentIndicator(this.suzyStatus, bl);
                this.setAgentIndicator(this.carrieStatus, bl);
            });
        });
    }

    private boolean hasDispatchCredentials() {
        try {
            String string = JMeterUtils.getProperty((String)"dcai.account.api");
            return string != null && !string.trim().isEmpty();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$insertRegexUnderSamplerWithDcai$67(GuiPackage guiPackage, TreePath treePath, TreePath treePath2) {
        try {
            JTree jTree = guiPackage.getMainFrame().getTree();
            if (jTree != null) {
                jTree.setSelectionPath(treePath);
                jTree.expandPath(treePath);
                if (treePath2 != null) {
                    jTree.scrollPathToVisible(treePath2);
                } else {
                    jTree.scrollPathToVisible(treePath);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private /* synthetic */ void lambda$appendCarrieReplyToChat$63(String string, String string2, String string3, String string4, String string5) {
        this.insertRegexUnderSamplerWithDcai(string, string2, string3, string4, string5);
    }

    private static /* synthetic */ void lambda$insertJsonUnderSamplerWithDcai$57(GuiPackage guiPackage, TreePath treePath, TreePath treePath2) {
        try {
            JTree jTree = guiPackage.getMainFrame().getTree();
            if (jTree != null) {
                jTree.setSelectionPath(treePath);
                jTree.expandPath(treePath);
                if (treePath2 != null) {
                    jTree.scrollPathToVisible(treePath2);
                } else {
                    jTree.scrollPathToVisible(treePath);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        lastErrorDcaiHeader = null;
        remainingUnlockAttempts = 3;
        log = LogManager.getLogger(GeminiSidePanel.class);
        commonmarkChecked = false;
        commonmarkCorePresent = false;
        commonmarkTablesPresent = false;
        commonmarkAutolinkPresent = false;
        aiIconHtml = null;
        aiIconAttempted = false;
        aiIconUrl = null;
        pendingInsertTargetLabel = null;
        pendingInsertTargetNode = null;
        WARNING_COLOR = new Color(200, 0, 0);
        lastCarrieCorrelationJson = null;
        lastCarrieCorrelationEscalated = false;
        lastCarrieCorrelationIssue = false;
        lastCarrieCorrelationValue = null;
        lastCarrieCorrelationCause = null;
        lastCarrieCorrelationSample = null;
        lastCarrieCorrelationCandidateName = null;
        lastCarrieCandidatesToProcess = null;
        currentCandidateBeingProcessed = null;
        lastCarrieValueHadNotFoundPrefix = false;
        pendingBoundariesDcaiId = null;
        validationEndpointDisabledDueTo404 = false;
        validationEndpointDisabledLogOnce = false;
        pendingBoundariesUrl = null;
    }

    private static class ResponseWindow {
        final String segment;
        final String url;

        ResponseWindow(String string, String string2) {
            this.segment = string;
            this.url = string2;
        }
    }

    private static class CarrieCandidate {
        String name;
        String value;
        String location;
        String jsonPath;
        double valueUniquenessProb = 1.0;
        String leftBoundary;

        private CarrieCandidate() {
        }
    }

    private static final class CarrieBoundariesResult {
        final String mode;
        final String value;
        final String leftBoundary;
        final String rightBoundary;

        CarrieBoundariesResult(String string, String string2, String string3, String string4) {
            this.mode = string;
            this.value = string2;
            this.leftBoundary = string3;
            this.rightBoundary = string4;
        }
    }

    private static class ReplacementCandidateInfo {
        JMeterTreeNode node;
        String context;
        int valuePosition;
        String occurrenceId;

        private ReplacementCandidateInfo() {
        }
    }

    private static class ValidationResultInfo {
        String occurrenceId;
        boolean safeToReplace;
        boolean boundaryFound;
        double boundaryConfidence;
        String reason;

        private ValidationResultInfo() {
        }
    }

    private static class SmartMatchingConfig {
        boolean enabled;
        String boundaryPattern;
        List<String> boundaryTokens;
        String normalizedPattern;
        List<MatchStrategy> matchStrategies;
        double confidenceThreshold;
        int proximityChars;
        boolean caseSensitive;
        String usageNote;

        private SmartMatchingConfig() {
        }
    }

    private static class MatchStrategy {
        String type;
        String pattern;
        List<String> tokens;
        String token;
        String description;
        double confidence;

        private MatchStrategy() {
        }
    }

    static class DcaiAgentClient {
        private final String baseUrl;
        private final String apiKey;

        DcaiAgentClient(String string, String string2) {
            this.baseUrl = string;
            this.apiKey = string2;
        }

        String generateText(String string) {
            ChatResult chatResult = this.generateTextWithMeta(string);
            return chatResult != null ? chatResult.text : "";
        }

        ChatResult generateTextWithMeta(String string) {
            try {
                String string2 = this.safeProp("dcai.chat.mode", null);
                if (string2 == null || string2.trim().isEmpty()) {
                    string2 = this.baseUrl != null && this.baseUrl.toLowerCase().contains("peak3000") ? "billing" : "openai";
                }
                log.info("[DCAI Debug] Mode resolved: {} (baseUrl={})", (Object)string2, (Object)this.sampleForLog(this.baseUrl, 200));
                if ("billing".equalsIgnoreCase(string2)) {
                    return this.callBillingEndpoint(string);
                }
                return this.callOpenAiCompatible(string);
            }
            catch (Exception exception) {
                try {
                    log.info("[DCAI Debug] Request failed: {} - {}", (Object)exception.getClass().getSimpleName(), (Object)String.valueOf(exception.getMessage()));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return new ChatResult("Request failed: " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName()), null, null, null);
            }
        }

        private ChatResult callOpenAiCompatible(String string) {
            String string2;
            Object object;
            String string3 = this.safeProp("dcai.chat.openai.path", "/api/v1/chat/completions");
            String string4 = this.baseUrl.endsWith("/") ? this.baseUrl + this.trimLeadingSlash(string3) : this.baseUrl + string3;
            String string5 = this.toJsonPayload(string);
            int n = this.propInt("dcai.chat.connectTimeoutMs", 15000);
            int n2 = this.propInt("dcai.chat.readTimeoutMs", 30000);
            try {
                log.info("[DCAI Debug] OPENAI request config: path={} connectMs={} readMs={} keyFp={}", (Object)string3, (Object)n, (Object)n2, (Object)this.sampleForLog(GeminiSidePanel.sha256Hex(this.apiKey), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                log.info("[DCAI Debug] About to POST: url={} payloadLen={} payloadPreview={}", (Object)string4, (Object)(string5 != null ? string5.length() : -1), (Object)this.sampleForLog(string5, 400));
                object = this.findControlChars(string);
                if (!((String)object).isEmpty()) {
                    log.info("[DCAI Debug] Unescaped control chars detected in original prompt (hex): {}", object);
                }
                this.logPayloadToInfo("pre", string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(Math.max(1, n))).build();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(string4)).timeout(Duration.ofMillis(Math.max(1, n2))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(string5, StandardCharsets.UTF_8));
            AAA.A(builder, this.apiKey);
            HttpRequest httpRequest = builder.build();
            long l = System.nanoTime();
            HttpResponse<String> httpResponse = ((HttpClient)object).send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            long l2 = Math.round((double)(System.nanoTime() - l) / 1000000.0);
            try {
                this.logPayloadToInfo("resp", httpResponse == null ? "" : httpResponse.body());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                log.info("[DCAI Debug] OPENAI response: status={} elapsedMs={} bodyLen={}", (Object)(httpResponse != null ? httpResponse.statusCode() : -1), (Object)l2, (Object)(httpResponse != null && httpResponse.body() != null ? httpResponse.body().length() : -1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.propBool("dcai.debug.headers", false)) {
                this.logResponseHeaders("openai", httpResponse);
            }
            if (httpResponse.statusCode() != 200) {
                string2 = httpResponse != null ? httpResponse.body() : "";
                log.info("[DCAI Debug] Non-200 response: status={} bodyLen={} bodyPreview={}", (Object)(httpResponse != null ? httpResponse.statusCode() : -1), (Object)(string2 != null ? string2.length() : -1), (Object)this.sampleForLog(string2, 400));
                throw new IOException("HTTP " + (httpResponse != null ? httpResponse.statusCode() : -1) + ": " + string2);
            }
            string2 = this.extractAssistantMessage(httpResponse.body());
            return new ChatResult(string2, null, null, null);
        }

        private ChatResult callBillingEndpoint(String string) {
            int n;
            String string2 = this.safeProp("dcai.chat.billing.path", "/api/billing/usage/test-query");
            String string3 = this.safeProp("dcai.chat.agentType", "george");
            String string4 = this.baseUrl.endsWith("/") ? this.baseUrl + this.trimLeadingSlash(string2) : this.baseUrl + string2;
            String string5 = this.toBillingJsonPayload(string3, string);
            int n2 = this.propInt("dcai.chat.connectTimeoutMs", 15000);
            int n3 = this.propInt("dcai.chat.readTimeoutMs", 30000);
            try {
                log.info("[DCAI Debug] BILLING request config: path={} agentType={} connectMs={} readMs={} keyFp={}", (Object)string2, (Object)string3, (Object)n2, (Object)n3, (Object)this.sampleForLog(GeminiSidePanel.sha256Hex(this.apiKey), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                log.info("[DCAI Debug] Billing POST: url={} payloadLen={} payloadPreview={}", (Object)string4, (Object)(string5 != null ? string5.length() : -1), (Object)this.sampleForLog(string5, 400));
                this.logPayloadToInfo("billing-pre", string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(Math.max(1, n2))).build();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(string4)).timeout(Duration.ofMillis(Math.max(1, n3))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(string5, StandardCharsets.UTF_8));
            AAA.A(builder, this.apiKey);
            HttpRequest httpRequest = builder.build();
            long l = System.nanoTime();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            long l2 = Math.round((double)(System.nanoTime() - l) / 1000000.0);
            String string6 = httpResponse != null ? httpResponse.body() : "";
            try {
                this.logPayloadToInfo("billing-resp", string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                log.info("[DCAI Debug] BILLING response: status={} elapsedMs={} bodyLen={}", (Object)(httpResponse != null ? httpResponse.statusCode() : -1), (Object)l2, (Object)(string6 != null ? string6.length() : -1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.propBool("dcai.debug.headers", false)) {
                this.logResponseHeaders("billing", httpResponse);
            }
            int n4 = n = httpResponse != null ? httpResponse.statusCode() : -1;
            if (n == 429) {
                String string7 = this.extractJsonStringField(string6, "message");
                if (string7 == null || string7.isEmpty()) {
                    string7 = "Query limit exceeded";
                }
                String string8 = this.extractJsonStringField(string6, "free_remaining");
                String string9 = this.extractJsonStringField(string6, "paid_queries");
                return new ChatResult("\u274c " + string7, string8, string9, "blocked");
            }
            if (n != 200) {
                throw new IOException("HTTP " + n + ": " + string6);
            }
            String string10 = this.extractJsonStringField(string6, "response");
            if (string10 == null || string10.isEmpty()) {
                string10 = string6;
            }
            String string11 = this.firstHeader(httpResponse, "X-Free-Queries-Remaining");
            String string12 = this.firstHeader(httpResponse, "X-Paid-Queries-Available");
            String string13 = this.firstHeader(httpResponse, "X-Query-Type");
            return new ChatResult(string10, string11, string12, string13);
        }

        private String firstHeader(HttpResponse<String> httpResponse, String string) {
            try {
                if (httpResponse == null || httpResponse.headers() == null) {
                    return null;
                }
                Optional<String> optional = httpResponse.headers().firstValue(string);
                return optional.orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private String safeProp(String string, String string2) {
            try {
                String string3 = JMeterUtils.getProperty((String)string);
                if (string3 == null || string3.trim().isEmpty()) {
                    return string2;
                }
                return string3.trim();
            }
            catch (Throwable throwable) {
                return string2;
            }
        }

        private String trimLeadingSlash(String string) {
            if (string == null || string.isEmpty()) {
                return "";
            }
            return string.startsWith("/") ? string.substring(1) : string;
        }

        private String toJsonPayload(String string) {
            String string2 = this.escapeForJson(string);
            return "{\n  \"messages\": [ { \"role\": \"user\", \"content\": \"" + string2 + "\" } ],\n  \"stream\": false,\n  \"include_retrieval_info\": true,\n  \"include_functions_info\": false,\n  \"include_guardrails_info\": false\n}";
        }

        private String escapeForJson(String string) {
            if (string == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
            block9: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        stringBuilder.append("\\\\");
                        continue block9;
                    }
                    case '\"': {
                        stringBuilder.append("\\\"");
                        continue block9;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        continue block9;
                    }
                    case '\b': {
                        stringBuilder.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        stringBuilder.append("\\f");
                        continue block9;
                    }
                    default: {
                        if (c == '\u2028' || c == '\u2029') {
                            stringBuilder.append(String.format("\\u%04x", c));
                            continue block9;
                        }
                        if (c < ' ') {
                            stringBuilder.append(String.format("\\u%04x", c));
                            continue block9;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }

        private String toBillingJsonPayload(String string, String string2) {
            String string3 = this.escapeForJson(string2);
            String string4 = this.escapeForJson(string);
            return "{\n  \"agent_type\": \"" + string4 + "\",\n  \"query\": \"" + string3 + "\"\n}";
        }

        private String findControlChars(String string) {
            if (string == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ') continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(String.format("%04x(@%d)", c, i));
            }
            return stringBuilder.toString();
        }

        private int extractBodyIndex(String string) {
            if (string == null) {
                return -1;
            }
            try {
                int n = string.indexOf("\"loc\"");
                if (n < 0) {
                    return -1;
                }
                int n2 = string.indexOf("\"body\"", n);
                if (n2 < 0) {
                    return -1;
                }
                int n3 = string.indexOf(44, n2);
                if (n3 < 0) {
                    return -1;
                }
                int n4 = string.indexOf(93, n3);
                if (n4 < 0) {
                    return -1;
                }
                String string2 = string.substring(n3 + 1, n4).replaceAll("[^0-9]", "").trim();
                if (string2.isEmpty()) {
                    return -1;
                }
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        private String sampleForLog(String string, int n) {
            if (string == null) {
                return "";
            }
            if (string.length() <= n) {
                return string;
            }
            return string.substring(0, Math.max(0, n)) + "\u2026(" + string.length() + ")";
        }

        private String sampleAround(String string, int n, int n2) {
            if (string == null) {
                return "";
            }
            int n3 = Math.max(0, n - n2);
            int n4 = Math.min(string.length(), n + n2);
            return string.substring(n3, n4);
        }

        private String sampleAroundHex(String string, int n, int n2) {
            if (string == null) {
                return "";
            }
            int n3 = Math.max(0, n - n2);
            int n4 = Math.min(string.length(), n + n2);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n3; i < n4; ++i) {
                char c = string.charAt(i);
                if (i > n3) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(String.format("%02x", c));
            }
            return stringBuilder.toString();
        }

        private void logPayloadToInfo(String string, String string2) {
            if (string2 == null) {
                string2 = "";
            }
            log.info("[DCAI Debug] Payload [{}] totalLen={}", (Object)string, (Object)string2.length());
            for (int i = 0; i < string2.length(); i += 2000) {
                int n = Math.min(string2.length(), i + 2000);
                String string3 = string2.substring(i, n);
                log.info("[DCAI Debug] Payload [{}] chunk {}-{}:\n{}", (Object)string, (Object)i, (Object)n, (Object)string3);
            }
        }

        private String extractAssistantMessage(String string) {
            if (string == null || string.isEmpty()) {
                return "";
            }
            int n = string.indexOf("\"choices\"");
            if (n < 0) {
                return string;
            }
            int n2 = string.indexOf("\"message\"", n);
            if (n2 < 0) {
                return string;
            }
            int n3 = string.indexOf("\"content\"", n2);
            if (n3 < 0) {
                return string;
            }
            int n4 = string.indexOf(":", n3);
            int n5 = string.indexOf(34, n4 + 1);
            int n6 = -1;
            boolean bl = false;
            for (int i = n5 + 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"' && !bl) {
                    n6 = i;
                    break;
                }
                boolean bl2 = bl = c == '\\' && !bl;
                if (c == '\\') continue;
                bl = false;
            }
            if (n5 > 0 && n6 > n5) {
                String string2 = string.substring(n5 + 1, n6);
                return string2.replace("\\n", "\n").replace("\\\"", "\"").replace("\\/", "/").replace("\\t", "\t");
            }
            return string;
        }

        private String extractJsonStringField(String string, String string2) {
            if (string == null || string2 == null) {
                return null;
            }
            try {
                String string3 = "\"" + string2 + "\"";
                int n = string.indexOf(string3);
                if (n < 0) {
                    return null;
                }
                int n2 = string.indexOf(":", n + string3.length());
                if (n2 < 0) {
                    return null;
                }
                int n3 = string.indexOf(34, n2 + 1);
                if (n3 < 0) {
                    return null;
                }
                int n4 = -1;
                boolean bl = false;
                for (int i = n3 + 1; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\"' && !bl) {
                        n4 = i;
                        break;
                    }
                    boolean bl2 = bl = c == '\\' && !bl;
                    if (c == '\\') continue;
                    bl = false;
                }
                if (n3 > 0 && n4 > n3) {
                    String string4 = string.substring(n3 + 1, n4);
                    return string4.replace("\\n", "\n").replace("\\\"", "\"").replace("\\/", "/").replace("\\t", "\t");
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private int propInt(String string, int n) {
            try {
                String string2 = JMeterUtils.getProperty((String)string);
                if (string2 == null) {
                    return n;
                }
                if ((string2 = string2.trim()).isEmpty()) {
                    return n;
                }
                return Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                return n;
            }
        }

        private boolean propBool(String string, boolean bl) {
            try {
                String string2 = JMeterUtils.getProperty((String)string);
                if (string2 == null) {
                    return bl;
                }
                if ("true".equals(string2 = string2.trim().toLowerCase()) || "1".equals(string2) || "yes".equals(string2) || "on".equals(string2)) {
                    return true;
                }
                if ("false".equals(string2) || "0".equals(string2) || "no".equals(string2) || "off".equals(string2)) {
                    return false;
                }
                return bl;
            }
            catch (Throwable throwable) {
                return bl;
            }
        }

        private void logResponseHeaders(String string, HttpResponse<String> httpResponse) {
            try {
                if (httpResponse == null || httpResponse.headers() == null) {
                    return;
                }
                Map<String, List<String>> map = httpResponse.headers().map();
                log.info("[DCAI Debug] {} headers ({}):", (Object)string, (Object)(map != null ? map.size() : 0));
                if (map != null) {
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        String string2;
                        String string3 = entry.getKey();
                        String string4 = string2 = entry.getValue() != null && !entry.getValue().isEmpty() ? String.valueOf(entry.getValue()) : "[]";
                        if (string3 != null && string3.toLowerCase().contains("authorization")) {
                            string2 = "[REDACTED]";
                        }
                        log.info("[DCAI Debug]   {}: {}", (Object)string3, (Object)this.sampleForLog(string2, 300));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static class ChatResult {
            final String text;
            final String freeRemaining;
            final String paidAvailable;
            final String queryType;

            ChatResult(String string, String string2, String string3, String string4) {
                this.text = string == null ? "" : string;
                this.freeRemaining = string2;
                this.paidAvailable = string3;
                this.queryType = string4;
            }
        }
    }
}

