/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.A;
import com.company.AA;
import com.company.AAA;
import com.company.GeminiSidePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.LayerUI;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.Utilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.gui.RegexExtractorGui;
import org.apache.jmeter.extractor.json.jsonpath.JSONPostProcessor;
import org.apache.jmeter.extractor.json.jsonpath.gui.JSONPostProcessorGui;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.Copy;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.java.sampler.JSR223Sampler;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DCAIResultsVisualizer
extends AbstractVisualizer
implements SampleListener {
    private final DefaultListModel<SampleEntry> sampleListModel = new DefaultListModel();
    private static final Logger log = LogManager.getLogger(DCAIResultsVisualizer.class);
    private JList<SampleEntry> sampleList;
    private JTextArea requestHeadersArea;
    private JTextArea requestBodyArea;
    private JEditorPane responseHeadersPane;
    private JTextArea regexSelectorArea;
    private JLayer<JTextArea> regexSelectorLayer;
    private RegexBoundaryLayerUI regexLayerUI;
    private JButton confirmRegexButton;
    private JPanel regexSelectorPanel;
    private JTabbedPane responseTabs;
    private JTabbedPane detailTabs;
    private JTree jsonTree;
    private JScrollPane jsonTreeScrollPane;
    private JTextField jsonPathField;
    private JButton copyPathButton;
    private Object objectMapper;
    private JEditorPane jsonValuePane;
    private JSplitPane mainSplitPane;
    private double dividerRatio = 0.33;
    private int dividerLocationPx = -1;
    private volatile boolean userAdjustingDivider = false;
    private volatile boolean programmaticAdjust = false;
    private JCheckBox sendErrorsCheckbox;
    private JCheckBox includeCookiesCheckbox;
    private JButton sendToChatButton;
    private final DateTimeFormatter timeFmt = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private ResultCollector collector;
    private static final Object AUTO_SEND_GUARD;
    private static volatile boolean autoSendInFlight;
    private static volatile long lastAutoSendMs;
    private static final long MIN_AUTO_SEND_INTERVAL_MS = 5000L;
    private static final Set<String> SENT_TEST_START_IDS;
    private static volatile boolean sentWithoutTestStartId;
    private volatile SampleEntry currentSelectedEntry;
    private volatile String cachedJsonSource;
    private volatile DefaultMutableTreeNode cachedJsonTree;
    private volatile Thread jsonParseThread;
    private final AtomicLong selectionSeq = new AtomicLong(0L);
    private volatile long lastRegexUpdateSeq = -1L;
    private volatile int lastRegexHash = 0;
    private static final int REGEX_LARGE_THRESHOLD = 100000;
    private volatile boolean regexTabInitialized = false;
    private Timer regexUpdateTimer;
    private volatile String pendingRegexText = null;
    private volatile long pendingRegexSeq = -1L;
    private boolean rstaAvailable = false;
    private Class<?> rstaClass;
    private volatile boolean regexPreviewMode = true;
    private volatile String currentRegexFullText = "";
    private JButton prevChunkButton;
    private JButton nextChunkButton;
    private JLabel chunkInfoLabel;
    private int regexChunkStart = 0;
    private static final int REGEX_CHUNK_SIZE = 50000;
    private static final int REGEX_CHUNK_OVERLAP = 2048;
    private static volatile Long lastCorrelationAttemptId;
    private static volatile Long lastCorrelationSessionId;
    private static volatile String lastCorrelationDcaiHeader;
    private static volatile String lastCorrelationCandidateValue;
    private static volatile Long lastCorrelationTimestamp;
    private static volatile String lastCorrelationHarFilename;
    private static volatile Map<String, Long> lastCorrelationAttemptsByName;
    private static volatile String lastCarrieResponseJson;

    public DCAIResultsVisualizer() {
        this.init();
    }

    public String getStaticLabel() {
        return "Load Magic Results Visualiser";
    }

    public String getLabelResource() {
        return "dc_ai_results_visualizer";
    }

    public void add(SampleResult sampleResult) {
        this.sampleOccurred(new SampleEvent(sampleResult, this.getName()));
    }

    public void sampleOccurred(SampleEvent sampleEvent) {
        SampleResult sampleResult = sampleEvent.getResult();
        try {
            if (sampleEvent.isTransactionSampleEvent()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (sampleResult != null && TransactionController.isFromTransactionController((SampleResult)sampleResult)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (DCAIResultsVisualizer.isTransactionAggregate(sampleResult)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            String string;
            SampleEntry sampleEntry = SampleEntry.from(sampleResult);
            this.sampleListModel.addElement(sampleEntry);
            try {
                if (!sampleResult.isSuccessful()) {
                    String string2 = GeminiSidePanel.getPendingInsertTargetLabel();
                    if (string2 == null || string2.trim().isEmpty()) {
                        GeminiSidePanel.setPendingInsertTargetLabel(sampleEntry.label);
                        Object object = string = this.shouldSendToScript(sampleEntry) ? this.findJSR223SamplerForEntry(sampleEntry) : this.findSamplerBySelectedEntry(sampleEntry);
                        if (string != null) {
                            GeminiSidePanel.setPendingInsertTargetNode((JMeterTreeNode)string);
                            try {
                                log.info("[DCAIResultsVisualizer] Set first error target: {} (node captured, type={})", (Object)sampleEntry.label, (Object)string.getTestElement().getClass().getSimpleName());
                            }
                            catch (Exception exception) {}
                        } else {
                            try {
                                log.warn("[DCAIResultsVisualizer] Could not find node for first error: {}", (Object)sampleEntry.label);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        try {
                            log.info("[DCAIResultsVisualizer] Skipping subsequent error target: {} (first error: {})", (Object)sampleEntry.label, (Object)string2);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.shouldAutoSendErrors() && !sampleResult.isSuccessful() && !DCAIResultsVisualizer.isTransactionAggregate(sampleResult)) {
                boolean bl = false;
                string = DCAIResultsVisualizer.getCurrentTestStartMs();
                Object object = AUTO_SEND_GUARD;
                synchronized (object) {
                    if (string != null && !string.isEmpty()) {
                        if (!SENT_TEST_START_IDS.contains(string)) {
                            SENT_TEST_START_IDS.add(string);
                            bl = true;
                        }
                    } else if (!sentWithoutTestStartId) {
                        sentWithoutTestStartId = true;
                        bl = true;
                    }
                }
                if (bl) {
                    object = GeminiSidePanel.getInstance();
                    if (this.shouldSendToScript(sampleEntry)) {
                        String string3 = this.extractCleanError(sampleEntry);
                        String string4 = this.extractScriptFromRequest(sampleEntry);
                        ((GeminiSidePanel)object).showScriptTabWithFixModeAndAutoInsert(string3, string4);
                    } else {
                        this.sendToCarrie(sampleEntry, true);
                    }
                    try {
                        log.info("Auto-send executed for TESTSTART.MS='{}'", (Object)String.valueOf(string));
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        log.info("Auto-send limited: already sent for TESTSTART.MS='{}'", (Object)String.valueOf(string));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void sampleStarted(SampleEvent sampleEvent) {
    }

    private void duplicateSamplerForEntry(SampleEntry sampleEntry) {
        block21: {
            try {
                String string;
                JMeterTreeNode jMeterTreeNode;
                JMeterTreeNode jMeterTreeNode2 = this.findSamplerBySelectedEntry(sampleEntry);
                if (jMeterTreeNode2 == null) {
                    return;
                }
                JMeterTreeNode jMeterTreeNode3 = (JMeterTreeNode)jMeterTreeNode2.getParent();
                if (jMeterTreeNode3 == null) {
                    return;
                }
                String string2 = jMeterTreeNode2.getName();
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.startsWith("[DCAI] ") || string2.startsWith("[Load Magic] ")) {
                    return;
                }
                String string3 = string2.startsWith("[ORIGINAL] ") ? string2.substring("[ORIGINAL] ".length()) : string2;
                String string4 = "[Load Magic] " + string3;
                String string5 = "[DCAI] " + string3;
                for (int i = 0; i < jMeterTreeNode3.getChildCount(); ++i) {
                    jMeterTreeNode = (JMeterTreeNode)jMeterTreeNode3.getChildAt(i);
                    string = jMeterTreeNode.getName();
                    if (!string4.equals(string) && !string5.equals(string)) continue;
                    if (!string2.startsWith("[ORIGINAL] ")) {
                        jMeterTreeNode2.setName("[ORIGINAL] " + string3);
                        try {
                            jMeterTreeNode2.nameChanged();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return;
                }
                JMeterTreeNode jMeterTreeNode4 = Copy.cloneTreeNode((JMeterTreeNode)jMeterTreeNode2);
                if (jMeterTreeNode4 == null) break block21;
                jMeterTreeNode4.setName(string4);
                jMeterTreeNode = GuiPackage.getInstance();
                if (jMeterTreeNode == null) {
                    return;
                }
                string = jMeterTreeNode.getTreeModel();
                int n = jMeterTreeNode3.getIndex((TreeNode)jMeterTreeNode2) + 1;
                string.insertNodeInto((MutableTreeNode)jMeterTreeNode4, (MutableTreeNode)jMeterTreeNode3, n);
                try {
                    if (jMeterTreeNode4.getTestElement() instanceof JSR223Sampler) {
                        JSR223Sampler jSR223Sampler = (JSR223Sampler)jMeterTreeNode4.getTestElement();
                        SwingUtilities.invokeLater(() -> DCAIResultsVisualizer.lambda$duplicateSamplerForEntry$2((JMeterTreeModel)string, jMeterTreeNode4, (GuiPackage)jMeterTreeNode, jSR223Sampler));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    jMeterTreeNode4.nameChanged();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!string2.startsWith("[ORIGINAL] ")) {
                    jMeterTreeNode2.setName("[ORIGINAL] " + string3);
                    try {
                        jMeterTreeNode2.nameChanged();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    jMeterTreeNode.getMainFrame().repaint();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sampleStopped(SampleEvent sampleEvent) {
    }

    public Collection<String> getMenuCategories() {
        return Collections.singletonList("menu_listener");
    }

    public TestElement createTestElement() {
        this.collector = new ResultCollector();
        this.modifyTestElement((TestElement)this.collector);
        return this.collector;
    }

    public void modifyTestElement(TestElement testElement) {
        super.configureTestElement(testElement);
        if (testElement instanceof ResultCollector) {
            ((ResultCollector)testElement).setListener((Visualizer)this);
        }
    }

    public void clearData() {
        this.sampleListModel.clear();
        if (this.requestHeadersArea != null) {
            this.requestHeadersArea.setText("");
        }
        if (this.requestBodyArea != null) {
            this.requestBodyArea.setText("");
        }
        if (this.responseHeadersPane != null) {
            this.responseHeadersPane.setText("<html><body></body></html>");
        }
        try {
            if (this.jsonTree != null) {
                this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
            }
            if (this.jsonPathField != null) {
                this.jsonPathField.setText("");
            }
            if (this.jsonValuePane != null) {
                this.jsonValuePane.setText("<html><body style='margin:6px;'><i>Select a node to view its JSON</i></body></html>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GeminiSidePanel.clearPendingInsertTargetLabel();
            log.info("[DCAIResultsVisualizer] Cleared pending insert target on clearData()");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        Serializable serializable;
        Serializable serializable2;
        JTabbedPane jTabbedPane;
        Serializable serializable3;
        this.setLayout(new BorderLayout(6, 6));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.sampleList = new JList<SampleEntry>(this.sampleListModel);
        this.sampleList.setCellRenderer(new SampleEntryRenderer());
        this.sampleList.setSelectionMode(0);
        try {
            serializable3 = UIManager.getFont("TextArea.font");
            if (serializable3 != null) {
                this.sampleList.setFont((Font)serializable3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sampleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    DCAIResultsVisualizer.this.onSelectionChanged();
                }
            }
        });
        serializable3 = new JScrollPane(this.sampleList);
        ((JComponent)serializable3).setPreferredSize(new Dimension(280, 400));
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 6));
        this.detailTabs = jTabbedPane = new JTabbedPane();
        this.requestHeadersArea = new JTextArea();
        this.requestHeadersArea.setEditable(false);
        this.requestHeadersArea.setLineWrap(true);
        this.requestHeadersArea.setWrapStyleWord(true);
        this.requestBodyArea = new JTextArea();
        this.requestBodyArea.setEditable(false);
        this.requestBodyArea.setLineWrap(true);
        this.requestBodyArea.setWrapStyleWord(true);
        try {
            serializable2 = UIManager.getFont("TextArea.font");
            if (serializable2 != null) {
                this.requestHeadersArea.setFont((Font)serializable2);
                this.requestBodyArea.setFont((Font)serializable2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable2 = new JTabbedPane();
        JScrollPane jScrollPane = new JScrollPane(this.requestHeadersArea);
        try {
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JScrollPane jScrollPane2 = new JScrollPane(this.requestBodyArea);
        try {
            jScrollPane2.getVerticalScrollBar().setUnitIncrement(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JTabbedPane)serializable2).addTab("Headers", jScrollPane);
        ((JTabbedPane)serializable2).addTab("Body", jScrollPane2);
        jTabbedPane.addTab("Request", (Component)serializable2);
        this.responseHeadersPane = new JEditorPane();
        this.responseHeadersPane.setEditable(false);
        this.responseHeadersPane.setContentType("text/html");
        try {
            this.responseHeadersPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.responseHeadersPane.setFont(UIManager.getFont("TextArea.font"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serializable = Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            this.objectMapper = ((Class)serializable).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            this.objectMapper = null;
        }
        serializable = new JTabbedPane();
        ((JTabbedPane)serializable).addTab("Headers", new JScrollPane(this.responseHeadersPane));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel("<html><div style='padding:8px;'>JSON Viewer initialises on first open...</div></html>"), "Center");
        ((JTabbedPane)serializable).addTab("JSON Viewer", jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel("<html><div style='padding:8px;'>Regex Selector initialises on first open...</div></html>"), "Center");
        ((JTabbedPane)serializable).addTab("Regex Selector", jPanel4);
        ((JTabbedPane)serializable).addChangeListener(changeEvent -> {
            int n = ((JTabbedPane)changeEvent.getSource()).getSelectedIndex();
            String string = ((JTabbedPane)changeEvent.getSource()).getTitleAt(n);
            if ("JSON Viewer".equals(string)) {
                this.ensureJsonTabInitialised((JTabbedPane)changeEvent.getSource(), n);
                SampleEntry sampleEntry = this.sampleList.getSelectedValue();
                if (sampleEntry != null) {
                    this.lazyPopulateJsonForSelection(sampleEntry);
                }
            } else if ("Regex Selector".equals(string)) {
                this.ensureRegexTabInitialised((JTabbedPane)changeEvent.getSource(), n);
                SampleEntry sampleEntry = this.sampleList.getSelectedValue();
                if (sampleEntry != null) {
                    this.updateRegexSelectorText(sampleEntry.responseBody == null ? "" : sampleEntry.responseBody);
                }
            }
        });
        this.responseTabs = serializable;
        jTabbedPane.addTab("Response", (Component)serializable);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 6, 2));
        this.sendErrorsCheckbox = new JCheckBox("Send Errors to Load Magic");
        this.sendErrorsCheckbox.setSelected(false);
        this.includeCookiesCheckbox = new JCheckBox("Include cookies");
        this.includeCookiesCheckbox.setSelected(false);
        this.sendToChatButton = new JButton("Send selected");
        this.sendToChatButton.addActionListener(actionEvent -> this.sendSelectedSmart());
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(actionEvent -> this.clearData());
        jPanel5.add(this.sendErrorsCheckbox);
        jPanel5.add(this.includeCookiesCheckbox);
        jPanel5.add(this.sendToChatButton);
        jPanel5.add(jButton);
        jPanel2.add((Component)jPanel5, "North");
        jPanel2.add((Component)jTabbedPane, "Center");
        try {
            jTabbedPane.setSelectedIndex(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSplitPane jSplitPane = new JSplitPane(1, (Component)serializable3, jPanel2);
        jSplitPane.setResizeWeight(0.3);
        jSplitPane.setPreferredSize(new Dimension(800, 400));
        jSplitPane.setMinimumSize(new Dimension(600, 300));
        jSplitPane.setDividerLocation(280);
        this.mainSplitPane = jSplitPane;
        jPanel.add((Component)jSplitPane, "Center");
        this.add(jPanel, "Center");
        try {
            GeminiSidePanel.setRegexInsertHandler((string, string2) -> {
                try {
                    SampleEntry sampleEntry = this.sampleList.getSelectedValue();
                    if (sampleEntry == null) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Select a sample entry first.", "No Sample Selected", 1);
                        return;
                    }
                    this.insertRegexExtractor(sampleEntry, (String)string, (String)string2);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Error inserting regex: " + exception.getMessage(), "Error", 0);
                }
            }, () -> {
                try {
                    String string = this.regexSelectorArea != null ? this.regexSelectorArea.getText() : null;
                    String string2 = string != null && string.length() > 0 ? string : "";
                    SampleEntry sampleEntry = this.sampleList.getSelectedValue();
                    String string3 = this.suggestVariableNameFromRegex(string2, sampleEntry);
                    return string3;
                }
                catch (Exception exception) {
                    return "DCAI_REGEX_VAR";
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onSelectionChanged() {
        String string;
        long l = System.currentTimeMillis();
        SampleEntry sampleEntry = this.sampleList.getSelectedValue();
        long l2 = this.selectionSeq.incrementAndGet();
        this.currentSelectedEntry = sampleEntry;
        if (sampleEntry == null) {
            this.requestHeadersArea.setText("");
            this.requestBodyArea.setText("");
            this.responseHeadersPane.setText("<html><body></body></html>");
            this.updateRegexSelectorText("");
            return;
        }
        long l3 = System.currentTimeMillis();
        this.requestHeadersArea.setText(sampleEntry.requestHeaders);
        this.requestBodyArea.setText(sampleEntry.requestBody);
        long l4 = System.currentTimeMillis();
        this.setResponseHeadersHtml(sampleEntry);
        long l5 = System.currentTimeMillis();
        try {
            log.info("=== JSON Viewer Debug ===");
            log.info("ObjectMapper available: {}", (Object)(this.objectMapper != null ? 1 : 0));
            if (sampleEntry.responseBody != null) {
                string = sampleEntry.responseBody.length() > 80 ? sampleEntry.responseBody.substring(0, 80) : sampleEntry.responseBody;
                log.info("Response body length: {}", (Object)sampleEntry.responseBody.length());
                log.info("Response starts with: {}", (Object)string.replace('\n', ' ').replace('\r', ' '));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isJsonTabActive()) {
            long l6 = System.currentTimeMillis();
            this.lazyPopulateJsonForSelection(sampleEntry, l2);
            long l7 = System.currentTimeMillis();
            try {
                log.info("Perf(JSON lazy): {} ms", (Object)(l7 - l6));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = sampleEntry.responseBody == null ? "" : sampleEntry.responseBody;
        long l8 = System.currentTimeMillis();
        if (this.isRegexTabActive()) {
            this.scheduleRegexUpdate(string, l2);
        }
        long l9 = System.currentTimeMillis();
        try {
            log.info("Perf(Selection): total={}ms, setReq={}ms, headersHtml={}ms, regexUpdate={}ms, bodySize={} chars", (Object)(System.currentTimeMillis() - l), (Object)(l4 - l3), (Object)(l5 - l4), (Object)(l9 - l8), (Object)(string == null ? 0 : string.length()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.jsonTree != null && this.jsonTree.getModel() != null && this.jsonTree.getModel().getRoot() != null) {
                log.info("Tree root: {}", (Object)this.jsonTree.getModel().getRoot().toString());
            }
            log.info("=========================");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestHeadersArea.setCaretPosition(0);
        this.requestBodyArea.setCaretPosition(0);
        this.responseHeadersPane.setCaretPosition(0);
    }

    private boolean isRegexTabActive() {
        try {
            if (this.responseTabs == null) {
                return false;
            }
            int n = this.responseTabs.getSelectedIndex();
            return n >= 0 && "Regex Selector".equals(this.responseTabs.getTitleAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void scheduleRegexUpdate(String string, long l) {
        try {
            this.pendingRegexText = string == null ? "" : string;
            this.pendingRegexSeq = l;
            if (this.regexUpdateTimer == null) {
                this.regexUpdateTimer = new Timer(120, actionEvent -> {
                    try {
                        if (this.pendingRegexText == null) {
                            return;
                        }
                        if (this.pendingRegexSeq != this.selectionSeq.get()) {
                            return;
                        }
                        if (!this.isRegexTabActive()) {
                            return;
                        }
                        String string = this.pendingRegexText;
                        this.pendingRegexText = null;
                        this.updateRegexSelectorText(string);
                        this.lastRegexHash = this.stableHash(string);
                        this.lastRegexUpdateSeq = this.selectionSeq.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                this.regexUpdateTimer.setRepeats(false);
            }
            if (this.regexUpdateTimer.isRunning()) {
                this.regexUpdateTimer.stop();
            }
            this.regexUpdateTimer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean shouldSkipRegexUpdate(String string) {
        try {
            if (string == null) {
                return false;
            }
            if (string.length() < 100000) {
                return false;
            }
            int n = this.stableHash(string);
            return this.lastRegexUpdateSeq == this.selectionSeq.get() && n == this.lastRegexHash;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int stableHash(String string) {
        int n = 1;
        for (int i = 0; i < string.length(); i += 1024) {
            int n2 = Math.min(i + 1024, string.length());
            for (int j = i; j < n2; ++j) {
                n = 31 * n + string.charAt(j);
            }
        }
        n = 31 * n + string.length();
        return n;
    }

    private boolean isJsonTabActive() {
        try {
            if (this.responseTabs == null) {
                return false;
            }
            int n = this.responseTabs.getSelectedIndex();
            return n >= 0 && "JSON Viewer".equals(this.responseTabs.getTitleAt(n));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void ensureJsonTabInitialised(JTabbedPane jTabbedPane, int n) {
        try {
            Serializable serializable;
            if (this.jsonTree != null && this.jsonValuePane != null) {
                return;
            }
            this.jsonTree = new JTree();
            this.jsonTree.setRootVisible(false);
            this.jsonTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DCAIResultsVisualizer.this.updateJsonPath();
                    DCAIResultsVisualizer.this.updateJsonValuePane();
                }
            });
            this.jsonTreeScrollPane = new JScrollPane(this.jsonTree);
            JPanel jPanel = new JPanel(new BorderLayout(4, 4));
            jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.jsonPathField = new JTextField();
            this.jsonPathField.setEditable(false);
            try {
                serializable = UIManager.getFont("TextArea.font");
                if (serializable != null) {
                    this.jsonPathField.setFont((Font)serializable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.copyPathButton = new JButton("Copy Path");
            this.copyPathButton.addActionListener(actionEvent -> this.copyJsonPathToClipboard());
            jPanel.add((Component)new JLabel("JSONPath:"), "West");
            jPanel.add((Component)this.jsonPathField, "Center");
            jPanel.add((Component)this.copyPathButton, "East");
            this.jsonValuePane = new JEditorPane();
            this.jsonValuePane.setEditable(false);
            this.jsonValuePane.setContentType("text/html");
            try {
                this.jsonValuePane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                this.jsonValuePane.setFont(UIManager.getFont("TextArea.font"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jsonValuePane.setText("<html><body style='margin:6px;'><i>Select a node to view its JSON</i></body></html>");
            serializable = new JScrollPane(this.jsonValuePane);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)serializable, "Center");
            jPanel2.add((Component)jPanel, "South");
            JSplitPane jSplitPane = new JSplitPane(0, this.jsonTreeScrollPane, jPanel2);
            jSplitPane.setResizeWeight(0.6);
            JPanel jPanel3 = new JPanel(new BorderLayout(6, 6));
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 6, 4));
            JButton jButton = this.createJsonExtractorButton();
            JLabel jLabel = new JLabel("Select JSON element");
            try {
                Font font = UIManager.getFont("TextArea.font");
                if (font != null) {
                    jLabel.setFont(font);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            jPanel4.add(jButton);
            jPanel4.add(jLabel);
            jPanel3.add((Component)jPanel4, "North");
            jPanel3.add((Component)jSplitPane, "Center");
            jTabbedPane.setComponentAt(n, jPanel3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ensureRegexTabInitialised(JTabbedPane jTabbedPane, int n) {
        try {
            if (this.regexTabInitialized && this.regexSelectorPanel != null) {
                return;
            }
            this.regexSelectorPanel = this.buildRegexSelectorTab();
            jTabbedPane.setComponentAt(n, this.regexSelectorPanel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void lazyPopulateJsonForSelection(SampleEntry sampleEntry) {
        this.lazyPopulateJsonForSelection(sampleEntry, this.selectionSeq.get());
    }

    private void lazyPopulateJsonForSelection(SampleEntry sampleEntry, long l) {
        try {
            String string;
            long l2 = System.currentTimeMillis();
            String string2 = string = sampleEntry.responseBody == null ? "" : sampleEntry.responseBody;
            if (l != this.selectionSeq.get()) {
                return;
            }
            if (this.cachedJsonSource != null && this.cachedJsonSource.equals(string) && this.cachedJsonTree != null) {
                SwingUtilities.invokeLater(() -> {
                    if (l != this.selectionSeq.get()) {
                        return;
                    }
                    this.jsonTree.setModel(new DefaultTreeModel(this.cachedJsonTree));
                    this.expandTree(this.jsonTree, 2);
                });
                try {
                    log.info("Perf(JSON lazy): cache-hit {} ms (len={})", (Object)(System.currentTimeMillis() - l2), (Object)string.length());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (this.jsonParseThread != null && this.jsonParseThread.isAlive()) {
                try {
                    this.jsonParseThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.jsonParseThread = new Thread(() -> {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    Object object;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    long l3 = System.currentTimeMillis();
                    String string2 = this.extractJsonFromResponse(string);
                    if (!DCAIResultsVisualizer.isLikelyJson(string2)) {
                        SwingUtilities.invokeLater(() -> {
                            if (l != this.selectionSeq.get()) {
                                return;
                            }
                            this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No JSON detected")));
                        });
                        try {
                            log.info("Perf(JSON lazy): detect={}ms -> not JSON (len={})", (Object)(System.currentTimeMillis() - l3), (Object)string.length());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        if (l != this.selectionSeq.get()) {
                            return;
                        }
                        this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Parsing JSON...")));
                    });
                    long l4 = System.currentTimeMillis();
                    try {
                        Object object2 = this.objectMapper;
                        try {
                            Method method = object2.getClass().getMethod("readValue", String.class, Class.class);
                            object = method.invoke(object2, string2, Map.class);
                            defaultMutableTreeNode = new DefaultMutableTreeNode("Response");
                            this.buildJsonTreeFromPojo(object, defaultMutableTreeNode, "$");
                        }
                        catch (Throwable throwable) {
                            object = this.objectMapper.getClass().getMethod("readTree", String.class);
                            Object object3 = ((Method)object).invoke(this.objectMapper, string2);
                            defaultMutableTreeNode = new DefaultMutableTreeNode("Response");
                            this.buildJsonTree(object3, defaultMutableTreeNode, "$");
                        }
                    }
                    catch (Throwable throwable) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Invalid JSON: " + throwable.getMessage());
                        SwingUtilities.invokeLater(() -> this.jsonTree.setModel(new DefaultTreeModel(defaultMutableTreeNode2)));
                        return;
                    }
                    long l5 = System.currentTimeMillis();
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    this.cachedJsonSource = string;
                    this.cachedJsonTree = object = defaultMutableTreeNode;
                    SwingUtilities.invokeLater(() -> this.lambda$lazyPopulateJsonForSelection$14(l, (DefaultMutableTreeNode)object, l4, l3, l5, l2, string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, "json-parse-lazy");
            this.jsonParseThread.setDaemon(true);
            this.jsonParseThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean shouldAutoSendErrors() {
        return this.sendErrorsCheckbox != null && this.sendErrorsCheckbox.isSelected();
    }

    private boolean shouldIncludeCookiesInCarrie() {
        return this.includeCookiesCheckbox != null && this.includeCookiesCheckbox.isSelected();
    }

    private static String stripCookieHeaders(String string) {
        if (string == null || string.isEmpty()) {
            return string == null ? "" : string;
        }
        String[] stringArray = string.split("\n", -1);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (String string2 : stringArray) {
            String string3 = string2 == null ? "" : string2;
            String string4 = string3.trim();
            String string5 = string4.toLowerCase();
            if (string5.startsWith("cookie:") || string5.startsWith("cookie2:") || string5.startsWith("set-cookie:") || string5.startsWith("set-cookie2:")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private static String stripCookieLinesFromSamplerData(String string) {
        if (string == null || string.isEmpty()) {
            return string == null ? "" : string;
        }
        String[] stringArray = string.split("\n", -1);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (String string2 : stringArray) {
            String string3 = string2 == null ? "" : string2;
            String string4 = string3.trim();
            String string5 = string4.toLowerCase();
            if (string5.startsWith("cookie data:") || string5.startsWith("cookies:")) {
                bl = true;
                continue;
            }
            if (bl) {
                if (!string4.isEmpty() && !string5.startsWith("post data:") && !string5.startsWith("put data:") && !string5.startsWith("get data:") && !string5.startsWith("request headers:") && !string5.startsWith("response headers:") && !string5.matches("^(get|post|put|delete|patch|head|options)\\s+https?://.*")) continue;
                bl = false;
                if (string4.isEmpty()) continue;
            }
            if (string5.startsWith("cookie:")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private static String getCurrentTestStartMs() {
        String string;
        try {
            string = JMeterUtils.getProperty((String)"TESTSTART.MS");
            if (string != null && !(string = string.trim()).isEmpty()) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = System.getProperty("TESTSTART.MS");
            if (string != null && !(string = string.trim()).isEmpty()) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean shouldSendToScript(SampleEntry sampleEntry) {
        try {
            if (sampleEntry.responseMessage != null && (sampleEntry.responseMessage.contains("javax.script.ScriptException") || sampleEntry.responseMessage.contains("groovy.lang.") || sampleEntry.responseMessage.contains("MissingPropertyException") || sampleEntry.responseMessage.contains("MissingMethodException"))) {
                try {
                    log.info("[DCAIResultsVisualizer] Script error detected from response message: {}", (Object)sampleEntry.responseMessage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            JMeterTreeNode jMeterTreeNode = this.findSamplerBySelectedEntry(sampleEntry);
            if (jMeterTreeNode == null) {
                return false;
            }
            TestElement testElement = jMeterTreeNode.getTestElement();
            return testElement instanceof JSR223Sampler;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void sendSelectedSmart() {
        GeminiSidePanel geminiSidePanel;
        try {
            log.info("[TRACE] ENTER sendSelectedSmart");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SampleEntry sampleEntry = this.sampleList.getSelectedValue();
        if (sampleEntry == null) {
            return;
        }
        try {
            GeminiSidePanel.setPendingInsertTargetLabel(sampleEntry.label);
            Object object = geminiSidePanel = this.shouldSendToScript(sampleEntry) ? this.findJSR223SamplerForEntry(sampleEntry) : this.findSamplerBySelectedEntry(sampleEntry);
            if (geminiSidePanel != null) {
                GeminiSidePanel.setPendingInsertTargetNode((JMeterTreeNode)geminiSidePanel);
                try {
                    log.info("[DCAIResultsVisualizer] Manual selection target: {} (node captured, type={})", (Object)sampleEntry.label, (Object)geminiSidePanel.getTestElement().getClass().getSimpleName());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        geminiSidePanel = GeminiSidePanel.getInstance();
        if (this.shouldSendToScript(sampleEntry)) {
            String string = this.extractCleanError(sampleEntry);
            String string2 = this.extractScriptFromRequest(sampleEntry);
            geminiSidePanel.showScriptTabWithFixModeAndAutoInsert(string, string2);
        } else {
            this.sendToCarrie(sampleEntry, true);
        }
        try {
            log.info("[TRACE] EXIT sendSelectedSmart");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendToCarrie(SampleEntry sampleEntry, boolean bl) {
        try {
            log.info("[TRACE] ENTER sendToCarrie autoFailure={}", (Object)bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!this.hasDispatchCredentials()) {
                try {
                    GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
                    String string = this.buildContext(sampleEntry, bl);
                    geminiSidePanel.acceptExternalContextAndAsk(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            String string = this.buildCarriePrompt(sampleEntry);
            try {
                GeminiSidePanel.setLastCarrieCorrelationSample(this.summariseForGeorge(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.appendCarrieUserMessageToChat(string);
            try {
                String string2 = this.extractDcaiHeaderFromRequest(sampleEntry);
                if (string2 != null && !string2.isEmpty()) {
                    try {
                        GeminiSidePanel.setLastErrorDcaiHeader(string2);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(() -> {
                try {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    linkedHashMap.put("source", "results-visualiser" + (bl ? "-auto" : "-manual"));
                    log.info("[CARRIE] Calling Carrie SORT with prompt length: {}", (Object)string.length());
                    A.AA aA = A.AAA(string, linkedHashMap);
                    if (aA == null || !aA.A) {
                        String string2 = "Carrie request failed";
                        String string3 = null;
                        if (aA != null && aA.AB != null) {
                            if (!DCAIResultsVisualizer.isNullOrEmpty(aA.AB.AA)) {
                                string2 = aA.AB.AA;
                            }
                            string3 = aA.AB.s;
                        }
                        log.warn("[CARRIE] Carrie request failed: {} (trace: {})", (Object)string2, string3);
                        String string4 = "{\n  \"mode\": \"SORT\",\n  \"is_correlation_issue\": false,\n  \"confidence\": 0.0,\n  \"cause\": \"" + DCAIResultsVisualizer.escapeJson(string2 + (String)(DCAIResultsVisualizer.isNullOrEmpty(string3) ? "" : " (trace " + string3 + ")")) + "\"\n}";
                        this.appendCarrieReplyToChat(string4);
                        return;
                    }
                    String string5 = !DCAIResultsVisualizer.isNullOrEmpty(aA.s) ? aA.s : (aA.AAA != null ? aA.AAA : "");
                    log.info("[CARRIE] Received Carrie response, length: {} chars, reply preview: {}", (Object)string5.length(), string5.length() > 100 ? string5.substring(0, 100) + "..." : string5);
                    this.appendCarrieReplyToChat(string5);
                    String string6 = this.extractDcaiHeaderFromRequest(sampleEntry);
                    this.trackCorrelationAttempt(sampleEntry, string5, string6);
                    if (lastCorrelationSessionId == null) {
                        log.error("[CARRIE-TRACKING] Correlation tracking did not produce a session ID. Aborting automated correlation for this response.");
                        try {
                            GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
                            geminiSidePanel.appendAiReplyWithAvatar("\ud83e\udd16 Carrie - The Correlator", "Correlation tracking failed (no session recorded). Please retry or escalate this request.", "/com/company/dcai/images/Carrie.png");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    try {
                        GeminiSidePanel.onCarrieReplyJson(string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        GeminiSidePanel.refreshCreditsAsync();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    try {
                        this.appendCarrieReplyToChat("{\n  \"mode\": \"SORT\",\n  \"is_correlation_issue\": false,\n  \"confidence\": 0.0,\n  \"cause\": \"Carrie request failed: " + DCAIResultsVisualizer.escapeJson(exception.getMessage()) + "\"\n}");
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }, "carrie-send").start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            log.info("[TRACE] EXIT sendToCarrie");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractDcaiHeaderFromRequest(SampleEntry sampleEntry) {
        try {
            String[] stringArray;
            String string;
            String string2 = string = sampleEntry.requestHeaders == null ? "" : sampleEntry.requestHeaders;
            if (string.isEmpty()) {
                return null;
            }
            for (String string3 : stringArray = string.split("\n", -1)) {
                String string4;
                String string5;
                if (string3 == null || !(string5 = string3.trim()).toUpperCase().startsWith("DCAI:") || (string4 = string5.substring(5).trim()).isEmpty()) continue;
                return string4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void trackCorrelationAttempt(SampleEntry sampleEntry, String string, String string2) {
        try {
            lastCorrelationSessionId = null;
            lastCorrelationHarFilename = null;
            if (lastCorrelationAttemptsByName == null) {
                lastCorrelationAttemptsByName = new HashMap<String, Long>();
            } else {
                lastCorrelationAttemptsByName.clear();
            }
            log.info("[CARRIE-TRACKING] Starting correlation tracking for DCAI: {}", (Object)string2);
            boolean bl = this.extractJsonBoolean(string, "is_correlation_issue", false);
            if (!bl) {
                log.info("[CARRIE-TRACKING] Skipping - not a correlation issue (is_correlation_issue=false)");
                return;
            }
            String string3 = this.extractJsonArray(string, "correlation_candidates");
            List<String> list = this.extractAllArrayElements(string3);
            if (list.isEmpty()) {
                log.info("[CARRIE-TRACKING] No candidates found in response");
                return;
            }
            log.info("[CARRIE-TRACKING] Found {} candidate(s) in Carrie response", (Object)list.size());
            String string4 = DCAIResultsVisualizer.loadJMeterVariable("LOADMAGIC_HAR");
            String string5 = this.generateHarId(sampleEntry);
            log.info("[CARRIE-TRACKING] harFilename: {}, harId: {}", (Object)string4, (Object)string5);
            Long l = this.createOrUpdateSession(string5, string4, sampleEntry);
            if (l == null) {
                log.warn("[CARRIE-TRACKING] Failed to create/update session");
                return;
            }
            log.info("[CARRIE-TRACKING] Session created/updated: {}", (Object)l);
            if (lastCorrelationAttemptsByName == null) {
                lastCorrelationAttemptsByName = new HashMap<String, Long>();
            }
            lastCorrelationAttemptsByName.clear();
            lastCorrelationSessionId = l;
            lastCorrelationDcaiHeader = string2;
            lastCorrelationTimestamp = System.currentTimeMillis();
            lastCarrieResponseJson = string;
            lastCorrelationHarFilename = string4;
            log.info("[CARRIE-TRACKING] Session {} created with {} candidates (attempts will be created lazily)", (Object)l, (Object)list.size());
        }
        catch (Exception exception) {
            log.error("[CARRIE-TRACKING] Error tracking correlation", (Throwable)exception);
        }
    }

    private String generateHarId(SampleEntry sampleEntry) {
        try {
            String string = JMeterUtils.getProperty((String)"LOADMAGIC_HAR_ID");
            if (string != null && !string.trim().isEmpty()) {
                log.info("[CARRIE-TRACKING] Using HAR ID from upload: {}", (Object)string);
                return string;
            }
            log.warn("[CARRIE-TRACKING] LOADMAGIC_HAR_ID not found, generating synthetic HAR ID");
            String string2 = sampleEntry.timeText != null ? sampleEntry.timeText.replaceAll("[^0-9]", "") : String.valueOf(System.currentTimeMillis());
            String string3 = sampleEntry.label != null ? sampleEntry.label.replaceAll("[^a-zA-Z0-9]", "-") : "unknown";
            return "har-" + string3 + "-" + string2.substring(Math.max(0, string2.length() - 8));
        }
        catch (Exception exception) {
            log.warn("[CARRIE-TRACKING] Exception generating HAR ID: {}", (Object)exception.getMessage());
            return "har-" + System.currentTimeMillis();
        }
    }

    private Long createOrUpdateSession(String string, String string2, SampleEntry sampleEntry) {
        try {
            String string3 = AAA.A();
            String string4 = AAA.AB();
            String string5 = string4 + "/api/carrie/correlation/sessions";
            String string6 = DCAIResultsVisualizer.loadJMeterVariable("LOADMAGIC_PROJECT_ID");
            if (string6 == null || string6.trim().isEmpty()) {
                string6 = "default";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{\"harId\":\"").append(DCAIResultsVisualizer.jsonEscape(string)).append("\"");
            stringBuilder.append(",\"harSource\":\"desktop-client\"");
            stringBuilder.append(",\"projectId\":\"").append(DCAIResultsVisualizer.jsonEscape(string6)).append("\"");
            if (string2 != null && !string2.trim().isEmpty()) {
                stringBuilder.append(",\"harFilename\":\"").append(DCAIResultsVisualizer.jsonEscape(string2)).append("\"");
            }
            if (sampleEntry.label != null) {
                stringBuilder.append(",\"lastKnownDcai\":\"").append(DCAIResultsVisualizer.jsonEscape(this.extractDcaiHeaderFromRequest(sampleEntry))).append("\"");
            }
            stringBuilder.append("}");
            log.info("[CARRIE-TRACKING] POST {} with harId={} harFilename={} projectId={}", (Object)string5, (Object)string, (Object)string2, (Object)string6);
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(string5)).timeout(Duration.ofSeconds(15L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString(), StandardCharsets.UTF_8));
            AAA.A(builder, string3);
            HttpRequest httpRequest = builder.build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            log.info("[CARRIE-TRACKING] Session response: status={}, body={}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            if (httpResponse.statusCode() == 200) {
                String string7 = httpResponse.body();
                Long l = this.extractSessionId(string7);
                return l;
            }
            log.warn("[CARRIE-TRACKING] Session creation failed with status {}: {}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            return null;
        }
        catch (Exception exception) {
            log.error("[CARRIE-TRACKING] Error creating session", (Throwable)exception);
            return null;
        }
    }

    private Long recordAttempt(Long l, String string, String string2, CarrieResponse carrieResponse, SampleEntry sampleEntry) {
        try {
            String string3 = AAA.A();
            String string4 = AAA.AB();
            String string5 = string4 + "/api/carrie/correlation/attempts";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{\"sessionId\":").append(l);
            if (string2 != null) {
                stringBuilder.append(",\"dcaiHeader\":\"").append(DCAIResultsVisualizer.jsonEscape(string2)).append("\"");
            }
            stringBuilder.append(",\"status\":\"matched\"");
            if (string != null && !string.trim().isEmpty()) {
                stringBuilder.append(",\"harFilename\":\"").append(DCAIResultsVisualizer.jsonEscape(string)).append("\"");
            }
            if (carrieResponse.candidateName != null) {
                stringBuilder.append(",\"candidateName\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateName)).append("\"");
            }
            if (carrieResponse.candidateValue != null) {
                stringBuilder.append(",\"candidateValue\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateValue)).append("\"");
            }
            if (carrieResponse.candidateLocation != null) {
                stringBuilder.append(",\"candidateLocation\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateLocation)).append("\"");
            }
            if (carrieResponse.candidateJsonPath != null) {
                stringBuilder.append(",\"candidateJsonPath\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateJsonPath)).append("\"");
            }
            stringBuilder.append(",\"candidateKind\":\"text\"");
            if (carrieResponse.confidence > 0.0) {
                stringBuilder.append(",\"carrieConfidence\":").append(carrieResponse.confidence);
            }
            stringBuilder.append(",\"searchStrategy\":\"carrie-sort\"");
            stringBuilder.append("}");
            log.info("[CARRIE-TRACKING] POST {} for sessionId={} harFilename={}", (Object)string5, (Object)l, (Object)string);
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(string5)).timeout(Duration.ofSeconds(15L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString(), StandardCharsets.UTF_8));
            AAA.A(builder, string3);
            HttpRequest httpRequest = builder.build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            log.info("[CARRIE-TRACKING] Attempt response: status={}, body={}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            if (httpResponse.statusCode() == 201) {
                String string6 = httpResponse.body();
                Long l2 = this.extractAttemptId(string6);
                return l2;
            }
            log.warn("[CARRIE-TRACKING] Attempt creation failed with status {}: {}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            return null;
        }
        catch (Exception exception) {
            log.error("[CARRIE-TRACKING] Error recording attempt", (Throwable)exception);
            return null;
        }
    }

    private CarrieResponse parseCarrieResponse(String string) {
        try {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            CarrieResponse carrieResponse = new CarrieResponse();
            carrieResponse.isCorrelationIssue = this.extractJsonBoolean(string, "is_correlation_issue", false);
            carrieResponse.confidence = DCAIResultsVisualizer.extractJsonDouble(string, "confidence", 0.0);
            String string2 = this.extractJsonArray(string, "correlation_candidates");
            if (string2 != null && !string2.trim().isEmpty()) {
                String string3 = this.extractFirstArrayElement(string2);
                if (string3 != null) {
                    carrieResponse.candidateName = this.extractJsonString(string3, "name");
                    carrieResponse.candidateValue = this.extractJsonString(string3, "value");
                    carrieResponse.candidateLocation = this.extractJsonString(string3, "location");
                    carrieResponse.candidateJsonPath = this.extractJsonString(string3, "json_path");
                    log.info("[CARRIE-TRACKING] Parsed candidate from array: name={}, location={}, value={}", (Object)carrieResponse.candidateName, (Object)carrieResponse.candidateLocation, carrieResponse.candidateValue != null && carrieResponse.candidateValue.length() > 20 ? carrieResponse.candidateValue.substring(0, 20) + "..." : carrieResponse.candidateValue);
                }
            } else {
                carrieResponse.candidateName = this.extractJsonString(string, "candidate_name");
                carrieResponse.candidateValue = this.extractJsonString(string, "candidate_value");
                carrieResponse.candidateLocation = this.extractJsonString(string, "candidate_location");
                carrieResponse.candidateJsonPath = this.extractJsonString(string, "candidate_json_path");
            }
            return carrieResponse;
        }
        catch (Exception exception) {
            log.error("[CARRIE-TRACKING] Error parsing Carrie response", (Throwable)exception);
            return null;
        }
    }

    private String extractJsonArray(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n2 = string.indexOf(string3);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf(58, n2 + string3.length());
        if (n3 < 0) {
            return null;
        }
        for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n >= string.length() || string.charAt(n) != '[') {
            return null;
        }
        int n4 = this.findMatchingBracket(string, n);
        if (n4 < 0) {
            return null;
        }
        return string.substring(n, n4 + 1);
    }

    private String extractFirstArrayElement(String string) {
        int n;
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String string2 = string.trim();
        if (!string2.startsWith("[")) {
            return null;
        }
        for (n = 1; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
        }
        if (n >= string2.length() || string2.charAt(n) != '{') {
            return null;
        }
        int n2 = this.findMatchingBrace(string2, n);
        if (n2 < 0) {
            return null;
        }
        return string2.substring(n, n2 + 1);
    }

    private List<String> extractAllArrayElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.trim().isEmpty()) {
            return arrayList;
        }
        String string2 = string.trim();
        if (!string2.startsWith("[")) {
            return arrayList;
        }
        int n = 1;
        while (n < string2.length()) {
            char c;
            while (n < string2.length() && Character.isWhitespace(string2.charAt(n))) {
                ++n;
            }
            if (n >= string2.length() || (c = string2.charAt(n)) == ']') break;
            if (c == ',') {
                ++n;
                continue;
            }
            if (c == '{') {
                int n2 = this.findMatchingBrace(string2, n);
                if (n2 < 0) break;
                arrayList.add(string2.substring(n, n2 + 1));
                n = n2 + 1;
                continue;
            }
            ++n;
        }
        return arrayList;
    }

    private int findMatchingBracket(String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '[') {
                ++n2;
                continue;
            }
            if (c != ']' || --n2 != 0) continue;
            return i;
        }
        return -1;
    }

    private Long extractSessionId(String string) {
        try {
            Long l;
            String string2 = this.extractJsonObject(string, "session");
            if (string2 != null && (l = this.extractJsonLong(string2, "id")) != null) {
                return l;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Long extractAttemptId(String string) {
        try {
            Long l;
            String string2 = this.extractJsonObject(string, "attempt");
            if (string2 != null && (l = this.extractJsonLong(string2, "id")) != null) {
                return l;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String extractJsonObject(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n2 = string.indexOf(string3);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf(58, n2 + string3.length());
        if (n3 < 0) {
            return null;
        }
        for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n >= string.length() || string.charAt(n) != '{') {
            return null;
        }
        int n4 = this.findMatchingBrace(string, n);
        if (n4 < 0) {
            return null;
        }
        return string.substring(n, n4 + 1);
    }

    private String extractJsonString(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n2 = string.indexOf(string3);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf(58, n2 + string3.length());
        if (n3 < 0) {
            return null;
        }
        int n4 = string.indexOf(34, n3 + 1);
        if (n4 < 0) {
            return null;
        }
        for (n = n4 + 1; n < string.length() && string.charAt(n) != '\"'; ++n) {
            if (string.charAt(n) != '\\') continue;
            ++n;
        }
        if (n >= string.length()) {
            return null;
        }
        return string.substring(n4 + 1, n).replace("\\\"", "\"").replace("\\n", "\n");
    }

    private boolean extractJsonBoolean(String string, String string2, boolean bl) {
        int n;
        if (string == null || string2 == null) {
            return bl;
        }
        String string3 = "\"" + string2 + "\"";
        int n2 = string.indexOf(string3);
        if (n2 < 0) {
            return bl;
        }
        int n3 = string.indexOf(58, n2 + string3.length());
        if (n3 < 0) {
            return bl;
        }
        for (n = n3 + 1; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (string.startsWith("true", n)) {
            return true;
        }
        if (string.startsWith("false", n)) {
            return false;
        }
        return bl;
    }

    private static double extractJsonDouble(String string, String string2, double d) {
        int n;
        int n2;
        if (string == null || string2 == null) {
            return d;
        }
        String string3 = "\"" + string2 + "\"";
        int n3 = string.indexOf(string3);
        if (n3 < 0) {
            return d;
        }
        int n4 = string.indexOf(58, n3 + string3.length());
        if (n4 < 0) {
            return d;
        }
        for (n2 = n4 + 1; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        for (n = n2; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.' || string.charAt(n) == '-'); ++n) {
        }
        if (n > n2) {
            try {
                return Double.parseDouble(string.substring(n2, n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    private Long extractJsonLong(String string, String string2) {
        int n;
        boolean bl;
        int n2;
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n3 = string.indexOf(string3);
        if (n3 < 0) {
            return null;
        }
        int n4 = string.indexOf(58, n3 + string3.length());
        if (n4 < 0) {
            return null;
        }
        for (n2 = n4 + 1; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        boolean bl2 = bl = n2 < string.length() && string.charAt(n2) == '\"';
        if (bl) {
            ++n2;
        }
        for (n = n2; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '-'); ++n) {
        }
        if (n > n2) {
            try {
                return Long.parseLong(string.substring(n2, n));
            }
            catch (Exception exception) {
                log.warn("[CARRIE-TRACKING] Failed to parse Long from: {}", (Object)string.substring(n2, Math.min(n + 10, string.length())));
            }
        }
        return null;
    }

    private int findMatchingBrace(String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                ++n2;
                continue;
            }
            if (c != '}' || --n2 != 0) continue;
            return i;
        }
        return -1;
    }

    private static String jsonEscape(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static Long getLastCorrelationAttemptId() {
        return lastCorrelationAttemptId;
    }

    public static Long getLastCorrelationSessionId() {
        return lastCorrelationSessionId;
    }

    public static String getLastCorrelationDcaiHeader() {
        return lastCorrelationDcaiHeader;
    }

    public static String getLastCorrelationCandidateValue() {
        return lastCorrelationCandidateValue;
    }

    public static Long getLastCorrelationTimestamp() {
        return lastCorrelationTimestamp;
    }

    public static String getLastCorrelationHarFilename() {
        return lastCorrelationHarFilename;
    }

    private static String sample(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n <= 0) {
            return "";
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, Math.max(0, n)) + "...";
    }

    public static Long getAttemptIdForCandidate(String string) {
        if (string == null || lastCorrelationAttemptsByName == null) {
            return null;
        }
        return lastCorrelationAttemptsByName.get(string);
    }

    public static Long createAttemptForCandidate(String string, String string2, String string3, String string4) {
        try {
            log.info("[CARRIE-TRACKING] Creating lazy attempt for candidate: name={}, location={}", (Object)string, (Object)string3);
            Long l = DCAIResultsVisualizer.getAttemptIdForCandidate(string);
            if (l != null) {
                log.info("[CARRIE-TRACKING] Attempt already exists for candidate '{}': attemptId={}", (Object)string, (Object)l);
                return l;
            }
            if (lastCorrelationSessionId == null) {
                log.warn("[CARRIE-TRACKING] No session ID available for lazy attempt creation");
                return null;
            }
            String string5 = lastCorrelationHarFilename;
            if (string5 == null || string5.trim().isEmpty()) {
                string5 = DCAIResultsVisualizer.loadJMeterVariable("LOADMAGIC_HAR");
            }
            double d = 0.0;
            if (lastCarrieResponseJson != null) {
                d = DCAIResultsVisualizer.extractJsonDouble(lastCarrieResponseJson, "confidence", 0.0);
            }
            CarrieResponse carrieResponse = new CarrieResponse();
            carrieResponse.isCorrelationIssue = true;
            carrieResponse.confidence = d;
            carrieResponse.candidateName = string;
            carrieResponse.candidateValue = string2;
            carrieResponse.candidateLocation = string3;
            carrieResponse.candidateJsonPath = string4;
            log.info("[CARRIE-TRACKING DEBUG] Lazy attempt payload - sessionId={} harFilename={} dcaiHeader={} candidateName={} location={} jsonPath={} value={}", (Object)lastCorrelationSessionId, (Object)string5, (Object)lastCorrelationDcaiHeader, (Object)string, (Object)string3, (Object)string4, (Object)DCAIResultsVisualizer.sample(string2, 120));
            Long l2 = DCAIResultsVisualizer.recordAttemptStatic(lastCorrelationSessionId, string5, lastCorrelationDcaiHeader, carrieResponse);
            if (l2 != null) {
                log.info("[CARRIE-TRACKING] Created lazy attempt for '{}': attemptId={}", (Object)string, (Object)l2);
                lastCorrelationAttemptsByName.put(string, l2);
                lastCorrelationAttemptId = l2;
                lastCorrelationCandidateValue = string2;
                return l2;
            }
            log.warn("[CARRIE-TRACKING] Failed to create lazy attempt for candidate '{}'", (Object)string);
            return null;
        }
        catch (Exception exception) {
            log.error("[CARRIE-TRACKING] Error creating lazy attempt for candidate '{}'", (Object)string, (Object)exception);
            return null;
        }
    }

    private static Long recordAttemptStatic(Long l, String string, String string2, CarrieResponse carrieResponse) {
        try {
            String string3 = JMeterUtils.getProperty((String)"dcai.account.api");
            if (string3 == null || string3.trim().isEmpty()) {
                return null;
            }
            String string4 = AAA.AB();
            String string5 = string4 + "/api/carrie/correlation/attempts";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{\"sessionId\":").append(l);
            if (string2 != null) {
                stringBuilder.append(",\"dcaiHeader\":\"").append(DCAIResultsVisualizer.jsonEscape(string2)).append("\"");
            }
            stringBuilder.append(",\"status\":\"matched\"");
            if (string != null && !string.trim().isEmpty()) {
                stringBuilder.append(",\"harFilename\":\"").append(DCAIResultsVisualizer.jsonEscape(string)).append("\"");
            }
            if (carrieResponse.candidateName != null) {
                stringBuilder.append(",\"candidateName\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateName)).append("\"");
            }
            if (carrieResponse.candidateValue != null) {
                stringBuilder.append(",\"candidateValue\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateValue)).append("\"");
            }
            if (carrieResponse.candidateLocation != null) {
                stringBuilder.append(",\"candidateLocation\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateLocation)).append("\"");
            }
            if (carrieResponse.candidateJsonPath != null) {
                stringBuilder.append(",\"candidateJsonPath\":\"").append(DCAIResultsVisualizer.jsonEscape(carrieResponse.candidateJsonPath)).append("\"");
            }
            stringBuilder.append(",\"candidateKind\":\"text\"");
            if (carrieResponse.confidence > 0.0) {
                stringBuilder.append(",\"carrieConfidence\":").append(carrieResponse.confidence);
            }
            stringBuilder.append(",\"searchStrategy\":\"carrie-sort\"");
            stringBuilder.append("}");
            log.info("[CARRIE-TRACKING] POST {} for sessionId={} harFilename={}", (Object)string5, (Object)l, (Object)string);
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string5)).timeout(Duration.ofSeconds(15L)).header("Content-Type", "application/json").header("Authorization", "Bearer " + string3).POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString(), StandardCharsets.UTF_8)).build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            log.info("[CARRIE-TRACKING] Attempt response: status={}, body={}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            if (httpResponse.statusCode() == 201) {
                String string6 = httpResponse.body();
                Long l2 = DCAIResultsVisualizer.extractAttemptIdStatic(string6);
                return l2;
            }
            log.warn("[CARRIE-TRACKING] Attempt creation failed with status {}: {}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
            return null;
        }
        catch (Exception exception) {
            log.error("[CARRIE-TRACKING] Error recording attempt", (Throwable)exception);
            return null;
        }
    }

    private static Long extractAttemptIdStatic(String string) {
        try {
            Long l;
            String string2 = DCAIResultsVisualizer.extractJsonObjectStatic(string, "attempt");
            if (string2 != null && (l = DCAIResultsVisualizer.extractJsonLongStatic(string2, "id")) != null) {
                return l;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String extractJsonObjectStatic(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n = string.indexOf(string3);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(58, n + string3.length());
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf(123, n2);
        if (n3 < 0) {
            return null;
        }
        int n4 = DCAIResultsVisualizer.findMatchingBraceStatic(string, n3);
        if (n4 < 0) {
            return null;
        }
        return string.substring(n3, n4 + 1);
    }

    private static Long extractJsonLongStatic(String string, String string2) {
        int n;
        int n2;
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n3 = string.indexOf(string3);
        if (n3 < 0) {
            return null;
        }
        int n4 = string.indexOf(58, n3 + string3.length());
        if (n4 < 0) {
            return null;
        }
        for (n2 = n4 + 1; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        boolean bl = false;
        if (n2 < string.length() && string.charAt(n2) == '\"') {
            bl = true;
            ++n2;
        }
        for (n = n2; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '-'); ++n) {
        }
        if (n == n2) {
            return null;
        }
        try {
            return Long.parseLong(string.substring(n2, n));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int findMatchingBraceStatic(String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                ++n2;
                continue;
            }
            if (c != '}' || --n2 != 0) continue;
            return i;
        }
        return -1;
    }

    public static void clearCorrelationTracking() {
        lastCorrelationAttemptId = null;
        lastCorrelationSessionId = null;
        lastCorrelationDcaiHeader = null;
        lastCorrelationCandidateValue = null;
        lastCorrelationTimestamp = null;
        lastCorrelationHarFilename = null;
        lastCarrieResponseJson = null;
        if (lastCorrelationAttemptsByName != null) {
            lastCorrelationAttemptsByName.clear();
        }
    }

    public static void trackCorrelationInsertion(Long l, String string, String string2, String string3, String string4, String string5, String string6) {
        log.info("[CARRIE-INSERTION DEBUG] trackCorrelationInsertion CALLED - attemptId={}, dcaiHeader={}, extractorType={}, variableName={}, harFilename={}", (Object)l, (Object)string, (Object)string2, (Object)string4, (Object)string6);
        new Thread(() -> {
            try {
                if (l == null) {
                    log.info("[CARRIE-INSERTION] Skipping - no attempt ID available");
                    return;
                }
                log.info("[CARRIE-INSERTION] Recording insertion for attempt {} (variable: {}, type: {})", (Object)l, (Object)string4, (Object)string2);
                String string7 = JMeterUtils.getProperty((String)"dcai.account.api");
                if (string7 == null || string7.trim().isEmpty()) {
                    log.warn("[CARRIE-INSERTION] No API key configured");
                    return;
                }
                String string8 = AAA.AB();
                String string9 = string8 + "/api/carrie/correlation/insertions";
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{\"attemptId\":").append(l);
                if (string != null) {
                    stringBuilder.append(",\"insertDcaiHeader\":\"").append(DCAIResultsVisualizer.jsonEscape(string)).append("\"");
                }
                if (string2 != null) {
                    stringBuilder.append(",\"extractorType\":\"").append(DCAIResultsVisualizer.jsonEscape(string2)).append("\"");
                }
                if (string3 != null) {
                    stringBuilder.append(",\"extractorPayload\":").append(string3);
                }
                if (string4 != null) {
                    stringBuilder.append(",\"variableName\":\"").append(DCAIResultsVisualizer.jsonEscape(string4)).append("\"");
                }
                if (string5 != null) {
                    stringBuilder.append(",\"defaultValue\":\"").append(DCAIResultsVisualizer.jsonEscape(string5)).append("\"");
                }
                if (string6 != null) {
                    stringBuilder.append(",\"harFilename\":\"").append(DCAIResultsVisualizer.jsonEscape(string6)).append("\"");
                }
                stringBuilder.append(",\"insertionStatus\":\"inserted\"");
                stringBuilder.append("}");
                log.info("[CARRIE-INSERTION DEBUG] Request body: {}", (Object)stringBuilder.toString());
                log.info("[CARRIE-INSERTION] POST {} with attemptId={}", (Object)string9, (Object)l);
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
                HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string9)).timeout(Duration.ofSeconds(15L)).header("Content-Type", "application/json").header("Authorization", "Bearer " + string7).POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString(), StandardCharsets.UTF_8)).build();
                HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                log.info("[CARRIE-INSERTION] Response: status={}, body={}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
                if (httpResponse.statusCode() == 201) {
                    log.info("[CARRIE-INSERTION] Successfully recorded insertion!");
                } else {
                    log.warn("[CARRIE-INSERTION] Insertion tracking failed with status {}: {}", (Object)httpResponse.statusCode(), (Object)httpResponse.body());
                }
            }
            catch (Exception exception) {
                log.error("[CARRIE-INSERTION] Error tracking insertion", (Throwable)exception);
            }
        }, "carrie-insertion-tracking").start();
    }

    private void appendCarrieReplyToChat(String string) {
        try {
            log.info("[TRACE] ENTER appendCarrieReplyToChat len={}", (Object)(string != null ? string.length() : -1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string2;
            String string3 = string == null ? "" : string.trim();
            try {
                string2 = DCAIResultsVisualizer.prettyPrintJson(string3);
            }
            catch (Exception exception) {
                string2 = string3;
            }
            String string4 = "```json\n" + string2 + "\n```";
            GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
            try {
                Method method = GeminiSidePanel.class.getDeclaredMethod("appendAiReplyWithAvatar", String.class, String.class, String.class);
                method.setAccessible(true);
                Method method2 = method;
                String string5 = string4;
                SwingUtilities.invokeLater(() -> {
                    try {
                        method2.invoke((Object)geminiSidePanel, "\ud83e\udd16 Carrie - The Correlator", string5, "/com/company/dcai/images/Carrie.png");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Method method = GeminiSidePanel.class.getDeclaredMethod("appendAiReply", String.class, String.class);
                method.setAccessible(true);
                Method method3 = method;
                String string6 = string4;
                SwingUtilities.invokeLater(() -> {
                    try {
                        method3.invoke((Object)geminiSidePanel, "\ud83e\udd16 Carrie - The Correlator", string6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            log.info("[TRACE] EXIT appendCarrieReplyToChat");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendCarrieUserMessageToChat(String string) {
        try {
            log.info("[TRACE] ENTER appendCarrieUserMessageToChat len={}", (Object)(string != null ? string.length() : -1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
            Method method = GeminiSidePanel.class.getDeclaredMethod("appendMarkdownToChat", String.class, Color.class);
            method.setAccessible(true);
            String string2 = "**To Carrie - The Correlator**\n\n" + (string == null ? "" : string);
            SwingUtilities.invokeLater(() -> {
                try {
                    method.invoke((Object)geminiSidePanel, string2, new Color(0, 153, 255));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            log.info("[TRACE] EXIT appendCarrieUserMessageToChat");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String escapeJson(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(Math.min(4096, string.length() + 16));
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                default: {
                    if (c < ' ') {
                        stringBuilder.append(String.format("\\u%04x", c));
                        continue block7;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String buildCarriePrompt(SampleEntry sampleEntry) {
        String string;
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder(4096);
        stringBuilder.append("SAMPLE:\n");
        stringBuilder.append("Label: ").append(sampleEntry.label).append("\n");
        stringBuilder.append("Success: ").append(sampleEntry.success).append("\n");
        if (sampleEntry.responseCode != null && !sampleEntry.responseCode.isEmpty()) {
            stringBuilder.append("Response Code: ").append(sampleEntry.responseCode).append("\n");
        }
        if (sampleEntry.responseMessage != null && !sampleEntry.responseMessage.isEmpty()) {
            stringBuilder.append("Response Message: ").append(sampleEntry.responseMessage).append("\n");
        }
        stringBuilder.append("\nREQUEST HEADERS:\n");
        String string4 = sampleEntry.requestHeaders == null ? "" : sampleEntry.requestHeaders;
        String string5 = string3 = sampleEntry.responseHeaders == null ? "" : sampleEntry.responseHeaders;
        if (!this.shouldIncludeCookiesInCarrie()) {
            string4 = DCAIResultsVisualizer.stripCookieHeaders(string4);
            string3 = DCAIResultsVisualizer.stripCookieHeaders(string3);
        }
        stringBuilder.append(string4).append("\n\n");
        stringBuilder.append("REQUEST BODY:\n");
        String string6 = string2 = sampleEntry.requestBody == null ? "" : sampleEntry.requestBody;
        if (!this.shouldIncludeCookiesInCarrie()) {
            string2 = DCAIResultsVisualizer.stripCookieLinesFromSamplerData(string2);
        }
        stringBuilder.append(string2).append("\n\n");
        stringBuilder.append("RESPONSE HEADERS:\n");
        stringBuilder.append(string3).append("\n\n");
        stringBuilder.append("RESPONSE BODY:\n");
        String string7 = string = sampleEntry.responseBody == null ? "" : sampleEntry.responseBody;
        if (string.length() > 200000) {
            string = this.createSmartTruncation(string, 200000);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private String summariseForGeorge(String string) {
        if (string == null) {
            return "";
        }
        int n = 20000;
        if (string.length() <= n) {
            return string;
        }
        return this.createSmartTruncation(string, n);
    }

    private String extractCleanError(SampleEntry sampleEntry) {
        if (sampleEntry.responseMessage != null && !sampleEntry.responseMessage.trim().isEmpty()) {
            Object object = sampleEntry.responseMessage.trim();
            if (sampleEntry.label != null) {
                object = sampleEntry.label + ": " + (String)object;
            }
            if (sampleEntry.timeText != null && sampleEntry.timeText.contains("ms")) {
                object = (String)object + " (Duration: " + sampleEntry.timeText + ")";
            }
            return object;
        }
        return "Script execution failed: " + sampleEntry.label;
    }

    private String buildScriptContext(SampleEntry sampleEntry) {
        Object object;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ERROR ANALYSIS:\n");
        stringBuilder.append("Sample: ").append(sampleEntry.label).append("\n");
        stringBuilder.append("Status: ").append(sampleEntry.success ? "SUCCESS" : "FAILED").append("\n");
        stringBuilder.append("Response Code: ").append(sampleEntry.responseCode).append("\n");
        stringBuilder.append("Response Message: ").append(sampleEntry.responseMessage).append("\n");
        stringBuilder.append("Time: ").append(sampleEntry.timeText).append("\n");
        if (!sampleEntry.success) {
            stringBuilder.append("\nFAILURE DETAILS:\n");
            stringBuilder.append("Error: ").append(sampleEntry.responseMessage).append("\n");
            if (sampleEntry.responseCode != null && !sampleEntry.responseCode.isEmpty()) {
                stringBuilder.append("HTTP Status: ").append(sampleEntry.responseCode).append("\n");
            }
        }
        if ((string = this.extractScriptFromRequest(sampleEntry)) != null && !string.trim().isEmpty()) {
            stringBuilder.append("\nBROKEN SCRIPT:\n");
            stringBuilder.append("```groovy\n");
            stringBuilder.append(string);
            stringBuilder.append("\n```\n");
        }
        if (sampleEntry.requestHeaders != null && !sampleEntry.requestHeaders.trim().isEmpty()) {
            stringBuilder.append("\nREQUEST HEADERS:\n");
            object = sampleEntry.requestHeaders;
            if (!this.shouldIncludeCookiesInCarrie()) {
                object = DCAIResultsVisualizer.stripCookieHeaders((String)object);
            }
            stringBuilder.append((String)object).append("\n");
        }
        if (sampleEntry.requestBody != null && !sampleEntry.requestBody.trim().isEmpty()) {
            stringBuilder.append("\nREQUEST BODY:\n");
            object = sampleEntry.requestBody;
            if (!this.shouldIncludeCookiesInCarrie()) {
                object = DCAIResultsVisualizer.stripCookieLinesFromSamplerData((String)object);
            }
            if (((String)object).length() > 10000) {
                object = ((String)object).substring(0, 10000) + "\n... [truncated]";
            }
            stringBuilder.append((String)object).append("\n");
        }
        if (sampleEntry.responseBody != null && !sampleEntry.responseBody.isEmpty()) {
            object = sampleEntry.responseBody;
            if (((String)object).length() > 2000) {
                object = ((String)object).substring(0, 2000) + "\n... [truncated, full length: " + sampleEntry.responseBody.length() + " chars]";
            }
            stringBuilder.append("\nRESPONSE BODY:\n");
            stringBuilder.append((String)object).append("\n");
        }
        if (sampleEntry.responseHeaders != null && !sampleEntry.responseHeaders.isEmpty()) {
            stringBuilder.append("\nRESPONSE HEADERS:\n");
            object = sampleEntry.responseHeaders;
            if (!this.shouldIncludeCookiesInCarrie()) {
                object = DCAIResultsVisualizer.stripCookieHeaders((String)object);
            }
            stringBuilder.append((String)object).append("\n");
        }
        return stringBuilder.toString();
    }

    private String extractScriptFromRequest(SampleEntry sampleEntry) {
        Object object;
        Object object2;
        if (sampleEntry.requestBody != null && !sampleEntry.requestBody.trim().isEmpty()) {
            object2 = sampleEntry.requestBody.trim();
            if (this.isLikelyGroovyScript((String)object2)) {
                return object2;
            }
            object = this.extractScriptFromJson((String)object2);
            if (object != null && !((String)object).trim().isEmpty()) {
                return object;
            }
        }
        try {
            String string;
            object2 = this.findJSR223SamplerForEntry(sampleEntry);
            if (object2 != null && object2.getTestElement() instanceof JSR223Sampler && (string = (object = (JSR223Sampler)object2.getTestElement()).getScript()) != null && !string.trim().isEmpty()) {
                return string.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isLikelyGroovyScript(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        String string2 = string.toLowerCase();
        return string2.contains("vars.") || string2.contains("props.") || string2.contains("log.") || string2.contains("prev.") || string2.contains("sampler.") || string2.contains("ctx.") || string.contains("${") || string.contains("import ") || string.contains("def ") || string.contains("return ");
    }

    private String extractScriptFromJson(String string) {
        if (string == null || !string.trim().startsWith("{")) {
            return null;
        }
        try {
            char c;
            int n;
            int n2 = string.indexOf("\"script\"");
            if (n2 < 0) {
                return null;
            }
            int n3 = string.indexOf(":", n2);
            if (n3 < 0) {
                return null;
            }
            int n4 = string.indexOf("\"", n3 + 1);
            if (n4 < 0) {
                return null;
            }
            boolean bl = false;
            for (n = n4 + 1; n < string.length() && ((c = string.charAt(n)) != '\"' || bl); ++n) {
                bl = c == '\\' && !bl;
            }
            if (n > n4 + 1) {
                String string2 = string.substring(n4 + 1, n);
                string2 = string2.replace("\\\"", "\"").replace("\\n", "\n").replace("\\t", "\t").replace("\\\\", "\\");
                return string2.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String buildContext(SampleEntry sampleEntry, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# JMeter Error Analysis\n\n");
        stringBuilder.append("Analyze this JMeter sample failure and provide:\n\n");
        stringBuilder.append("## Cause\n");
        stringBuilder.append("The most likely root cause\n\n");
        stringBuilder.append("## Fix\n");
        stringBuilder.append("Specific steps to resolve the issue\n\n");
        stringBuilder.append("---\n\n");
        stringBuilder.append("**Sample:** ").append(sampleEntry.label).append("\n");
        stringBuilder.append("**Time:** ").append(sampleEntry.timeText).append("\n");
        stringBuilder.append("**Success:** ").append(sampleEntry.success).append("\n");
        stringBuilder.append("**Response Code:** ").append(sampleEntry.responseCode).append("\n");
        stringBuilder.append("**Response Message:** ").append(sampleEntry.responseMessage).append("\n\n");
        if (sampleEntry.requestHeaders != null && !sampleEntry.requestHeaders.trim().isEmpty()) {
            stringBuilder.append("## Request Headers\n");
            string = sampleEntry.requestHeaders;
            if (!this.shouldIncludeCookiesInCarrie()) {
                string = DCAIResultsVisualizer.stripCookieHeaders(string);
            }
            stringBuilder.append("```\n").append(string).append("\n```\n\n");
        }
        if (sampleEntry.requestBody != null && !sampleEntry.requestBody.trim().isEmpty()) {
            stringBuilder.append("## Request Body\n");
            string = sampleEntry.requestBody;
            if (!this.shouldIncludeCookiesInCarrie()) {
                string = DCAIResultsVisualizer.stripCookieLinesFromSamplerData(string);
            }
            stringBuilder.append("```\n").append(string).append("\n```\n\n");
        }
        String string2 = string = sampleEntry.responseHeaders == null ? "" : sampleEntry.responseHeaders;
        if (!this.shouldIncludeCookiesInCarrie()) {
            string = DCAIResultsVisualizer.stripCookieHeaders(string);
        }
        String string3 = (String)(string.isEmpty() ? "" : "**Response Headers:**\n```\n" + string + "\n```\n\n") + (String)(sampleEntry.responseBody == null ? "" : "**Response Body:**\n```\n" + sampleEntry.responseBody + "\n```");
        if (bl && string3.length() > 4000) {
            String string4 = string3.substring(0, 4000);
            stringBuilder.append("## Response (truncated)\n").append(string4).append("\n\n*[Response truncated for auto-analysis]*");
        } else {
            stringBuilder.append("## Response\n").append(string3);
        }
        return stringBuilder.toString();
    }

    private static boolean isTransactionAggregate(SampleResult sampleResult) {
        if (sampleResult == null) {
            return false;
        }
        try {
            if (sampleResult.getSubResults() != null && sampleResult.getSubResults().length > 0) {
                String string = SampleEntry.safe(sampleResult.getResponseMessage());
                if (string.startsWith("Number of samples in transaction")) {
                    return true;
                }
                String string2 = SampleEntry.normalizeNewlines(SampleEntry.safe(sampleResult.getRequestHeaders())).trim();
                String string3 = SampleEntry.safe(sampleResult.getSamplerData()).trim();
                String string4 = SampleEntry.normalizeNewlines(SampleEntry.safe(sampleResult.getResponseHeaders())).trim();
                String string5 = SampleEntry.safe(sampleResult.getResponseDataAsString()).trim();
                return string2.isEmpty() && string3.isEmpty() && string4.isEmpty() && string5.isEmpty();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean hasDispatchCredentials() {
        try {
            String string = JMeterUtils.getProperty((String)"dcai.account.api");
            return string != null && !string.trim().isEmpty();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void populateJsonTree(String string) {
        if (this.jsonTree == null) {
            return;
        }
        if (this.objectMapper == null) {
            this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("JSON viewer unavailable (jackson-databind not on classpath)")));
            return;
        }
        if (string == null || string.isEmpty() || string.charAt(0) != '{') {
            this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No JSON detected")));
            return;
        }
        String string2 = this.extractJsonFromResponse(string);
        if (!DCAIResultsVisualizer.isLikelyJson(string2)) {
            this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No JSON detected")));
            return;
        }
        try {
            Object object = this.objectMapper;
            try {
                Method method = object.getClass().getMethod("readValue", String.class, Class.class);
                Object object2 = method.invoke(object, string2, Map.class);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Response");
                this.buildJsonTreeFromPojo(object2, defaultMutableTreeNode, "$");
                this.jsonTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
                this.expandTree(this.jsonTree, 2);
                return;
            }
            catch (Throwable throwable) {
                Method method = object.getClass().getMethod("readTree", String.class);
                Object object3 = method.invoke(object, string2);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Response");
                this.buildJsonTree(object3, defaultMutableTreeNode, "$");
                this.jsonTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
                this.expandTree(this.jsonTree, 2);
            }
        }
        catch (Throwable throwable) {
            this.jsonTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Invalid JSON: " + throwable.getMessage())));
        }
    }

    private String extractJsonFromResponse(String string) {
        if (string == null) {
            return "";
        }
        String[] stringArray = string.split("\n", -1);
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"[Body]".equals(stringArray[i].trim())) continue;
            n = i;
            break;
        }
        if (n >= 0 && n + 1 < stringArray.length) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n + 1; i < stringArray.length; ++i) {
                if (i > n + 1) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(stringArray[i] == null ? "" : stringArray[i]);
            }
            return DCAIResultsVisualizer.extractJsonSubstring(stringBuilder.toString().trim());
        }
        return DCAIResultsVisualizer.extractJsonSubstring(string.trim());
    }

    private static String extractJsonSubstring(String string) {
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < n2 && (string.charAt(n) == '{' || string.charAt(n) == '[')) {
            return string;
        }
        return "";
    }

    private void buildJsonTree(Object object, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod("isObject", new Class[0]);
        Method method2 = clazz.getMethod("isArray", new Class[0]);
        Method method3 = clazz.getMethod("isValueNode", new Class[0]);
        if (((Boolean)method.invoke(object, new Object[0])).booleanValue()) {
            Method method4 = clazz.getMethod("fieldNames", new Class[0]);
            Method method5 = clazz.getMethod("get", String.class);
            Iterator iterator = (Iterator)method4.invoke(object, new Object[0]);
            while (iterator.hasNext()) {
                String string2 = String.valueOf(iterator.next());
                Object object2 = method5.invoke(object, string2);
                String string3 = string.isEmpty() ? "$." + string2 : string + "." + string2;
                JsonTreeNode jsonTreeNode = new JsonTreeNode(string2, object2, string3);
                defaultMutableTreeNode.add(jsonTreeNode);
                if (!((Boolean)method.invoke(object2, new Object[0])).booleanValue() && !((Boolean)method2.invoke(object2, new Object[0])).booleanValue()) continue;
                this.buildJsonTree(object2, jsonTreeNode, string3);
            }
        } else if (((Boolean)method2.invoke(object, new Object[0])).booleanValue()) {
            Method method6 = clazz.getMethod("size", new Class[0]);
            Method method7 = clazz.getMethod("get", Integer.TYPE);
            int n = (Integer)method6.invoke(object, new Object[0]);
            for (int i = 0; i < n; ++i) {
                Object object3 = method7.invoke(object, i);
                String string4 = string + "[" + i + "]";
                JsonTreeNode jsonTreeNode = new JsonTreeNode("[" + i + "]", object3, string4);
                defaultMutableTreeNode.add(jsonTreeNode);
                if (!((Boolean)method.invoke(object3, new Object[0])).booleanValue() && !((Boolean)method2.invoke(object3, new Object[0])).booleanValue()) continue;
                this.buildJsonTree(object3, jsonTreeNode, string4);
            }
        } else if (((Boolean)method3.invoke(object, new Object[0])).booleanValue()) {
            // empty if block
        }
    }

    private void buildJsonTreeFromPojo(Object object, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        block3: {
            block2: {
                if (!(object instanceof Map)) break block2;
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    String string2 = (String)entry.getKey();
                    Object v = entry.getValue();
                    String string3 = string.isEmpty() ? "$." + string2 : string + "." + string2;
                    JsonTreeNode jsonTreeNode = new JsonTreeNode(string2, v, string3);
                    defaultMutableTreeNode.add(jsonTreeNode);
                    if (!(v instanceof Map) && !(v instanceof List)) continue;
                    this.buildJsonTreeFromPojo(v, jsonTreeNode, string3);
                }
                break block3;
            }
            if (!(object instanceof List)) break block3;
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                String string4 = string + "[" + i + "]";
                JsonTreeNode jsonTreeNode = new JsonTreeNode("[" + i + "]", e, string4);
                defaultMutableTreeNode.add(jsonTreeNode);
                if (!(e instanceof Map) && !(e instanceof List)) continue;
                this.buildJsonTreeFromPojo(e, jsonTreeNode, string4);
            }
        }
    }

    private void updateJsonPath() {
        Object object;
        if (this.jsonTree == null) {
            return;
        }
        TreePath treePath = this.jsonTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JsonTreeNode) {
            this.jsonPathField.setText(((JsonTreeNode)object).getJsonPath());
            return;
        }
        this.jsonPathField.setText("");
    }

    private void updateJsonValuePane() {
        String string;
        if (this.jsonTree == null || this.jsonValuePane == null) {
            return;
        }
        TreePath treePath = this.jsonTree.getSelectionPath();
        if (treePath == null) {
            this.jsonValuePane.setText("<html><body style='margin:6px;'><i>Select a node to view its JSON</i></body></html>");
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof JsonTreeNode)) {
            this.jsonValuePane.setText("<html><body style='margin:6px;'><i>Select a node to view its JSON</i></body></html>");
            return;
        }
        JsonTreeNode jsonTreeNode = (JsonTreeNode)object;
        Object object2 = jsonTreeNode.getJsonValue();
        try {
            String string2 = this.toPrettyJson(object2);
            string = "<html><body style='margin:6px;'><pre>" + DCAIResultsVisualizer.escapeHtml(string2) + "</pre></body></html>";
        }
        catch (Exception exception) {
            string = "<html><body style='margin:6px;'><pre>" + DCAIResultsVisualizer.escapeHtml(String.valueOf(object2)) + "</pre></body></html>";
        }
        this.jsonValuePane.setText(string);
    }

    private String toPrettyJson(Object object) {
        if (this.objectMapper == null || object == null) {
            return String.valueOf(object);
        }
        Object object2 = this.objectMapper;
        try {
            Method method = object2.getClass().getMethod("writerWithDefaultPrettyPrinter", new Class[0]);
            Object object3 = method.invoke(object2, new Object[0]);
            Method method2 = object3.getClass().getMethod("writeValueAsString", Object.class);
            return String.valueOf(method2.invoke(object3, object));
        }
        catch (Throwable throwable) {
            Method method = object2.getClass().getMethod("writeValueAsString", Object.class);
            return String.valueOf(method.invoke(object2, object));
        }
    }

    private void copyJsonPathToClipboard() {
        String string;
        String string2 = string = this.jsonPathField != null ? this.jsonPathField.getText() : "";
        if (string == null || string.isEmpty()) {
            return;
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
            String string3 = this.copyPathButton.getText();
            this.copyPathButton.setText("Copied!");
            Timer timer = new Timer(1500, actionEvent -> this.copyPathButton.setText(string3));
            timer.setRepeats(false);
            timer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCurrentJsonPath() {
        return this.jsonPathField != null ? this.jsonPathField.getText() : null;
    }

    private boolean isSampler(TestElement testElement) {
        return testElement instanceof Sampler;
    }

    private JMeterTreeNode findSamplerBySelectedEntry(SampleEntry sampleEntry) {
        try {
            if (sampleEntry == null) {
                return null;
            }
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                return null;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)jMeterTreeModel.getRoot();
            return this.findSamplerByTreePosition(jMeterTreeNode, sampleEntry.label, sampleEntry);
        }
        catch (Exception exception) {
            log.info("Error finding sampler: {}", (Object)exception.getMessage());
            return null;
        }
    }

    private JMeterTreeNode findJSR223SamplerForEntry(SampleEntry sampleEntry) {
        try {
            if (sampleEntry == null) {
                return null;
            }
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                return null;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)jMeterTreeModel.getRoot();
            JMeterTreeNode jMeterTreeNode2 = this.findJSR223SamplerByLabel(jMeterTreeNode, sampleEntry.label);
            if (jMeterTreeNode2 != null) {
                try {
                    log.info("[DCAIResultsVisualizer] Found JSR223 sampler for label: {}", (Object)sampleEntry.label);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jMeterTreeNode2;
            }
            try {
                log.warn("[DCAIResultsVisualizer] No JSR223 sampler found for label '{}', falling back to general search", (Object)sampleEntry.label);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.findSamplerBySelectedEntry(sampleEntry);
        }
        catch (Exception exception) {
            try {
                log.error("[DCAIResultsVisualizer] Error finding JSR223 sampler: {}", (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    private JMeterTreeNode findJSR223SamplerByLabel(JMeterTreeNode jMeterTreeNode, String string) {
        if (jMeterTreeNode == null || string == null) {
            return null;
        }
        TestElement testElement = jMeterTreeNode.getTestElement();
        if (testElement instanceof JSR223Sampler && string.equals(testElement.getName())) {
            return jMeterTreeNode;
        }
        for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
            JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
            JMeterTreeNode jMeterTreeNode3 = this.findJSR223SamplerByLabel(jMeterTreeNode2, string);
            if (jMeterTreeNode3 == null) continue;
            return jMeterTreeNode3;
        }
        return null;
    }

    private JMeterTreeNode findSamplerByTreePosition(JMeterTreeNode jMeterTreeNode, String string, SampleEntry sampleEntry) {
        if (jMeterTreeNode == null || string == null) {
            return null;
        }
        ArrayList<SamplerWithPosition> arrayList = new ArrayList<SamplerWithPosition>();
        this.collectSamplersWithPositions(jMeterTreeNode, string, arrayList, 0);
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            log.info("Found single sampler '{}' at position {}", (Object)string, (Object)((SamplerWithPosition)arrayList.get((int)0)).position);
            return ((SamplerWithPosition)arrayList.get((int)0)).node;
        }
        log.info("Found {} samplers with name '{}', using position-based selection", (Object)arrayList.size(), (Object)string);
        return this.selectSamplerByPosition(arrayList, sampleEntry);
    }

    private void collectSamplersWithPositions(JMeterTreeNode jMeterTreeNode, String string, List<SamplerWithPosition> list, int n) {
        if (jMeterTreeNode == null) {
            return;
        }
        TestElement testElement = jMeterTreeNode.getTestElement();
        if (this.isSampler(testElement) && string.equals(testElement.getName())) {
            String string2 = this.buildNodePath(jMeterTreeNode);
            list.add(new SamplerWithPosition(jMeterTreeNode, n, string2));
            log.debug("Found sampler '{}' at position {} with path: {}", (Object)string, (Object)n, (Object)string2);
        }
        for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
            JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
            this.collectSamplersWithPositions(jMeterTreeNode2, string, list, n + 1);
        }
    }

    private String buildNodePath(JMeterTreeNode jMeterTreeNode) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (JMeterTreeNode jMeterTreeNode2 = jMeterTreeNode; jMeterTreeNode2 != null; jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode2.getParent()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, " > ");
                }
                String string = this.getNodeName(jMeterTreeNode2);
                stringBuilder.insert(0, string);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "unknown-path";
        }
    }

    private String getNodeName(JMeterTreeNode jMeterTreeNode) {
        try {
            if (jMeterTreeNode == null) {
                return "(root)";
            }
            Object object = jMeterTreeNode.getUserObject();
            if (object instanceof TestElement) {
                String string = ((TestElement)object).getName();
                return string == null || string.isEmpty() ? jMeterTreeNode.toString() : string;
            }
            return jMeterTreeNode.toString();
        }
        catch (Exception exception) {
            return "(node)";
        }
    }

    private JMeterTreeNode selectSamplerByPosition(List<SamplerWithPosition> list, SampleEntry sampleEntry) {
        TestElement testElement;
        SamplerWithPosition samplerWithPosition;
        ArrayList<SamplerWithPosition> arrayList = new ArrayList<SamplerWithPosition>();
        ArrayList<SamplerWithPosition> arrayList2 = new ArrayList<SamplerWithPosition>();
        Object object = list.iterator();
        while (object.hasNext()) {
            samplerWithPosition = object.next();
            testElement = samplerWithPosition.node.getTestElement();
            if (testElement.isEnabled()) {
                arrayList.add(samplerWithPosition);
                continue;
            }
            arrayList2.add(samplerWithPosition);
        }
        Object object2 = object = arrayList.isEmpty() ? arrayList2 : arrayList;
        if (object.size() == 1) {
            samplerWithPosition = (SamplerWithPosition)object.get(0);
            log.info("Selected single {} sampler '{}' at position {}", (Object)(samplerWithPosition.node.getTestElement().isEnabled() ? "enabled" : "disabled"), (Object)samplerWithPosition.node.getTestElement().getName(), (Object)samplerWithPosition.position);
            return samplerWithPosition.node;
        }
        samplerWithPosition = this.selectSamplerByExecutionContext((List<SamplerWithPosition>)object, sampleEntry);
        testElement = samplerWithPosition.node.getTestElement();
        log.info("Selected {} sampler '{}' at position {} (path: {}) using execution context", (Object)(testElement.isEnabled() ? "enabled" : "disabled"), (Object)testElement.getName(), (Object)samplerWithPosition.position, (Object)samplerWithPosition.path);
        return samplerWithPosition.node;
    }

    private SamplerWithPosition selectSamplerByExecutionContext(List<SamplerWithPosition> list, SampleEntry sampleEntry) {
        SamplerWithPosition samplerWithPosition = this.matchByExecutionPattern(list, sampleEntry);
        if (samplerWithPosition != null) {
            log.info("Matched sampler by execution pattern");
            return samplerWithPosition;
        }
        SamplerWithPosition samplerWithPosition2 = list.get(list.size() - 1);
        log.info("Using tree position fallback - selected sampler at position {} (last in tree)", (Object)samplerWithPosition2.position);
        return samplerWithPosition2;
    }

    private SamplerWithPosition matchByExecutionPattern(List<SamplerWithPosition> list, SampleEntry sampleEntry) {
        try {
            List<SampleEntry> list2 = this.getRecentSampleHistory(10);
            if (list2.size() < 2) {
                log.debug("Insufficient sample history for pattern matching");
                return null;
            }
            int n = -1;
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i) != sampleEntry) continue;
                n = i;
                break;
            }
            if (n == -1) {
                log.debug("Could not find current sample in recent history");
                return null;
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (SampleEntry sampleEntry2 : list2) {
                hashMap.put(sampleEntry2.label, hashMap.getOrDefault(sampleEntry2.label, 0) + 1);
            }
            int n2 = hashMap.getOrDefault(sampleEntry.label, 0);
            if (n2 > 1) {
                int n3;
                int n4 = 0;
                for (n3 = 0; n3 <= n; ++n3) {
                    if (!list2.get((int)n3).label.equals(sampleEntry.label)) continue;
                    ++n4;
                }
                log.info("Sample '{}' is occurrence #{} of {} in recent history", (Object)sampleEntry.label, (Object)n4, (Object)n2);
                n3 = Math.min(n4 - 1, list.size() - 1);
                SamplerWithPosition samplerWithPosition = list.get(n3);
                log.info("Selected sampler at position {} for occurrence #{}", (Object)samplerWithPosition.position, (Object)n4);
                return samplerWithPosition;
            }
        }
        catch (Exception exception) {
            log.debug("Error in execution pattern matching: {}", (Object)exception.getMessage());
        }
        return null;
    }

    private List<SampleEntry> getRecentSampleHistory(int n) {
        int n2;
        ArrayList<SampleEntry> arrayList = new ArrayList<SampleEntry>();
        int n3 = this.sampleListModel.getSize();
        for (int i = n2 = Math.max(0, n3 - n); i < n3; ++i) {
            SampleEntry sampleEntry = this.sampleListModel.getElementAt(i);
            if (sampleEntry == null) continue;
            arrayList.add(sampleEntry);
        }
        return arrayList;
    }

    private void collectSamplersByName(JMeterTreeNode jMeterTreeNode, String string, List<JMeterTreeNode> list) {
        if (jMeterTreeNode == null) {
            return;
        }
        TestElement testElement = jMeterTreeNode.getTestElement();
        if (this.isSampler(testElement) && string.equals(testElement.getName())) {
            list.add(jMeterTreeNode);
        }
        for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
            JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
            this.collectSamplersByName(jMeterTreeNode2, string, list);
        }
    }

    private JMeterTreeNode selectBestSamplerMatch(List<JMeterTreeNode> list, SampleEntry sampleEntry) {
        Object object;
        JMeterTreeNode jMeterTreeNode2;
        ArrayList<JMeterTreeNode> arrayList = new ArrayList<JMeterTreeNode>();
        ArrayList<JMeterTreeNode> arrayList2 = new ArrayList<JMeterTreeNode>();
        for (JMeterTreeNode jMeterTreeNode2 : list) {
            object = jMeterTreeNode2.getTestElement();
            if (object.isEnabled()) {
                arrayList.add(jMeterTreeNode2);
                continue;
            }
            arrayList2.add(jMeterTreeNode2);
        }
        if (!arrayList.isEmpty()) {
            list = arrayList;
            log.info("Selected from {} enabled samplers", (Object)arrayList.size());
        } else {
            log.info("All samplers disabled, selected from {} disabled samplers", (Object)arrayList2.size());
        }
        JMeterTreeNode jMeterTreeNode3 = list.get(0);
        jMeterTreeNode2 = jMeterTreeNode3.getTestElement();
        object = this.getParentContext(jMeterTreeNode3);
        log.info("Selected sampler '{}' (enabled={}) under '{}'", (Object)jMeterTreeNode2.getName(), (Object)jMeterTreeNode2.isEnabled(), object);
        return jMeterTreeNode3;
    }

    private String getParentContext(JMeterTreeNode jMeterTreeNode) {
        try {
            JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getParent();
            if (jMeterTreeNode2 == null) {
                return "root";
            }
            TestElement testElement = jMeterTreeNode2.getTestElement();
            if (testElement != null) {
                return testElement.getName();
            }
            return jMeterTreeNode2.toString();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    private String promptForVariableName(String string, SampleEntry sampleEntry) {
        String string2 = this.suggestVariableNameFromContext(string, sampleEntry);
        String string3 = String.format("Adding JSON Extractor to: %s\nJSON Path: %s\n\nEnter variable name:", sampleEntry.label, string);
        String string4 = (String)JOptionPane.showInputDialog((Component)((Object)this), string3, "Variable Name", 3, null, null, string2);
        if (string4 != null && !(string4 = string4.trim()).isEmpty()) {
            string4 = string4.replaceAll("[^a-zA-Z0-9_]", "_");
        }
        return string4;
    }

    private String suggestVariableNameFromContext(String string, SampleEntry sampleEntry) {
        Object object;
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder("DCAI");
        if (sampleEntry != null && sampleEntry.label != null) {
            stringArray = sampleEntry.label.replaceAll("[^a-zA-Z0-9]", " ").split("\\s+");
            object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                if (((String)object2).length() <= 2 || this.isCommonWord(((String)object2).toLowerCase())) continue;
                stringBuilder.append("_").append(((String)object2).toUpperCase());
                break;
            }
        }
        if ((stringArray = this.extractMeaningfulPathPart(string)) != null && !stringArray.isEmpty()) {
            stringBuilder.append("_").append(stringArray.toUpperCase());
        }
        if (((String)(object = stringBuilder.toString())).length() > 40) {
            object = ((String)object).substring(0, 40);
        }
        while (((String)object).endsWith("_")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return ((String)object).isEmpty() ? "DCAI_JSON_VAR" : object;
    }

    private boolean isCommonWord(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"http", "request", "get", "post", "put", "delete", "api", "test", "sample"}) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private String extractMeaningfulPathPart(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll("\\[\\d+\\]", "");
        String[] stringArray = string2.split("\\.");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string3 = stringArray[i].trim();
            if (string3.isEmpty() || string3.equals("$")) continue;
            return string3;
        }
        return null;
    }

    private boolean createAndAddJsonExtractor(JMeterTreeNode jMeterTreeNode, String string, String string2) {
        try {
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                throw new RuntimeException("JMeter GUI not available");
            }
            JSONPostProcessor jSONPostProcessor = new JSONPostProcessor();
            jSONPostProcessor.setName(string);
            jSONPostProcessor.setProperty("TestElement.test_class", JSONPostProcessor.class.getName());
            jSONPostProcessor.setProperty("TestElement.gui_class", JSONPostProcessorGui.class.getName());
            jSONPostProcessor.setRefNames(string);
            jSONPostProcessor.setJsonPathExpressions(string2);
            jSONPostProcessor.setMatchNumbers("1");
            jSONPostProcessor.setDefaultValues("NOT_FOUND");
            jSONPostProcessor.setComputeConcatenation(false);
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            jMeterTreeModel.addComponent((TestElement)jSONPostProcessor, jMeterTreeNode);
            JTree jTree = guiPackage.getMainFrame().getTree();
            TreePath treePath = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode));
            jTree.setSelectionPath(treePath);
            jTree.scrollPathToVisible(treePath);
            return true;
        }
        catch (Exception exception) {
            log.info("Error creating JSON Extractor: {}", (Object)exception.getMessage());
            return false;
        }
    }

    private JButton createJsonExtractorButton() {
        JButton jButton = new JButton("Add JSON Extractor");
        jButton.setToolTipText("Add JSON Extractor to the sampler that produced the selected sample");
        jButton.addActionListener(actionEvent -> this.addJsonExtractorToSelectedSampler());
        return jButton;
    }

    private JPanel buildRegexSelectorTab() {
        Object object;
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 6, 4));
        this.confirmRegexButton = new JButton("Confirm Boundaries");
        this.confirmRegexButton.setToolTipText("Double-click to place handles; drag GREEN (left) and BLUE (right) spans.");
        this.confirmRegexButton.addActionListener(actionEvent -> this.onConfirmRegexBoundaries());
        this.prevChunkButton = new JButton("Prev chunk");
        this.nextChunkButton = new JButton("Next chunk");
        this.chunkInfoLabel = new JLabel("");
        try {
            serializable = UIManager.getFont("TextArea.font");
            if (serializable != null) {
                this.chunkInfoLabel.setFont((Font)serializable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jPanel2.add(this.prevChunkButton);
        jPanel2.add(this.nextChunkButton);
        jPanel2.add(this.confirmRegexButton);
        try {
            Object object2;
            this.rstaClass = Class.forName("org.fife.ui.rsyntaxtextarea.RSyntaxTextArea");
            object = this.rstaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.regexSelectorArea = (JTextArea)object;
            this.regexSelectorArea.setEditable(false);
            this.regexSelectorArea.setLineWrap(true);
            this.regexSelectorArea.setWrapStyleWord(true);
            try {
                object2 = UIManager.getFont("TextArea.font");
                if (object2 != null) {
                    this.regexSelectorArea.setFont((Font)object2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object2 = this.rstaClass.getMethod("setSyntaxEditingStyle", String.class);
                ((Method)object2).invoke((Object)this.regexSelectorArea, "text/plain");
                try {
                    this.rstaClass.getMethod("setCodeFoldingEnabled", Boolean.TYPE).invoke((Object)this.regexSelectorArea, Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.rstaClass.getMethod("setHighlightCurrentLine", Boolean.TYPE).invoke((Object)this.regexSelectorArea, Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.rstaClass.getMethod("setMarkOccurrences", Boolean.TYPE).invoke((Object)this.regexSelectorArea, Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.rstaClass.getMethod("setHyperlinksEnabled", Boolean.TYPE).invoke((Object)this.regexSelectorArea, Boolean.FALSE);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object2 = UIManager.getColor("TextArea.background");
                Color color = UIManager.getColor("TextArea.foreground");
                if (object2 != null) {
                    this.regexSelectorArea.setBackground((Color)object2);
                }
                if (color != null) {
                    this.regexSelectorArea.setForeground(color);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializable = new JScrollPane(this.regexSelectorArea);
            this.rstaAvailable = true;
        }
        catch (Throwable throwable) {
            this.regexSelectorArea = new JTextArea();
            this.regexSelectorArea.setEditable(false);
            this.regexSelectorArea.setLineWrap(true);
            this.regexSelectorArea.setWrapStyleWord(true);
            try {
                Font font = UIManager.getFont("TextArea.font");
                if (font != null) {
                    this.regexSelectorArea.setFont(font);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializable = new JScrollPane(this.regexSelectorArea);
            this.rstaAvailable = false;
            this.rstaClass = null;
        }
        this.regexLayerUI = new RegexBoundaryLayerUI(this.regexSelectorArea);
        this.regexLayerUI.setInteractionEnabled(true);
        object = new JLayer<JComponent>((JComponent)serializable, this.regexLayerUI);
        this.regexSelectorLayer = object;
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)object, "Center");
        try {
            this.confirmRegexButton.setEnabled(true);
            this.prevChunkButton.addActionListener(actionEvent -> this.showPrevChunk());
            this.nextChunkButton.addActionListener(actionEvent -> this.showNextChunk());
            jPanel2.add(this.chunkInfoLabel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.regexTabInitialized = true;
        return jPanel;
    }

    private void onConfirmRegexBoundaries() {
        SampleEntry sampleEntry;
        Object[] objectArray;
        if (this.regexLayerUI == null || this.regexSelectorArea == null) {
            return;
        }
        int n = this.regexLayerUI.getLeftStart();
        int n2 = this.regexLayerUI.getLeftEnd();
        int n3 = this.regexLayerUI.getRightStart();
        int n4 = this.regexLayerUI.getRightEnd();
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Set both left and right boundary spans (two lines each).", "Incomplete", 1);
            return;
        }
        if (n > n2 || n2 > n3 || n3 > n4) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Boundaries must satisfy: left-start \u2264 left-end \u2264 right-start \u2264 right-end.", "Invalid order", 2);
            return;
        }
        String string = this.regexSelectorArea.getText();
        String string2 = DCAIResultsVisualizer.safeSub(string, n, n2);
        String string3 = DCAIResultsVisualizer.safeSub(string, n2, n3);
        String string4 = DCAIResultsVisualizer.safeSub(string, n3, n4);
        if (string2 == null) {
            string2 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string2.isEmpty() || string4.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Left and Right boundary spans must be non-empty. Please adjust selectors.", "Empty boundary", 1);
            return;
        }
        boolean bl = string3.contains("\n");
        String string5 = (bl ? "(?s)" : "") + DCAIResultsVisualizer.escapeOroRegexLiteral(string2) + "(.*?)" + DCAIResultsVisualizer.escapeOroRegexLiteral(string4);
        String string6 = this.suggestVariableNameFromRegex(string2, this.sampleList.getSelectedValue());
        String string7 = String.format("Left span: %s\nCapture: %s\nRight span: %s\n\nSuggested regex:\n%s\nSuggested variable:\n%s", DCAIResultsVisualizer.truncatePreview(string2), DCAIResultsVisualizer.truncatePreview(string3), DCAIResultsVisualizer.truncatePreview(string4), string5, string6);
        int n5 = JOptionPane.showOptionDialog((Component)((Object)this), string7, "Boundaries Confirmed", -1, 1, null, objectArray = new Object[]{"Back", "Insert", "Load Magic Auto", "Load Magic Edit"}, objectArray[0]);
        if (n5 == 1) {
            SampleEntry sampleEntry2 = this.sampleList.getSelectedValue();
            if (sampleEntry2 != null) {
                this.insertRegexExtractor(sampleEntry2, string6, string5);
            }
        } else if (n5 == 2) {
            SampleEntry sampleEntry3 = this.sampleList.getSelectedValue();
            if (sampleEntry3 != null) {
                this.performDcAiAutoInsert(sampleEntry3, string2, string3, string4, bl);
            }
        } else if (n5 == 3 && (sampleEntry = this.sampleList.getSelectedValue()) != null) {
            this.openDcAiRegexTabWithContext(sampleEntry, string2, string3, string4, bl);
        }
    }

    private void openDcAiRegexTabWithContext(SampleEntry sampleEntry, String string, String string2, String string3, boolean bl) {
        try {
            String string4 = String.valueOf(string) + String.valueOf(string2) + String.valueOf(string3);
            String string5 = this.buildBoundaryRequestPayload(string, string3, bl, string4);
            GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
            geminiSidePanel.showRegexTabWith(string4, string5);
            try {
                Method method = GeminiSidePanel.class.getDeclaredMethod("consumeCreditAsync", String.class, String.class, Integer.TYPE);
                method.setAccessible(true);
                String string6 = string5 != null ? string5 : "";
                method.invoke((Object)geminiSidePanel, "rupert", string6, 1);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error opening Load Magic Regex tab: " + exception.getMessage(), "Error", 0);
        }
    }

    private void performDcAiAutoInsert(SampleEntry sampleEntry, String string, String string2, String string3, boolean bl) {
        JDialog[] jDialogArray = new JDialog[1];
        try {
            SwingUtilities.invokeLater(() -> {
                jDialogArray[0] = this.showProgressDialog("Generating regex via Load Magic...");
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(() -> {
            try {
                Object object;
                String string4;
                Object object2;
                String string5 = String.valueOf(string) + String.valueOf(string2) + String.valueOf(string3);
                String string6 = this.buildBoundaryRequestPayload(string, string3, bl, string5);
                String string7 = string6.isEmpty() ? "" : string6.substring(0, Math.min(200, string6.length())).replace('\n', ' ').replace('\r', ' ');
                log.info("DCAI Auto: provider={}, payloadLen={}, payloadHead={}", (Object)GeminiSidePanel.getSelectedProviderLabel(), (Object)string6.length(), (Object)string7);
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("source", "results-visualiser");
                A.AA aA = A.A(string, string3, string5, bl, linkedHashMap);
                if (aA == null || !aA.A) {
                    String string8 = "Dispatch error";
                    String string9 = null;
                    if (aA != null && aA.AB != null) {
                        if (aA.AB.AA != null && !aA.AB.AA.trim().isEmpty()) {
                            string8 = aA.AB.AA;
                        }
                        string9 = aA.AB.s;
                    }
                    throw new RuntimeException(string8 + (String)(string9 == null || string9.trim().isEmpty() ? "" : " (trace " + string9 + ")"));
                }
                String string10 = !DCAIResultsVisualizer.isNullOrEmpty(aA.s) ? aA.s : (aA.AAA != null ? aA.AAA : "");
                try {
                    GeminiSidePanel.refreshCreditsAsync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.info("DCAI Auto: replyLen={}, replyHead={}", (Object)(string10 == null ? 0 : string10.length()), (Object)(string10 == null ? "<null>" : string10.substring(0, Math.min(200, string10.length())).replace('\n', ' ').replace('\r', ' ')));
                Object object3 = DCAIResultsVisualizer.extractRegexSmartFromReply(string10);
                if (object3 == null || ((String)object3).trim().isEmpty()) {
                    object2 = DCAIResultsVisualizer.escapeOroRegexLiteral(string);
                    string4 = DCAIResultsVisualizer.escapeOroRegexLiteral(string3);
                    boolean bl2 = string != null && string.contains("\"") || string3 != null && string3.contains("\"");
                    String string11 = bl2 ? "[^\\\"]+" : ".*?";
                    object = (bl ? "(?s)" : "") + (String)object2 + "(" + string11 + ")" + string4;
                    log.info("DCAI Auto: no regex parsed; using boundary-based fallback");
                    object3 = object;
                }
                log.info("DCAI Auto: parsedRegex={}", object3);
                object2 = DCAIResultsVisualizer.normalizeAiRegex((String)object3);
                try {
                    object2 = ((String)object2).replace("\\\\\"", "\"");
                    object2 = ((String)object2).replace("\\\"", "\"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    object2 = DCAIResultsVisualizer.reconstituteWithBoundariesIfNeeded((String)object2, string, string3, bl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.info("DCAI Auto: normalizedRegex={}", object2);
                if (DCAIResultsVisualizer.isOroUnsafeRegex((String)object2)) {
                    string4 = DCAIResultsVisualizer.escapeOroRegexLiteral(string);
                    String string12 = DCAIResultsVisualizer.escapeOroRegexLiteral(string3);
                    boolean bl3 = string != null && string.contains("\"") || string3 != null && string3.contains("\"");
                    object = bl3 ? "[^\\\"]+" : ".*?";
                    object2 = (bl ? "(?s)" : "") + string4 + "(" + (String)object + ")" + string12;
                    log.info("DCAI Auto: unsafe or non-compliant constructs detected; using boundary-based literal fallback.");
                }
                string4 = this.suggestVariableNameFromRegex(string, sampleEntry);
                String string13 = object2;
                String string14 = string4;
                object = sampleEntry;
                SwingUtilities.invokeLater(() -> this.lambda$performDcAiAutoInsert$27((SampleEntry)object, string14, string13));
                if (!GeminiSidePanel.isDcaiProviderSelected()) {
                    try {
                        GeminiSidePanel geminiSidePanel = GeminiSidePanel.getInstance();
                        Method method = GeminiSidePanel.class.getDeclaredMethod("consumeCreditAsync", String.class, String.class, Integer.TYPE);
                        method.setAccessible(true);
                        method.invoke((Object)geminiSidePanel, "rupert", string6, 1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this), "Auto AI insert failed: " + exception.getMessage(), "Error", 0));
            }
            finally {
                try {
                    SwingUtilities.invokeLater(() -> {
                        if (jDialogArray[0] != null) {
                            jDialogArray[0].dispose();
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }, "dcai-auto-insert").start();
    }

    private static boolean isOroUnsafeRegex(String string) {
        if (string == null) {
            return true;
        }
        if (string.contains("(?<=") || string.contains("(?<!")) {
            return true;
        }
        if (string.contains("(?>")) {
            return true;
        }
        if (string.contains("*+") || string.contains("++") || string.contains("?+")) {
            return true;
        }
        if (string.matches(".*\\(\\?<[^>]+>.*")) {
            return true;
        }
        return string.contains("(*");
    }

    private JDialog showProgressDialog(String string) {
        JDialog jDialog = new JDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), "Please wait", Dialog.ModalityType.MODELESS);
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.add((Component)new JLabel(string), "North");
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel.add((Component)jProgressBar, "Center");
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo((Component)((Object)this));
        jDialog.setVisible(true);
        return jDialog;
    }

    private String buildBoundaryRequestPayload(String string, String string2, boolean bl, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string3 != null ? string3.length() + 128 : 256);
        stringBuilder.append('{');
        stringBuilder.append("\"mode\":\"boundary\"");
        stringBuilder.append(',').append("\"left_boundary\":\"").append(DCAIResultsVisualizer.escapeJson(string == null ? "" : string)).append('\"');
        stringBuilder.append(',').append("\"right_boundary\":\"").append(DCAIResultsVisualizer.escapeJson(string2 == null ? "" : string2)).append('\"');
        stringBuilder.append(',').append("\"multiline\":").append(bl ? "true" : "false");
        stringBuilder.append(',').append("\"context\":\"").append(DCAIResultsVisualizer.escapeJson(string3 == null ? "" : string3)).append('\"');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static String extractRegexSmartFromReply(String string) {
        String[] stringArray;
        int n;
        if (string == null) {
            return null;
        }
        String string2 = DCAIResultsVisualizer.extractFencedCode(string);
        if (string2 != null && !string2.trim().isEmpty()) {
            return string2.trim();
        }
        int n2 = string.indexOf(96);
        if (n2 >= 0 && (n = string.indexOf(96, n2 + 1)) > n2) {
            return string.substring(n2 + 1, n).trim();
        }
        for (String string3 : stringArray = string.split("\n")) {
            String string4;
            String string5 = string3.trim();
            if (string5.isEmpty() || (string4 = string5.toLowerCase()).startsWith("here is") || string4.contains("jmeter") || !DCAIResultsVisualizer.looksLikeRegex(string5)) continue;
            return string5;
        }
        return null;
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    private static String extractFencedCode(String string) {
        int n;
        String string2 = AA.A(string, "regex");
        if (string2 != null && !string2.trim().isEmpty()) {
            return string2;
        }
        int n2 = string.indexOf("```");
        if (n2 >= 0 && (n = string.indexOf("```", n2 + 3)) > n2) {
            String string3 = string.substring(n2 + 3, n).trim();
            int n3 = string3.indexOf(10);
            if (n3 > 0) {
                String string4 = string3.substring(0, n3).trim();
                if (string4.matches("(?i)^(bash|sh|shell|perl|pcre|regex|regexp|python|py|js|javascript|ts|typescript|java|csharp|php|ruby|go|golang)$")) {
                    string3 = string3.substring(n3 + 1).trim();
                }
            } else if (string3.matches("(?i)^(bash|sh|shell|perl|pcre|regex|regexp|python|py|js|javascript|ts|typescript|java|csharp|php|ruby|go|golang)$")) {
                string3 = "";
            }
            if (string3.startsWith("\"") && string3.endsWith("\"") || string3.startsWith("'") && string3.endsWith("'")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            return string3;
        }
        return null;
    }

    private static boolean looksLikeRegex(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return false;
        }
        String string3 = "\\()[]^$?+*{}|";
        boolean bl = false;
        for (int i = 0; i < string3.length(); ++i) {
            if (string2.indexOf(string3.charAt(i)) < 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static String normalizeAiRegex(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("`") && string2.endsWith("`") && string2.length() > 2) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        string2 = string2.replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r");
        string2 = string2.replace("\\\"", "\"").replace("\\'", "'");
        string2 = string2.replace("\\/", "/");
        string2 = string2.replace("\\\\", "\\");
        string2 = string2.replace("\\u003c", "<").replace("\\u003e", ">").replace("\\u002f", "/");
        string2 = string2.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&");
        string2 = string2.replaceFirst("(?i)^regex\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^regexp\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^pattern\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^perl\\s*[:\\-]?\\s*", "");
        string2 = string2.replaceFirst("(?i)^pcre\\s*[:\\-]?\\s*", "");
        if ((string2 = string2.replaceFirst("(?i)^(bash|sh|shell|python|py|js|javascript|ts|typescript|java|csharp|php|ruby|go|golang)\\b\\s*", "")).length() >= 2 && (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"' || string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'')) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.length() >= 2 && string2.charAt(0) == '/' && string2.charAt(string2.length() - 1) == '/') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2.trim();
    }

    private static String reconstituteWithBoundariesIfNeeded(String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2;
        if (string == null) {
            string = "";
        }
        String string5 = DCAIResultsVisualizer.escapeOroRegexLiteral(string2 == null ? "" : string2);
        String string6 = DCAIResultsVisualizer.escapeOroRegexLiteral(string3 == null ? "" : string3);
        String string7 = string.trim();
        boolean bl3 = string5.isEmpty() || string7.contains(string5);
        boolean bl4 = bl2 = string6.isEmpty() || string7.contains(string6);
        if (bl3 && bl2) {
            return string7;
        }
        String string8 = string7;
        boolean bl5 = string8.startsWith("(") && string8.endsWith(")");
        String string9 = string4 = bl5 ? string8.substring(1, Math.max(1, string8.length() - 1)) : null;
        if (string4 == null || string4.isEmpty()) {
            boolean bl6 = string2 != null && string2.contains("\"") || string3 != null && string3.contains("\"");
            string4 = bl6 ? "[^\\\"]+" : ".*?";
        }
        String string10 = (bl ? "(?s)" : "") + string5 + "(" + string4 + ")" + string6;
        return string10;
    }

    private void insertRegexExtractor(SampleEntry sampleEntry, String string, String string2) {
        try {
            if (string == null || string.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Variable name is required.", "Missing name", 1);
                return;
            }
            if (string2 == null || string2.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Regex pattern is required.", "Missing pattern", 1);
                return;
            }
            JMeterTreeNode jMeterTreeNode = this.findSamplerBySelectedEntry(sampleEntry);
            if (jMeterTreeNode == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), String.format("Could not find sampler '%s' in the test plan.", sampleEntry.label), "Sampler Not Found", 2);
                return;
            }
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                throw new RuntimeException("JMeter GUI not available");
            }
            RegexExtractor regexExtractor = new RegexExtractor();
            regexExtractor.setName("Load Magic Regex Extractor - " + string);
            regexExtractor.setProperty("TestElement.test_class", RegexExtractor.class.getName());
            regexExtractor.setProperty("TestElement.gui_class", RegexExtractorGui.class.getName());
            regexExtractor.setRefName(string);
            regexExtractor.setRegex(string2);
            regexExtractor.setTemplate("$1$");
            regexExtractor.setMatchNumber("1");
            regexExtractor.setDefaultValue("NOT_FOUND");
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            jMeterTreeModel.addComponent((TestElement)regexExtractor, jMeterTreeNode);
            JTree jTree = guiPackage.getMainFrame().getTree();
            TreePath treePath = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode));
            jTree.setSelectionPath(treePath);
            jTree.scrollPathToVisible(treePath);
            JOptionPane.showMessageDialog((Component)((Object)this), String.format("Regex Extractor added under '%s'\nVariable: %s\nTemplate: $1$\nMatch No.: 1", sampleEntry.label, string), "Success", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error adding Regex Extractor: " + exception.getMessage(), "Error", 0);
        }
    }

    private String suggestVariableNameFromRegex(String string, SampleEntry sampleEntry) {
        String string2;
        String string3 = DCAIResultsVisualizer.extractFirstAlnumToken(string);
        String string4 = string3 != null && !string3.isEmpty() ? ("DCAI_" + string3).toUpperCase() : ((string2 = this.suggestVariableNameFromContext("$", sampleEntry)) == null || string2.isEmpty() ? "DCAI_REGEX_VAR" : string2).toUpperCase();
        String string5 = DCAIResultsVisualizer.sanitizeVarName(string4 + "_" + (string2 = DCAIResultsVisualizer.shortRandomSuffix()));
        if (string5.length() > 40) {
            string5 = string5.substring(0, 40);
        }
        while (string5.endsWith("_")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        return string5.isEmpty() ? "DCAI_JSON_VAR" : string5;
    }

    private static String extractFirstAlnumToken(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                bl = true;
                if (stringBuilder.length() < 24) continue;
                break;
            }
            if (bl) break;
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private static String shortRandomSuffix() {
        int n = (int)(System.nanoTime() & 0xFFFFL);
        String string = Integer.toString(n, 36).toUpperCase();
        if (string.length() < 3) {
            string = ("000" + string).substring(string.length());
        }
        return string;
    }

    private static String sanitizeVarName(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("[^A-Za-z0-9_]", "_");
        return string2;
    }

    private static String safeSub(String string, int n, int n2) {
        int n3;
        int n4 = n3 = string == null ? 0 : string.length();
        if (string == null) {
            return "";
        }
        int n5 = Math.max(0, Math.min(n, n3));
        int n6 = Math.max(0, Math.min(n2, n3));
        if (n6 < n5) {
            int n7 = n5;
            n5 = n6;
            n6 = n7;
        }
        return string.substring(n5, n6);
    }

    private static String truncatePreview(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 300) {
            return string;
        }
        return string.substring(0, 300) + "...";
    }

    private static String escapeOroRegexLiteral(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuilder.append('\\').append(c);
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void updateRegexSelectorText(String string) {
        if (this.regexSelectorArea == null) {
            return;
        }
        long l = this.selectionSeq.get();
        SwingUtilities.invokeLater(() -> {
            String string2;
            if (l != this.selectionSeq.get()) {
                return;
            }
            String string3 = string2 = string == null ? "" : string;
            if (this.isUsingRsta()) {
                try {
                    Method method = this.rstaClass.getMethod("setSyntaxEditingStyle", String.class);
                    method.invoke((Object)this.regexSelectorArea, "text/plain");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.currentRegexFullText = string2;
            this.enterPreviewModeWith(string2);
            boolean bl = false;
            SwingUtilities.invokeLater(() -> {
                if (l == this.selectionSeq.get()) {
                    try {
                        this.regexSelectorArea.setCaretPosition(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        });
        if (this.regexLayerUI != null) {
            this.regexLayerUI.resetBoundaries();
        }
    }

    private void enterPreviewModeWith(String string) {
        try {
            this.regexPreviewMode = true;
            if (this.confirmRegexButton != null) {
                this.confirmRegexButton.setEnabled(true);
            }
            if (this.regexLayerUI != null) {
                this.regexLayerUI.setInteractionEnabled(true);
                this.regexLayerUI.resetBoundaries();
            }
            if (this.regexSelectorArea != null) {
                this.currentRegexFullText = string == null ? "" : string;
                this.regexChunkStart = 0;
                this.refreshRegexChunkView();
            }
            if (this.prevChunkButton != null) {
                this.prevChunkButton.setEnabled(true);
            }
            if (this.nextChunkButton != null) {
                this.nextChunkButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshRegexChunkView() {
        String string = this.currentRegexFullText == null ? "" : this.currentRegexFullText;
        int n = string.length();
        if (this.regexChunkStart < 0) {
            this.regexChunkStart = 0;
        }
        if (this.regexChunkStart > Math.max(0, n - 1)) {
            this.regexChunkStart = Math.max(0, n - 1);
        }
        int n2 = Math.min(n, this.regexChunkStart + 50000);
        String string2 = string.substring(this.regexChunkStart, n2);
        if (this.isUsingRsta()) {
            try {
                this.rstaClass.getMethod("setSyntaxEditingStyle", String.class).invoke((Object)this.regexSelectorArea, "text/plain");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.regexSelectorArea.setLineWrap(true);
            this.regexSelectorArea.setWrapStyleWord(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.regexSelectorArea.setText(string2);
        if (this.chunkInfoLabel != null) {
            int n3 = this.regexChunkStart;
            int n4 = n2;
            int n5 = this.regexChunkStart / Math.max(1, 47952) + 1;
            int n6 = Math.max(1, (int)Math.ceil((double)Math.max(1, n - 2048) / (double)Math.max(1, 47952)));
            this.chunkInfoLabel.setText(String.format("Chunk %d/%d (%d\u2013%d of %d)", n5, n6, n3, n4, n));
        }
        if (this.prevChunkButton != null) {
            this.prevChunkButton.setEnabled(this.regexChunkStart > 0);
        }
        if (this.nextChunkButton != null) {
            this.nextChunkButton.setEnabled(n2 < n);
        }
        try {
            this.regexSelectorArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showPrevChunk() {
        int n;
        if (!this.regexPreviewMode) {
            return;
        }
        int n2 = 47952;
        if (n2 <= 0) {
            n2 = 50000;
        }
        if ((n = Math.max(0, this.regexChunkStart - n2)) != this.regexChunkStart) {
            this.regexChunkStart = n;
            if (this.regexLayerUI != null) {
                this.regexLayerUI.resetBoundaries();
            }
            this.refreshRegexChunkView();
        }
    }

    private void showNextChunk() {
        int n;
        if (!this.regexPreviewMode) {
            return;
        }
        String string = this.currentRegexFullText == null ? "" : this.currentRegexFullText;
        int n2 = string.length();
        int n3 = 47952;
        if (n3 <= 0) {
            n3 = 50000;
        }
        if ((n = Math.min(Math.max(0, n2 - 1), this.regexChunkStart + n3)) != this.regexChunkStart && n < n2) {
            this.regexChunkStart = n;
            if (this.regexLayerUI != null) {
                this.regexLayerUI.resetBoundaries();
            }
            this.refreshRegexChunkView();
        }
    }

    private boolean isUsingRsta() {
        try {
            return this.rstaAvailable && this.rstaClass != null && this.rstaClass.isInstance(this.regexSelectorArea);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean looksLikeHtml(String string) {
        if (string == null || string.length() < 16) {
            return false;
        }
        String string2 = string.substring(0, Math.min(2000, string.length())).toLowerCase();
        if (string2.indexOf(60) < 0) {
            return false;
        }
        return string2.contains("<html") || string2.contains("<!doctype") || string2.contains("<body") || string2.contains("</") || string2.contains("<div") || string2.contains("<head");
    }

    private String createSmartTruncation(String string, int n) {
        if (string == null || string.length() <= n) {
            return string;
        }
        int n2 = n / 2;
        int n3 = n / 4;
        if (n2 + n3 > n) {
            n3 = Math.max(0, n - n2);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(string.length() - n3);
        StringBuilder stringBuilder = new StringBuilder(n + 500);
        stringBuilder.append(string2).append("\n\n=========== CONTENT TRUNCATED FOR PERFORMANCE ===========\n").append("Original size: ").append(string.length()).append(" characters\n").append("Showing first ").append(n2).append(" and last ").append(n3).append(" characters\n").append("Use browser dev tools or save response to view complete content\n").append("==========================================================\n\n").append(string3);
        return stringBuilder.toString();
    }

    private boolean validateSelections() {
        SampleEntry sampleEntry = this.sampleList.getSelectedValue();
        if (sampleEntry == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a sample entry in the list first.", "No Sample Selected", 1);
            return false;
        }
        String string = this.getCurrentJsonPath();
        if (string == null || string.trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a JSON element in the JSON viewer.", "No JSON Path Selected", 1);
            return false;
        }
        return true;
    }

    private void addJsonExtractorToSelectedSampler() {
        if (!this.validateSelections()) {
            return;
        }
        try {
            SampleEntry sampleEntry = this.sampleList.getSelectedValue();
            String string = this.getCurrentJsonPath();
            JMeterTreeNode jMeterTreeNode = this.findSamplerBySelectedEntry(sampleEntry);
            if (jMeterTreeNode == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), String.format("Could not find sampler '%s' in the test plan.", sampleEntry.label), "Sampler Not Found", 2);
                return;
            }
            String string2 = this.promptForVariableName(string, sampleEntry);
            if (string2 == null || string2.trim().isEmpty()) {
                return;
            }
            boolean bl = this.createAndAddJsonExtractor(jMeterTreeNode, string2.trim(), string);
            if (bl) {
                JOptionPane.showMessageDialog((Component)((Object)this), String.format("JSON Extractor added under '%s'\nVariable: %s\nPath: %s", sampleEntry.label, string2.trim(), string), "Success", 1);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error adding JSON Extractor: " + exception.getMessage(), "Error", 0);
        }
    }

    private void expandTree(JTree jTree, int n) {
        TreeModel treeModel = jTree.getModel();
        if (treeModel == null) {
            return;
        }
        this.expandNode(jTree, new TreePath(treeModel.getRoot()), n);
    }

    private void expandNode(JTree jTree, TreePath treePath, int n) {
        if (n <= 0) {
            return;
        }
        jTree.expandPath(treePath);
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
            this.expandNode(jTree, treePath2, n - 1);
        }
    }

    private void setResponseHeadersHtml(SampleEntry sampleEntry) {
        Object object;
        long l = System.currentTimeMillis();
        Object object2 = object = sampleEntry.responseHeaders == null ? "" : sampleEntry.responseHeaders;
        if (((String)object).trim().isEmpty()) {
            this.responseHeadersPane.setText("<html><body><i>No response headers</i></body></html>");
            try {
                log.info("Perf(HeadersHtml): {} ms (empty)", (Object)(System.currentTimeMillis() - l));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (((String)object).length() > 50000) {
            object = ((String)object).substring(0, 50000) + "\n[...headers truncated...]";
        }
        String[] stringArray = ((String)object).split("\n", -1);
        String string = sampleEntry.success ? "#2e7d32" : "#c62828";
        StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 1000);
        Font font = UIManager.getFont("TextArea.font");
        String string2 = font != null ? font.getFamily() : "Sans-Serif";
        int n = font != null ? font.getSize() : 12;
        stringBuilder.append("<html><head><style>").append("body{margin:6px;font-family:'").append(DCAIResultsVisualizer.escapeHtml(string2)).append("',Sans-Serif;font-size:").append(n).append("pt;}").append("pre{margin:0;white-space:pre-wrap;overflow-wrap:anywhere;word-break:break-word;}").append("</style></head><body><pre>");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray[i] == null ? "" : stringArray[i];
            String string5 = string3 = this.needsHtmlEscaping(string4) ? DCAIResultsVisualizer.escapeHtml(string4) : string4;
            if (i == 0 && string3.startsWith("HTTP/")) {
                stringBuilder.append("<b><span style='color:").append(string).append(";'>").append(string3).append("</span></b>");
            } else {
                stringBuilder.append(string3);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append("</pre></body></html>");
        this.responseHeadersPane.setText(stringBuilder.toString());
        try {
            log.info("Perf(HeadersHtml): {} ms (len={})", (Object)(System.currentTimeMillis() - l), (Object)((String)object).length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean needsHtmlEscaping(String string) {
        return string.indexOf(60) >= 0 || string.indexOf(62) >= 0 || string.indexOf(38) >= 0 || string.indexOf(34) >= 0 || string.indexOf(39) >= 0;
    }

    private static boolean isLikelyJson(String string) {
        int n;
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n >= n2) {
            return false;
        }
        char c = string.charAt(n);
        return c == '{' || c == '[';
    }

    private static String prettyPrintJson(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 64);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuilder.append(c);
                bl2 = false;
                continue;
            }
            if (c == '\\') {
                stringBuilder.append(c);
                bl2 = true;
                continue;
            }
            if (c == '\"') {
                stringBuilder.append(c);
                bl = !bl;
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case '[': 
                case '{': {
                    stringBuilder.append(c).append('\n');
                    DCAIResultsVisualizer.appendSpaces(stringBuilder, n += 2);
                    continue block6;
                }
                case ']': 
                case '}': {
                    stringBuilder.append('\n');
                    n = Math.max(0, n - 2);
                    DCAIResultsVisualizer.appendSpaces(stringBuilder, n);
                    stringBuilder.append(c);
                    continue block6;
                }
                case ',': {
                    stringBuilder.append(c).append('\n');
                    DCAIResultsVisualizer.appendSpaces(stringBuilder, n);
                    continue block6;
                }
                case ':': {
                    stringBuilder.append(": ");
                    continue block6;
                }
                default: {
                    if (Character.isWhitespace(c)) continue block6;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void appendSpaces(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
    }

    private static String escapeHtml(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private static String loadJMeterVariable(String string) {
        try {
            String string2;
            TestPlan testPlan;
            Map map;
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage == null) {
                return null;
            }
            JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
            if (jMeterTreeModel == null) {
                return null;
            }
            JMeterTreeNode jMeterTreeNode = (JMeterTreeNode)jMeterTreeModel.getRoot();
            if (jMeterTreeNode == null) {
                return null;
            }
            TestElement testElement = jMeterTreeNode.getTestElement();
            if (testElement instanceof TestPlan && (map = (testPlan = (TestPlan)testElement).getUserDefinedVariables()) != null && (string2 = (String)map.get(string)) != null && !string2.trim().isEmpty()) {
                return string2;
            }
            return DCAIResultsVisualizer.findVariableInTree(jMeterTreeNode, string);
        }
        catch (Exception exception) {
            log.debug("[CARRIE-TRACKING] Exception loading JMeter variable {}: {}", (Object)string, (Object)exception.getMessage());
            return null;
        }
    }

    private static String findVariableInTree(JMeterTreeNode jMeterTreeNode, String string) {
        Object object;
        if (jMeterTreeNode == null) {
            return null;
        }
        TestElement testElement = jMeterTreeNode.getTestElement();
        if (testElement instanceof Arguments) {
            Arguments arguments = (Arguments)testElement;
            for (int i = 0; i < arguments.getArgumentCount(); ++i) {
                String string2;
                object = arguments.getArgument(i);
                if (!string.equals(object.getName()) || (string2 = object.getValue()) == null || string2.trim().isEmpty()) continue;
                return string2;
            }
        }
        for (int i = 0; i < jMeterTreeNode.getChildCount(); ++i) {
            JMeterTreeNode jMeterTreeNode2 = (JMeterTreeNode)jMeterTreeNode.getChildAt(i);
            object = DCAIResultsVisualizer.findVariableInTree(jMeterTreeNode2, string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private void applyDividerPosition() {
        if (this.mainSplitPane == null) {
            return;
        }
        int n = 280;
        int n2 = Math.max(200, this.mainSplitPane.getWidth() - 400);
        int n3 = Math.min(n, n2);
        this.mainSplitPane.setDividerLocation(n3);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = Math.min(Math.max(dimension.width, 600), 1000);
        int n2 = Math.min(Math.max(dimension.height, 300), 600);
        return new Dimension(n, n2);
    }

    private /* synthetic */ void lambda$performDcAiAutoInsert$27(SampleEntry sampleEntry, String string, String string2) {
        this.insertRegexExtractor(sampleEntry, string, string2);
    }

    private /* synthetic */ void lambda$lazyPopulateJsonForSelection$14(long l, DefaultMutableTreeNode defaultMutableTreeNode, long l2, long l3, long l4, long l5, String string) {
        if (l != this.selectionSeq.get()) {
            return;
        }
        this.jsonTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.expandTree(this.jsonTree, 2);
        try {
            log.info("Perf(JSON lazy): detect={}ms, parse={}ms, total={}ms (len={})", (Object)(l2 - l3), (Object)(l4 - l2), (Object)(System.currentTimeMillis() - l5), (Object)string.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$duplicateSamplerForEntry$2(JMeterTreeModel jMeterTreeModel, JMeterTreeNode jMeterTreeNode, GuiPackage guiPackage, JSR223Sampler jSR223Sampler) {
        try {
            TreePath treePath = new TreePath(jMeterTreeModel.getPathToRoot((TreeNode)jMeterTreeNode));
            guiPackage.getMainFrame().getTree().setSelectionPath(treePath);
            Timer timer = new Timer(120, actionEvent -> {
                try {
                    jSR223Sampler.setFilename("");
                    jSR223Sampler.setScript("Please stand by, George is working on a fix...");
                    JMeterGUIComponent jMeterGUIComponent = guiPackage.getCurrentGui();
                    if (jMeterGUIComponent != null) {
                        jMeterGUIComponent.configure((TestElement)jSR223Sampler);
                    }
                    jMeterTreeModel.nodeChanged((TreeNode)jMeterTreeNode);
                    guiPackage.getMainFrame().getTree().repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            URL uRL = DCAIResultsVisualizer.class.getResource("/com/company/dcai/images/loadmagic-icon.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                if (imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                    GUIFactory.registerIcon((String)DCAIResultsVisualizer.class.getName(), (ImageIcon)imageIcon);
                    GUIFactory.registerDisabledIcon((String)DCAIResultsVisualizer.class.getName(), (ImageIcon)imageIcon);
                } else {
                    log.warn("[DCAIResultsVisualizer] Icon resource present but has zero size: {}", (Object)uRL);
                }
            } else {
                log.warn("[DCAIResultsVisualizer] Icon resource not found for Load Magic visualizer");
            }
        }
        catch (Exception exception) {
            log.warn("[DCAIResultsVisualizer] Failed to register tree icon: {}", (Object)exception.getMessage());
        }
        AUTO_SEND_GUARD = new Object();
        autoSendInFlight = false;
        lastAutoSendMs = 0L;
        SENT_TEST_START_IDS = Collections.newSetFromMap(new ConcurrentHashMap());
        sentWithoutTestStartId = false;
        lastCorrelationAttemptId = null;
        lastCorrelationSessionId = null;
        lastCorrelationDcaiHeader = null;
        lastCorrelationCandidateValue = null;
        lastCorrelationTimestamp = null;
        lastCorrelationHarFilename = null;
        lastCorrelationAttemptsByName = new HashMap<String, Long>();
        lastCarrieResponseJson = null;
    }

    private static class SampleEntry {
        final String label;
        final boolean success;
        final String responseCode;
        final String responseMessage;
        final String timeText;
        final String requestHeaders;
        final String requestBody;
        final String responseHeaders;
        final String responseBody;

        SampleEntry(String string, boolean bl, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.label = string;
            this.success = bl;
            this.responseCode = string2;
            this.responseMessage = string3;
            this.timeText = string4;
            this.requestHeaders = string5;
            this.requestBody = string6;
            this.responseHeaders = string7;
            this.responseBody = string8;
        }

        static SampleEntry from(SampleResult sampleResult) {
            String string = SampleEntry.safe(sampleResult.getSampleLabel());
            boolean bl = sampleResult.isSuccessful();
            String string2 = SampleEntry.safe(sampleResult.getResponseCode());
            String string3 = SampleEntry.safe(sampleResult.getResponseMessage());
            String string4 = Instant.ofEpochMilli(sampleResult.getStartTime()).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
            String string5 = SampleEntry.normalizeNewlines(SampleEntry.safe(sampleResult.getRequestHeaders()));
            String string6 = SampleEntry.safe(sampleResult.getSamplerData());
            String string7 = (String)(string5.isEmpty() ? "" : "[Headers]\n" + string5 + "\n") + (String)(string6.isEmpty() ? "" : "[Body / Data]\n" + string6);
            String string8 = SampleEntry.normalizeNewlines(SampleEntry.safe(sampleResult.getResponseHeaders()));
            String string9 = SampleEntry.safe(sampleResult.getResponseDataAsString());
            return new SampleEntry(string, bl, string2, string3, string4, string5, string6, string8, string9);
        }

        private static String safe(String string) {
            return string == null ? "" : string;
        }

        private static String normalizeNewlines(String string) {
            if (string == null) {
                return "";
            }
            return string.replace("\r\n", "\n").replace('\r', '\n');
        }

        public String toString() {
            return String.format("%s - %s (%s)", this.timeText.substring(11), this.label, this.responseCode);
        }
    }

    private static class SampleEntryRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final String ICON_SIZE_PROP = "jmeter.tree.icons.size";
        private static final String DEFAULT_ICON_SIZE = "19x19";
        private static final ImageIcon imageSuccess = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.success", (String)("vrt/" + JMeterUtils.getPropDefault((String)"jmeter.tree.icons.size", (String)"19x19") + "/security-high-2.png")));
        private static final ImageIcon imageFailure = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.failure", (String)("vrt/" + JMeterUtils.getPropDefault((String)"jmeter.tree.icons.size", (String)"19x19") + "/security-low-2.png")));

        private SampleEntryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof SampleEntry) {
                SampleEntry sampleEntry = (SampleEntry)object;
                this.setIcon(sampleEntry.success ? imageSuccess : imageFailure);
                try {
                    this.setFont(jList.getFont().deriveFont(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!sampleEntry.success) {
                    try {
                        this.setForeground(new Color(198, 40, 40));
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.setIcon(null);
            }
            return component;
        }
    }

    private static class CarrieResponse {
        boolean isCorrelationIssue;
        double confidence;
        String candidateName;
        String candidateValue;
        String candidateLocation;
        String candidateJsonPath;

        private CarrieResponse() {
        }
    }

    private static class JsonTreeNode
    extends DefaultMutableTreeNode {
        private final String jsonPath;
        private final Object jsonValue;

        public JsonTreeNode(String string, Object object, String string2) {
            super(string);
            this.jsonValue = object;
            this.jsonPath = string2;
        }

        public String getJsonPath() {
            return this.jsonPath;
        }

        public Object getJsonValue() {
            return this.jsonValue;
        }

        @Override
        public String toString() {
            String string = String.valueOf(this.getUserObject());
            try {
                Class<?> clazz = this.jsonValue.getClass();
                Method method = clazz.getMethod("isValueNode", new Class[0]);
                Method method2 = clazz.getMethod("isArray", new Class[0]);
                Method method3 = clazz.getMethod("isObject", new Class[0]);
                if (((Boolean)method.invoke(this.jsonValue, new Object[0])).booleanValue()) {
                    Method method4 = clazz.getMethod("asText", new Class[0]);
                    Object object = String.valueOf(method4.invoke(this.jsonValue, new Object[0]));
                    if (((String)object).length() > 50) {
                        object = ((String)object).substring(0, 47) + "...";
                    }
                    return string + ": " + (String)object;
                }
                if (((Boolean)method2.invoke(this.jsonValue, new Object[0])).booleanValue()) {
                    Method method5 = clazz.getMethod("size", new Class[0]);
                    int n = (Integer)method5.invoke(this.jsonValue, new Object[0]);
                    return string + " [" + n + "]";
                }
                if (((Boolean)method3.invoke(this.jsonValue, new Object[0])).booleanValue()) {
                    Method method6 = clazz.getMethod("size", new Class[0]);
                    int n = (Integer)method6.invoke(this.jsonValue, new Object[0]);
                    return string + " {" + n + "}";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return string;
        }
    }

    private static class SamplerWithPosition {
        final JMeterTreeNode node;
        final int position;
        final String path;

        SamplerWithPosition(JMeterTreeNode jMeterTreeNode, int n, String string) {
            this.node = jMeterTreeNode;
            this.position = n;
            this.path = string;
        }
    }

    private static final class RegexBoundaryLayerUI
    extends LayerUI<JComponent> {
        private final JTextArea textArea;
        private int leftStart = -1;
        private int leftEnd = -1;
        private int rightStart = -1;
        private int rightEnd = -1;
        private Object highlightBetweenTag;
        private Object highlightLeftTag;
        private Object highlightRightTag;
        private final Highlighter.HighlightPainter betweenPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 235, 59, 80));
        private final Highlighter.HighlightPainter boundaryPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(129, 199, 132, 70));
        private Dragging dragging = Dragging.NONE;
        private boolean interactionEnabled = true;

        RegexBoundaryLayerUI(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            ((JLayer)jComponent).setLayerEventMask(48L);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            ((JLayer)jComponent).setLayerEventMask(0L);
            super.uninstallUI(jComponent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            if (this.textArea == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                if (this.leftStart >= 0) {
                    this.drawLineAtOffset(graphics2D, jComponent, this.leftStart, new Color(67, 160, 71));
                }
                if (this.leftEnd >= 0) {
                    this.drawLineAtOffset(graphics2D, jComponent, this.leftEnd, new Color(76, 175, 80));
                }
                if (this.rightStart >= 0) {
                    this.drawLineAtOffset(graphics2D, jComponent, this.rightStart, new Color(25, 118, 210));
                }
                if (this.rightEnd >= 0) {
                    this.drawLineAtOffset(graphics2D, jComponent, this.rightEnd, new Color(30, 136, 229));
                }
            }
            finally {
                graphics2D.dispose();
            }
        }

        private void drawLineAtOffset(Graphics2D graphics2D, JComponent jComponent, int n, Color color) {
            try {
                Rectangle2D rectangle2D = this.textArea.modelToView2D(Math.max(0, Math.min(n, this.textArea.getDocument().getLength())));
                if (rectangle2D == null) {
                    return;
                }
                Point point = SwingUtilities.convertPoint(this.textArea, new Point((int)rectangle2D.getX(), (int)rectangle2D.getY()), jComponent);
                int n2 = point.x;
                int n3 = point.y;
                graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 140));
                graphics2D.fillRect(n2, n3, 2, jComponent.getHeight() - n3 - 8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent, JLayer<? extends JComponent> jLayer) {
            if (!this.interactionEnabled) {
                return;
            }
            if (this.textArea == null) {
                return;
            }
            if (mouseEvent.getID() == 501) {
                int n;
                if (mouseEvent.getClickCount() >= 2 && (n = this.pointToOffset(mouseEvent, jLayer)) >= 0) {
                    this.autoPlaceBoundariesAt(n);
                    this.applyHighlights();
                    jLayer.repaint();
                    return;
                }
                n = this.pointToOffset(mouseEvent, jLayer);
                if (n < 0) {
                    return;
                }
                if (this.leftStart < 0) {
                    this.leftStart = this.computePaddedOffset(n, true);
                    this.dragging = Dragging.LEFT_START;
                } else if (this.leftEnd < 0) {
                    this.leftEnd = this.computePaddedOffset(n, true);
                    this.dragging = Dragging.LEFT_END;
                } else if (this.rightStart < 0) {
                    this.rightStart = this.computePaddedOffset(n, false);
                    this.dragging = Dragging.RIGHT_START;
                } else if (this.rightEnd < 0) {
                    this.rightEnd = this.computePaddedOffset(n, false);
                    this.dragging = Dragging.RIGHT_END;
                } else {
                    int[] nArray = new int[]{this.leftStart, this.leftEnd, this.rightStart, this.rightEnd};
                    Dragging[] draggingArray = new Dragging[]{Dragging.LEFT_START, Dragging.LEFT_END, Dragging.RIGHT_START, Dragging.RIGHT_END};
                    int n2 = 0;
                    int n3 = Integer.MAX_VALUE;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n4 = Math.abs(nArray[i] - n);
                        if (n4 >= n3) continue;
                        n3 = n4;
                        n2 = i;
                    }
                    this.dragging = draggingArray[n2];
                }
                this.normaliseAndClamp();
                this.applyHighlights();
                jLayer.repaint();
            } else if (mouseEvent.getID() == 502) {
                this.dragging = Dragging.NONE;
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent, JLayer<? extends JComponent> jLayer) {
            if (!this.interactionEnabled) {
                return;
            }
            if (this.textArea == null) {
                return;
            }
            if (this.dragging == Dragging.NONE) {
                return;
            }
            int n = this.pointToOffset(mouseEvent, jLayer);
            if (n < 0) {
                return;
            }
            switch (this.dragging) {
                case LEFT_START: {
                    this.leftStart = this.computePaddedOffset(n, true);
                    break;
                }
                case LEFT_END: {
                    this.leftEnd = this.computePaddedOffset(n, true);
                    break;
                }
                case RIGHT_START: {
                    this.rightStart = this.computePaddedOffset(n, false);
                    break;
                }
                case RIGHT_END: {
                    this.rightEnd = this.computePaddedOffset(n, false);
                    break;
                }
            }
            this.normaliseAndClamp();
            this.applyHighlights();
            jLayer.repaint();
        }

        private int pointToOffset(MouseEvent mouseEvent, JLayer<?> jLayer) {
            try {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.textArea);
                int n = this.textArea.viewToModel2D(point);
                if (n < 0 || n > this.textArea.getDocument().getLength()) {
                    return -1;
                }
                return n;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        private void applyHighlights() {
            try {
                Highlighter highlighter = this.textArea.getHighlighter();
                if (this.highlightBetweenTag != null) {
                    highlighter.removeHighlight(this.highlightBetweenTag);
                    this.highlightBetweenTag = null;
                }
                if (this.highlightLeftTag != null) {
                    highlighter.removeHighlight(this.highlightLeftTag);
                    this.highlightLeftTag = null;
                }
                if (this.highlightRightTag != null) {
                    highlighter.removeHighlight(this.highlightRightTag);
                    this.highlightRightTag = null;
                }
                if (this.isOrdered()) {
                    if (this.leftStart >= 0 && this.leftEnd >= 0 && this.leftEnd > this.leftStart) {
                        this.highlightLeftTag = highlighter.addHighlight(this.leftStart, this.leftEnd, this.boundaryPainter);
                    }
                    if (this.rightStart >= 0 && this.rightEnd >= 0 && this.rightEnd > this.rightStart) {
                        this.highlightRightTag = highlighter.addHighlight(this.rightStart, this.rightEnd, this.boundaryPainter);
                    }
                    if (this.leftEnd >= 0 && this.rightStart >= 0 && this.rightStart > this.leftEnd) {
                        this.highlightBetweenTag = highlighter.addHighlight(this.leftEnd, this.rightStart, this.betweenPainter);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void autoPlaceBoundariesAt(int n) {
            try {
                int n2 = this.textArea.getDocument().getLength();
                int n3 = Utilities.getWordStart(this.textArea, n);
                int n4 = Utilities.getWordEnd(this.textArea, n);
                n3 = RegexBoundaryLayerUI.clamp(n3, 0, n2);
                n4 = RegexBoundaryLayerUI.clamp(n4, 0, n2);
                if (n3 >= n4) {
                    n3 = Math.max(0, n - 1);
                    n4 = Math.min(n2, n + 1);
                }
                int[] nArray = this.guessLeftSpan(n3);
                int[] nArray2 = this.guessRightSpan(n4);
                this.leftStart = nArray[0];
                this.leftEnd = nArray[1];
                this.rightStart = nArray2[0];
                this.rightEnd = nArray2[1];
                this.normaliseAndClamp();
                try {
                    this.textArea.select(n3, n4);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int[] guessLeftSpan(int n) {
            int n2;
            String string = this.textArea.getText();
            int n3 = this.lastIndexOf(string, ':', n - 1, n2 = Math.max(0, n - 200));
            if (n3 >= 0) {
                int n4 = this.lastIndexOf(string, '\"', n3 - 1, Math.max(0, n3 - 120));
                if (n4 >= 0) {
                    return new int[]{n4, n};
                }
                return new int[]{Math.max(n3 - 10, n2), n};
            }
            int n5 = this.lastIndexOf(string, '=', n - 1, n2);
            if (n5 >= 0) {
                int n6 = this.lastIndexOf(string, '\"', n5 - 1, Math.max(0, n5 - 120));
                if (n6 >= 0) {
                    return new int[]{n6, n};
                }
                return new int[]{Math.max(n5 - 10, n2), n};
            }
            int n7 = this.backUntilDelimiter(string, n, n2);
            return new int[]{n7, n};
        }

        private int[] guessRightSpan(int n) {
            int n2;
            String string = this.textArea.getText();
            int n3 = this.indexOf(string, ',', n, n2 = Math.min(string.length(), n + 240));
            if (n3 >= 0) {
                int n4;
                int n5 = this.indexOf(string, '\"', n3 + 1, Math.min(string.length(), n3 + 120));
                if (n5 >= 0 && (n4 = this.indexOf(string, '\"', n5 + 1, Math.min(string.length(), n5 + 200))) >= 0) {
                    return new int[]{n, Math.min(string.length(), n4 + 1)};
                }
                return new int[]{n, Math.min(string.length(), n3 + 1)};
            }
            int n6 = this.forwardUntilDelimiter(string, n, n2);
            return new int[]{n, n6};
        }

        private int backUntilDelimiter(String string, int n, int n2) {
            for (int i = Math.max(n2, n - 24); i < n && i >= 0 && !this.isHardDelimiter(string.charAt(i)); ++i) {
            }
            int n3 = Math.max(n2, n - 12);
            return n3;
        }

        private int forwardUntilDelimiter(String string, int n, int n2) {
            for (int i = Math.min(n2, n + 24); i > n && i < string.length() && !this.isHardDelimiter(string.charAt(i - 1)); --i) {
            }
            int n3 = Math.min(n2, n + 12);
            return n3;
        }

        private boolean isHardDelimiter(char c) {
            return Character.isWhitespace(c) || c == ':' || c == '=' || c == ',' || c == '>' || c == '<' || c == '\"' || c == '\'' || c == '{' || c == '}' || c == '[' || c == ']' || c == '(' || c == ')';
        }

        private int lastIndexOf(String string, char c, int n, int n2) {
            if (n >= string.length()) {
                n = string.length() - 1;
            }
            for (int i = n; i >= n2 && i >= 0; --i) {
                if (string.charAt(i) != c) continue;
                return i;
            }
            return -1;
        }

        private int indexOf(String string, char c, int n, int n2) {
            if (n < 0) {
                n = 0;
            }
            for (int i = n; i < string.length() && i < n2; ++i) {
                if (string.charAt(i) != c) continue;
                return i;
            }
            return -1;
        }

        private boolean isOrdered() {
            int n = this.textArea.getDocument().getLength();
            int n2 = RegexBoundaryLayerUI.clamp(this.leftStart, 0, n);
            int n3 = RegexBoundaryLayerUI.clamp(this.leftEnd, 0, n);
            int n4 = RegexBoundaryLayerUI.clamp(this.rightStart, 0, n);
            int n5 = RegexBoundaryLayerUI.clamp(this.rightEnd, 0, n);
            return n2 >= 0 && n3 >= 0 && n4 >= 0 && n5 >= 0 && n2 <= n3 && n3 <= n4 && n4 <= n5;
        }

        private void normaliseAndClamp() {
            int n = this.textArea.getDocument().getLength();
            this.leftStart = RegexBoundaryLayerUI.clamp(this.leftStart, 0, n);
            this.leftEnd = RegexBoundaryLayerUI.clamp(this.leftEnd, 0, n);
            this.rightStart = RegexBoundaryLayerUI.clamp(this.rightStart, 0, n);
            this.rightEnd = RegexBoundaryLayerUI.clamp(this.rightEnd, 0, n);
            if (this.leftStart >= 0 && this.leftEnd >= 0 && this.leftStart > this.leftEnd) {
                this.leftEnd = this.leftStart;
            }
            if (this.leftEnd >= 0 && this.rightStart >= 0 && this.leftEnd > this.rightStart) {
                this.rightStart = this.leftEnd;
            }
            if (this.rightStart >= 0 && this.rightEnd >= 0 && this.rightStart > this.rightEnd) {
                this.rightEnd = this.rightStart;
            }
        }

        private static int clamp(int n, int n2, int n3) {
            return Math.max(n2, Math.min(n, n3));
        }

        private int computePaddedOffset(int n, boolean bl) {
            int n2 = this.textArea.getDocument().getLength();
            return Math.max(0, Math.min(n, n2));
        }

        void resetBoundaries() {
            this.leftStart = -1;
            this.leftEnd = -1;
            this.rightStart = -1;
            this.rightEnd = -1;
            try {
                Highlighter highlighter = this.textArea.getHighlighter();
                if (this.highlightBetweenTag != null) {
                    highlighter.removeHighlight(this.highlightBetweenTag);
                }
                if (this.highlightLeftTag != null) {
                    highlighter.removeHighlight(this.highlightLeftTag);
                }
                if (this.highlightRightTag != null) {
                    highlighter.removeHighlight(this.highlightRightTag);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.highlightBetweenTag = null;
            this.highlightLeftTag = null;
            this.highlightRightTag = null;
        }

        int getLeftStart() {
            return this.leftStart;
        }

        int getLeftEnd() {
            return this.leftEnd;
        }

        int getRightStart() {
            return this.rightStart;
        }

        int getRightEnd() {
            return this.rightEnd;
        }

        void setInteractionEnabled(boolean bl) {
            this.interactionEnabled = bl;
        }

        private static enum Dragging {
            NONE,
            LEFT_START,
            LEFT_END,
            RIGHT_START,
            RIGHT_END;

        }
    }
}

